/*
 * Decompiled with CFR 0.152.
 */
package io.github.sgtsilvio.gradle.oci.junit.jupiter;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Image;
import com.sun.jna.Platform;
import io.github.sgtsilvio.oci.registry.DistributionRegistryStorage;
import io.github.sgtsilvio.oci.registry.OciRegistryHandler;
import io.github.sgtsilvio.oci.registry.OciRegistryStorage;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.utility.DockerImageName;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0007J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\rH\u0002J\b\u0010\u001b\u001a\u00020\u000fH\u0002R6\u0010\u0003\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/sgtsilvio/gradle/oci/junit/jupiter/OciImages;", "", "()V", "imageNames", "Ljava/util/LinkedHashSet;", "Lkotlin/Pair;", "Lorg/testcontainers/utility/DockerImageName;", "", "Lkotlin/collections/LinkedHashSet;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "registry", "Lreactor/netty/DisposableServer;", "cleanup", "", "cleanup$gradle_oci_junit_jupiter", "cleanupImages", "cleanupLeftoverImages", "currentRegistryPort", "", "getImageName", "imageName", "", "retain", "getRegistryHost", "startRegistry", "stopRegistry", "gradle-oci-junit-jupiter"})
@SourceDebugExtension(value={"SMAP\nOciImages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OciImages.kt\nio/github/sgtsilvio/gradle/oci/junit/jupiter/OciImages\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,154:1\n1360#2:155\n1446#2,5:156\n1603#2,9:161\n1855#2:170\n1856#2:172\n1612#2:173\n1490#2:174\n1520#2,3:175\n1523#2,3:185\n1#3:171\n372#4,7:178\n215#5,2:188\n*S KotlinDebug\n*F\n+ 1 OciImages.kt\nio/github/sgtsilvio/gradle/oci/junit/jupiter/OciImages\n*L\n58#1:155\n58#1:156,5\n58#1:161,9\n58#1:170\n58#1:172\n58#1:173\n73#1:174\n73#1:175,3\n73#1:185,3\n58#1:171\n73#1:178,7\n73#1:188,2\n*E\n"})
public final class OciImages {
    @NotNull
    public static final OciImages INSTANCE = new OciImages();
    @Nullable
    private static DisposableServer registry;
    @NotNull
    private static final LinkedHashSet<Pair<DockerImageName, Boolean>> imageNames;
    private static final Logger logger;

    private OciImages() {
    }

    @JvmStatic
    @NotNull
    public static final DockerImageName getImageName(@NotNull String imageName) {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        return OciImages.getImageName(imageName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final DockerImageName getImageName(@NotNull String imageName, boolean retain) {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        OciImages ociImages = INSTANCE;
        synchronized (ociImages) {
            boolean bl = false;
            String host = INSTANCE.getRegistryHost();
            DisposableServer disposableServer = registry;
            if (disposableServer == null) {
                disposableServer = INSTANCE.startRegistry();
            }
            int port = disposableServer.port();
            DockerImageName dockerImageName = DockerImageName.parse((String)(host + ':' + port + '/' + imageName)).asCompatibleSubstituteFor(imageName);
            ((Collection)imageNames).add(new Pair((Object)dockerImageName, (Object)retain));
            Intrinsics.checkNotNull((Object)dockerImageName);
            DockerImageName dockerImageName2 = dockerImageName;
            return dockerImageName2;
        }
    }

    private final String getRegistryHost() {
        return Platform.isMac() || Platform.isWindows() ? "host.docker.internal" : "localhost";
    }

    private final DisposableServer startRegistry() {
        Path registryDataDirectory = Paths.get(System.getProperty("io.github.sgtsilvio.gradle.oci.registry.data.dir"), new String[0]);
        logger.debug("Starting OCI registry with data directory {}", (Object)registryDataDirectory);
        HttpServer httpServer = HttpServer.create().port(0);
        Intrinsics.checkNotNull((Object)registryDataDirectory);
        DisposableServer registry = httpServer.handle((BiFunction)new OciRegistryHandler((OciRegistryStorage)new DistributionRegistryStorage(registryDataDirectory))).bindNow();
        logger.debug("Started OCI registry on port {}", (Object)registry.port());
        OciImages.registry = registry;
        Runtime.getRuntime().addShutdownHook(new Thread(OciImages::startRegistry$lambda$1));
        this.cleanupLeftoverImages(registry.port());
        Intrinsics.checkNotNull((Object)registry);
        return registry;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void cleanupLeftoverImages(int currentRegistryPort) {
        OciImages.logger.debug("Checking for leftover images");
        hostPrefix = this.getRegistryHost() + ':';
        dockerClient = DockerClientFactory.instance().client();
        v0 = dockerClient.listImagesCmd().exec();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"exec(...)");
        $this$flatMap$iv = (Iterable)v0;
        $i$f$flatMap = false;
        var6_6 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            block26: {
                block25: {
                    it = (Image)element$iv$iv;
                    $i$a$-flatMap-OciImages$cleanupLeftoverImages$1 = false;
                    v1 /* !! */  = var13_23 = it.getRepoTags();
                    if (var13_23 == null) break block25;
                    Intrinsics.checkNotNull((Object)v1 /* !! */ );
                    v1 /* !! */  = ArraysKt.toList((Object[])var13_23);
                    if (v1 /* !! */  != null) break block26;
                }
                v1 /* !! */  = CollectionsKt.emptyList();
            }
            list$iv$iv = (Iterable)v1 /* !! */ ;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            block24: {
                element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                imageName = (String)element$iv$iv;
                $i$a$-mapNotNull-OciImages$cleanupLeftoverImages$2 = false;
                Intrinsics.checkNotNull((Object)imageName);
                if (!StringsKt.startsWith$default((String)imageName, (String)hostPrefix, (boolean)false, (int)2, null)) {
                    v2 = null;
                } else {
                    portStartIndex = hostPrefix.length();
                    portEndIndex = StringsKt.indexOf$default((CharSequence)imageName, (char)'/', (int)portStartIndex, (boolean)false, (int)4, null);
                    if (portEndIndex == -1) {
                        v2 = null;
                    } else {
                        try {
                            v3 = imageName.substring(portStartIndex, portEndIndex);
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
                            var19_38 = Integer.parseInt(v3);
                        }
                        catch (NumberFormatException e) {
                            v2 = null;
                            break block24;
                        }
                        port = var19_38;
                        v2 = new Pair((Object)port, (Object)imageName);
                    }
                }
            }
            if (v2 == null) continue;
            it$iv$iv = v2;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        for (T element$iv$iv : $this$groupByTo$iv$iv) {
            it = (Pair)element$iv$iv;
            $i$a$-groupBy-OciImages$cleanupLeftoverImages$3 = false;
            key$iv$iv = ((Number)it.getFirst()).intValue();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$2$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                v4 /* !! */  = answer$iv$iv$iv;
            } else {
                v4 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v4 /* !! */ ;
            $i$a$-groupBy-OciImages$cleanupLeftoverImages$3 = (Pair)element$iv$iv;
            var24_43 = list$iv$iv;
            $i$a$-groupBy-OciImages$cleanupLeftoverImages$4 = false;
            var24_43.add((String)it.getSecond());
        }
        $this$groupBy$iv = destination$iv$iv;
        $i$f$forEach = false;
        var6_6 = $this$forEach$iv.entrySet().iterator();
        while (var6_6.hasNext()) {
            var8_9 = element$iv = (Map.Entry)var6_6.next();
            $i$a$-forEach-OciImages$cleanupLeftoverImages$5 = false;
            port = ((Number)var8_9.getKey()).intValue();
            imageNames = (List)var8_9.getValue();
            if (port == currentRegistryPort) ** GOTO lbl-1000
            try {
                new ServerSocket(port).close();
                var12_21 = true;
            }
            catch (Exception ignored) {
                OciImages.logger.debug("Not removing images {} because they might be in use by another test run", (Object)imageNames);
                var12_21 = false;
            }
            if (var12_21) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = false;
            }
            if (!(isLeftover = v5)) continue;
            for (String imageName : imageNames) {
                try {
                    dockerClient.removeImageCmd(imageName).exec();
                    OciImages.logger.debug("Removed leftover image {}", (Object)imageName);
                }
                catch (NotFoundException $i$f$getOrPut) {
                }
                catch (Exception e) {
                    OciImages.logger.debug("Removing leftover image {} failed", (Object)imageName, (Object)e);
                    if (port != currentRegistryPort) continue;
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanup$gradle_oci_junit_jupiter() {
        OciImages ociImages = INSTANCE;
        synchronized (ociImages) {
            boolean bl = false;
            try {
                INSTANCE.cleanupImages();
            }
            finally {
                INSTANCE.stopRegistry();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void cleanupImages() {
        if (imageNames.isEmpty()) {
            return;
        }
        DockerClient dockerClient = DockerClientFactory.instance().client();
        Exception error = null;
        for (Pair pair : imageNames) {
            DockerImageName imageName = (DockerImageName)pair.component1();
            boolean retain = (Boolean)pair.component2();
            if (retain) {
                try {
                    dockerClient.tagImageCmd(imageName.toString(), imageName.getRepository(), imageName.getVersionPart()).exec();
                    logger.debug("Retained image {}:{}", (Object)imageName.getRepository(), (Object)imageName.getVersionPart());
                }
                catch (NotFoundException ignored) {
                    Object[] objectArray = new Object[]{imageName.getRepository(), imageName.getVersionPart(), ignored};
                    logger.debug("Retaining image {}:{} failed", objectArray);
                }
            }
            try {
                dockerClient.removeImageCmd(imageName.toString()).exec();
                logger.debug("Removed image {}", (Object)imageName);
            }
            catch (NotFoundException ignored) {
            }
            catch (Exception e) {
                logger.debug("Removing image {} failed", (Object)imageName, (Object)e);
                if (error == null) {
                    error = e;
                    continue;
                }
                ExceptionsKt.addSuppressed((Throwable)error, (Throwable)e);
            }
        }
        imageNames.clear();
        if (error != null) {
            throw error;
        }
    }

    private final void stopRegistry() {
        block0: {
            DisposableServer disposableServer = registry;
            if (disposableServer == null) break block0;
            DisposableServer $this$stopRegistry_u24lambda_u248 = disposableServer;
            boolean bl = false;
            logger.debug("Stopping OCI registry on port {}", (Object)$this$stopRegistry_u24lambda_u248.port());
            $this$stopRegistry_u24lambda_u248.disposeNow();
            logger.debug("Stopped OCI registry");
            registry = null;
        }
    }

    private static final void startRegistry$lambda$1() {
        INSTANCE.cleanup$gradle_oci_junit_jupiter();
    }

    static {
        imageNames = new LinkedHashSet();
        logger = LoggerFactory.getLogger(OciImages.class);
    }
}

