/*
 * Decompiled with CFR 0.152.
 */
package io.github.sgtsilvio.oci.registry;

import io.github.sgtsilvio.oci.registry.DistributionRegistryStorage;
import io.github.sgtsilvio.oci.registry.OciDigest;
import io.github.sgtsilvio.oci.registry.OciDigestAlgorithm;
import io.github.sgtsilvio.oci.registry.OciDigestKt;
import io.github.sgtsilvio.oci.registry.OciReference;
import io.github.sgtsilvio.oci.registry.OciRegistryStorage;
import io.github.sgtsilvio.oci.registry.OciTag;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u000bJA\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u0016J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u0018J!\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0010\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b J>\u0010!\u001a\b\u0012\u0004\u0012\u0002H\"0\r\"\u0004\b\u0000\u0010\"2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\"0\r0$H\u0002J%\u0010%\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b'J9\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b)J%\u0010*\u001a\u00020+2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0018\u0010.\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0018\u0010/\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0018\u00100\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0018\u00101\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\t2\u0006\u00102\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\t2\u0006\u00102\u001a\u000203H\u0002J \u00105\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\t2\u0006\u00102\u001a\u0002032\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u00106\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\tH\u0002J%\u00107\u001a\u00020+2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u00102\u001a\u000203H\u0010\u00a2\u0006\u0002\b8J\f\u00109\u001a\u00020\u0003*\u00020\u0003H\u0002J\u0014\u0010:\u001a\u00020+*\u00020\u00032\u0006\u0010;\u001a\u00020\u0003H\u0002J\u000e\u0010<\u001a\u0004\u0018\u00010\u001d*\u00020\u0003H\u0002J\u0014\u0010=\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u000e\u0010>\u001a\u0004\u0018\u00010\u0003*\u00020\u0003H\u0002J$\u0010?\u001a\u00020+*\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u0014H\u0002J(\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00140\r*\u00020B2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J!\u0010E\u001a\u00020+*\u00020\u00032\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020+0$H\u0082\bJ!\u0010G\u001a\u00020+*\u00020\u00032\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020+0$H\u0082\bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lio/github/sgtsilvio/oci/registry/DistributionRegistryStorage;", "Lio/github/sgtsilvio/oci/registry/OciRegistryStorage;", "directory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "blobUploadsInProgress", "Ljava/util/concurrent/ConcurrentHashMap;", "", "createBlobUpload", "", "repositoryName", "createBlobUpload$oci_registry", "finishBlobUpload", "Lreactor/core/publisher/Mono;", "Lio/github/sgtsilvio/oci/registry/OciDigest;", "id", "data", "Lreactor/core/publisher/Flux;", "Lio/netty/buffer/ByteBuf;", "offset", "", "digest", "finishBlobUpload$oci_registry", "getBlob", "getBlob$oci_registry", "getBlobUploadSize", "getBlobUploadSize$oci_registry", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Long;", "getManifest", "", "reference", "Lio/github/sgtsilvio/oci/registry/OciReference;", "getManifest$oci_registry", "lockBlobUpload", "T", "block", "Lkotlin/Function1;", "mountBlob", "fromRepositoryName", "mountBlob$oci_registry", "progressBlobUpload", "progressBlobUpload$oci_registry", "putManifest", "", "putManifest$oci_registry", "resolveBlobFile", "resolveBlobLinkFile", "resolveBlobUploadDataFile", "resolveManifestLinkFile", "resolveManifestTagCurrentLinkFile", "tag", "Lio/github/sgtsilvio/oci/registry/OciTag;", "resolveManifestTagDirectory", "resolveManifestTagIndexLinkFile", "resolveRepositoryDirectory", "tagManifest", "tagManifest$oci_registry", "createParentDirectories", "moveToIfNotExists", "target", "readLinkedBlob", "resolveLinkFile", "resolveLinkedBlobFile", "update", "Ljava/security/MessageDigest;", "fileChannel", "Ljava/nio/channels/FileChannel;", "length", "write", "writeAtomically", "writeOperation", "writeAtomicallyIfNotExists", "oci-registry"})
@SourceDebugExtension(value={"SMAP\nDistributionRegistryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistributionRegistryStorage.kt\nio/github/sgtsilvio/oci/registry/DistributionRegistryStorage\n*L\n1#1,276:1\n258#1,9:277\n258#1,9:286\n248#1,8:295\n258#1,9:303\n258#1,9:312\n*S KotlinDebug\n*F\n+ 1 DistributionRegistryStorage.kt\nio/github/sgtsilvio/oci/registry/DistributionRegistryStorage\n*L\n31#1:277,9\n33#1:286,9\n38#1:295,8\n40#1:303,9\n61#1:312,9\n*E\n"})
public final class DistributionRegistryStorage
extends OciRegistryStorage {
    @NotNull
    private final Path directory;
    @NotNull
    private final ConcurrentHashMap<Path, Boolean> blobUploadsInProgress;

    public DistributionRegistryStorage(@NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        super(null);
        this.directory = directory;
        this.blobUploadsInProgress = new ConcurrentHashMap();
    }

    @Override
    @Nullable
    public byte[] getManifest$oci_registry(@NotNull String repositoryName, @NotNull OciReference reference) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        OciReference ociReference = reference;
        if (ociReference instanceof OciTag) {
            path = this.resolveManifestTagCurrentLinkFile(repositoryName, (OciTag)reference);
        } else if (ociReference instanceof OciDigest) {
            path = this.resolveManifestLinkFile(repositoryName, (OciDigest)reference);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return this.readLinkedBlob(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putManifest$oci_registry(@NotNull String repositoryName, @NotNull OciDigest digest, @NotNull byte[] data) {
        DistributionRegistryStorage this_$iv;
        Path it;
        Path tempFile$iv;
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DistributionRegistryStorage distributionRegistryStorage = this;
        Path $this$writeAtomicallyIfNotExists$iv = this.createParentDirectories(this.resolveBlobFile(digest));
        boolean $i$f$writeAtomicallyIfNotExists = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$writeAtomicallyIfNotExists$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            tempFile$iv = PathsKt.createTempFile$default((Path)$this$writeAtomicallyIfNotExists$iv.getParent(), (String)PathsKt.getName((Path)$this$writeAtomicallyIfNotExists$iv), null, (FileAttribute[])new FileAttribute[0], (int)4, null);
            try {
                it = tempFile$iv;
                boolean bl = false;
                OpenOption[] openOptionArray = new OpenOption[]{};
                Files.write(it, data, Arrays.copyOf(openOptionArray, openOptionArray.length));
                this_$iv.moveToIfNotExists(tempFile$iv, $this$writeAtomicallyIfNotExists$iv);
            }
            finally {
                Files.deleteIfExists(tempFile$iv);
            }
        }
        this_$iv = this;
        $this$writeAtomicallyIfNotExists$iv = this.createParentDirectories(this.resolveManifestLinkFile(repositoryName, digest));
        $i$f$writeAtomicallyIfNotExists = false;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.exists($this$writeAtomicallyIfNotExists$iv, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            tempFile$iv = PathsKt.createTempFile$default((Path)$this$writeAtomicallyIfNotExists$iv.getParent(), (String)PathsKt.getName((Path)$this$writeAtomicallyIfNotExists$iv), null, (FileAttribute[])new FileAttribute[0], (int)4, null);
            try {
                it = tempFile$iv;
                boolean bl = false;
                PathsKt.writeText$default((Path)it, (CharSequence)digest.toString(), null, (OpenOption[])new OpenOption[0], (int)2, null);
                this_$iv.moveToIfNotExists(tempFile$iv, $this$writeAtomicallyIfNotExists$iv);
            }
            finally {
                Files.deleteIfExists(tempFile$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void tagManifest$oci_registry(@NotNull String repositoryName, @NotNull OciDigest digest, @NotNull OciTag tag) {
        void $this$writeAtomicallyIfNotExists$iv;
        Path it;
        Path $this$writeAtomically$iv;
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        DistributionRegistryStorage distributionRegistryStorage = this;
        Path path = this.createParentDirectories(this.resolveManifestTagCurrentLinkFile(repositoryName, tag));
        boolean $i$f$writeAtomically = false;
        Path tempFile$iv = PathsKt.createTempFile$default((Path)$this$writeAtomically$iv.getParent(), (String)PathsKt.getName((Path)$this$writeAtomically$iv), null, (FileAttribute[])new FileAttribute[0], (int)4, null);
        try {
            it = tempFile$iv;
            boolean $i$a$-writeAtomically-DistributionRegistryStorage$tagManifest$22 = false;
            PathsKt.writeText$default((Path)it, (CharSequence)digest.toString(), null, (OpenOption[])new OpenOption[0], (int)2, null);
            it = tempFile$iv;
            CopyOption[] $i$a$-writeAtomically-DistributionRegistryStorage$tagManifest$22 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray = $i$a$-writeAtomically-DistributionRegistryStorage$tagManifest$22;
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(it, $this$writeAtomically$iv, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
        }
        finally {
            Files.deleteIfExists(tempFile$iv);
        }
        DistributionRegistryStorage this_$iv = this;
        $this$writeAtomically$iv = this.createParentDirectories(this.resolveManifestTagIndexLinkFile(repositoryName, tag, digest));
        boolean $i$f$writeAtomicallyIfNotExists = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists((Path)$this$writeAtomicallyIfNotExists$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            tempFile$iv = PathsKt.createTempFile$default((Path)$this$writeAtomicallyIfNotExists$iv.getParent(), (String)PathsKt.getName((Path)$this$writeAtomicallyIfNotExists$iv), null, (FileAttribute[])new FileAttribute[0], (int)4, null);
            try {
                it = tempFile$iv;
                boolean bl = false;
                PathsKt.writeText$default((Path)it, (CharSequence)digest.toString(), null, (OpenOption[])new OpenOption[0], (int)2, null);
                this_$iv.moveToIfNotExists(tempFile$iv, (Path)$this$writeAtomicallyIfNotExists$iv);
            }
            finally {
                Files.deleteIfExists(tempFile$iv);
            }
        }
    }

    @Override
    @Nullable
    public Path getBlob$oci_registry(@NotNull String repositoryName, @NotNull OciDigest digest) {
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Path path = this.resolveLinkedBlobFile(this.resolveBlobLinkFile(repositoryName, digest));
        if (path == null) {
            return null;
        }
        Path blobFile = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(blobFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        return blobFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean mountBlob$oci_registry(@NotNull String repositoryName, @NotNull OciDigest digest, @NotNull String fromRepositoryName) {
        void $this$writeAtomicallyIfNotExists$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)fromRepositoryName, (String)"fromRepositoryName");
        try {
            object = PathsKt.readText$default((Path)this.resolveBlobLinkFile(fromRepositoryName, digest), null, (int)1, null);
        }
        catch (IOException e) {
            return false;
        }
        OciDigest blobDigest = OciDigestKt.toOciDigest((String)object);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.resolveBlobFile(blobDigest), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return false;
        }
        object = this;
        Path e = this.createParentDirectories(this.resolveBlobLinkFile(repositoryName, digest));
        boolean $i$f$writeAtomicallyIfNotExists = false;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.exists((Path)$this$writeAtomicallyIfNotExists$iv, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            Path tempFile$iv = PathsKt.createTempFile$default((Path)$this$writeAtomicallyIfNotExists$iv.getParent(), (String)PathsKt.getName((Path)$this$writeAtomicallyIfNotExists$iv), null, (FileAttribute[])new FileAttribute[0], (int)4, null);
            try {
                void this_$iv;
                Path it = tempFile$iv;
                boolean bl = false;
                PathsKt.writeText$default((Path)it, (CharSequence)blobDigest.toString(), null, (OpenOption[])new OpenOption[0], (int)2, null);
                ((DistributionRegistryStorage)this_$iv).moveToIfNotExists(tempFile$iv, (Path)$this$writeAtomicallyIfNotExists$iv);
            }
            finally {
                Files.deleteIfExists(tempFile$iv);
            }
        }
        return true;
    }

    @Override
    @NotNull
    public String createBlobUpload$oci_registry(@NotNull String repositoryName) {
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(this.createParentDirectories(this.resolveBlobUploadDataFile(repositoryName, id)), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        return id;
    }

    @Override
    @Nullable
    public Long getBlobUploadSize$oci_registry(@NotNull String repositoryName, @NotNull String id) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            l = Files.size(this.resolveBlobUploadDataFile(repositoryName, id));
        }
        catch (IOException e) {
            l = null;
        }
        return l;
    }

    private final <T> Mono<T> lockBlobUpload(String repositoryName, String id, Function1<? super Path, ? extends Mono<T>> block) {
        Mono mono = Mono.using(() -> DistributionRegistryStorage.lockBlobUpload$lambda$5(this, repositoryName, id), arg_0 -> DistributionRegistryStorage.lockBlobUpload$lambda$6(block, arg_0), arg_0 -> DistributionRegistryStorage.lockBlobUpload$lambda$7((Function1)new Function1<Path, Unit>(this){
            final /* synthetic */ DistributionRegistryStorage this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Path blobUploadDataFile) {
                DistributionRegistryStorage.access$getBlobUploadsInProgress$p(this.this$0).remove(blobUploadDataFile);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"using(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Long> progressBlobUpload$oci_registry(@NotNull String repositoryName, @NotNull String id, @NotNull Flux<ByteBuf> data, long offset) {
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return this.lockBlobUpload(repositoryName, id, (Function1)new Function1<Path, Mono<Long>>(offset, this, data){
            final /* synthetic */ long $offset;
            final /* synthetic */ DistributionRegistryStorage this$0;
            final /* synthetic */ Flux<ByteBuf> $data;
            {
                this.$offset = $offset;
                this.this$0 = $receiver;
                this.$data = $data;
                super(1);
            }

            @NotNull
            public final Mono<Long> invoke(@NotNull Path blobUploadDataFile) {
                Intrinsics.checkNotNullParameter((Object)blobUploadDataFile, (String)"blobUploadDataFile");
                Mono mono = Mono.using(() -> progressBlobUpload.1.invoke$lambda$0(blobUploadDataFile, this.$offset), arg_0 -> progressBlobUpload.1.invoke$lambda$1((Function1)new Function1<FileChannel, Mono<? extends Long>>(this.this$0, this.$data, this.$offset){
                    final /* synthetic */ DistributionRegistryStorage this$0;
                    final /* synthetic */ Flux<ByteBuf> $data;
                    final /* synthetic */ long $offset;
                    {
                        this.this$0 = $receiver;
                        this.$data = $data;
                        this.$offset = $offset;
                        super(1);
                    }

                    public final Mono<? extends Long> invoke(FileChannel fileChannel) {
                        Intrinsics.checkNotNull((Object)fileChannel);
                        return DistributionRegistryStorage.access$write(this.this$0, fileChannel, this.$data, RangesKt.coerceAtLeast((long)this.$offset, (long)0L));
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"using(...)");
                return mono;
            }

            private static final FileChannel invoke$lambda$0(Path $blobUploadDataFile, long $offset) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)$blobUploadDataFile, (String)"$blobUploadDataFile");
                try {
                    object = new OpenOption[]{StandardOpenOption.WRITE};
                    object = FileChannel.open($blobUploadDataFile, (OpenOption[])object);
                }
                catch (IOException e) {
                    throw new NoSuchElementException();
                }
                Object fileChannel = object;
                if ($offset != -1L && $offset != ((FileChannel)fileChannel).size()) {
                    throw new IndexOutOfBoundsException();
                }
                return fileChannel;
            }

            private static final Mono invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Mono)$tmp0.invoke(p0);
            }
        });
    }

    @Override
    @NotNull
    public Mono<OciDigest> finishBlobUpload$oci_registry(@NotNull String repositoryName, @NotNull String id, @NotNull Flux<ByteBuf> data, long offset, @NotNull OciDigest digest) {
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        return this.lockBlobUpload(repositoryName, id, (Function1)new Function1<Path, Mono<OciDigest>>(offset, digest, this, data, repositoryName){
            final /* synthetic */ long $offset;
            final /* synthetic */ OciDigest $digest;
            final /* synthetic */ DistributionRegistryStorage this$0;
            final /* synthetic */ Flux<ByteBuf> $data;
            final /* synthetic */ String $repositoryName;
            {
                this.$offset = $offset;
                this.$digest = $digest;
                this.this$0 = $receiver;
                this.$data = $data;
                this.$repositoryName = $repositoryName;
                super(1);
            }

            @NotNull
            public final Mono<OciDigest> invoke(@NotNull Path blobUploadDataFile) {
                Intrinsics.checkNotNullParameter((Object)blobUploadDataFile, (String)"blobUploadDataFile");
                Mono mono = Mono.using(() -> finishBlobUpload.1.invoke$lambda$0(blobUploadDataFile, this.$offset), arg_0 -> finishBlobUpload.1.invoke$lambda$1((Function1)new Function1<FileChannel, Mono<? extends OciDigest>>(this.$digest, this.$offset, this.this$0, this.$data){
                    final /* synthetic */ OciDigest $digest;
                    final /* synthetic */ long $offset;
                    final /* synthetic */ DistributionRegistryStorage this$0;
                    final /* synthetic */ Flux<ByteBuf> $data;
                    {
                        this.$digest = $digest;
                        this.$offset = $offset;
                        this.this$0 = $receiver;
                        this.$data = $data;
                        super(1);
                    }

                    public final Mono<? extends OciDigest> invoke(FileChannel fileChannel) {
                        MessageDigest messageDigest = this.$digest.getAlgorithm().createMessageDigest();
                        if (this.$offset > 0L) {
                            Intrinsics.checkNotNull((Object)fileChannel);
                            DistributionRegistryStorage.access$update(this.this$0, messageDigest, fileChannel, 0L, this.$offset);
                        }
                        Intrinsics.checkNotNull((Object)fileChannel);
                        Flux flux = this.$data.doOnNext(arg_0 -> finishBlobUpload.2.invoke$lambda$0((Function1)new Function1<ByteBuf, Unit>(messageDigest){
                            final /* synthetic */ MessageDigest $messageDigest;
                            {
                                this.$messageDigest = $messageDigest;
                                super(1);
                            }

                            public final void invoke(ByteBuf byteBuf) {
                                this.$messageDigest.update(byteBuf.nioBuffer());
                            }
                        }, arg_0));
                        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"doOnNext(...)");
                        return DistributionRegistryStorage.access$write(this.this$0, fileChannel, flux, RangesKt.coerceAtLeast((long)this.$offset, (long)0L)).map(arg_0 -> finishBlobUpload.2.invoke$lambda$1((Function1)new Function1<Long, OciDigest>(fileChannel, this.this$0, messageDigest, this.$digest){
                            final /* synthetic */ FileChannel $fileChannel;
                            final /* synthetic */ DistributionRegistryStorage this$0;
                            final /* synthetic */ MessageDigest $messageDigest;
                            final /* synthetic */ OciDigest $digest;
                            {
                                this.$fileChannel = $fileChannel;
                                this.this$0 = $receiver;
                                this.$messageDigest = $messageDigest;
                                this.$digest = $digest;
                                super(1);
                            }

                            public final OciDigest invoke(Long position) {
                                Intrinsics.checkNotNull((Object)position);
                                if (position < this.$fileChannel.size()) {
                                    FileChannel fileChannel = this.$fileChannel;
                                    Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"$fileChannel");
                                    DistributionRegistryStorage.access$update(this.this$0, this.$messageDigest, fileChannel, position, Long.MAX_VALUE);
                                }
                                OciDigestAlgorithm ociDigestAlgorithm = this.$digest.getAlgorithm();
                                byte[] byArray = this.$messageDigest.digest();
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
                                return new OciDigest(ociDigestAlgorithm, byArray);
                            }
                        }, arg_0));
                    }

                    private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }

                    private static final OciDigest invoke$lambda$1(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (OciDigest)$tmp0.invoke(p0);
                    }
                }, arg_0)).doOnNext(arg_0 -> finishBlobUpload.1.invoke$lambda$2((Function1)new Function1<OciDigest, Unit>(this.$digest, this.this$0, blobUploadDataFile, this.$repositoryName){
                    final /* synthetic */ OciDigest $digest;
                    final /* synthetic */ DistributionRegistryStorage this$0;
                    final /* synthetic */ Path $blobUploadDataFile;
                    final /* synthetic */ String $repositoryName;
                    {
                        this.$digest = $digest;
                        this.this$0 = $receiver;
                        this.$blobUploadDataFile = $blobUploadDataFile;
                        this.$repositoryName = $repositoryName;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final void invoke(OciDigest actualDigest) {
                        void $this$writeAtomicallyIfNotExists$iv;
                        Object blobFile;
                        try {
                            if (!Intrinsics.areEqual((Object)this.$digest, (Object)actualDigest)) {
                                throw new DigestException();
                            }
                            blobFile = DistributionRegistryStorage.access$createParentDirectories(this.this$0, DistributionRegistryStorage.access$resolveBlobFile(this.this$0, this.$digest));
                            DistributionRegistryStorage.access$moveToIfNotExists(this.this$0, this.$blobUploadDataFile, (Path)blobFile);
                        }
                        finally {
                            Files.deleteIfExists(this.$blobUploadDataFile);
                            Path path = this.$blobUploadDataFile.getParent();
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
                            Files.deleteIfExists(path);
                        }
                        blobFile = this.this$0;
                        Path path = DistributionRegistryStorage.access$createParentDirectories(this.this$0, DistributionRegistryStorage.access$resolveBlobLinkFile(this.this$0, this.$repositoryName, this.$digest));
                        OciDigest ociDigest = this.$digest;
                        boolean $i$f$writeAtomicallyIfNotExists = false;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!Files.exists((Path)$this$writeAtomicallyIfNotExists$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            Path tempFile$iv = PathsKt.createTempFile$default((Path)$this$writeAtomicallyIfNotExists$iv.getParent(), (String)PathsKt.getName((Path)$this$writeAtomicallyIfNotExists$iv), null, (FileAttribute[])new FileAttribute[0], (int)4, null);
                            try {
                                void this_$iv;
                                Path it = tempFile$iv;
                                boolean bl = false;
                                PathsKt.writeText$default((Path)it, (CharSequence)ociDigest.toString(), null, (OpenOption[])new OpenOption[0], (int)2, null);
                                DistributionRegistryStorage.access$moveToIfNotExists((DistributionRegistryStorage)this_$iv, tempFile$iv, (Path)$this$writeAtomicallyIfNotExists$iv);
                            }
                            finally {
                                Files.deleteIfExists(tempFile$iv);
                            }
                        }
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnNext(...)");
                return mono;
            }

            private static final FileChannel invoke$lambda$0(Path $blobUploadDataFile, long $offset) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)$blobUploadDataFile, (String)"$blobUploadDataFile");
                try {
                    object = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
                    object = FileChannel.open($blobUploadDataFile, (OpenOption[])object);
                }
                catch (IOException e) {
                    throw new NoSuchElementException();
                }
                Object fileChannel = object;
                if ($offset != -1L && $offset != ((FileChannel)fileChannel).size()) {
                    throw new IndexOutOfBoundsException();
                }
                return fileChannel;
            }

            private static final Mono invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Mono)$tmp0.invoke(p0);
            }

            private static final void invoke$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        });
    }

    private final Mono<Long> write(FileChannel $this$write, Flux<ByteBuf> data, long offset) {
        Mono mono = data.scan((Object)offset, (arg_0, arg_1) -> DistributionRegistryStorage.write$lambda$8((Function2)new Function2<Long, ByteBuf, Long>($this$write){
            final /* synthetic */ FileChannel $this_write;
            {
                this.$this_write = $receiver;
                super(2);
            }

            public final Long invoke(Long position, ByteBuf byteBuf) {
                int length = byteBuf.readableBytes();
                Intrinsics.checkNotNull((Object)position);
                byteBuf.readBytes(this.$this_write, position.longValue(), length);
                return position + (long)length;
            }
        }, arg_0, arg_1)).last();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"last(...)");
        return mono;
    }

    private final void update(MessageDigest $this$update, FileChannel fileChannel, long offset, long length) {
        int read;
        int bufferCapacity = 8192;
        ByteBuffer buffer = ByteBuffer.allocate(bufferCapacity);
        long position = offset;
        for (long remaining = length; remaining > 0L; remaining -= (long)read) {
            buffer.position(0);
            buffer.limit((int)RangesKt.coerceAtMost((long)remaining, (long)bufferCapacity));
            read = fileChannel.read(buffer, position);
            if (read == -1) {
                if (length == Long.MAX_VALUE) break;
                throw new IllegalStateException();
            }
            buffer.flip();
            $this$update.update(buffer);
            position += (long)read;
        }
    }

    private final Path resolveBlobFile(OciDigest digest) {
        String encodedHash = digest.getEncodedHash();
        Path path = this.directory.resolve("blobs").resolve(digest.getAlgorithm().getId());
        String string = encodedHash.substring(0, 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Path path2 = path.resolve(string).resolve(encodedHash).resolve("data");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    private final Path resolveRepositoryDirectory(String repositoryName) {
        Path path = this.directory.resolve("repositories").resolve(repositoryName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path resolveManifestLinkFile(String repositoryName, OciDigest digest) {
        Path path = this.resolveRepositoryDirectory(repositoryName).resolve("_manifests/revisions");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return this.resolveLinkFile(path, digest);
    }

    private final Path resolveManifestTagDirectory(String repositoryName, OciTag tag) {
        Path path = this.resolveRepositoryDirectory(repositoryName).resolve("_manifests/tags").resolve(tag.getName());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path resolveManifestTagCurrentLinkFile(String repositoryName, OciTag tag) {
        Path path = this.resolveManifestTagDirectory(repositoryName, tag).resolve("current/link");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path resolveManifestTagIndexLinkFile(String repositoryName, OciTag tag, OciDigest digest) {
        Path path = this.resolveManifestTagDirectory(repositoryName, tag).resolve("index");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return this.resolveLinkFile(path, digest);
    }

    private final Path resolveBlobLinkFile(String repositoryName, OciDigest digest) {
        Path path = this.resolveRepositoryDirectory(repositoryName).resolve("_layers");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return this.resolveLinkFile(path, digest);
    }

    private final Path resolveLinkFile(Path $this$resolveLinkFile, OciDigest digest) {
        Path path = $this$resolveLinkFile.resolve(digest.getAlgorithm().getId()).resolve(digest.getEncodedHash()).resolve("link");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path resolveLinkedBlobFile(Path $this$resolveLinkedBlobFile) {
        String string;
        try {
            string = PathsKt.readText$default((Path)$this$resolveLinkedBlobFile, null, (int)1, null);
        }
        catch (IOException e) {
            return null;
        }
        OciDigest digest = OciDigestKt.toOciDigest(string);
        return this.resolveBlobFile(digest);
    }

    private final byte[] readLinkedBlob(Path $this$readLinkedBlob) {
        byte[] byArray;
        Path path = this.resolveLinkedBlobFile($this$readLinkedBlob);
        if (path == null) {
            return null;
        }
        Path blobFile = path;
        try {
            byte[] byArray2 = Files.readAllBytes(blobFile);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readAllBytes(...)");
            byArray = byArray2;
        }
        catch (IOException e) {
            byArray = null;
        }
        return byArray;
    }

    private final Path resolveBlobUploadDataFile(String repositoryName, String id) {
        Path path = this.resolveRepositoryDirectory(repositoryName).resolve("_uploads").resolve(id).resolve("data");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path createParentDirectories(Path $this$createParentDirectories) {
        Path path;
        Path path2 = $this$createParentDirectories.getParent();
        if (path2 != null) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
        } else {
            path = null;
        }
        return $this$createParentDirectories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeAtomically(Path $this$writeAtomically, Function1<? super Path, Unit> writeOperation) {
        boolean $i$f$writeAtomically = false;
        Path tempFile = PathsKt.createTempFile$default((Path)$this$writeAtomically.getParent(), (String)PathsKt.getName((Path)$this$writeAtomically), null, (FileAttribute[])new FileAttribute[0], (int)4, null);
        try {
            writeOperation.invoke((Object)tempFile);
            Path path = tempFile;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, $this$writeAtomically, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"move(...)");
        }
        finally {
            InlineMarker.finallyStart((int)1);
            Files.deleteIfExists(tempFile);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeAtomicallyIfNotExists(Path $this$writeAtomicallyIfNotExists, Function1<? super Path, Unit> writeOperation) {
        boolean $i$f$writeAtomicallyIfNotExists = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists($this$writeAtomicallyIfNotExists, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        Path tempFile = PathsKt.createTempFile$default((Path)$this$writeAtomicallyIfNotExists.getParent(), (String)PathsKt.getName((Path)$this$writeAtomicallyIfNotExists), null, (FileAttribute[])new FileAttribute[0], (int)4, null);
        try {
            writeOperation.invoke((Object)tempFile);
            this.moveToIfNotExists(tempFile, $this$writeAtomicallyIfNotExists);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            Files.deleteIfExists(tempFile);
            InlineMarker.finallyEnd((int)1);
        }
    }

    private final void moveToIfNotExists(Path $this$moveToIfNotExists, Path target) {
        block2: {
            try {
                Path path = $this$moveToIfNotExists;
                CopyOption[] copyOptionArray = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, target, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
            }
            catch (IOException e) {
                if (e instanceof FileAlreadyExistsException) break block2;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(target, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block2;
                throw e;
            }
        }
    }

    private static final Path lockBlobUpload$lambda$5(DistributionRegistryStorage this$0, String $repositoryName, String $id) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$repositoryName, (String)"$repositoryName");
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        Path blobUploadDataFile = this$0.resolveBlobUploadDataFile($repositoryName, $id);
        if (this$0.blobUploadsInProgress.putIfAbsent(blobUploadDataFile, true) != null) {
            throw new ConcurrentModificationException();
        }
        return blobUploadDataFile;
    }

    private static final Mono lockBlobUpload$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final void lockBlobUpload$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Long write$lambda$8(Function2 $tmp0, Long p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Long)$tmp0.invoke((Object)p0, p1);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getBlobUploadsInProgress$p(DistributionRegistryStorage $this) {
        return $this.blobUploadsInProgress;
    }

    public static final /* synthetic */ Mono access$write(DistributionRegistryStorage $this, FileChannel $receiver, Flux data, long offset) {
        return $this.write($receiver, (Flux<ByteBuf>)data, offset);
    }

    public static final /* synthetic */ void access$update(DistributionRegistryStorage $this, MessageDigest $receiver, FileChannel fileChannel, long offset, long length) {
        $this.update($receiver, fileChannel, offset, length);
    }

    public static final /* synthetic */ Path access$createParentDirectories(DistributionRegistryStorage $this, Path $receiver) {
        return $this.createParentDirectories($receiver);
    }

    public static final /* synthetic */ Path access$resolveBlobFile(DistributionRegistryStorage $this, OciDigest digest) {
        return $this.resolveBlobFile(digest);
    }

    public static final /* synthetic */ Path access$resolveBlobLinkFile(DistributionRegistryStorage $this, String repositoryName, OciDigest digest) {
        return $this.resolveBlobLinkFile(repositoryName, digest);
    }
}

