/*
 * Decompiled with CFR 0.152.
 */
package io.github.sgtsilvio.oci.registry;

import io.github.sgtsilvio.oci.registry.OciDigestAlgorithm;
import io.github.sgtsilvio.oci.registry.OciReference;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lio/github/sgtsilvio/oci/registry/OciDigest;", "Lio/github/sgtsilvio/oci/registry/OciReference;", "algorithm", "Lio/github/sgtsilvio/oci/registry/OciDigestAlgorithm;", "hash", "", "(Lio/github/sgtsilvio/oci/registry/OciDigestAlgorithm;[B)V", "getAlgorithm", "()Lio/github/sgtsilvio/oci/registry/OciDigestAlgorithm;", "encodedHash", "", "getEncodedHash", "()Ljava/lang/String;", "getHash", "()[B", "equals", "", "other", "", "hashCode", "", "toString", "oci-registry"})
public final class OciDigest
implements OciReference {
    @NotNull
    private final OciDigestAlgorithm algorithm;
    @NotNull
    private final byte[] hash;

    public OciDigest(@NotNull OciDigestAlgorithm algorithm, @NotNull byte[] hash) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        this.algorithm = algorithm;
        this.hash = hash;
        this.algorithm.validateHash(this.hash);
    }

    @NotNull
    public final OciDigestAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] getHash() {
        return this.hash;
    }

    @NotNull
    public final String getEncodedHash() {
        return this.algorithm.encodeHash(this.hash);
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof OciDigest) ? false : (!Intrinsics.areEqual((Object)this.algorithm, (Object)((OciDigest)other).algorithm) ? false : Arrays.equals(this.hash, ((OciDigest)other).hash)));
    }

    public int hashCode() {
        int result = this.algorithm.hashCode();
        result = 31 * result + Arrays.hashCode(this.hash);
        return result;
    }

    @NotNull
    public String toString() {
        return this.algorithm.getId() + ':' + this.getEncodedHash();
    }
}

