/*
 * Decompiled with CFR 0.152.
 */
package io.github.sgtsilvio.oci.registry;

import io.github.sgtsilvio.oci.registry.OciDigest;
import io.github.sgtsilvio.oci.registry.OciDigestAlgorithm;
import io.github.sgtsilvio.oci.registry.StandardOciDigestAlgorithm;
import io.github.sgtsilvio.oci.registry.UnsupportedOciDigestAlgorithm;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0007H\u0000\u001a\f\u0010\n\u001a\u00020\u0004*\u00020\u000bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"OCI_DIGEST_ALGORITHM_REGEX", "Lkotlin/text/Regex;", "OCI_DIGEST_ENCODED_HASH_REGEX", "calculateOciDigest", "Lio/github/sgtsilvio/oci/registry/OciDigest;", "", "algorithm", "Lio/github/sgtsilvio/oci/registry/OciDigestAlgorithm;", "isUnsupported", "", "toOciDigest", "", "oci-registry"})
public final class OciDigestKt {
    @NotNull
    private static final Regex OCI_DIGEST_ALGORITHM_REGEX = new Regex("[a-z0-9]+(?:[.+_-][a-z0-9]+)*");
    @NotNull
    private static final Regex OCI_DIGEST_ENCODED_HASH_REGEX = new Regex("[a-zA-Z0-9=_-]+");

    public static final boolean isUnsupported(@NotNull OciDigestAlgorithm $this$isUnsupported) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnsupported, (String)"<this>");
        return $this$isUnsupported instanceof UnsupportedOciDigestAlgorithm;
    }

    @NotNull
    public static final OciDigest toOciDigest(@NotNull String $this$toOciDigest) {
        Intrinsics.checkNotNullParameter((Object)$this$toOciDigest, (String)"<this>");
        int colonIndex = StringsKt.indexOf$default((CharSequence)$this$toOciDigest, (char)':', (int)0, (boolean)false, (int)6, null);
        if (colonIndex == -1) {
            throw new IllegalArgumentException("missing ':' in digest '" + $this$toOciDigest + '\'');
        }
        String string = $this$toOciDigest.substring(0, colonIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String algorithmId = string;
        OciDigestAlgorithm algorithm = Intrinsics.areEqual((Object)algorithmId, (Object)StandardOciDigestAlgorithm.SHA_256.getId()) ? (OciDigestAlgorithm)StandardOciDigestAlgorithm.SHA_256 : (Intrinsics.areEqual((Object)algorithmId, (Object)StandardOciDigestAlgorithm.SHA_512.getId()) ? (OciDigestAlgorithm)StandardOciDigestAlgorithm.SHA_512 : (OciDigestAlgorithm)new UnsupportedOciDigestAlgorithm(algorithmId));
        String string2 = $this$toOciDigest.substring(colonIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return new OciDigest(algorithm, algorithm.decodeHash(string2));
    }

    @NotNull
    public static final OciDigest calculateOciDigest(@NotNull byte[] $this$calculateOciDigest, @NotNull OciDigestAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateOciDigest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        byte[] byArray = algorithm.createMessageDigest().digest($this$calculateOciDigest);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return new OciDigest(algorithm, byArray);
    }

    public static final /* synthetic */ Regex access$getOCI_DIGEST_ALGORITHM_REGEX$p() {
        return OCI_DIGEST_ALGORITHM_REGEX;
    }

    public static final /* synthetic */ Regex access$getOCI_DIGEST_ENCODED_HASH_REGEX$p() {
        return OCI_DIGEST_ENCODED_HASH_REGEX;
    }
}

