/*
 * Decompiled with CFR 0.152.
 */
package io.github.sgtsilvio.oci.registry;

import io.github.sgtsilvio.oci.registry.OciDigest;
import io.github.sgtsilvio.oci.registry.OciDigestAlgorithm;
import io.github.sgtsilvio.oci.registry.OciDigestKt;
import io.github.sgtsilvio.oci.registry.OciReference;
import io.github.sgtsilvio.oci.registry.OciReferenceKt;
import io.github.sgtsilvio.oci.registry.OciRegistryHandlerKt;
import io.github.sgtsilvio.oci.registry.OciRegistryStorage;
import io.github.sgtsilvio.oci.registry.OciTag;
import io.github.sgtsilvio.oci.registry.StandardOciDigestAlgorithm;
import io.github.sgtsilvio.oci.registry.http.HttpRange;
import io.github.sgtsilvio.oci.registry.http.HttpRangeKt;
import io.github.sgtsilvio.oci.registry.http.HttpRangeSpec;
import io.github.sgtsilvio.oci.registry.http.HttpServerResponseExtensionsKt;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.DigestException;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.netty.ByteBufFlux;
import reactor.netty.NettyOutbound;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J.\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J.\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J.\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J&\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J&\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J.\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J.\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J&\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J.\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J.\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0002JD\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050/2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u00010\u000e2\u0006\u00103\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J.\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0018\u00105\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00106\u001a\u000207H\u0002J\u0018\u00108\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00106\u001a\u000207H\u0002J@\u00109\u001a&\u0012\f\u0012\n :*\u0004\u0018\u00010\u00050\u0005 :*\u0012\u0012\f\u0012\n :*\u0004\u0018\u00010\u00050\u0005\u0018\u00010/0/*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lio/github/sgtsilvio/oci/registry/OciRegistryHandler;", "Ljava/util/function/BiFunction;", "Lreactor/netty/http/server/HttpServerRequest;", "Lreactor/netty/http/server/HttpServerResponse;", "Lorg/reactivestreams/Publisher;", "Ljava/lang/Void;", "storage", "Lio/github/sgtsilvio/oci/registry/OciRegistryStorage;", "(Lio/github/sgtsilvio/oci/registry/OciRegistryStorage;)V", "apply", "request", "response", "createBlobUpload", "repositoryName", "", "deleteBlob", "digest", "Lio/github/sgtsilvio/oci/registry/OciDigest;", "deleteBlobUpload", "id", "deleteManifest", "reference", "Lio/github/sgtsilvio/oci/registry/OciReference;", "getBlob", "getOrHeadBlobUpload", "getOrHeadManifest", "isGet", "", "getRepositories", "getTags", "handleBlob", "rawDigest", "handleBlobUpload", "handleCatalog", "handleManifest", "rawReference", "handleTags", "handleV2", "path", "headBlob", "mountBlob", "fromRepositoryName", "patchBlobUpload", "postBlobUpload", "putBlob", "putBlobUpload", "putManifest", "Lreactor/core/publisher/Mono;", "tag", "Lio/github/sgtsilvio/oci/registry/OciTag;", "mediaType", "data", "", "validateIndex", "jsonObject", "Lorg/json/JSONObject;", "validateManifest", "sendBlobCreated", "kotlin.jvm.PlatformType", "oci-registry"})
public final class OciRegistryHandler
implements BiFunction<HttpServerRequest, HttpServerResponse, Publisher<Void>> {
    @NotNull
    private final OciRegistryStorage storage;

    public OciRegistryHandler(@NotNull OciRegistryStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
    }

    @Override
    @NotNull
    public Publisher<Void> apply(@NotNull HttpServerRequest request, @NotNull HttpServerResponse response) {
        Publisher<Void> publisher;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string = request.fullPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fullPath(...)");
        String string2 = string;
        int n = 1;
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String path = string3;
        if (Intrinsics.areEqual((Object)StringsKt.substringBefore$default((String)path, (char)'/', null, (int)2, null), (Object)"v2")) {
            String string4 = path.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            publisher = this.handleV2(request, string4, response);
        } else {
            Mono mono = response.sendNotFound();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"sendNotFound(...)");
            publisher = (Publisher<Void>)mono;
        }
        return publisher;
    }

    /*
     * Unable to fully structure code
     */
    private final Publisher<Void> handleV2(HttpServerRequest request, String path, HttpServerResponse response) {
        var4_4 = path;
        switch (var4_4.hashCode()) {
            case 0: {
                if (!var4_4.equals("")) {
                    ** break;
                }
                ** GOTO lbl12
            }
            case -432052215: {
                if (var4_4.equals("/_catalog")) break;
                ** break;
            }
            case 47: {
                if (!var4_4.equals("/")) ** break;
lbl12:
                // 2 sources

                if (Intrinsics.areEqual((Object)(var5_6 = request.method()), (Object)HttpMethod.GET) != false ? true : Intrinsics.areEqual((Object)var5_6, (Object)HttpMethod.HEAD)) {
                    v0 = response.header((CharSequence)"Docker-Distribution-API-Version", (CharSequence)"registry/2.0").send();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"send(...)");
                    v1 = (Publisher)v0;
                } else {
                    v2 = response.status(HttpResponseStatus.METHOD_NOT_ALLOWED).send();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"send(...)");
                    v1 = (Publisher)v2;
                }
                return v1;
            }
        }
        return this.handleCatalog(request, response);
lbl22:
        // 4 sources

        lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        secondLastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)(lastSlashIndex - 1), (boolean)false, (int)4, null);
        if (secondLastSlashIndex < 1) {
            v3 = response.sendNotFound();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"sendNotFound(...)");
            return (Publisher)v3;
        }
        v4 = path.substring(1, secondLastSlashIndex);
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"substring(...)");
        firstSegments = v4;
        v5 = path.substring(secondLastSlashIndex + 1, lastSlashIndex);
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"substring(...)");
        secondLastSegment = v5;
        v6 = path.substring(lastSlashIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"substring(...)");
        lastSegment = v6;
        var9_11 = secondLastSegment;
        tmp = -1;
        switch (var9_11.hashCode()) {
            case 93832310: {
                if (var9_11.equals("blobs")) {
                    tmp = 1;
                }
                break;
            }
            case -245589980: {
                if (var9_11.equals("manifests")) {
                    tmp = 2;
                }
                break;
            }
            case 3552281: {
                if (var9_11.equals("tags")) {
                    tmp = 3;
                }
                break;
            }
            case -226643310: {
                if (var9_11.equals("uploads")) {
                    tmp = 4;
                }
                break;
            }
        }
        switch (tmp) {
            case 3: {
                var10_12 = Intrinsics.areEqual((Object)lastSegment, (Object)"list") != false ? this.handleTags(firstSegments, request, response) : (Publisher<Void>)response.sendNotFound();
                Intrinsics.checkNotNull(var10_12);
                v7 = var10_12;
                break;
            }
            case 2: {
                v7 = this.handleManifest(firstSegments, lastSegment, request, response);
                break;
            }
            case 1: {
                v7 = this.handleBlob(firstSegments, lastSegment, request, response);
                break;
            }
            case 4: {
                var10_13 = StringsKt.endsWith$default((String)firstSegments, (String)"/blobs", (boolean)false, (int)2, null) != false ? this.handleBlobUpload(StringsKt.removeSuffix((String)firstSegments, (CharSequence)"/blobs"), lastSegment, request, response) : (Publisher<Void>)response.sendNotFound();
                Intrinsics.checkNotNull((Object)var10_13);
                v7 = var10_13;
                break;
            }
            default: {
                v8 = response.sendNotFound();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"sendNotFound(...)");
                v7 = (Publisher<Void>)v8;
            }
        }
        return v7;
    }

    private final Publisher<Void> handleCatalog(HttpServerRequest request, HttpServerResponse response) {
        Publisher publisher;
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.GET)) {
            publisher = this.getRepositories(response);
        } else {
            Mono mono = response.status(HttpResponseStatus.METHOD_NOT_ALLOWED).send();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
            publisher = (Publisher)mono;
        }
        return publisher;
    }

    private final Publisher<Void> getRepositories(HttpServerResponse response) {
        Mono mono = response.status(HttpResponseStatus.METHOD_NOT_ALLOWED).send();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
        return (Publisher)mono;
    }

    private final Publisher<Void> handleTags(String repositoryName, HttpServerRequest request, HttpServerResponse response) {
        Publisher publisher;
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.GET)) {
            publisher = this.getTags(repositoryName, response);
        } else {
            Mono mono = response.status(HttpResponseStatus.METHOD_NOT_ALLOWED).send();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
            publisher = (Publisher)mono;
        }
        return publisher;
    }

    private final Publisher<Void> getTags(String repositoryName, HttpServerResponse response) {
        Mono mono = response.status(HttpResponseStatus.METHOD_NOT_ALLOWED).send();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
        return (Publisher)mono;
    }

    private final Publisher<Void> handleManifest(String repositoryName, String rawReference, HttpServerRequest request, HttpServerResponse response) {
        Publisher publisher;
        OciReference ociReference;
        try {
            ociReference = OciReferenceKt.toOciReference(rawReference);
        }
        catch (IllegalArgumentException e) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        OciReference reference = ociReference;
        ociReference = request.method();
        if (Intrinsics.areEqual((Object)ociReference, (Object)HttpMethod.GET)) {
            publisher = this.getOrHeadManifest(repositoryName, reference, true, response);
        } else if (Intrinsics.areEqual((Object)ociReference, (Object)HttpMethod.HEAD)) {
            publisher = this.getOrHeadManifest(repositoryName, reference, false, response);
        } else if (Intrinsics.areEqual((Object)ociReference, (Object)HttpMethod.PUT)) {
            publisher = this.putManifest(repositoryName, reference, request, response);
        } else if (Intrinsics.areEqual((Object)ociReference, (Object)HttpMethod.DELETE)) {
            publisher = this.deleteManifest(repositoryName, reference, response);
        } else {
            Mono mono = response.status(HttpResponseStatus.METHOD_NOT_ALLOWED).send();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
            publisher = (Publisher)mono;
        }
        return publisher;
    }

    private final Publisher<Void> getOrHeadManifest(String repositoryName, OciReference reference, boolean isGet, HttpServerResponse response) {
        Publisher publisher;
        byte[] byArray = this.storage.getManifest$oci_registry(repositoryName, reference);
        if (byArray == null) {
            Mono mono = response.sendNotFound();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"sendNotFound(...)");
            return (Publisher)mono;
        }
        byte[] manifestBytes = byArray;
        response.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)new JSONObject(StringsKt.decodeToString((byte[])manifestBytes)).getString("mediaType"));
        response.header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(manifestBytes.length));
        if (isGet) {
            NettyOutbound nettyOutbound = response.sendByteArray((Publisher)Mono.just((Object)manifestBytes));
            Intrinsics.checkNotNullExpressionValue((Object)nettyOutbound, (String)"sendByteArray(...)");
            publisher = (Publisher)nettyOutbound;
        } else {
            Mono mono = response.send();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
            publisher = (Publisher)mono;
        }
        return publisher;
    }

    private final Publisher<Void> putManifest(String repositoryName, OciReference reference, HttpServerRequest request, HttpServerResponse response) {
        if (reference instanceof OciDigest && OciDigestKt.isUnsupported(((OciDigest)reference).getAlgorithm())) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        String contentType = request.requestHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        Mono mono = request.receive().aggregate().asByteArray().flatMap(arg_0 -> OciRegistryHandler.putManifest$lambda$0((Function1)new Function1<byte[], Mono<? extends Void>>(this, repositoryName, reference, contentType, response){
            final /* synthetic */ OciRegistryHandler this$0;
            final /* synthetic */ String $repositoryName;
            final /* synthetic */ OciReference $reference;
            final /* synthetic */ String $contentType;
            final /* synthetic */ HttpServerResponse $response;
            {
                this.this$0 = $receiver;
                this.$repositoryName = $repositoryName;
                this.$reference = $reference;
                this.$contentType = $contentType;
                this.$response = $response;
                super(1);
            }

            public final Mono<? extends Void> invoke(byte[] data) {
                OciReference ociReference = this.$reference;
                OciDigest ociDigest = ociReference instanceof OciDigest ? (OciDigest)ociReference : null;
                ociReference = this.$reference;
                OciTag ociTag = ociReference instanceof OciTag ? (OciTag)ociReference : null;
                Intrinsics.checkNotNull((Object)data);
                return OciRegistryHandler.access$putManifest(this.this$0, this.$repositoryName, ociDigest, ociTag, this.$contentType, data, this.$response);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return (Publisher)mono;
    }

    /*
     * Unable to fully structure code
     */
    private final Mono<Void> putManifest(String repositoryName, OciDigest digest, OciTag tag, String mediaType, byte[] data, HttpServerResponse response) {
        block16: {
            v0 = digest;
            if (v0 == null || (v0 = v0.getAlgorithm()) == null) {
                v0 = StandardOciDigestAlgorithm.SHA_256;
            }
            actualDigest = OciDigestKt.calculateOciDigest(data, (OciDigestAlgorithm)v0);
            if (digest != null && !Intrinsics.areEqual((Object)digest, (Object)actualDigest)) {
                return HttpServerResponseExtensionsKt.sendBadRequest(response);
            }
            try {
                var9_8 = new JSONObject(StringsKt.decodeToString((byte[])data));
            }
            catch (JSONException e) {
                return HttpServerResponseExtensionsKt.sendBadRequest(response);
            }
            manifestJsonObject = var9_8;
            actualMediaType = manifestJsonObject.opt("mediaType");
            if (!(actualMediaType instanceof String)) {
                return HttpServerResponseExtensionsKt.sendBadRequest(response);
            }
            if (mediaType != null && !Intrinsics.areEqual((Object)mediaType, (Object)actualMediaType)) {
                return HttpServerResponseExtensionsKt.sendBadRequest(response);
            }
            var10_10 = (String)actualMediaType;
            switch (var10_10.hashCode()) {
                case -1585366650: {
                    if (var10_10.equals("application/vnd.oci.image.manifest.v1+json")) break;
                    ** break;
                }
                case 1275881109: {
                    if (var10_10.equals("application/vnd.docker.distribution.manifest.v2+json")) break;
                    ** break;
                }
                case -1504499703: {
                    if (!var10_10.equals("application/vnd.docker.distribution.manifest.list.v2+json")) {
                        ** break;
                    }
                    ** GOTO lbl33
                }
                case -2112740433: {
                    if (!var10_10.equals("application/vnd.oci.image.index.v1+json")) ** break;
lbl33:
                    // 2 sources

                    if (!this.validateIndex(repositoryName, manifestJsonObject)) {
                        return HttpServerResponseExtensionsKt.sendBadRequest(response);
                    }
                    break block16;
                }
            }
            if (!this.validateManifest(repositoryName, manifestJsonObject)) {
                return HttpServerResponseExtensionsKt.sendBadRequest(response);
            }
            break block16;
lbl39:
            // 5 sources

            return HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        this.storage.putManifest$oci_registry(repositoryName, actualDigest, data);
        if (tag != null) {
            this.storage.tagManifest$oci_registry(repositoryName, actualDigest, tag);
        }
        v1 = tag;
        response.header((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)("/v2/" + repositoryName + "/manifests/" + (v1 != null ? (OciReference)v1 : (OciReference)actualDigest)));
        response.header((CharSequence)"docker-content-digest", (CharSequence)actualDigest.toString());
        v2 = response.status(HttpResponseStatus.CREATED).send();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"send(...)");
        return v2;
    }

    private final boolean validateManifest(String repositoryName, JSONObject jsonObject) {
        Object object = jsonObject.opt("config");
        JSONObject jSONObject = object instanceof JSONObject ? (JSONObject)object : null;
        if (jSONObject == null) {
            return false;
        }
        JSONObject config = jSONObject;
        Object object2 = config.opt("digest");
        String string = object2 instanceof String ? (String)object2 : null;
        if (string == null) {
            return false;
        }
        String rawConfigDigest = string;
        try {
            object2 = OciDigestKt.toOciDigest(rawConfigDigest);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        Object configDigest = object2;
        if (this.storage.getBlob$oci_registry(repositoryName, (OciDigest)configDigest) == null) {
            return false;
        }
        Object object3 = jsonObject.opt("layers");
        JSONArray jSONArray = object3 instanceof JSONArray ? (JSONArray)object3 : null;
        if (jSONArray == null) {
            return false;
        }
        JSONArray layers = jSONArray;
        for (Object layer : layers) {
            String rawLayerDigest;
            if (!(layer instanceof JSONObject)) {
                return false;
            }
            Object object4 = ((JSONObject)layer).opt("digest");
            if ((object4 instanceof String ? (String)object4 : null) == null) {
                return false;
            }
            rawLayerDigest = rawLayerDigest;
            try {
                object4 = OciDigestKt.toOciDigest(rawLayerDigest);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            Object layerDigest = object4;
            if (this.storage.getBlob$oci_registry(repositoryName, (OciDigest)layerDigest) != null) continue;
            return false;
        }
        return true;
    }

    private final boolean validateIndex(String repositoryName, JSONObject jsonObject) {
        Object object = jsonObject.opt("manifests");
        JSONArray jSONArray = object instanceof JSONArray ? (JSONArray)object : null;
        if (jSONArray == null) {
            return false;
        }
        JSONArray manifests = jSONArray;
        for (Object manifest : manifests) {
            String rawManifestDigest;
            if (!(manifest instanceof JSONObject)) {
                return false;
            }
            Object object2 = ((JSONObject)manifest).opt("digest");
            if ((object2 instanceof String ? (String)object2 : null) == null) {
                return false;
            }
            rawManifestDigest = rawManifestDigest;
            try {
                object2 = OciDigestKt.toOciDigest(rawManifestDigest);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            Object manifestDigest = object2;
            if (this.storage.getManifest$oci_registry(repositoryName, (OciReference)manifestDigest) != null) continue;
            return false;
        }
        return true;
    }

    private final Publisher<Void> deleteManifest(String repositoryName, OciReference reference, HttpServerResponse response) {
        Mono mono = response.status(HttpResponseStatus.METHOD_NOT_ALLOWED).send();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
        return (Publisher)mono;
    }

    private final Publisher<Void> handleBlob(String repositoryName, String rawDigest, HttpServerRequest request, HttpServerResponse response) {
        Publisher publisher;
        OciDigest ociDigest;
        try {
            ociDigest = OciDigestKt.toOciDigest(rawDigest);
        }
        catch (IllegalArgumentException e) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        OciDigest digest = ociDigest;
        ociDigest = request.method();
        if (Intrinsics.areEqual((Object)ociDigest, (Object)HttpMethod.GET)) {
            publisher = this.getBlob(repositoryName, digest, request, response);
        } else if (Intrinsics.areEqual((Object)ociDigest, (Object)HttpMethod.HEAD)) {
            publisher = this.headBlob(repositoryName, digest, response);
        } else if (Intrinsics.areEqual((Object)ociDigest, (Object)HttpMethod.DELETE)) {
            publisher = this.deleteBlob(repositoryName, digest, response);
        } else {
            Mono mono = response.status(HttpResponseStatus.METHOD_NOT_ALLOWED).send();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
            publisher = (Publisher)mono;
        }
        return publisher;
    }

    private final Publisher<Void> getBlob(String repositoryName, OciDigest digest, HttpServerRequest request, HttpServerResponse response) {
        Path path = this.storage.getBlob$oci_registry(repositoryName, digest);
        if (path == null) {
            Mono mono = response.sendNotFound();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"sendNotFound(...)");
            return (Publisher)mono;
        }
        Path blobFile = path;
        long size = Files.size(blobFile);
        String rangeHeader = request.requestHeaders().get((CharSequence)HttpHeaderNames.RANGE);
        if (rangeHeader != null && StringsKt.startsWith$default((String)rangeHeader, (String)"bytes=", (boolean)false, (int)2, null)) {
            List<HttpRangeSpec> list;
            try {
                String string = rangeHeader.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                list = HttpRangeKt.decodeHttpRangeSpecs(string);
            }
            catch (IllegalArgumentException e) {
                return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
            }
            List<HttpRangeSpec> rangeSpecs = list;
            if (rangeSpecs.size() == 1) {
                HttpRange httpRange;
                try {
                    httpRange = HttpRangeKt.createRange(rangeSpecs.get(0), size);
                }
                catch (IllegalArgumentException e) {
                    return (Publisher)HttpServerResponseExtensionsKt.sendRangeNotSatisfiable(response, size);
                }
                HttpRange range = httpRange;
                response.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.APPLICATION_OCTET_STREAM);
                response.header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(range.getSize()));
                response.header((CharSequence)HttpHeaderNames.CONTENT_RANGE, (CharSequence)HttpRangeKt.contentRangeHeaderValue(range, size));
                NettyOutbound nettyOutbound = response.status(HttpResponseStatus.PARTIAL_CONTENT).sendFile(blobFile, range.getFirst(), range.getSize());
                Intrinsics.checkNotNullExpressionValue((Object)nettyOutbound, (String)"sendFile(...)");
                return (Publisher)nettyOutbound;
            }
        }
        response.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.APPLICATION_OCTET_STREAM);
        response.header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(size));
        NettyOutbound nettyOutbound = response.sendFile(blobFile, 0L, size);
        Intrinsics.checkNotNullExpressionValue((Object)nettyOutbound, (String)"sendFile(...)");
        return (Publisher)nettyOutbound;
    }

    private final Publisher<Void> headBlob(String repositoryName, OciDigest digest, HttpServerResponse response) {
        Path path = this.storage.getBlob$oci_registry(repositoryName, digest);
        if (path == null) {
            Mono mono = response.sendNotFound();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"sendNotFound(...)");
            return (Publisher)mono;
        }
        Path blobFile = path;
        response.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.APPLICATION_OCTET_STREAM);
        response.header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(Files.size(blobFile)));
        Mono mono = response.send();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
        return (Publisher)mono;
    }

    private final Publisher<Void> deleteBlob(String repositoryName, OciDigest digest, HttpServerResponse response) {
        Mono mono = response.status(HttpResponseStatus.METHOD_NOT_ALLOWED).send();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
        return (Publisher)mono;
    }

    private final Publisher<Void> handleBlobUpload(String repositoryName, String id, HttpServerRequest request, HttpServerResponse response) {
        Publisher publisher;
        if (Intrinsics.areEqual((Object)id, (Object)"")) {
            Publisher publisher2 = Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST) ? this.postBlobUpload(repositoryName, request, response) : (Publisher)response.status(HttpResponseStatus.METHOD_NOT_ALLOWED).send();
            Intrinsics.checkNotNull((Object)publisher2);
            publisher = publisher2;
        } else {
            HttpMethod httpMethod = request.method();
            Publisher publisher3 = (Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.GET) ? true : Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.HEAD)) ? this.getOrHeadBlobUpload(repositoryName, id, response) : (Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.PATCH) ? this.patchBlobUpload(repositoryName, id, request, response) : (Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.PUT) ? this.putBlobUpload(repositoryName, id, request, response) : (Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.DELETE) ? this.deleteBlobUpload(repositoryName, id, response) : (Publisher)response.status(HttpResponseStatus.METHOD_NOT_ALLOWED).send())));
            Intrinsics.checkNotNull(publisher3);
            publisher = publisher3;
        }
        return publisher;
    }

    private final Publisher<Void> postBlobUpload(String repositoryName, HttpServerRequest request, HttpServerResponse response) {
        Map queryParameters = OciRegistryHandlerKt.access$getQueryParameters(new URI(request.uri()));
        String mountParameter = (String)queryParameters.get("mount");
        String fromParameter = (String)queryParameters.get("from");
        if (mountParameter != null && fromParameter != null) {
            return this.mountBlob(repositoryName, mountParameter, fromParameter, response);
        }
        String digestParameter = (String)queryParameters.get("digest");
        if (digestParameter != null) {
            return this.putBlob(repositoryName, digestParameter, request, response);
        }
        return this.createBlobUpload(repositoryName, response);
    }

    private final Publisher<Void> mountBlob(String repositoryName, String rawDigest, String fromRepositoryName, HttpServerResponse response) {
        Publisher publisher;
        Mono<Void> mono;
        try {
            mono = OciDigestKt.toOciDigest(rawDigest);
        }
        catch (IllegalArgumentException e) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        Mono<Void> digest = mono;
        if (this.storage.mountBlob$oci_registry(repositoryName, (OciDigest)digest, fromRepositoryName)) {
            mono = this.sendBlobCreated(response, repositoryName, (OciDigest)digest);
            Intrinsics.checkNotNull(mono);
            publisher = (Publisher)mono;
        } else {
            publisher = this.createBlobUpload(repositoryName, response);
        }
        return publisher;
    }

    private final Publisher<Void> putBlob(String repositoryName, String rawDigest, HttpServerRequest request, HttpServerResponse response) {
        OciDigest ociDigest;
        try {
            ociDigest = OciDigestKt.toOciDigest(rawDigest);
        }
        catch (IllegalArgumentException e) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        OciDigest digest = ociDigest;
        if (OciDigestKt.isUnsupported(digest.getAlgorithm())) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        String contentType = request.requestHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null && !Intrinsics.areEqual((Object)contentType, (Object)HttpHeaderValues.APPLICATION_OCTET_STREAM.toString())) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        String id = this.storage.createBlobUpload$oci_registry(repositoryName);
        ByteBufFlux byteBufFlux = request.receive();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufFlux, (String)"receive(...)");
        Mono mono = this.storage.finishBlobUpload$oci_registry(repositoryName, id, (Flux<ByteBuf>)((Flux)byteBufFlux), -1L, digest).materialize().flatMap(arg_0 -> OciRegistryHandler.putBlob$lambda$1((Function1)new Function1<Signal<OciDigest>, Mono<? extends Void>>(this, response, repositoryName, digest){
            final /* synthetic */ OciRegistryHandler this$0;
            final /* synthetic */ HttpServerResponse $response;
            final /* synthetic */ String $repositoryName;
            final /* synthetic */ OciDigest $digest;
            {
                this.this$0 = $receiver;
                this.$response = $response;
                this.$repositoryName = $repositoryName;
                this.$digest = $digest;
                super(1);
            }

            public final Mono<? extends Void> invoke(Signal<OciDigest> result) {
                Mono mono;
                Throwable error = result.getThrowable();
                if (error == null) {
                    mono = OciRegistryHandler.access$sendBlobCreated(this.this$0, this.$response, this.$repositoryName, this.$digest);
                } else if (error instanceof DigestException) {
                    mono = HttpServerResponseExtensionsKt.sendBadRequest(this.$response);
                } else {
                    throw error;
                }
                return mono;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return (Publisher)mono;
    }

    private final Publisher<Void> createBlobUpload(String repositoryName, HttpServerResponse response) {
        String id = this.storage.createBlobUpload$oci_registry(repositoryName);
        response.header((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)("/v2/" + repositoryName + "/blobs/uploads/" + id));
        Mono mono = response.status(HttpResponseStatus.ACCEPTED).send();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
        return (Publisher)mono;
    }

    private final Publisher<Void> getOrHeadBlobUpload(String repositoryName, String id, HttpServerResponse response) {
        Long l = this.storage.getBlobUploadSize$oci_registry(repositoryName, id);
        if (l == null) {
            Mono mono = response.sendNotFound();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"sendNotFound(...)");
            return (Publisher)mono;
        }
        long size = l;
        response.header((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)("/v2/" + repositoryName + "/blobs/uploads/" + id));
        response.header((CharSequence)HttpHeaderNames.RANGE, (CharSequence)("0-" + (size - 1L)));
        Mono mono = response.status(HttpResponseStatus.NO_CONTENT).send();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
        return (Publisher)mono;
    }

    private final Publisher<Void> patchBlobUpload(String repositoryName, String id, HttpServerRequest request, HttpServerResponse response) {
        String contentType;
        HttpRange httpRange;
        HttpHeaders requestHeaders = request.requestHeaders();
        try {
            String string = requestHeaders.get((CharSequence)HttpHeaderNames.CONTENT_RANGE);
            httpRange = string != null ? OciRegistryHandlerKt.access$decodeNonStandardHttpRange(string) : null;
        }
        catch (IllegalArgumentException e) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        HttpRange contentRange = httpRange;
        if (contentRange != null) {
            Object object = requestHeaders.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            if (object == null || (object = StringsKt.toLongOrNull((String)object)) == null) {
                return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
            }
            long contentLength = (Long)object;
            if (contentRange.getSize() != contentLength) {
                return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
            }
        }
        if ((contentType = requestHeaders.get((CharSequence)HttpHeaderNames.CONTENT_TYPE)) != null && !Intrinsics.areEqual((Object)contentType, (Object)HttpHeaderValues.APPLICATION_OCTET_STREAM.toString())) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        ByteBufFlux byteBufFlux = request.receive();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufFlux, (String)"receive(...)");
        HttpRange httpRange2 = contentRange;
        Mono mono = this.storage.progressBlobUpload$oci_registry(repositoryName, id, (Flux<ByteBuf>)((Flux)byteBufFlux), httpRange2 != null ? httpRange2.getFirst() : -1L).materialize().flatMap(arg_0 -> OciRegistryHandler.patchBlobUpload$lambda$2((Function1)new Function1<Signal<Long>, Mono<? extends Void>>(response, repositoryName, id){
            final /* synthetic */ HttpServerResponse $response;
            final /* synthetic */ String $repositoryName;
            final /* synthetic */ String $id;
            {
                this.$response = $response;
                this.$repositoryName = $repositoryName;
                this.$id = $id;
                super(1);
            }

            public final Mono<? extends Void> invoke(Signal<Long> result) {
                Mono mono;
                Throwable error = result.getThrowable();
                if (error == null) {
                    Object object = result.get();
                    Intrinsics.checkNotNull((Object)object);
                    long size = ((Number)object).longValue();
                    this.$response.header((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)("/v2/" + this.$repositoryName + "/blobs/uploads/" + this.$id));
                    this.$response.header((CharSequence)HttpHeaderNames.RANGE, (CharSequence)("0-" + (size - 1L)));
                    mono = this.$response.status(HttpResponseStatus.ACCEPTED).send();
                } else if (error instanceof NoSuchElementException) {
                    mono = this.$response.sendNotFound();
                } else if (error instanceof ConcurrentModificationException) {
                    mono = this.$response.status(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE).send();
                } else if (error instanceof IndexOutOfBoundsException) {
                    mono = this.$response.status(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE).send();
                } else {
                    throw error;
                }
                return mono;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return (Publisher)mono;
    }

    private final Publisher<Void> putBlobUpload(String repositoryName, String id, HttpServerRequest request, HttpServerResponse response) {
        String contentType;
        HttpRange httpRange;
        OciDigest ociDigest;
        Map queryParameters = OciRegistryHandlerKt.access$getQueryParameters(new URI(request.uri()));
        String string = (String)queryParameters.get("digest");
        if (string == null) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        String digestParameter = string;
        try {
            ociDigest = OciDigestKt.toOciDigest(digestParameter);
        }
        catch (IllegalArgumentException e) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        OciDigest digest = ociDigest;
        if (OciDigestKt.isUnsupported(digest.getAlgorithm())) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        HttpHeaders requestHeaders = request.requestHeaders();
        try {
            String string2 = requestHeaders.get((CharSequence)HttpHeaderNames.CONTENT_RANGE);
            httpRange = string2 != null ? OciRegistryHandlerKt.access$decodeNonStandardHttpRange(string2) : null;
        }
        catch (IllegalArgumentException e) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        HttpRange contentRange = httpRange;
        if (contentRange != null) {
            Object object = requestHeaders.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            if (object == null || (object = StringsKt.toLongOrNull((String)object)) == null) {
                return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
            }
            long contentLength = (Long)object;
            if (contentRange.getSize() != contentLength) {
                return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
            }
        }
        if ((contentType = requestHeaders.get((CharSequence)HttpHeaderNames.CONTENT_TYPE)) != null && !Intrinsics.areEqual((Object)contentType, (Object)HttpHeaderValues.APPLICATION_OCTET_STREAM.toString())) {
            return (Publisher)HttpServerResponseExtensionsKt.sendBadRequest(response);
        }
        ByteBufFlux byteBufFlux = request.receive();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufFlux, (String)"receive(...)");
        HttpRange httpRange2 = contentRange;
        Mono mono = this.storage.finishBlobUpload$oci_registry(repositoryName, id, (Flux<ByteBuf>)((Flux)byteBufFlux), httpRange2 != null ? httpRange2.getFirst() : -1L, digest).materialize().flatMap(arg_0 -> OciRegistryHandler.putBlobUpload$lambda$3((Function1)new Function1<Signal<OciDigest>, Mono<? extends Void>>(this, response, repositoryName, digest){
            final /* synthetic */ OciRegistryHandler this$0;
            final /* synthetic */ HttpServerResponse $response;
            final /* synthetic */ String $repositoryName;
            final /* synthetic */ OciDigest $digest;
            {
                this.this$0 = $receiver;
                this.$response = $response;
                this.$repositoryName = $repositoryName;
                this.$digest = $digest;
                super(1);
            }

            public final Mono<? extends Void> invoke(Signal<OciDigest> result) {
                Mono<Void> mono;
                Throwable error = result.getThrowable();
                if (error == null) {
                    mono = OciRegistryHandler.access$sendBlobCreated(this.this$0, this.$response, this.$repositoryName, this.$digest);
                } else if (error instanceof NoSuchElementException) {
                    mono = this.$response.sendNotFound();
                } else if (error instanceof ConcurrentModificationException) {
                    mono = this.$response.status(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE).send();
                } else if (error instanceof IndexOutOfBoundsException) {
                    mono = this.$response.status(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE).send();
                } else if (error instanceof DigestException) {
                    mono = HttpServerResponseExtensionsKt.sendBadRequest(this.$response);
                } else {
                    throw error;
                }
                return mono;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return (Publisher)mono;
    }

    private final Mono<Void> sendBlobCreated(HttpServerResponse $this$sendBlobCreated, String repositoryName, OciDigest digest) {
        return $this$sendBlobCreated.status(HttpResponseStatus.CREATED).header((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)("/v2/" + repositoryName + "/blobs/" + digest)).send();
    }

    private final Publisher<Void> deleteBlobUpload(String repositoryName, String id, HttpServerResponse response) {
        Mono mono = response.status(HttpResponseStatus.METHOD_NOT_ALLOWED).send();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
        return (Publisher)mono;
    }

    private static final Mono putManifest$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono putBlob$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono patchBlobUpload$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono putBlobUpload$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Mono access$putManifest(OciRegistryHandler $this, String repositoryName, OciDigest digest, OciTag tag, String mediaType, byte[] data, HttpServerResponse response) {
        return $this.putManifest(repositoryName, digest, tag, mediaType, data, response);
    }

    public static final /* synthetic */ Mono access$sendBlobCreated(OciRegistryHandler $this, HttpServerResponse $receiver, String repositoryName, OciDigest digest) {
        return $this.sendBlobCreated($receiver, repositoryName, digest);
    }
}

