/*
 * Decompiled with CFR 0.152.
 */
package io.github.sgtsilvio.oci.registry;

import io.github.sgtsilvio.oci.registry.OciDigestAlgorithm;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Lio/github/sgtsilvio/oci/registry/StandardOciDigestAlgorithm;", "", "Lio/github/sgtsilvio/oci/registry/OciDigestAlgorithm;", "id", "", "hashAlgorithmName", "hashByteLength", "", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;I)V", "getId", "()Ljava/lang/String;", "createMessageDigest", "Ljava/security/MessageDigest;", "decodeHash", "", "encodedHash", "encodeHash", "hash", "toString", "validateEncodedHash", "validateHash", "SHA_256", "SHA_512", "oci-registry"})
@SourceDebugExtension(value={"SMAP\nOciDigest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OciDigest.kt\nio/github/sgtsilvio/oci/registry/StandardOciDigestAlgorithm\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,141:1\n1064#2,2:142\n*S KotlinDebug\n*F\n+ 1 OciDigest.kt\nio/github/sgtsilvio/oci/registry/StandardOciDigestAlgorithm\n*L\n72#1:142,2\n*E\n"})
public final class StandardOciDigestAlgorithm
extends Enum<StandardOciDigestAlgorithm>
implements OciDigestAlgorithm {
    @NotNull
    private final String id;
    @NotNull
    private final String hashAlgorithmName;
    private final int hashByteLength;
    public static final /* enum */ StandardOciDigestAlgorithm SHA_256 = new StandardOciDigestAlgorithm("sha256", "SHA-256", 32);
    public static final /* enum */ StandardOciDigestAlgorithm SHA_512 = new StandardOciDigestAlgorithm("sha512", "SHA-512", 64);
    private static final /* synthetic */ StandardOciDigestAlgorithm[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private StandardOciDigestAlgorithm(String id, String hashAlgorithmName, int hashByteLength) {
        this.id = id;
        this.hashAlgorithmName = hashAlgorithmName;
        this.hashByteLength = hashByteLength;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String encodeHash(@NotNull byte[] hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        String string = Hex.encodeHexString((byte[])this.validateHash(hash));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeHexString(...)");
        return string;
    }

    @Override
    @NotNull
    public byte[] decodeHash(@NotNull String encodedHash) {
        Intrinsics.checkNotNullParameter((Object)encodedHash, (String)"encodedHash");
        byte[] byArray = Hex.decodeHex((String)this.validateEncodedHash(encodedHash));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeHex(...)");
        return byArray;
    }

    @Override
    @NotNull
    public byte[] validateHash(@NotNull byte[] hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        if (hash.length != this.hashByteLength) {
            throw new IllegalArgumentException("digest hash has wrong length " + hash.length + ", " + this.hashAlgorithmName + " requires " + this.hashByteLength);
        }
        return hash;
    }

    @Override
    @NotNull
    public String validateEncodedHash(@NotNull String encodedHash) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)encodedHash, (String)"encodedHash");
            if (encodedHash.length() != this.hashByteLength * 2) {
                throw new IllegalArgumentException("digest encoded hash '" + encodedHash + "' has wrong length " + encodedHash.length() + ", " + this.hashAlgorithmName + " requires " + this.hashByteLength * 2);
            }
            CharSequence $this$all$iv = encodedHash;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char c = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Intrinsics.compare((int)c, (int)48) >= 0 && Intrinsics.compare((int)c, (int)57) <= 0 || Intrinsics.compare((int)c, (int)97) >= 0 && Intrinsics.compare((int)c, (int)102) <= 0) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("digest encoded hash '" + encodedHash + "' does not match [a-f0-9]");
        }
        return encodedHash;
    }

    @Override
    @NotNull
    public MessageDigest createMessageDigest() {
        MessageDigest messageDigest = MessageDigest.getInstance(this.hashAlgorithmName);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        return messageDigest;
    }

    @NotNull
    public String toString() {
        return this.getId();
    }

    public static StandardOciDigestAlgorithm[] values() {
        return (StandardOciDigestAlgorithm[])$VALUES.clone();
    }

    public static StandardOciDigestAlgorithm valueOf(String value) {
        return Enum.valueOf(StandardOciDigestAlgorithm.class, value);
    }

    @NotNull
    public static EnumEntries<StandardOciDigestAlgorithm> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = standardOciDigestAlgorithmArray = new StandardOciDigestAlgorithm[]{StandardOciDigestAlgorithm.SHA_256, StandardOciDigestAlgorithm.SHA_512};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }
}

