/*
 * Decompiled with CFR 0.152.
 */
package io.github.sgtsilvio.oci.registry.http;

import io.github.sgtsilvio.oci.registry.http.HttpRange;
import io.github.sgtsilvio.oci.registry.http.HttpRangeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0002*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0006*\u00020\u0001H\u0002\u001a\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t*\u00020\u0001H\u0000\u00a8\u0006\n"}, d2={"contentRangeHeaderValue", "", "Lio/github/sgtsilvio/oci/registry/http/HttpRange;", "size", "", "createRange", "Lio/github/sgtsilvio/oci/registry/http/HttpRangeSpec;", "decodeHttpRangeSpec", "decodeHttpRangeSpecs", "", "oci-registry"})
@SourceDebugExtension(value={"SMAP\nHttpRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRange.kt\nio/github/sgtsilvio/oci/registry/http/HttpRangeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1549#2:61\n1620#2,3:62\n*S KotlinDebug\n*F\n+ 1 HttpRange.kt\nio/github/sgtsilvio/oci/registry/http/HttpRangeKt\n*L\n8#1:61\n8#1:62,3\n*E\n"})
public final class HttpRangeKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<HttpRangeSpec> decodeHttpRangeSpecs(@NotNull String $this$decodeHttpRangeSpecs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$decodeHttpRangeSpecs, (String)"<this>");
        char[] cArray = new char[]{','};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$decodeHttpRangeSpecs, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HttpRangeKt.decodeHttpRangeSpec((String)it));
        }
        return (List)destination$iv$iv;
    }

    private static final HttpRangeSpec decodeHttpRangeSpec(String $this$decodeHttpRangeSpec) {
        char[] cArray = new char[]{'-'};
        List rangeParts = StringsKt.split$default((CharSequence)$this$decodeHttpRangeSpec, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (rangeParts.size() != 2) {
            throw new IllegalArgumentException('\"' + $this$decodeHttpRangeSpec + "\" is not a valid HTTP range spec, it must contain exactly 1 '-' character.");
        }
        String rangePart1 = ((Object)StringsKt.trim((CharSequence)((String)rangeParts.get(0)))).toString();
        String rangePart2 = ((Object)StringsKt.trim((CharSequence)((String)rangeParts.get(1)))).toString();
        long first = ((CharSequence)rangePart1).length() == 0 ? -1L : Long.parseLong(rangePart1);
        long last = 0L;
        if (((CharSequence)rangePart2).length() == 0) {
            if (first == -1L) {
                throw new IllegalArgumentException('\"' + $this$decodeHttpRangeSpec + "\" is not a valid HTTP range spec, it must contain at least a start position or a suffix length.");
            }
            last = -1L;
        } else {
            last = Long.parseLong(rangePart2);
            if (last < first) {
                throw new IllegalArgumentException('\"' + $this$decodeHttpRangeSpec + "\" is not a valid HTTP range spec, last position must not be less than first position.");
            }
        }
        return new HttpRangeSpec(first, last);
    }

    @NotNull
    public static final HttpRange createRange(@NotNull HttpRangeSpec $this$createRange, long size) {
        HttpRange httpRange;
        Intrinsics.checkNotNullParameter((Object)$this$createRange, (String)"<this>");
        if ($this$createRange.getFirst() == -1L) {
            if ($this$createRange.getLast() == 0L) {
                throw new IllegalArgumentException("HTTP range spec " + $this$createRange + " is not satisfiable for resource with size " + size + ", suffix length must not be 0");
            }
            httpRange = new HttpRange(Math.max(0L, size - $this$createRange.getLast()), size - 1L);
        } else {
            if ($this$createRange.getFirst() >= size) {
                throw new IllegalArgumentException("HTTP range spec " + $this$createRange + " is not satisfiable for resource with size " + size + ", first position must be less than " + size);
            }
            httpRange = new HttpRange($this$createRange.getFirst(), $this$createRange.getLast() == -1L ? size - 1L : Math.min(size - 1L, $this$createRange.getLast()));
        }
        return httpRange;
    }

    @NotNull
    public static final String contentRangeHeaderValue(@NotNull HttpRange $this$contentRangeHeaderValue, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$contentRangeHeaderValue, (String)"<this>");
        return "bytes " + $this$contentRangeHeaderValue.getFirst() + '-' + $this$contentRangeHeaderValue.getLast() + '/' + size;
    }
}

