/*
 * Decompiled with CFR 0.152.
 */
package io.github.sgtsilvio.oci.registry;

import io.github.sgtsilvio.oci.registry.OciDigestAlgorithm;
import io.github.sgtsilvio.oci.registry.OciDigestKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\nH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lio/github/sgtsilvio/oci/registry/UnsupportedOciDigestAlgorithm;", "Lio/github/sgtsilvio/oci/registry/OciDigestAlgorithm;", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "createMessageDigest", "", "decodeHash", "", "encodedHash", "encodeHash", "hash", "equals", "", "other", "", "hashCode", "", "toString", "validateEncodedHash", "validateHash", "oci-registry"})
final class UnsupportedOciDigestAlgorithm
implements OciDigestAlgorithm {
    @NotNull
    private final String id;

    public UnsupportedOciDigestAlgorithm(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        if (!OciDigestKt.access$getOCI_DIGEST_ALGORITHM_REGEX$p().matches((CharSequence)this.getId())) {
            throw new IllegalArgumentException("digest algorithm '" + this.getId() + "' does not match " + OciDigestKt.access$getOCI_DIGEST_ALGORITHM_REGEX$p());
        }
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String encodeHash(@NotNull byte[] hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return this.validateEncodedHash(new String(hash, Charsets.ISO_8859_1));
    }

    @Override
    @NotNull
    public byte[] decodeHash(@NotNull String encodedHash) {
        Intrinsics.checkNotNullParameter((Object)encodedHash, (String)"encodedHash");
        byte[] byArray = this.validateEncodedHash(encodedHash).getBytes(Charsets.ISO_8859_1);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @Override
    @NotNull
    public byte[] validateHash(@NotNull byte[] hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        this.encodeHash(hash);
        return hash;
    }

    @Override
    @NotNull
    public String validateEncodedHash(@NotNull String encodedHash) {
        Intrinsics.checkNotNullParameter((Object)encodedHash, (String)"encodedHash");
        if (!OciDigestKt.access$getOCI_DIGEST_ENCODED_HASH_REGEX$p().matches((CharSequence)encodedHash)) {
            throw new IllegalArgumentException("digest encoded hash '" + encodedHash + "' does not match " + OciDigestKt.access$getOCI_DIGEST_ENCODED_HASH_REGEX$p());
        }
        return encodedHash;
    }

    @NotNull
    public Void createMessageDigest() {
        throw new UnsupportedOperationException("unsupported digest algorithm '" + this.getId() + '\'');
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof UnsupportedOciDigestAlgorithm) ? false : Intrinsics.areEqual((Object)this.getId(), (Object)((UnsupportedOciDigestAlgorithm)other).getId()));
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getId();
    }
}

