/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.api;

import com.shaft.api.RestActions;
import com.shaft.cli.FileActions;
import io.qameta.allure.Step;
import io.restassured.RestAssured;
import io.restassured.config.RestAssuredConfig;
import io.restassured.config.SSLConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class RequestBuilder {
    private RestActions session;
    private Map<String, String> sessionHeaders;
    private Map<String, Object> sessionCookies;
    private RestAssuredConfig sessionConfig;
    private RestActions.RequestType requestType;
    private String serviceName;
    private String serviceURI;
    private int targetStatusCode;
    private String urlArguments = null;
    private List<List<Object>> parameters = null;
    private RestActions.ParametersType parametersType = null;
    private Object requestBody = null;
    private ContentType contentType = null;
    private AuthenticationType authenticationType;
    private String authenticationUsername;
    private String authenticationPassword;
    private boolean appendDefaultContentCharsetToContentTypeIfUndefined;
    private boolean urlEncodingEnabled;

    RequestBuilder(String serviceURI, String serviceName, RestActions.RequestType requestType) {
        this.initializeVariables(new RestActions(serviceURI), serviceName, requestType);
    }

    RequestBuilder(RestActions session, String serviceName, RestActions.RequestType requestType) {
        this.initializeVariables(session, serviceName, requestType);
    }

    private void initializeVariables(RestActions session, String serviceName, RestActions.RequestType requestType) {
        this.session = session;
        this.serviceURI = session.getServiceURI();
        this.sessionCookies = session.getSessionCookies();
        this.sessionHeaders = session.getSessionHeaders();
        this.sessionConfig = session.getSessionConfig();
        this.requestType = requestType;
        this.serviceName = serviceName;
        this.targetStatusCode = 0;
        this.contentType = ContentType.ANY;
        this.authenticationType = AuthenticationType.NONE;
        this.appendDefaultContentCharsetToContentTypeIfUndefined = true;
        this.urlEncodingEnabled = true;
    }

    public RequestBuilder useRelaxedHTTPSValidation() {
        this.useRelaxedHTTPSValidation("SSL");
        return this;
    }

    public RequestBuilder useRelaxedHTTPSValidation(String protocol) {
        this.sessionConfig = RestAssured.config().and().sslConfig(SSLConfig.sslConfig().relaxedHTTPSValidation(protocol));
        return this;
    }

    public RequestBuilder setTargetStatusCode(int targetStatusCode) {
        this.targetStatusCode = targetStatusCode;
        return this;
    }

    public RequestBuilder setUrlArguments(String urlArguments) {
        this.urlArguments = urlArguments;
        return this;
    }

    public RequestBuilder setParameters(List<List<Object>> parameters, RestActions.ParametersType parametersType) {
        this.parameters = parameters;
        this.parametersType = parametersType;
        return this;
    }

    public RequestBuilder setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public RequestBuilder setRequestBodyFromFile(String relativeFilePath) {
        this.requestBody = new FileActions().readFile(relativeFilePath);
        return this;
    }

    public RequestBuilder setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public RequestBuilder setContentType(String contentType) {
        this.contentType = ContentType.fromContentType((String)contentType);
        return this;
    }

    public RequestBuilder appendDefaultContentCharsetToContentTypeIfUndefined(boolean appendDefaultContentCharsetToContentTypeIfUndefined) {
        this.appendDefaultContentCharsetToContentTypeIfUndefined = appendDefaultContentCharsetToContentTypeIfUndefined;
        return this;
    }

    public RequestBuilder enableUrlEncoding(boolean urlEncodingEnabled) {
        this.urlEncodingEnabled = urlEncodingEnabled;
        return this;
    }

    public RequestBuilder addHeader(String key, String value) {
        this.sessionHeaders.put(key, value);
        return this;
    }

    public RequestBuilder addCookie(String key, Object value) {
        this.sessionCookies.put(key, value);
        return this;
    }

    public RequestBuilder setAuthentication(String username, String password, AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        this.authenticationUsername = username;
        this.authenticationPassword = password;
        return this;
    }

    public Response perform() {
        return this.performRequest();
    }

    @Step(value="Perform {this.requestType} request to {this.serviceURI}{this.serviceName}")
    public Response performRequest() {
        String request = this.session.prepareRequestURL(this.serviceURI, this.urlArguments, this.serviceName);
        RequestSpecification specs = this.session.prepareRequestSpecs(this.parameters, this.parametersType, this.requestBody, this.contentType, this.sessionCookies, this.sessionHeaders, this.sessionConfig, this.appendDefaultContentCharsetToContentTypeIfUndefined, this.urlEncodingEnabled);
        switch (this.authenticationType.ordinal()) {
            case 0: {
                specs.auth().preemptive().basic(this.authenticationUsername, this.authenticationPassword);
                break;
            }
            case 1: {
                specs.auth().form(this.authenticationUsername, this.authenticationPassword);
                break;
            }
        }
        Response response = null;
        try {
            if (this.requestType.equals((Object)RestActions.RequestType.POST) || this.requestType.equals((Object)RestActions.RequestType.PATCH) || this.requestType.equals((Object)RestActions.RequestType.PUT) || this.requestType.equals((Object)RestActions.RequestType.GET) || this.requestType.equals((Object)RestActions.RequestType.DELETE)) {
                response = this.session.sendRequest(this.requestType, request, specs);
            } else {
                RestActions.failAction(request, new Throwable[0]);
            }
            boolean responseStatus = this.session.evaluateResponseStatusCode(Objects.requireNonNull(response), this.targetStatusCode);
            String reportMessage = this.session.prepareReportMessage(response, this.targetStatusCode, this.requestType, this.serviceName, this.contentType, this.urlArguments);
            if (!Boolean.TRUE.equals(responseStatus)) {
                RestActions.failAction(reportMessage, this.requestBody, specs, response, new Throwable[]{new AssertionError((Object)("Invalid response status code; Expected " + this.targetStatusCode + " but found " + response.getStatusCode() + "."))});
            }
            if (!"".equals(reportMessage)) {
                RestActions.passAction(reportMessage, this.requestBody, specs, response);
            } else {
                RestActions.failAction(reportMessage, this.requestBody, specs, response, new Throwable[0]);
            }
        }
        catch (Exception rootCauseException) {
            if (response != null) {
                RestActions.failAction(request + ", Response Time: " + response.timeIn(TimeUnit.MILLISECONDS) + "ms", this.requestBody, specs, response, rootCauseException);
            }
            RestActions.failAction(request, rootCauseException);
        }
        RestActions.lastResponse = response;
        return response;
    }

    RestActions getSession() {
        return this.session;
    }

    Map<String, String> getSessionHeaders() {
        return this.sessionHeaders;
    }

    Map<String, Object> getSessionCookies() {
        return this.sessionCookies;
    }

    RestAssuredConfig getSessionConfig() {
        return this.sessionConfig;
    }

    RestActions.RequestType getRequestType() {
        return this.requestType;
    }

    String getServiceName() {
        return this.serviceName;
    }

    String getServiceURI() {
        return this.serviceURI;
    }

    int getTargetStatusCode() {
        return this.targetStatusCode;
    }

    String getUrlArguments() {
        return this.urlArguments;
    }

    List<List<Object>> getParameters() {
        return this.parameters;
    }

    RestActions.ParametersType getParametersType() {
        return this.parametersType;
    }

    Object getRequestBody() {
        return this.requestBody;
    }

    ContentType getContentType() {
        return this.contentType;
    }

    AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    String getAuthenticationUsername() {
        return this.authenticationUsername;
    }

    String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    boolean isAppendDefaultContentCharsetToContentTypeIfUndefined() {
        return this.appendDefaultContentCharsetToContentTypeIfUndefined;
    }

    boolean isUrlEncodingEnabled() {
        return this.urlEncodingEnabled;
    }

    public static enum AuthenticationType {
        BASIC,
        FORM,
        NONE;

    }
}

