/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonOrgJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.shaft.api.RequestBuilder;
import com.shaft.driver.SHAFT;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import com.shaft.validation.Validations;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.MimeUtil2;
import io.restassured.RestAssured;
import io.restassured.builder.MultiPartSpecBuilder;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.HttpClientConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.http.Cookie;
import io.restassured.http.Header;
import io.restassured.mapper.ObjectMapperType;
import io.restassured.path.json.exception.JsonPathException;
import io.restassured.path.xml.element.Node;
import io.restassured.path.xml.element.NodeChildren;
import io.restassured.response.Response;
import io.restassured.response.ResponseBody;
import io.restassured.specification.QueryableRequestSpecification;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.SpecificationQuerier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class RestActions {
    private static final String ARGUMENT_SEPARATOR = "?";
    private static final String ERROR_NOT_FOUND = "Either actual value is \"null\" or couldn't find anything that matches with the desired ";
    private static final String ERROR_INCORRECT_JSONPATH = "Incorrect jsonPath ";
    private static final String ERROR_INCORRECT_XML_PATH = "Incorrect xmlPath ";
    private static final String ERROR_FAILED_TO_PARSE_JSON = "Failed to parse the JSON document";
    private static final String GRAPHQL_END_POINT = "graphql";
    static Response lastResponse;
    private static boolean AUTOMATICALLY_ASSERT_RESPONSE_STATUS_CODE;
    private static int HTTP_SOCKET_TIMEOUT;
    private static int HTTP_CONNECTION_TIMEOUT;
    private static int HTTP_CONNECTION_MANAGER_TIMEOUT;
    private final String serviceURI;
    private final Map<String, String> sessionHeaders;
    private final Map<String, Object> sessionCookies;
    private final RestAssuredConfig sessionConfig;
    private String headerAuthorization;

    public RestActions(String serviceURI) {
        RestActions.initializeSystemProperties();
        this.headerAuthorization = "";
        this.serviceURI = serviceURI;
        this.sessionCookies = new HashMap<String, Object>();
        this.sessionHeaders = new HashMap<String, String>();
        this.sessionConfig = RestAssured.config();
    }

    public static RequestBuilder buildNewRequest(String serviceURI, String serviceName, RequestType requestType) {
        return new RequestBuilder(new RestActions(serviceURI), serviceName, requestType);
    }

    private static void passAction(String actionName, String testData, Object requestBody, RequestSpecification specs, Response response, Boolean isDiscrete, List<Object> expectedFileBodyAttachment) {
        RestActions.reportActionResult(actionName, testData, requestBody, specs, response, isDiscrete, expectedFileBodyAttachment, true, new Throwable[0]);
    }

    private static void failAction(String actionName, String testData, Object requestBody, RequestSpecification specs, Response response, Throwable ... rootCauseException) {
        String message = RestActions.reportActionResult(actionName, testData, requestBody, specs, response, false, null, false, rootCauseException);
        if (rootCauseException.length > 0) {
            FailureReporter.fail(RestActions.class, message, rootCauseException[0]);
        } else {
            FailureReporter.fail(message);
        }
    }

    protected static void passAction(String testData) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        RestActions.passAction(actionName, testData, null, null, null, true, null);
    }

    protected static void passAction(String testData, List<Object> expectedFileBodyAttachment) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        RestActions.passAction(actionName, testData, null, null, null, true, expectedFileBodyAttachment);
    }

    static void passAction(String testData, Object requestBody, RequestSpecification specs, Response response) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        RestActions.passAction(actionName, testData, requestBody, specs, response, false, null);
    }

    public static InputStream parseBodyToJson(Response response) {
        return RestActions.parseBodyToJson(response.getBody());
    }

    public static InputStream parseBodyToJson(Object body) {
        try {
            return RestActions.parseJsonBody(body);
        }
        catch (Exception e) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(byteArrayOutputStream);
                oos.writeObject(body);
                oos.flush();
                oos.close();
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            catch (IOException ioe) {
                if (body.getClass().getName().toLowerCase().contains("restassured")) {
                    return ((ResponseBody)body).asInputStream();
                }
                return new ByteArrayInputStream(body.toString().getBytes());
            }
        }
    }

    public static String getResponseBody(Response response) {
        return response.getBody().asString();
    }

    public static String getResponseJSONValue(Response response, String jsonPath) {
        String searchPool = "";
        String jsonResponse = response.asPrettyString();
        try {
            if (jsonPath.contains(ARGUMENT_SEPARATOR)) {
                List jsonValueAsList = (List)JsonPath.read((String)jsonResponse, (String)jsonPath, (Predicate[])new Predicate[0]);
                searchPool = String.valueOf(jsonValueAsList.getFirst());
            } else {
                Object jsonValue = JsonPath.read((String)jsonResponse, (String)jsonPath, (Predicate[])new Predicate[0]);
                searchPool = String.valueOf(jsonValue);
            }
        }
        catch (PathNotFoundException e) {
            String jsonObject = jsonResponse.substring(jsonResponse.indexOf("{"), jsonResponse.lastIndexOf("}") + 1);
            Configuration confOrgJsonProvider = Configuration.builder().jsonProvider((JsonProvider)new JsonOrgJsonProvider()).build();
            try {
                if (jsonPath.contains(ARGUMENT_SEPARATOR)) {
                    JSONArray jsonValue = (JSONArray)JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]).read((Object)new org.json.JSONObject(jsonObject), confOrgJsonProvider);
                    searchPool = String.valueOf(jsonValue.get(0));
                }
                Object jsonValue = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]).read((Object)new org.json.JSONObject(jsonObject), confOrgJsonProvider);
                searchPool = String.valueOf(jsonValue);
            }
            catch (JSONException rootCauseException) {
                ReportManager.log(ERROR_FAILED_TO_PARSE_JSON);
                RestActions.failAction(jsonPath, rootCauseException);
            }
        }
        catch (ClassCastException rootCauseException) {
            ReportManager.log("Incorrect jsonPath \"" + jsonPath + "\"");
            RestActions.failAction(jsonPath, rootCauseException);
        }
        catch (JsonPathException | IllegalArgumentException rootCauseException) {
            ReportManager.log(ERROR_FAILED_TO_PARSE_JSON);
            RestActions.failAction(jsonPath, rootCauseException);
        }
        if (searchPool != null) {
            RestActions.passAction(jsonPath);
            return searchPool;
        }
        ReportManager.logDiscrete("Either actual value is \"null\" or couldn't find anything that matches with the desired jsonPath \"" + jsonPath + "\"");
        RestActions.passAction(jsonPath);
        return null;
    }

    public static String getResponseJSONValue(Object response, String jsonPath) {
        String searchPool;
        block12: {
            searchPool = "";
            try {
                if (response instanceof HashMap) {
                    HashMap hashMapResponse = (HashMap)response;
                    org.json.JSONObject obj = new org.json.JSONObject((Map)hashMapResponse);
                    searchPool = io.restassured.path.json.JsonPath.from((String)obj.toString()).getString(jsonPath);
                    break block12;
                }
                if (!(response instanceof Response)) break block12;
                Response responseObject = (Response)response;
                String jsonResponse = responseObject.asPrettyString();
                try {
                    if (jsonPath.contains(ARGUMENT_SEPARATOR)) {
                        List jsonValueAsList = (List)JsonPath.read((String)jsonResponse, (String)jsonPath, (Predicate[])new Predicate[0]);
                        searchPool = String.valueOf(jsonValueAsList.getFirst());
                        break block12;
                    }
                    Object jsonValue = JsonPath.read((String)jsonResponse, (String)jsonPath, (Predicate[])new Predicate[0]);
                    searchPool = String.valueOf(jsonValue);
                }
                catch (PathNotFoundException e) {
                    String jsonObject = jsonResponse.substring(jsonResponse.indexOf("{"), jsonResponse.lastIndexOf("}") + 1);
                    Configuration confOrgJsonProvider = Configuration.builder().jsonProvider((JsonProvider)new JsonOrgJsonProvider()).build();
                    try {
                        if (jsonPath.contains(ARGUMENT_SEPARATOR)) {
                            JSONArray jsonValue = (JSONArray)JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]).read((Object)new org.json.JSONObject(jsonObject), confOrgJsonProvider);
                            searchPool = String.valueOf(jsonValue.get(0));
                        } else {
                            Object jsonValue = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]).read((Object)new org.json.JSONObject(jsonObject), confOrgJsonProvider);
                            searchPool = String.valueOf(jsonValue);
                        }
                    }
                    catch (JSONException rootCauseException) {
                        ReportManager.log(ERROR_FAILED_TO_PARSE_JSON);
                        RestActions.failAction(jsonPath, rootCauseException);
                    }
                }
            }
            catch (ClassCastException rootCauseException) {
                ReportManager.log("Incorrect jsonPath \"" + jsonPath + "\"");
                RestActions.failAction(jsonPath, rootCauseException);
            }
            catch (JsonPathException | IllegalArgumentException rootCauseException) {
                ReportManager.log(ERROR_FAILED_TO_PARSE_JSON);
                RestActions.failAction(jsonPath, rootCauseException);
            }
        }
        if (searchPool != null) {
            RestActions.passAction(jsonPath);
            return searchPool;
        }
        ReportManager.logDiscrete("Either actual value is \"null\" or couldn't find anything that matches with the desired jsonPath \"" + jsonPath + "\"");
        RestActions.passAction(jsonPath);
        return null;
    }

    public static List<Object> getResponseJSONValueAsList(Response response, String jsonPath) {
        List searchPool = null;
        String jsonResponse = response.asPrettyString();
        try {
            searchPool = (List)JsonPath.read((String)jsonResponse, (String)jsonPath, (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException e) {
            String jsonObject = jsonResponse.substring(jsonResponse.indexOf("{"), jsonResponse.lastIndexOf("}") + 1);
            Configuration confOrgJsonProvider = Configuration.builder().jsonProvider((JsonProvider)new JsonOrgJsonProvider()).build();
            List jsonList = null;
            try {
                JSONArray jsonArray = (JSONArray)JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]).read((Object)new org.json.JSONObject(jsonObject), confOrgJsonProvider);
                jsonList = (List)new ObjectMapper().readValue(Objects.requireNonNull(jsonArray).toString(), (TypeReference)new TypeReference<List<Object>>(){});
            }
            catch (JsonProcessingException | JSONException rootCauseException) {
                ReportManager.log(ERROR_FAILED_TO_PARSE_JSON);
                RestActions.failAction(jsonPath, rootCauseException);
            }
            searchPool = jsonList;
        }
        catch (ClassCastException rootCauseException) {
            ReportManager.log("Incorrect jsonPath \"" + jsonPath + "\"");
            RestActions.failAction(jsonPath, rootCauseException);
        }
        catch (JsonPathException | IllegalArgumentException rootCauseException) {
            ReportManager.log(ERROR_FAILED_TO_PARSE_JSON);
            RestActions.failAction(jsonPath, rootCauseException);
        }
        if (searchPool != null) {
            RestActions.passAction(jsonPath);
            return searchPool;
        }
        ReportManager.logDiscrete("Either actual value is \"null\" or couldn't find anything that matches with the desired jsonPath \"" + jsonPath + "\"");
        RestActions.passAction(jsonPath);
        return null;
    }

    public static String getResponseJSONValueFromList(Response response, String jsonPathToList, String jsonPathToValueNeeded, String jsonPathToValueReference, String valueReference) {
        List<Object> list = RestActions.getResponseJSONValueAsList(response, jsonPathToList);
        String value = "";
        for (Object res : Objects.requireNonNull(list)) {
            if (!Objects.equals(RestActions.getResponseJSONValue(res, jsonPathToValueReference), valueReference)) continue;
            value = RestActions.getResponseJSONValue(res, jsonPathToValueNeeded);
        }
        if (Objects.equals(value, "")) {
            RestActions.failAction("Can't find the reference value [" + valueReference + "] in the list with the [" + jsonPathToValueReference + "] JSON Path", new Throwable[0]);
        } else {
            RestActions.passAction(value);
        }
        return value;
    }

    public static String getResponseXMLValue(Response response, String xmlPath) {
        String searchPool = "";
        try {
            searchPool = response.xmlPath().getString(xmlPath);
        }
        catch (ClassCastException rootCauseException) {
            ReportManager.log("Incorrect xmlPath \"" + xmlPath + "\"");
            RestActions.failAction(xmlPath, rootCauseException);
        }
        if (searchPool != null) {
            RestActions.passAction(xmlPath);
            return searchPool;
        }
        ReportManager.logDiscrete("Either actual value is \"null\" or couldn't find anything that matches with the desired xmlPath \"" + xmlPath + "\"");
        RestActions.passAction(xmlPath);
        return null;
    }

    public static String getResponseXMLValue(Object response, String xmlPath) {
        String output = "";
        try {
            output = ((Node)response).getAttribute(xmlPath);
        }
        catch (ClassCastException rootCauseException) {
            ReportManager.log("Incorrect xmlPath \"" + xmlPath + "\"");
            RestActions.failAction(xmlPath, rootCauseException);
        }
        if (output != null) {
            RestActions.passAction(xmlPath);
            return output;
        }
        ReportManager.logDiscrete("Either actual value is \"null\" or couldn't find anything that matches with the desired xmlPath \"" + xmlPath + "\"");
        RestActions.passAction(xmlPath);
        return null;
    }

    public static List<Object> getResponseXMLValueAsList(Response response, String xmlPath) {
        NodeChildren output = null;
        try {
            output = (NodeChildren)response.xmlPath().get(xmlPath);
        }
        catch (ClassCastException rootCauseException) {
            ReportManager.log("Incorrect xmlPath \"" + xmlPath + "\"");
            RestActions.failAction(xmlPath, rootCauseException);
        }
        List nodes = null;
        if (output != null) {
            nodes = output.list();
        }
        List<Object> searchPool = null;
        if (nodes != null) {
            searchPool = Arrays.asList(nodes.toArray());
        }
        if (searchPool != null) {
            RestActions.passAction(xmlPath);
            return searchPool;
        }
        ReportManager.logDiscrete("Either actual value is \"null\" or couldn't find anything that matches with the desired xmlPath \"" + xmlPath + "\"");
        RestActions.passAction(xmlPath);
        return null;
    }

    public static int getResponseStatusCode(Response response) {
        int statusCode = response.getStatusCode();
        RestActions.passAction(String.valueOf(statusCode));
        return statusCode;
    }

    public static long getResponseTime(Response response) {
        long time = response.timeIn(TimeUnit.MILLISECONDS);
        RestActions.passAction(String.valueOf(time));
        return time;
    }

    public static boolean compareJSON(Response response, String referenceJsonFilePath, ComparisonType comparisonType) {
        return RestActions.compareJSON(response, referenceJsonFilePath, comparisonType, "");
    }

    public static boolean compareJSON(Response response, String referenceJsonFilePath, ComparisonType comparisonType, String jsonPathToTargetArray) {
        boolean comparisonResult;
        if (jsonPathToTargetArray.isEmpty()) {
            ReportManager.logDiscrete("Comparing the provided API response with the file at this path \"" + referenceJsonFilePath + "\", comparison type \"" + String.valueOf((Object)comparisonType) + "\"");
        } else {
            ReportManager.logDiscrete("Comparing the provided API response with the file at this path \"" + referenceJsonFilePath + "\", comparison type \"" + String.valueOf((Object)comparisonType) + "\", jsonPath to target array \"" + jsonPathToTargetArray + "\".");
        }
        JSONParser parser = new JSONParser();
        List<Object> expectedJSONAttachment = null;
        try {
            JSONObject actualJsonObject = null;
            org.json.simple.JSONArray actualJsonArray = null;
            Object actualObject = parser.parse(response.asString());
            if (actualObject instanceof JSONObject) {
                actualJsonObject = (JSONObject)parser.parse(response.asString());
            } else {
                actualJsonArray = (org.json.simple.JSONArray)parser.parse(response.asString());
            }
            JSONObject expectedJsonObject = null;
            org.json.simple.JSONArray expectedJsonArray = null;
            Object expectedObject = parser.parse((Reader)new FileReader(referenceJsonFilePath));
            if (expectedObject instanceof JSONObject) {
                expectedJsonObject = (JSONObject)parser.parse((Reader)new FileReader(referenceJsonFilePath));
                expectedJSONAttachment = Arrays.asList("File Content", "Expected JSON", new GsonBuilder().setPrettyPrinting().create().toJson(JsonParser.parseString((String)expectedJsonObject.toJSONString())));
            } else {
                expectedJsonArray = (org.json.simple.JSONArray)parser.parse((Reader)new FileReader(referenceJsonFilePath));
                expectedJSONAttachment = Arrays.asList("File Content", "Expected JSON", new GsonBuilder().setPrettyPrinting().create().toJson(JsonParser.parseString((String)expectedJsonArray.toJSONString())));
            }
            comparisonResult = switch (comparisonType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> RestActions.compareJSONEquals(expectedJsonObject, expectedJsonArray, actualJsonObject, actualJsonArray);
                case 1 -> RestActions.compareJSONContains(response, expectedJsonObject, expectedJsonArray, actualJsonObject, jsonPathToTargetArray);
                case 2 -> RestActions.compareJSONEqualsIgnoringOrder(expectedJsonObject, expectedJsonArray, actualJsonObject, actualJsonArray);
            };
        }
        catch (IOException rootCauseException) {
            RestActions.failAction("Couldn't find the desired file. \"" + referenceJsonFilePath + "\".", rootCauseException);
            comparisonResult = false;
        }
        catch (JSONException | ParseException rootCauseException) {
            RestActions.failAction("Couldn't parse the desired file. \"" + referenceJsonFilePath + "\".", rootCauseException);
            comparisonResult = false;
        }
        RestActions.passAction(referenceJsonFilePath, expectedJSONAttachment);
        return comparisonResult;
    }

    public static String formatXML(String input) {
        return RestActions.prettyFormatXML(input);
    }

    protected static void failAction(String testData, Object requestBody, RequestSpecification specs, Response response, Throwable ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        RestActions.failAction(actionName, testData, requestBody, specs, response, rootCauseException);
    }

    protected static void failAction(String testData, Throwable ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        RestActions.failAction(actionName, testData, null, null, null, rootCauseException);
    }

    private static String reportActionResult(String actionName, String testData, Object requestBody, RequestSpecification specs, Response response, Boolean isDiscrete, List<Object> expectedFileBodyAttachment, Boolean passFailStatus, Throwable ... rootCauseException) {
        actionName = (actionName = JavaHelper.convertToSentenceCase(actionName)).equals("Perform request") ? "Request details: " : actionName;
        Object message = Boolean.TRUE.equals(passFailStatus) ? "API Action: " + actionName : "API Action: " + actionName + " failed";
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        if (testData != null && testData.length() >= 500) {
            List<Object> actualValueAttachment = Arrays.asList("API Action Test Data - " + actionName, "Actual Value", testData);
            attachments.add(actualValueAttachment);
        } else if (testData != null && !testData.isEmpty()) {
            message = (String)message + " \"" + testData.trim() + "\"";
        }
        message = (String)message + ".";
        message = ((String)message).replace("API Action: ", "");
        Boolean initialLoggingState = ReportManagerHelper.getDiscreteLogging();
        if (Boolean.TRUE.equals(isDiscrete)) {
            if (requestBody != null && !requestBody.equals(new JsonObject())) {
                RestActions.reportRequestBody(requestBody);
            }
            RestActions.reportResponseBody(response, true);
            ReportManager.logDiscrete((String)message);
        } else {
            attachments.add(RestActions.reportRequestSpecs(specs));
            if (requestBody != null && !requestBody.equals(new JsonObject())) {
                attachments.add(RestActions.reportRequestBody(requestBody));
            }
            attachments.add(expectedFileBodyAttachment);
            attachments.add(RestActions.reportResponseBody(response, initialLoggingState));
            if (rootCauseException != null && rootCauseException.length >= 1) {
                List<Object> actualValueAttachment = Arrays.asList("API Action Exception - " + actionName, "Stacktrace", ReportManagerHelper.formatStackTraceToLogEntry(rootCauseException[0]));
                attachments.add(actualValueAttachment);
            }
            if (Boolean.FALSE.equals(initialLoggingState)) {
                ReportManagerHelper.log((String)message, attachments);
            } else {
                ReportManager.logDiscrete((String)message);
            }
        }
        return message;
    }

    private static List<Object> reportRequestSpecs(RequestSpecification specs) {
        ArrayList<Object> requestSpecsAttachment = new ArrayList<Object>();
        if (specs != null) {
            Map queryParams;
            Map formParams;
            requestSpecsAttachment.add("API Request");
            requestSpecsAttachment.add("Specifications");
            StringBuilder builder = new StringBuilder();
            QueryableRequestSpecification queryableRequestSpecification = SpecificationQuerier.query((RequestSpecification)specs);
            List headers = queryableRequestSpecification.getHeaders().asList();
            if (headers != null && !headers.isEmpty()) {
                builder.append("Headers:").append(System.lineSeparator()).append("_______________").append(System.lineSeparator()).append(System.lineSeparator());
                for (Header header : headers) {
                    builder.append(header.getName()).append("=").append(header.getValue()).append(System.lineSeparator());
                }
                builder.append(System.lineSeparator());
            }
            if ((formParams = queryableRequestSpecification.getFormParams()) != null && !formParams.isEmpty()) {
                builder.append("Form Parameters:").append(System.lineSeparator()).append("_______________").append(System.lineSeparator()).append(System.lineSeparator());
                for (String key : formParams.keySet()) {
                    builder.append(key).append("=").append((String)formParams.get(key)).append(System.lineSeparator());
                }
                builder.append(System.lineSeparator());
            }
            if ((queryParams = queryableRequestSpecification.getQueryParams()) != null && !queryParams.isEmpty()) {
                builder.append("Query Parameters:").append(System.lineSeparator()).append("_______________").append(System.lineSeparator()).append(System.lineSeparator());
                for (String key : queryParams.keySet()) {
                    builder.append(key).append("=").append((String)queryParams.get(key)).append(System.lineSeparator());
                }
            }
            requestSpecsAttachment.add(builder);
        }
        return requestSpecsAttachment;
    }

    private static List<Object> reportRequestBody(Object requestBody) {
        ArrayList<Object> requestBodyAttachment = new ArrayList<Object>();
        if (requestBody.toString() != null && !requestBody.toString().isEmpty()) {
            if (ReportManagerHelper.getDiscreteLogging()) {
                try {
                    ReportManager.logDiscrete("API Request - REST Body:\n" + IOUtils.toString((InputStream)RestActions.parseBodyToJson(requestBody), (Charset)StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    ReportManager.logDiscrete("API Request - REST Body:\n" + String.valueOf(requestBody));
                }
            } else {
                requestBodyAttachment.add("API Request");
                switch (RestActions.identifyBodyObjectType(requestBody)) {
                    case 1: {
                        requestBodyAttachment.add("JSON Body");
                        requestBodyAttachment.add(RestActions.parseBodyToJson(requestBody));
                        break;
                    }
                    case 2: {
                        requestBodyAttachment.add("XML Body");
                        requestBodyAttachment.add(RestActions.formatXML(String.valueOf(requestBody)));
                        break;
                    }
                    case 3: 
                    case 4: {
                        requestBodyAttachment.add("Body");
                        requestBodyAttachment.add(RestActions.parseBodyToJson(requestBody));
                        break;
                    }
                    default: {
                        requestBodyAttachment.add(RestActions.parseBodyToJson(requestBody));
                    }
                }
                return requestBodyAttachment;
            }
        }
        return null;
    }

    private static List<Object> reportResponseBody(Response responseBody, Boolean isDiscrete) {
        ArrayList<Object> responseBodyAttachment = new ArrayList<Object>();
        if (responseBody != null) {
            if (Boolean.TRUE.equals(isDiscrete)) {
                try {
                    ReportManager.logDiscrete("API Response - REST Body:\n" + IOUtils.toString((InputStream)RestActions.parseBodyToJson(responseBody), (Charset)StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    ReportManager.logDiscrete("API Response - REST Body:\n" + responseBody.asString());
                }
            } else {
                responseBodyAttachment.add("API Response");
                switch (RestActions.identifyBodyObjectType(responseBody)) {
                    case 1: {
                        responseBodyAttachment.add("JSON Body");
                        responseBodyAttachment.add(RestActions.parseBodyToJson(responseBody));
                        break;
                    }
                    case 2: {
                        responseBodyAttachment.add("XML Body");
                        responseBodyAttachment.add(RestActions.formatXML(String.valueOf(responseBody)));
                        break;
                    }
                    case 3: 
                    case 4: {
                        responseBodyAttachment.add("Body");
                        responseBodyAttachment.add(RestActions.parseBodyToJson(responseBody));
                        break;
                    }
                    default: {
                        responseBodyAttachment.add(RestActions.parseBodyToJson(responseBody));
                    }
                }
                return responseBodyAttachment;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int identifyBodyObjectType(Object body) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject actualJsonObject = null;
            org.json.simple.JSONArray actualJsonArray = null;
            if (body.getClass().getName().toLowerCase().contains("restassured")) {
                try {
                    String bodyString = ((ResponseBody)body).asString();
                    if (bodyString.isEmpty()) return 1;
                    actualJsonObject = (JSONObject)parser.parse(bodyString);
                    return 1;
                }
                catch (ClassCastException e) {
                    String bodyString = ((ResponseBody)body).asString();
                    if (bodyString.isEmpty()) return 1;
                    actualJsonArray = (org.json.simple.JSONArray)parser.parse(bodyString);
                    return 1;
                }
                catch (ParseException e) {
                    return 3;
                }
            } else if (body instanceof JSONObject) {
                actualJsonObject = (JSONObject)body;
                return 1;
            } else if (body instanceof org.json.simple.JSONArray) {
                actualJsonArray = (org.json.simple.JSONArray)body;
                return 1;
            } else if (body.getClass().getName().toLowerCase().contains("jsonobject")) {
                actualJsonObject = (JSONObject)parser.parse(body.toString().replace("\\n", "").replace("\\t", "").replace(" ", ""));
                return 1;
            } else {
                if (body instanceof Map) {
                    Map bodyMap = (Map)body;
                    return 1;
                }
                actualJsonObject = (JSONObject)parser.parse(body.toString());
            }
            return 1;
        }
        catch (Exception e) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(byteArrayOutputStream);
                oos.writeObject(body);
                oos.flush();
                oos.close();
                return 4;
            }
            catch (IOException ioe) {
                if (!body.getClass().getName().toLowerCase().contains("restassured")) return 3;
                return 2;
            }
        }
    }

    private static InputStream parseJsonBody(Object body) throws ParseException {
        org.json.simple.JSONArray actualJsonArray;
        JSONObject actualJsonObject;
        block15: {
            JSONParser parser = new JSONParser();
            actualJsonObject = null;
            actualJsonArray = null;
            if (body.getClass().getName().toLowerCase().contains("restassured")) {
                try {
                    String bodyString = ((ResponseBody)body).asString();
                    if (!bodyString.isEmpty()) {
                        actualJsonObject = (JSONObject)parser.parse(bodyString);
                    }
                    break block15;
                }
                catch (ClassCastException e) {
                    String bodyString = ((ResponseBody)body).asString();
                    if (!bodyString.isEmpty()) {
                        actualJsonArray = (org.json.simple.JSONArray)parser.parse(bodyString);
                    }
                    break block15;
                }
            }
            if (body instanceof JSONObject) {
                actualJsonObject = (JSONObject)body;
            } else if (body instanceof org.json.simple.JSONArray) {
                actualJsonArray = (org.json.simple.JSONArray)body;
            } else if (body.getClass().getName().toLowerCase().contains("jsonobject")) {
                actualJsonObject = (JSONObject)parser.parse(body.toString().replace("\\n", "").replace("\\t", "").replace(" ", ""));
            } else if (body instanceof Map) {
                Map bodyMap = (Map)body;
                actualJsonObject = new JSONObject(bodyMap);
            } else {
                actualJsonObject = (JSONObject)parser.parse(body.toString());
            }
        }
        if (actualJsonObject != null) {
            return new ByteArrayInputStream(new GsonBuilder().setPrettyPrinting().create().toJson(JsonParser.parseString((String)actualJsonObject.toJSONString())).getBytes());
        }
        if (actualJsonArray != null) {
            return new ByteArrayInputStream(new GsonBuilder().setPrettyPrinting().create().toJson(JsonParser.parseString((String)actualJsonArray.toJSONString())).getBytes());
        }
        return new ByteArrayInputStream("".getBytes());
    }

    private static boolean compareJSONEquals(JSONObject expectedJsonObject, org.json.simple.JSONArray expectedJsonArray, JSONObject actualJsonObject, org.json.simple.JSONArray actualJsonArray) {
        if (expectedJsonObject != null && actualJsonObject != null) {
            return actualJsonObject.toString().equals(expectedJsonObject.toString());
        }
        return actualJsonArray.toString().equals(expectedJsonArray.toString());
    }

    private static boolean compareJSONEqualsIgnoringOrder(JSONObject expectedJsonObject, org.json.simple.JSONArray expectedJsonArray, JSONObject actualJsonObject, org.json.simple.JSONArray actualJsonArray) {
        if (expectedJsonObject != null && actualJsonObject != null) {
            try {
                JSONAssert.assertEquals((String)expectedJsonObject.toString(), (String)actualJsonObject.toString(), (JSONCompareMode)JSONCompareMode.NON_EXTENSIBLE);
                return true;
            }
            catch (JSONException e) {
                return false;
            }
        }
        try {
            JSONAssert.assertEquals((String)expectedJsonArray.toString(), (String)actualJsonArray.toString(), (JSONCompareMode)JSONCompareMode.NON_EXTENSIBLE);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private static boolean compareJSONContains(Response response, JSONObject expectedJsonObject, org.json.simple.JSONArray expectedJsonArray, JSONObject actualJsonObject, String jsonPathToTargetArray) throws JSONException, ParseException {
        JSONParser parser = new JSONParser();
        if (!jsonPathToTargetArray.isEmpty() && expectedJsonArray != null) {
            org.json.simple.JSONArray actualJsonArray = (org.json.simple.JSONArray)parser.parse(new Gson().toJsonTree(RestActions.getResponseJSONValueAsList(response, jsonPathToTargetArray)).getAsJsonArray().toString());
            return actualJsonArray.containsAll((Collection)expectedJsonArray);
        }
        if (jsonPathToTargetArray.isEmpty() && expectedJsonArray != null) {
            String actual = new Gson().toJson((Object)actualJsonObject);
            String expected = new Gson().toJson((Object)expectedJsonArray);
            return actual.contains(expected.substring(1));
        }
        if (expectedJsonObject != null) {
            boolean initialComparison = JSONCompare.compareJSON((String)expectedJsonObject.toJSONString(), (String)actualJsonObject.toJSONString(), (JSONCompareMode)JSONCompareMode.LENIENT).passed();
            if (Boolean.FALSE.equals(initialComparison)) {
                return actualJsonObject.toString().contains(expectedJsonObject.toString());
            }
            return initialComparison;
        }
        return false;
    }

    private static String prettyFormatXML(String input) {
        StreamSource xmlInput = new StreamSource(new StringReader(input));
        StringWriter stringWriter = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("doctype-public", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, new StreamResult(stringWriter));
            return stringWriter.toString().trim();
        }
        catch (Exception e) {
            return input;
        }
    }

    private static void initializeSystemProperties() {
        HTTP_SOCKET_TIMEOUT = SHAFT.Properties.timeouts.apiSocketTimeout();
        HTTP_CONNECTION_TIMEOUT = SHAFT.Properties.timeouts.apiConnectionTimeout();
        HTTP_CONNECTION_MANAGER_TIMEOUT = SHAFT.Properties.timeouts.apiConnectionManagerTimeout();
        AUTOMATICALLY_ASSERT_RESPONSE_STATUS_CODE = SHAFT.Properties.flags.automaticallyAssertResponseStatusCode();
    }

    private static Response graphQlRequestHelper(String base_URI_forHelperMethod, JSONObject requestBody_forHelperMethod) {
        ReportManager.logDiscrete("GraphQl Request is being Performed with the Following Parameters [Service URL: " + base_URI_forHelperMethod + "graphql | Request Body: " + String.valueOf(requestBody_forHelperMethod) + "\"");
        return RestActions.buildNewRequest(base_URI_forHelperMethod, GRAPHQL_END_POINT, RequestType.POST).setRequestBody(requestBody_forHelperMethod).setContentType(ContentType.JSON).performRequest();
    }

    public static Response sendGraphQlRequest(String base_URI, String query) {
        JSONObject requestBody = new JSONObject();
        requestBody.put((Object)"query", (Object)query);
        return RestActions.graphQlRequestHelper(base_URI, requestBody);
    }

    public static Response sendGraphQlRequest(String base_URI, String query, String variables) {
        JSONObject requestBody = new JSONObject();
        requestBody.put((Object)"query", (Object)query);
        requestBody.put((Object)"variables", (Object)variables);
        return RestActions.graphQlRequestHelper(base_URI, requestBody);
    }

    public static Response sendGraphQlRequest(String base_URI, String query, String variables, String fragment) {
        JSONObject requestBody = new JSONObject();
        requestBody.put((Object)"query", (Object)query);
        requestBody.put((Object)"variables", (Object)variables);
        requestBody.put((Object)"fragment", (Object)fragment);
        return RestActions.graphQlRequestHelper(base_URI, requestBody);
    }

    private static Response graphQlRequestHelperWithHeader(String base_URI_forHelperMethod, JSONObject requestBody_forHelperMethod, String headerKey_forHelperMethod, String headerValue_forHelperMethod) {
        ReportManager.logDiscrete("GraphQl Request is being Performed with the Following Parameters [Service URL: " + base_URI_forHelperMethod + "graphql | Request Body: " + String.valueOf(requestBody_forHelperMethod) + " | Header: \"" + headerKey_forHelperMethod + "\":\"" + headerValue_forHelperMethod + "\"\"");
        return RestActions.buildNewRequest(base_URI_forHelperMethod, GRAPHQL_END_POINT, RequestType.POST).setRequestBody(requestBody_forHelperMethod).setContentType(ContentType.JSON).addHeader(headerKey_forHelperMethod, headerValue_forHelperMethod).performRequest();
    }

    public static Response sendGraphQlRequestWithHeader(String base_URI, String query, String header_key, String header_value) {
        JSONObject requestBody = new JSONObject();
        requestBody.put((Object)"query", (Object)query);
        return RestActions.graphQlRequestHelperWithHeader(base_URI, requestBody, header_key, header_value);
    }

    public static Response sendGraphQlRequestWithHeader(String base_URI, String query, String variables, String header_key, String header_value) {
        JSONObject requestBody = new JSONObject();
        requestBody.put((Object)"query", (Object)query);
        requestBody.put((Object)"variables", (Object)variables);
        return RestActions.graphQlRequestHelperWithHeader(base_URI, requestBody, header_key, header_value);
    }

    public static Response sendGraphQlRequestWithHeader(String base_URI, String query, String variables, String fragment, String header_key, String header_value) {
        JSONObject requestBody = new JSONObject();
        requestBody.put((Object)"query", (Object)query);
        requestBody.put((Object)"variables", (Object)variables);
        requestBody.put((Object)"fragment", (Object)fragment);
        return RestActions.graphQlRequestHelperWithHeader(base_URI, requestBody, header_key, header_value);
    }

    public RequestBuilder buildNewRequest(String serviceName, RequestType requestType) {
        return new RequestBuilder(this, serviceName, requestType);
    }

    protected String getServiceURI() {
        return this.serviceURI;
    }

    protected Map<String, String> getSessionHeaders() {
        return this.sessionHeaders;
    }

    protected Map<String, Object> getSessionCookies() {
        return this.sessionCookies;
    }

    protected RestAssuredConfig getSessionConfig() {
        return this.sessionConfig;
    }

    private RequestSpecBuilder setConfigs(RequestSpecBuilder builder, List<RestAssuredConfig> configs) {
        for (RestAssuredConfig config : configs) {
            builder.setConfig(config);
        }
        return builder;
    }

    private RequestSpecBuilder initializeBuilder(Map<String, Object> sessionCookies, Map<String, String> sessionHeaders, RestAssuredConfig sessionConfig, boolean appendDefaultContentCharsetToContentTypeIfUndefined) {
        RequestSpecBuilder builder = new RequestSpecBuilder();
        builder.addCookies(sessionCookies);
        builder.addHeaders(sessionHeaders);
        RestAssuredConfig userConfigs = sessionConfig.and().encoderConfig(new EncoderConfig().defaultContentCharset("UTF-8").appendDefaultContentCharsetToContentTypeIfUndefined(appendDefaultContentCharsetToContentTypeIfUndefined)).and().httpClient(HttpClientConfig.httpClientConfig().setParam("http.connection.timeout", (Object)(HTTP_CONNECTION_TIMEOUT * 1000)).setParam("http.socket.timeout", (Object)(HTTP_SOCKET_TIMEOUT * 1000)).setParam("http.connection-manager.timeout", (Object)(HTTP_CONNECTION_MANAGER_TIMEOUT * 1000)));
        builder.setConfig(userConfigs);
        return builder;
    }

    public RestActions addHeaderVariable(String key, String value) {
        this.sessionHeaders.put(key, value);
        return this;
    }

    public RestActions addCookieVariable(String key, String value) {
        this.sessionCookies.put(key, value);
        return this;
    }

    protected String prepareRequestURL(String serviceURI, String urlArguments, String serviceName) {
        if (urlArguments != null && !urlArguments.isEmpty()) {
            return serviceURI + serviceName + ARGUMENT_SEPARATOR + urlArguments;
        }
        return serviceURI + serviceName;
    }

    protected RequestSpecification prepareRequestSpecs(List<List<Object>> parameters, ParametersType parametersType, Object body, ContentType contentType, Map<String, Object> sessionCookies, Map<String, String> sessionHeaders, RestAssuredConfig sessionConfig, boolean appendDefaultContentCharsetToContentTypeIfUndefined, boolean urlEncodingEnabled) {
        RequestSpecBuilder builder = this.initializeBuilder(sessionCookies, sessionHeaders, sessionConfig, appendDefaultContentCharsetToContentTypeIfUndefined);
        builder.setContentType(contentType);
        builder.setUrlEncodingEnabled(urlEncodingEnabled);
        if (body != null && contentType != null && !body.toString().isEmpty()) {
            this.prepareRequestBody(builder, body, contentType);
        } else if (parameters != null && !parameters.isEmpty() && !parameters.getFirst().getFirst().equals("")) {
            this.prepareRequestBody(builder, parameters, parametersType);
        }
        return builder.build();
    }

    private void prepareRequestBody(RequestSpecBuilder builder, Object body, ContentType contentType) {
        String bodyString;
        if (body instanceof String && (bodyString = (String)body).contains("\n")) {
            builder.setBody(bodyString);
        } else if (body instanceof org.json.JSONObject || body instanceof JSONArray) {
            builder.setBody(body.toString());
        } else {
            try {
                switch (contentType) {
                    case JSON: {
                        builder.setBody(body, ObjectMapperType.GSON);
                        break;
                    }
                    case XML: {
                        builder.setBody(body, ObjectMapperType.JAXB);
                        break;
                    }
                    default: {
                        builder.setBody(body);
                        break;
                    }
                }
            }
            catch (Exception rootCauseException) {
                RestActions.failAction("Issue with parsing body content", rootCauseException);
            }
        }
    }

    private void prepareRequestBody(RequestSpecBuilder builder, List<List<Object>> parameters, ParametersType parametersType) {
        parameters.forEach(param -> {
            if (param.get(1).getClass().equals(File.class)) {
                MultiPartSpecBuilder multiPartSpecBuilder = new MultiPartSpecBuilder(param.get(1));
                multiPartSpecBuilder.controlName(param.get(0).toString());
                String fileName = ((File)param.get(1)).getName();
                multiPartSpecBuilder.fileName(fileName);
                String mimeType = URLConnection.guessContentTypeFromName(((File)param.get(1)).getName());
                if (mimeType == null) {
                    mimeType = MimeUtil2.getMostSpecificMimeType((Collection)MimeUtil.getMimeTypes((String)fileName)).toString();
                }
                multiPartSpecBuilder.mimeType(mimeType);
                builder.addMultiPart(multiPartSpecBuilder.build());
                builder.setContentType("multipart/form-data");
            } else if (parametersType.equals((Object)ParametersType.FORM)) {
                builder.addFormParam(param.get(0).toString(), new Object[]{param.get(1)});
            } else {
                builder.addQueryParam(param.get(0).toString(), new Object[]{param.get(1)});
            }
        });
    }

    Response sendRequest(RequestType requestType, String request, RequestSpecification specs) {
        switch (requestType.ordinal()) {
            case 0: {
                return (Response)((Response)RestAssured.given().spec(specs).when().post(request, new Object[0])).andReturn();
            }
            case 2: {
                return (Response)((Response)RestAssured.given().spec(specs).when().patch(request, new Object[0])).andReturn();
            }
            case 4: {
                return (Response)((Response)RestAssured.given().spec(specs).when().put(request, new Object[0])).andReturn();
            }
            case 1: {
                return (Response)((Response)RestAssured.given().spec(specs).when().get(request, new Object[0])).andReturn();
            }
            case 3: {
                return (Response)((Response)RestAssured.given().spec(specs).when().delete(request, new Object[0])).andReturn();
            }
        }
        return null;
    }

    private void extractCookiesFromResponse(Response response) {
        if (response.getDetailedCookies().size() > 0) {
            for (Cookie cookie : response.getDetailedCookies()) {
                this.sessionCookies.put(cookie.getName(), cookie.getValue());
                if (!cookie.getName().equals("XSRF-TOKEN")) continue;
                this.sessionHeaders.put("X-XSRF-TOKEN", cookie.getValue());
            }
        }
    }

    private void extractHeadersFromResponse(Response response) {
        if (response.getHeaders().size() > 0) {
            for (Header header : response.getHeaders()) {
                if (!header.getName().equals("X-XSRF-TOKEN") && !header.getName().equals("Set-Cookie")) continue;
                this.sessionHeaders.put(header.getName(), header.getValue());
            }
        }
        try {
            if (response.jsonPath().getString("type").equalsIgnoreCase("bearer")) {
                this.headerAuthorization = "Bearer " + RestActions.getResponseJSONValue(response, "token");
                this.sessionHeaders.put("Authorization", this.headerAuthorization);
                this.sessionHeaders.put("Content-Type", "application/json");
            }
        }
        catch (JsonPathException | NullPointerException throwable) {
            // empty catch block
        }
    }

    protected boolean evaluateResponseStatusCode(Response response, int targetStatusCode) {
        try {
            boolean discreetLoggingState = ReportManagerHelper.getDiscreteLogging();
            ReportManagerHelper.setDiscreteLogging(true);
            int statusCode = response.getStatusCode();
            ReportManager.logDiscrete("Response status code: \"" + statusCode + "\", status line: \"" + response.getStatusLine() + "\"");
            if (AUTOMATICALLY_ASSERT_RESPONSE_STATUS_CODE) {
                if (targetStatusCode != 0) {
                    Validations.assertThat().number(statusCode).isEqualTo(targetStatusCode).withCustomReportMessage("Evaluating the actual response status code " + statusCode + " against the expected one " + targetStatusCode + ".").perform();
                } else {
                    Validations.assertThat().object(statusCode >= 200 && statusCode < 300).isTrue().withCustomReportMessage("Evaluating that the response is successful (Status code is between 200 and 299).").perform();
                }
            }
            ReportManagerHelper.setDiscreteLogging(discreetLoggingState);
            return true;
        }
        catch (AssertionError rootCauseException) {
            return false;
        }
    }

    String prepareReportMessage(Response response, int targetStatusCode, RequestType requestType, String serviceName, ContentType contentType, String urlArguments) {
        if (response != null) {
            this.extractCookiesFromResponse(response);
            this.extractHeadersFromResponse(response);
            StringBuilder reportMessage = new StringBuilder();
            reportMessage.append((Object)requestType);
            reportMessage.append(" | Target Status Code: ").append(targetStatusCode);
            reportMessage.append(" | Service URL: ").append(this.serviceURI).append(serviceName);
            reportMessage.append(" | Content Type: ").append(contentType);
            reportMessage.append(" | Response Time: ").append(response.timeIn(TimeUnit.MILLISECONDS)).append("ms");
            if (urlArguments != null) {
                reportMessage.append(" | URL Arguments: ").append(urlArguments);
            }
            return reportMessage.toString().trim();
        }
        return "";
    }

    public static Response getLastResponse() {
        return lastResponse;
    }

    static {
        AUTOMATICALLY_ASSERT_RESPONSE_STATUS_CODE = true;
    }

    public static enum RequestType {
        POST,
        GET,
        PATCH,
        DELETE,
        PUT;

    }

    public static enum ComparisonType {
        EQUALS,
        CONTAINS,
        EQUALS_IGNORING_ORDER;

    }

    public static enum ParametersType {
        FORM,
        QUERY;

    }
}

