/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.cli;

import com.google.common.hash.Hashing;
import com.shaft.cli.TerminalActions;
import com.shaft.driver.SHAFT;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.PdfFileManager;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.Platform;

public class FileActions {
    private static final String ERROR_CANNOT_CREATE_DIRECTORY = "Could not create directory: ";
    private boolean internalInstance = false;

    public static FileActions getInstance() {
        return FileActions.getInstance(false);
    }

    public static FileActions getInstance(boolean internalInstance) {
        FileActions instance = new FileActions();
        instance.internalInstance = internalInstance;
        return instance;
    }

    public void copyFile(String sourceFilePath, String destinationFilePath) {
        File sourceFile = new File(sourceFilePath);
        File destinationFile = new File(destinationFilePath);
        this.copyFile(sourceFile, destinationFile);
        this.passAction("Source File: \"" + sourceFilePath + "\" | Destination File: \"" + destinationFilePath + "\"");
    }

    public void renameFile(String filePath, String newFileName) {
        try {
            File targetFile = new File(filePath);
            String targetDirectory = targetFile.getParentFile().getAbsolutePath();
            FileUtils.copyFile((File)targetFile, (File)new File(targetDirectory + File.separator + newFileName));
            FileUtils.deleteQuietly((File)targetFile);
            this.passAction("Target File Path: \"" + filePath + "\", file was renamed to \"" + newFileName + "\".");
        }
        catch (IOException e) {
            this.failAction(e);
        }
    }

    public String copyFile(TerminalActions terminalSession, String sourceDirectory, String destinationDirectory, String fileName) {
        String command = this.isTargetOSUnixBased() ? (fileName.trim().isEmpty() ? "rsync --verbose --recursive " + sourceDirectory + File.separator + " " + destinationDirectory : "rsync --verbose --recursive " + sourceDirectory + File.separator + fileName + " " + destinationDirectory + File.separator) : "robocopy  /e /v /fp " + sourceDirectory + " " + destinationDirectory + " " + fileName;
        String terminalLog = terminalSession.performTerminalCommand(command);
        this.passAction("Source Directory: \"" + sourceDirectory + "\" | Destination Directory: \"" + destinationDirectory + "\" | File Name: \"" + fileName + "\"", terminalLog);
        return terminalLog;
    }

    public String listFilesInDirectory(String targetDirectory) {
        StringBuilder files = new StringBuilder();
        try {
            Collection filesList = FileUtils.listFiles((File)new File(targetDirectory), (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE);
            filesList.forEach(file -> files.append(file.getName()).append(System.lineSeparator()));
        }
        catch (IllegalArgumentException rootCauseException) {
            this.failAction("Failed to list files in this directory: \"" + targetDirectory + "\"", rootCauseException);
        }
        this.passAction("Target Directory: \"" + targetDirectory + "\"", files.toString().trim());
        return files.toString().trim();
    }

    public String listFilesInDirectory(String targetDirectory, TrueFileFilter recursively) {
        StringBuilder files = new StringBuilder();
        try {
            Collection filesList = FileUtils.listFiles((File)new File(targetDirectory), (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)recursively);
            filesList.forEach(file -> files.append(file.getName()).append(System.lineSeparator()));
        }
        catch (IllegalArgumentException rootCauseException) {
            this.failAction("Failed to list files in this directory: \"" + targetDirectory + "\"", rootCauseException);
        }
        this.passAction("Target Directory: \"" + targetDirectory + "\"", files.toString().trim());
        return files.toString().trim();
    }

    public Collection<File> getFileList(String targetDirectory) {
        StringBuilder files = new StringBuilder();
        Collection<File> filesList = new ArrayList();
        try {
            filesList = FileUtils.listFiles((File)new File(targetDirectory), (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE);
            filesList.forEach(file -> files.append(file.getAbsolutePath()).append(System.lineSeparator()));
        }
        catch (IllegalArgumentException rootCauseException) {
            this.failAction("Failed to list absolute file paths in this directory: \"" + targetDirectory + "\"", rootCauseException);
        }
        this.passAction("Target Directory: \"" + targetDirectory + "\"", files.toString().trim());
        return filesList;
    }

    public String listFilesInDirectory(TerminalActions terminalSession, String targetDirectory) {
        List<CallSite> commands = this.isTargetOSUnixBased() ? Collections.singletonList("ls " + targetDirectory) : Collections.singletonList("dir " + targetDirectory);
        String log = terminalSession.performTerminalCommands(commands);
        this.passAction("TargetDirectory: \"" + targetDirectory + "\"", log);
        return log;
    }

    public String getFileChecksum(TerminalActions terminalSession, String targetFileFolderPath, String targetFileName, String ... pathToTempDirectoryOnRemoteMachine) {
        String targetFilePath = this.copyFileToLocalMachine(terminalSession, targetFileFolderPath, targetFileName, pathToTempDirectoryOnRemoteMachine);
        String sha256 = "";
        try {
            byte[] fileBytes = Files.readAllBytes(Paths.get(targetFilePath, new String[0]));
            sha256 = Hashing.sha256().hashBytes(fileBytes).toString();
        }
        catch (IOException rootCauseException) {
            this.failAction("Failed to read file \"" + targetFilePath + "\"", rootCauseException);
        }
        this.passAction("Target File: \"" + targetFilePath + "\" | SHA-256: \"" + sha256 + "\"");
        return sha256;
    }

    public String copyFileToLocalMachine(TerminalActions terminalSession, String targetFileFolderPath, String targetFileName, String ... pathToTempDirectoryOnRemoteMachine) {
        String targetFilePath = targetFileFolderPath + targetFileName;
        TerminalActions terminalSessionForRemoteMachine = new TerminalActions();
        if (terminalSession.isDockerizedTerminal()) {
            terminalSessionForRemoteMachine = new TerminalActions(terminalSession.getSshHostName(), terminalSession.getSshPortNumber(), terminalSession.getSshUsername(), terminalSession.getSshKeyFileFolderName(), terminalSession.getSshKeyFileName());
            terminalSessionForRemoteMachine.performTerminalCommand("rm -r " + pathToTempDirectoryOnRemoteMachine[0]);
            terminalSessionForRemoteMachine.performTerminalCommand("mkdir -p " + pathToTempDirectoryOnRemoteMachine[0] + targetFileFolderPath);
            terminalSessionForRemoteMachine.performTerminalCommand("docker cp " + terminalSession.getDockerName() + ":" + targetFilePath + " " + pathToTempDirectoryOnRemoteMachine[0] + targetFilePath);
            targetFilePath = pathToTempDirectoryOnRemoteMachine[0] + targetFilePath;
        }
        if (terminalSession.isRemoteTerminal()) {
            String destination;
            String sshParameters = "-i " + FileActions.getInstance(true).getAbsolutePath(terminalSession.getSshKeyFileFolderName(), terminalSession.getSshKeyFileName()) + " -P " + terminalSession.getSshPortNumber();
            String pathToRemoteFileThatWillBeCopied = targetFilePath;
            String source = terminalSession.getSshUsername() + "@" + terminalSession.getSshHostName() + ":" + pathToRemoteFileThatWillBeCopied;
            String pathToLocalParentFolder = FileActions.getInstance(true).getAbsolutePath("target/temp");
            FileActions.getInstance(true).deleteFolder(pathToLocalParentFolder);
            FileActions.getInstance(true).createFolder(pathToLocalParentFolder);
            targetFilePath = destination = pathToLocalParentFolder + "/" + targetFileName;
            String command = "scp -v -o StrictHostKeyChecking=no " + sshParameters + " -r " + source + " " + destination;
            new TerminalActions().performTerminalCommand("chmod 400 " + FileActions.getInstance(true).getAbsolutePath(terminalSession.getSshKeyFileFolderName(), terminalSession.getSshKeyFileName()));
            new TerminalActions().performTerminalCommand(command);
        }
        if (terminalSession.isDockerizedTerminal() && terminalSession.isRemoteTerminal()) {
            terminalSessionForRemoteMachine.performTerminalCommand("rm -r " + Arrays.toString(pathToTempDirectoryOnRemoteMachine));
        }
        this.passAction("Target File Path: \"" + targetFilePath + "\"");
        return targetFilePath;
    }

    public void deleteFile(String targetFilePath) {
        boolean wasFileDeleted = FileUtils.deleteQuietly((File)new File(targetFilePath));
        String negation = wasFileDeleted ? "" : "not ";
        this.passAction("Target File Path: \"" + targetFilePath + "\", file was " + negation + "deleted.");
    }

    public void writeToFile(String fileFolderName, String fileName, List<String> text) {
        byte[] textToBytes = String.join((CharSequence)System.lineSeparator(), text).getBytes();
        this.writeToFile(fileFolderName, fileName, textToBytes);
    }

    public void writeToFile(String fileFolderName, String fileName, byte[] content) {
        String absoluteFilePath = this.getAbsolutePath(fileFolderName, fileName);
        try {
            Path filePath = Paths.get(absoluteFilePath, new String[0]);
            Path parentDir = filePath.getParent();
            if (!parentDir.toFile().exists()) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            Files.write(filePath, content, new OpenOption[0]);
            this.passAction("Target File Path: \"" + String.valueOf(filePath) + "\"", Arrays.toString(content));
        }
        catch (IOException | InvalidPathException rootCauseException) {
            this.failAction("Folder Name: \"" + fileFolderName + "\", File Name \"" + fileName + "\".", rootCauseException);
        }
    }

    public void writeToFile(String fileFolderName, String fileName, String text) {
        byte[] textToBytes = text.getBytes();
        this.writeToFile(fileFolderName, fileName, textToBytes);
    }

    public String readPDF(String fileFolderName, String fileName) {
        return new PdfFileManager(fileFolderName + fileName).readFileContent();
    }

    public String readPDF(String relativeFilePath) {
        return new PdfFileManager(relativeFilePath).readFileContent();
    }

    public String readFile(String fileFolderName, String fileName) {
        return this.readFile(fileFolderName + fileName);
    }

    public byte[] readFileAsByteArray(String pathToTargetImage) {
        byte[] data = new byte[]{};
        String absoluteFilePath = this.getAbsolutePath(pathToTargetImage);
        Path filePath = Paths.get(absoluteFilePath, new String[0]);
        try {
            data = Files.readAllBytes(filePath);
            this.passAction("File Path: \"" + String.valueOf(filePath) + "\"");
        }
        catch (IOException rootCauseException) {
            this.failAction(rootCauseException);
        }
        return data;
    }

    public String readFile(String pathToTargetFile) {
        String absoluteFilePath = this.getAbsolutePath(pathToTargetFile);
        String text = "";
        try {
            text = Files.readString(new File(absoluteFilePath).toPath());
            this.passAction("File Path: \"" + absoluteFilePath + "\"", text);
        }
        catch (IOException rootCauseException) {
            this.failAction(rootCauseException);
        }
        return text;
    }

    public boolean doesFileExist(String fileFolderName, String fileName, int numberOfRetries) {
        boolean doesFileExit = false;
        for (int i = 0; i < numberOfRetries; ++i) {
            try {
                doesFileExit = new File(fileFolderName + fileName).getAbsoluteFile().exists();
            }
            catch (Exception rootCauseException) {
                ReportManagerHelper.logDiscrete(rootCauseException);
            }
            if (!Boolean.FALSE.equals(doesFileExit)) continue;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception rootCauseException) {
                ReportManagerHelper.logDiscrete(rootCauseException);
            }
        }
        this.passAction("File Path: \"" + fileFolderName + fileName + "\"");
        return doesFileExit;
    }

    public boolean doesFileExist(String targetFile) {
        boolean doesFileExit = false;
        try {
            doesFileExit = new File(targetFile).getAbsoluteFile().exists();
        }
        catch (Exception rootCauseException) {
            this.failAction(rootCauseException);
        }
        this.passAction("File Path: \"" + targetFile + "\"");
        return doesFileExit;
    }

    public String getAbsolutePath(String fileFolderName, String fileName) {
        String filePath = "";
        try {
            filePath = new File(fileFolderName + fileName).getAbsolutePath();
            this.passAction("Relative File Path: \"" + fileFolderName + fileName + "\"", filePath);
        }
        catch (Exception rootCauseException) {
            this.failAction(rootCauseException);
        }
        return filePath;
    }

    public String getAbsolutePath(String relativePath) {
        relativePath = JavaHelper.appendTestDataToRelativePath(relativePath);
        String filePath = "";
        try {
            filePath = new File(relativePath).getAbsolutePath();
            this.passAction("Relative Folder Path: \"" + relativePath + "\"", filePath);
        }
        catch (Exception rootCauseException) {
            this.failAction(rootCauseException);
        }
        return filePath;
    }

    public void copyFolder(String sourceFolderPath, String destinationFolderPath) {
        File sourceFolder = new File(sourceFolderPath);
        File destinationFolder = new File(destinationFolderPath);
        try {
            FileUtils.copyDirectory((File)sourceFolder, (File)destinationFolder);
            this.passAction("Source Folder: \"" + sourceFolderPath + "\" | Destination Folder: \"" + String.valueOf(destinationFolder) + "\"");
        }
        catch (IOException rootCauseException) {
            this.failAction(rootCauseException);
        }
    }

    public void copyFolderFromJar(String sourceFolderPath, String destinationFolderPath) {
        try {
            URL url = URI.create(sourceFolderPath.replace("file:", "jar:file:")).toURL();
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            JarFile jarFile = jarConnection.getJarFile();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                String jarConnectionEntryName;
                JarEntry jarEntry = e.nextElement();
                String jarEntryName = jarEntry.getName();
                if (!jarEntryName.startsWith(jarConnectionEntryName = jarConnection.getEntryName())) continue;
                String filename = jarEntryName.startsWith(jarConnectionEntryName) ? jarEntryName.substring(jarConnectionEntryName.length()) : jarEntryName;
                File currentFile = new File(destinationFolderPath, filename);
                if (!currentFile.toPath().normalize().startsWith(new File(destinationFolderPath).toPath())) {
                    throw new Exception("Bad zip entry");
                }
                if (jarEntry.isDirectory()) {
                    boolean success = currentFile.mkdirs();
                    if (!success) continue;
                    ReportManager.logDiscrete("Directory Created successfully...");
                    continue;
                }
                InputStream is = jarFile.getInputStream(jarEntry);
                FileOutputStream out = FileUtils.openOutputStream((File)currentFile);
                IOUtils.copy((InputStream)is, (OutputStream)out);
                is.close();
                ((OutputStream)out).close();
            }
        }
        catch (Exception rootCauseException) {
            this.failAction(rootCauseException);
        }
    }

    public void copyFileFromJar(String sourceFolderPath, String destinationFolderPath, String fileName) {
        try {
            URL url = URI.create(sourceFolderPath.replace("file:", "jar:file:")).toURL();
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            JarFile jarFile = jarConnection.getJarFile();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                String jarConnectionEntryName;
                JarEntry jarEntry = e.nextElement();
                String jarEntryName = jarEntry.getName();
                if (!jarEntryName.startsWith(jarConnectionEntryName = jarConnection.getEntryName()) || !jarEntryName.contains(fileName)) continue;
                String filename = jarEntryName.startsWith(jarConnectionEntryName) ? jarEntryName.substring(jarConnectionEntryName.length()) : jarEntryName;
                File currentFile = new File(destinationFolderPath, filename);
                if (!currentFile.toPath().normalize().startsWith(new File(destinationFolderPath).toPath())) {
                    throw new Exception("Bad zip entry");
                }
                if (jarEntry.isDirectory()) {
                    boolean success = currentFile.mkdirs();
                    if (!success) continue;
                    ReportManager.logDiscrete("Directory Created successfully...");
                    continue;
                }
                InputStream is = jarFile.getInputStream(jarEntry);
                FileOutputStream out = FileUtils.openOutputStream((File)currentFile);
                IOUtils.copy((InputStream)is, (OutputStream)out);
                is.close();
                ((OutputStream)out).close();
            }
        }
        catch (Exception rootCauseException) {
            this.failAction(rootCauseException);
        }
    }

    public void deleteFolder(String folderPath) {
        this.deleteFile(folderPath);
    }

    public void createFolder(String folderPath) {
        try {
            FileUtils.forceMkdir((File)new File(folderPath));
            this.passAction("Target Folder: \"" + folderPath + "\"");
        }
        catch (IOException rootCauseException) {
            this.failAction(rootCauseException);
        }
    }

    public void createFile(String folderPath, String fileName) {
        try {
            FileUtils.forceMkdir((File)new File(folderPath));
            FileUtils.touch((File)new File(folderPath + fileName));
            this.passAction("Target Folder: \"" + folderPath + "\", Target File: \"" + fileName + "\"");
        }
        catch (IOException rootCauseException) {
            this.failAction(rootCauseException);
        }
    }

    public boolean zipFiles(String srcFolder, String destZipFile) {
        boolean result = false;
        try (Stream<Path> fileWalker = Files.walk(Paths.get(srcFolder, new String[0]), new FileVisitOption[0]);){
            if (SHAFT.Properties.reporting.debugMode()) {
                StringBuilder log = new StringBuilder();
                fileWalker.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(filePath -> {
                    log.append(filePath.toString());
                    log.append("\n");
                });
                ReportManager.log("Archiving the following files:\n" + String.valueOf(log));
            }
            this.zipFolder(srcFolder, destZipFile);
            result = true;
            this.passAction("Target Folder: \"" + srcFolder + "\" | Destination Archive: \"" + destZipFile + "\"");
        }
        catch (Exception rootCauseException) {
            this.failAction(rootCauseException);
        }
        return result;
    }

    public File unpackArchive(URL url, String destinationFolderPath) {
        File targetDir = new File(destinationFolderPath);
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            this.failAction("file: " + url.toString() + " to directory: " + destinationFolderPath, new Exception[0]);
        }
        File unpacked = null;
        try (BufferedInputStream in = new BufferedInputStream(url.openStream(), 1024);){
            File zip = File.createTempFile("archive_", url.toString().substring(url.toString().length() - 4), targetDir);
            zip.deleteOnExit();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zip));
            this.copyInputStream(in, out);
            ((OutputStream)out).close();
            unpacked = this.unpackArchive(zip, targetDir);
            this.passAction("Target URL\"" + String.valueOf(url) + "\" | Destination Folder: \"" + destinationFolderPath + "\"");
        }
        catch (IOException rootCauseException) {
            this.failAction("file: " + String.valueOf(url) + " to directory: " + destinationFolderPath, rootCauseException);
        }
        return unpacked;
    }

    public URL downloadFile(String targetFileURL, String destinationFilePath) {
        return this.downloadFile(targetFileURL, destinationFilePath, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL downloadFile(String targetFileURL, String destinationFilePath, int connectionTimeout, int readTimeout) {
        if (targetFileURL != null && destinationFilePath != null) {
            boolean initialLoggingState = ReportManagerHelper.getDiscreteLogging();
            ReportManagerHelper.setDiscreteLogging(false);
            try {
                ReportManager.log("Downloading a file from this url \"" + targetFileURL + "\" to this directory \"" + destinationFilePath + "\", please wait as downloading may take some time...");
                FileUtils.copyURLToFile((URL)URI.create(targetFileURL).toURL(), (File)new File(destinationFilePath), (int)connectionTimeout, (int)readTimeout);
                ReportManager.logDiscrete("Downloading completed successfully.");
                URL downloadedFile = new File(destinationFilePath).toURI().toURL();
                this.passAction("Target File URL\"" + targetFileURL + "\" | Destination Folder: \"" + destinationFilePath + "\" | Connection Timeout: \"" + connectionTimeout + "\" | Read Timeout: \"" + readTimeout + "\"");
                URL uRL = downloadedFile;
                return uRL;
            }
            catch (IOException rootCauseException) {
                this.failAction("Target File URL: \"" + targetFileURL + "\", and Destination File Path: \"" + destinationFilePath + "\"", rootCauseException);
                URL uRL = null;
                return uRL;
            }
            finally {
                ReportManagerHelper.setDiscreteLogging(initialLoggingState);
            }
        }
        this.failAction("Target File URL: \"" + targetFileURL + "\", and Destination File Path: \"" + destinationFilePath + "\"", new Exception[0]);
        return null;
    }

    private void passAction(String testData) {
        if (!this.internalInstance) {
            String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
            this.reportActionResult(actionName, testData, null, true, new Exception[0]);
        }
    }

    private void passAction(String testData, String log) {
        if (!this.internalInstance) {
            String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
            this.reportActionResult(actionName, testData, log, true, new Exception[0]);
        }
    }

    private void failAction(String testData, Exception ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.failAction(actionName, testData, rootCauseException);
    }

    private void failAction(Exception ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.failAction(actionName, (String)null, rootCauseException);
    }

    private void failAction(String actionName, String testData, Exception ... rootCauseException) {
        String message = this.reportActionResult(actionName, testData, null, false, rootCauseException);
        FailureReporter.fail(FileActions.class, message, rootCauseException[0]);
    }

    private String reportActionResult(String actionName, String testData, String log, Boolean passFailStatus, Exception ... rootCauseException) {
        StackTraceElement[] stackTrace;
        StackTraceElement parentMethod;
        List<Object> actualValueAttachment;
        actionName = ((String)actionName).substring(0, 1).toUpperCase() + ((String)actionName).substring(1);
        String message = Boolean.TRUE.equals(passFailStatus) ? "File Action \"" + (String)actionName + "\" successfully performed." : "File Action \"" + (String)actionName + "\" failed.";
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        if (testData != null && testData.length() >= 500) {
            actualValueAttachment = Arrays.asList("File Action Test Data - " + (String)actionName, "Actual Value", testData);
            attachments.add(actualValueAttachment);
        } else if (testData != null && !testData.isEmpty()) {
            message = message + " With the following test data \"" + testData + "\".";
        }
        if (log != null && !log.trim().isEmpty()) {
            attachments.add(Arrays.asList("File Action Actual Result", "Command Log", log));
        }
        if (rootCauseException != null && rootCauseException.length >= 1) {
            actualValueAttachment = Arrays.asList("File Action Exception - " + (String)actionName, "Stacktrace", ReportManagerHelper.formatStackTraceToLogEntry(rootCauseException[0]));
            attachments.add(actualValueAttachment);
        }
        if ((parentMethod = (stackTrace = Thread.currentThread().getStackTrace())[4]).getClassName().contains("shaft")) {
            ReportManager.logDiscrete(message);
        } else if (!attachments.equals(new ArrayList())) {
            ReportManagerHelper.log(message, attachments);
        } else {
            ReportManager.log(message);
        }
        return message;
    }

    private boolean isTargetOSUnixBased() {
        if (SHAFT.Properties.platform.executionAddress().equals("local")) {
            if (SystemUtils.IS_OS_WINDOWS) {
                return false;
            }
            if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) {
                return true;
            }
            ReportManager.logDiscrete("Unsupported OS type, will assume it's unix based.");
            return true;
        }
        String targetOS = SHAFT.Properties.platform.targetPlatform();
        if (Platform.WINDOWS.name().equals(targetOS)) {
            return false;
        }
        if (Platform.LINUX.name().equals(targetOS) || Platform.MAC.name().equals(targetOS)) {
            return true;
        }
        ReportManager.logDiscrete("Unsupported OS type, will assume it's unix based.");
        return true;
    }

    private void copyFile(File sourceFile, File destinationFile) {
        try {
            FileUtils.copyFile((File)sourceFile, (File)destinationFile);
        }
        catch (IOException rootCauseException) {
            this.failAction(rootCauseException);
        }
    }

    private void zipFolder(String srcFolder, String destZipFile) {
        try (FileOutputStream fileWriter = new FileOutputStream(destZipFile);
             ZipOutputStream zip = new ZipOutputStream(fileWriter);){
            this.addFolderToZip("", srcFolder, zip);
            zip.flush();
        }
        catch (IOException rootCauseException) {
            this.failAction(rootCauseException);
        }
    }

    private void addFileToZip(String path, String srcFile, ZipOutputStream zip, boolean flag) throws IOException {
        File folder = new File(srcFile);
        if (flag) {
            zip.putNextEntry(new ZipEntry(path + FileSystems.getDefault().getSeparator() + folder.getName() + FileSystems.getDefault().getSeparator()));
        } else if (folder.isDirectory()) {
            this.addFolderToZip(path, srcFile, zip);
        } else {
            try (FileInputStream in = new FileInputStream(srcFile);){
                int len;
                byte[] buf = new byte[1024];
                zip.putNextEntry(new ZipEntry(path + FileSystems.getDefault().getSeparator() + folder.getName()));
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            catch (Exception rootCauseException) {
                this.failAction(rootCauseException);
            }
        }
    }

    private void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws IOException {
        File folder = new File(srcFolder);
        if (Objects.requireNonNull(folder.list()).length == 0) {
            this.addFileToZip(path, srcFolder, zip, true);
        } else {
            for (String fileName : Objects.requireNonNull(folder.list())) {
                if (path.isEmpty()) {
                    this.addFileToZip(folder.getName(), srcFolder + FileSystems.getDefault().getSeparator() + fileName, zip, false);
                    continue;
                }
                this.addFileToZip(path + FileSystems.getDefault().getSeparator() + folder.getName(), srcFolder + FileSystems.getDefault().getSeparator() + fileName, zip, false);
            }
        }
    }

    private File unpackArchive(File theFile, File targetDir) throws IOException {
        if (!theFile.exists()) {
            throw new IOException(theFile.getAbsolutePath() + " does not exist");
        }
        if (this.buildDirectory(targetDir)) {
            throw new IOException(ERROR_CANNOT_CREATE_DIRECTORY + String.valueOf(targetDir));
        }
        try (ZipFile zipFile = new ZipFile(theFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File file = new File(targetDir, File.separator + entry.getName());
                if (!file.toPath().normalize().startsWith(targetDir.toPath())) {
                    throw new IOException("Bad zip entry");
                }
                if (this.buildDirectory(file.getParentFile())) {
                    throw new IOException(ERROR_CANNOT_CREATE_DIRECTORY + String.valueOf(file.getParentFile()));
                }
                if (!entry.isDirectory()) {
                    this.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(file)));
                    continue;
                }
                if (!this.buildDirectory(file)) continue;
                throw new IOException(ERROR_CANNOT_CREATE_DIRECTORY + String.valueOf(file));
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        this.passAction("Target File\"" + theFile.getAbsolutePath() + "\" | Destination Folder: \"" + String.valueOf(targetDir) + "\"");
        return theFile;
    }

    private void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }

    private boolean buildDirectory(File file) {
        return !file.exists() && !file.mkdirs();
    }
}

