/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.cli;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.shaft.cli.FileActions;
import com.shaft.driver.SHAFT;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;

public class TerminalActions {
    private String sshHostName = "";
    private String sshUsername;
    private String sshKeyFileFolderName;
    private String sshKeyFileName;
    private int sshPortNumber = 22;
    private String dockerName = "";
    private String dockerUsername;
    private boolean asynchronous = false;
    private boolean verbose = false;
    private boolean isInternal = false;

    public TerminalActions() {
    }

    public TerminalActions(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    private TerminalActions(boolean asynchronous, boolean verbose, boolean isInternal) {
        this.asynchronous = asynchronous;
        this.verbose = verbose;
        this.isInternal = isInternal;
    }

    public TerminalActions(String dockerName, String dockerUsername) {
        this.dockerName = dockerName;
        this.dockerUsername = dockerUsername;
    }

    public TerminalActions(String sshHostName, int sshPortNumber, String sshUsername, String sshKeyFileFolderName, String sshKeyFileName) {
        this.sshHostName = sshHostName;
        this.sshPortNumber = sshPortNumber;
        this.sshUsername = sshUsername;
        this.sshKeyFileFolderName = sshKeyFileFolderName;
        this.sshKeyFileName = sshKeyFileName;
    }

    public TerminalActions(String sshHostName, int sshPortNumber, String sshUsername, String sshKeyFileFolderName, String sshKeyFileName, String dockerName, String dockerUsername) {
        this.sshHostName = sshHostName;
        this.sshPortNumber = sshPortNumber;
        this.sshUsername = sshUsername;
        this.sshKeyFileFolderName = sshKeyFileFolderName;
        this.sshKeyFileName = sshKeyFileName;
        this.dockerName = dockerName;
        this.dockerUsername = dockerUsername;
    }

    public static TerminalActions getInstance() {
        return new TerminalActions();
    }

    public static TerminalActions getInstance(boolean asynchronous) {
        return new TerminalActions(asynchronous);
    }

    public static TerminalActions getInstance(boolean asynchronous, boolean verbose) {
        return new TerminalActions(asynchronous, verbose, false);
    }

    public static TerminalActions getInstance(boolean asynchronous, boolean verbose, boolean isInternal) {
        return new TerminalActions(asynchronous, verbose, isInternal);
    }

    private static String reportActionResult(String actionName, String testData, String log, Boolean passFailStatus, Exception ... rootCauseException) {
        List<Object> actualValueAttachment;
        actionName = ((String)actionName).substring(0, 1).toUpperCase() + ((String)actionName).substring(1);
        String message = Boolean.TRUE.equals(passFailStatus) ? "Terminal Action \"" + (String)actionName + "\" successfully performed." : "Terminal Action \"" + (String)actionName + "\" failed.";
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        if (testData != null && testData.length() >= 500) {
            actualValueAttachment = Arrays.asList("Terminal Action Test Data - " + (String)actionName, "Actual Value", testData);
            attachments.add(actualValueAttachment);
        } else if (testData != null && !testData.isEmpty()) {
            message = message + " With the following test data \"" + testData + "\".";
        }
        if (log != null && !log.trim().isEmpty()) {
            attachments.add(Arrays.asList("Terminal Action Actual Result", "Command Log", log));
        }
        if (rootCauseException != null && rootCauseException.length >= 1) {
            actualValueAttachment = Arrays.asList("Terminal Action Exception - " + (String)actionName, "Stacktrace", ReportManagerHelper.formatStackTraceToLogEntry(rootCauseException[0]));
            attachments.add(actualValueAttachment);
        }
        if (!attachments.equals(new ArrayList())) {
            ReportManagerHelper.log(message, attachments);
        } else {
            ReportManager.log(message);
        }
        return message;
    }

    public boolean isRemoteTerminal() {
        return !this.sshHostName.isEmpty();
    }

    public boolean isDockerizedTerminal() {
        return !this.dockerName.isEmpty();
    }

    public String performTerminalCommands(List<String> commands) {
        List<String> internalCommands = commands;
        String longCommand = this.buildLongCommand(internalCommands);
        if (internalCommands.size() == 1) {
            if (internalCommands.getFirst().contains(" && ")) {
                internalCommands = List.of(internalCommands.getFirst().split(" && "));
            } else if (internalCommands.getFirst().contains(" ; ")) {
                internalCommands = List.of(internalCommands.getFirst().split(" ; "));
            }
        }
        List<String> exitLogs = this.isRemoteTerminal() ? this.executeRemoteCommand(internalCommands, longCommand) : this.executeLocalCommand(internalCommands, longCommand);
        String log = exitLogs.get(0);
        String exitStatus = exitLogs.get(1);
        StringBuilder reportMessage = new StringBuilder();
        if (!this.sshHostName.isEmpty()) {
            reportMessage.append("Host Name: \"").append(this.sshHostName).append("\"");
            reportMessage.append(" | SSH Port Number: \"").append(this.sshPortNumber).append("\"");
            reportMessage.append(" | SSH Username: \"").append(this.sshUsername).append("\"");
        } else {
            reportMessage.append("Host Name: \"localHost\"");
        }
        if (this.sshKeyFileName != null && !this.sshKeyFileName.isEmpty()) {
            reportMessage.append(" | Key File: \"").append(this.sshKeyFileFolderName).append(this.sshKeyFileName).append("\"");
        }
        reportMessage.append(" | Command: \"").append(longCommand).append("\"");
        reportMessage.append(" | Exit Status: \"").append(exitStatus).append("\"");
        if (log != null) {
            if (!this.isInternal) {
                this.passAction(reportMessage.toString(), log);
            }
            return log;
        }
        return "";
    }

    public String performTerminalCommand(String command) {
        return this.performTerminalCommands(Collections.singletonList(command));
    }

    private void passAction(String actionName, String testData, String log) {
        TerminalActions.reportActionResult(actionName, testData, log, true, new Exception[0]);
    }

    private void passAction(String testData, String log) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.passAction(actionName, testData, log);
    }

    private void failAction(String actionName, String testData, Exception ... rootCauseException) {
        String message = TerminalActions.reportActionResult(actionName, testData, null, false, rootCauseException);
        FailureReporter.fail(TerminalActions.class, message, rootCauseException[0]);
    }

    private void failAction(String testData, Exception ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.failAction(actionName, testData, rootCauseException);
    }

    private Session createSSHsession() {
        Session session = null;
        String testData = this.sshHostName + ", " + this.sshPortNumber + ", " + this.sshUsername + ", " + this.sshKeyFileFolderName + ", " + this.sshKeyFileName;
        try {
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            JSch jsch = new JSch();
            if (this.sshKeyFileName != null && !this.sshKeyFileName.isEmpty()) {
                jsch.addIdentity(FileActions.getInstance(true).getAbsolutePath(this.sshKeyFileFolderName, this.sshKeyFileName));
            }
            session = jsch.getSession(this.sshUsername, this.sshHostName, this.sshPortNumber);
            session.setConfig(config);
            session.connect();
            ReportManager.logDiscrete("Successfully created SSH Session.");
        }
        catch (JSchException rootCauseException) {
            this.failAction(testData, new Exception[]{rootCauseException});
        }
        return session;
    }

    private String buildLongCommand(List<String> commands) {
        StringBuilder command = new StringBuilder();
        Iterator<String> i = commands.iterator();
        while (i.hasNext()) {
            if (command.isEmpty()) {
                command.append(i.next());
                continue;
            }
            command.append(" && ").append(i.next());
        }
        if (this.isDockerizedTerminal()) {
            command.insert(0, "docker exec -u " + this.dockerUsername + " -i " + this.dockerName + " timeout " + SHAFT.Properties.timeouts.dockerCommandTimeout() + " sh -c '");
            command.append("'");
        }
        return command.toString();
    }

    private List<String> executeLocalCommand(List<String> commands, String longCommand) {
        LinkedList<String> internalCommands;
        String directory;
        StringBuilder logs = new StringBuilder();
        StringBuilder exitStatuses = new StringBuilder();
        boolean isWindows = SystemUtils.IS_OS_WINDOWS;
        if (commands.size() > 1 && commands.getFirst().startsWith("cd ")) {
            directory = commands.getFirst().replace("cd ", "");
            internalCommands = new LinkedList<String>(commands);
            internalCommands.removeFirst();
        } else {
            directory = System.getProperty("user.dir");
            internalCommands = new LinkedList<String>(commands);
        }
        FileActions.getInstance(true).createFolder(directory.replace("\"", ""));
        String finalDirectory = directory;
        internalCommands.forEach(command -> {
            command = command.contains(".bat") && !command.contains(".\\") && !command.matches("(^.:\\\\.*$)") ? ".\\" + command : command;
            ReportManager.logDiscrete("Executing: \"" + command + "\" locally.");
            try {
                ProcessBuilder pb = this.getProcessBuilder((String)command, finalDirectory, isWindows);
                pb.environment().put("JAVA_HOME", System.getProperty("java.home"));
                if (!this.asynchronous) {
                    String line;
                    pb.redirectErrorStream(true);
                    Process localProcess = pb.start();
                    InputStreamReader isr = new InputStreamReader(localProcess.getInputStream());
                    BufferedReader rdr = new BufferedReader(isr);
                    while ((line = rdr.readLine()) != null) {
                        if (Boolean.TRUE.equals(this.verbose)) {
                            ReportManager.logDiscrete(line);
                        }
                        logs.append(line);
                        logs.append("\n");
                    }
                    isr = new InputStreamReader(localProcess.getErrorStream());
                    rdr = new BufferedReader(isr);
                    while ((line = rdr.readLine()) != null) {
                        if (Boolean.TRUE.equals(this.verbose)) {
                            ReportManager.logDiscrete(line);
                        }
                        logs.append("\n");
                        logs.append(line);
                    }
                    localProcess.waitFor(SHAFT.Properties.timeouts.shellSessionTimeout(), TimeUnit.MINUTES);
                    exitStatuses.append(localProcess.exitValue());
                } else {
                    exitStatuses.append("asynchronous");
                    ScheduledExecutorService asynchronousProcessExecution = Executors.newScheduledThreadPool(1);
                    asynchronousProcessExecution.schedule(() -> {
                        try {
                            pb.start();
                            asynchronousProcessExecution.shutdown();
                        }
                        catch (Throwable throwable) {
                            asynchronousProcessExecution.shutdownNow();
                        }
                    }, 0L, TimeUnit.SECONDS);
                    if (!asynchronousProcessExecution.awaitTermination(SHAFT.Properties.timeouts.shellSessionTimeout(), TimeUnit.MINUTES)) {
                        asynchronousProcessExecution.shutdownNow();
                    }
                }
            }
            catch (IOException | InterruptedException exception) {
                this.failAction(longCommand, exception);
            }
        });
        return Arrays.asList(logs.toString().trim(), exitStatuses.toString());
    }

    private ProcessBuilder getProcessBuilder(String command, String finalDirectory, boolean isWindows) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(new File(finalDirectory));
        if (isWindows) {
            if (this.asynchronous && this.verbose) {
                pb.command("powershell.exe", "Start-Process powershell.exe '-NoExit -WindowStyle Minimized \"[Console]::Title = ''SHAFT_Engine''; " + command + "\"'");
            } else {
                pb.command("powershell.exe", "-Command", command);
            }
        } else {
            pb.command("sh", "-c", command);
        }
        return pb;
    }

    private List<String> executeRemoteCommand(List<String> commands, String longCommand) {
        StringBuilder logs = new StringBuilder();
        StringBuilder exitStatuses = new StringBuilder();
        int sessionTimeout = Integer.parseInt(String.valueOf(SHAFT.Properties.timeouts.shellSessionTimeout() * 1000L));
        ReportManager.logDiscrete("Attempting to perform the following command remotely. Command: \"" + longCommand + "\"");
        Session remoteSession = this.createSSHsession();
        if (remoteSession != null) {
            try {
                remoteSession.setTimeout(sessionTimeout);
                ChannelExec remoteChannelExecutor = (ChannelExec)remoteSession.openChannel("exec");
                remoteChannelExecutor.setCommand(longCommand);
                remoteChannelExecutor.connect();
                BufferedReader reader = new BufferedReader(new InputStreamReader(remoteChannelExecutor.getInputStream()));
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(remoteChannelExecutor.getErrStream()));
                logs.append(this.readConsoleLogs(reader));
                logs.append(this.readConsoleLogs(errorReader));
                exitStatuses.append(remoteChannelExecutor.getExitStatus());
                remoteSession.disconnect();
            }
            catch (JSchException | IOException exception) {
                this.failAction(longCommand, new Exception[]{exception});
            }
        }
        return Arrays.asList(logs.toString(), exitStatuses.toString());
    }

    private String readConsoleLogs(BufferedReader reader) throws IOException {
        StringBuilder logBuilder = new StringBuilder();
        if (reader != null) {
            String logLine;
            while ((logLine = reader.readLine()) != null) {
                if (logBuilder.isEmpty()) {
                    logBuilder.append(logLine);
                    continue;
                }
                logBuilder.append(System.lineSeparator()).append(logLine);
            }
            reader.close();
        }
        return logBuilder.toString();
    }

    public String getSshHostName() {
        return this.sshHostName;
    }

    public String getSshUsername() {
        return this.sshUsername;
    }

    public String getSshKeyFileFolderName() {
        return this.sshKeyFileFolderName;
    }

    public String getSshKeyFileName() {
        return this.sshKeyFileName;
    }

    public int getSshPortNumber() {
        return this.sshPortNumber;
    }

    public String getDockerName() {
        return this.dockerName;
    }

    public String getDockerUsername() {
        return this.dockerUsername;
    }
}

