/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.cucumber;

import com.shaft.driver.SHAFT;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.When;
import java.util.Objects;

public class BrowserSteps {
    private final ThreadLocal<SHAFT.GUI.WebDriver> driver;

    public BrowserSteps(ThreadLocal<SHAFT.GUI.WebDriver> driver) {
        this.driver = Objects.requireNonNullElseGet(driver, ThreadLocal::new);
    }

    @Given(value="I Open the target browser")
    public void getBrowser() {
        this.driver.set(new SHAFT.GUI.WebDriver());
    }

    @When(value="I Navigate to {string}")
    public void navigateToURL(String targetUrl) {
        this.driver.get().browser().navigateToURL(targetUrl);
    }

    @When(value="I Navigate to {string} and get redirected to {string}")
    public void navigateToURL(String targetUrl, String targetUrlAfterRedirection) {
        this.driver.get().browser().navigateToURL(targetUrl, targetUrlAfterRedirection);
    }

    @When(value="I Navigate back")
    public void navigateBack() {
        this.driver.get().browser().navigateBack();
    }

    @When(value="I Navigate forward")
    public void navigateForward() {
        this.driver.get().browser().navigateForward();
    }

    @When(value="I Maximize the current window")
    public void maximizeWindow() {
        this.driver.get().browser().maximizeWindow();
    }

    @When(value="I Resize the current window size to {int} width * {int} height")
    public void setWindowSize(int width, int height) {
        this.driver.get().browser().setWindowSize(width, height);
    }

    @When(value="I Full Screen the current window")
    public void fullScreenWindow() {
        this.driver.get().browser().fullScreenWindow();
    }

    @When(value="I Refresh the current window")
    public void refreshCurrentPage() {
        this.driver.get().browser().refreshCurrentPage();
    }

    @When(value="I Close the current window")
    public void closeCurrentWindow() {
        this.driver.get().quit();
    }
}

