/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.cucumber;

import com.shaft.driver.SHAFT;
import com.shaft.enums.internal.ClipboardAction;
import io.cucumber.java.en.When;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class ElementSteps {
    private final ThreadLocal<SHAFT.GUI.WebDriver> driver;

    public ElementSteps(ThreadLocal<SHAFT.GUI.WebDriver> driver) {
        this.driver = Objects.requireNonNullElseGet(driver, ThreadLocal::new);
    }

    protected static By getLocatorFromTypeAndValue(String locatorType, String locatorValue) {
        switch (locatorType.toLowerCase()) {
            case "id": {
                return By.id((String)locatorValue);
            }
            case "tagname": 
            case "tag_name": 
            case "tag name": {
                return By.tagName((String)locatorValue);
            }
            case "classname": 
            case "class_name": 
            case "class name": {
                return By.className((String)locatorValue);
            }
            case "name": {
                return By.name((String)locatorValue);
            }
            case "linktext": 
            case "link_text": 
            case "link text": {
                return By.linkText((String)locatorValue);
            }
            case "partiallinktext": 
            case "partial_link_text": 
            case "partial link text": {
                return By.partialLinkText((String)locatorValue);
            }
            case "cssselector": 
            case "css": 
            case "selector": 
            case "css_selector": 
            case "css selector": {
                return By.cssSelector((String)locatorValue);
            }
        }
        return By.xpath((String)locatorValue);
    }

    @When(value="I Type {string} into the element found by {string}: {string}")
    public void type(String text, String locatorType, String locatorValue) {
        this.driver.get().element().type(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue), text);
    }

    @When(value="I Type {string} securely into the element found by {string}: {string}")
    public void typeSecure(String text, String locatorType, String locatorValue) {
        this.driver.get().element().typeSecure(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue), text);
    }

    @When(value="I Append the text {string} to the element found by {string}: {string}")
    public void typeAppend(String text, String locatorType, String locatorValue) {
        this.driver.get().element().typeAppend(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue), text);
    }

    @When(value="I Upload the file {string} to the element found by {string}: {string}")
    public void typeFileLocationForUpload(String absoluteFilePath, String locatorType, String locatorValue) {
        this.driver.get().element().typeFileLocationForUpload(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue), absoluteFilePath);
    }

    @When(value="I Press the {string} key into the element found by {string}: {string}")
    public void keyPress(String key, String locatorType, String locatorValue) {
        this.driver.get().element().keyPress(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue), Keys.valueOf((String)key.toUpperCase()));
    }

    @When(value="I Click the element found by {string}: {string}")
    public void click(String locatorType, String locatorValue) {
        this.driver.get().element().click(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue));
    }

    @When(value="I Click and hold the element found by {string}: {string}")
    public void clickAndHold(String locatorType, String locatorValue) {
        this.driver.get().element().clickAndHold(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue));
    }

    @When(value="I use the clipboard to perform {string} on the element found by {string}: {string}")
    public void clipboardActions(String action, String locatorType, String locatorValue) {
        this.driver.get().element().clipboardActions(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue), ClipboardAction.valueOf(action));
    }

    @When(value="I Double-click the element found by {string}: {string}")
    public void doubleClick(String locatorType, String locatorValue) {
        this.driver.get().element().doubleClick(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue));
    }

    @When(value="I Drag the element found by {string}: {string} and drop it on the element found by {string}: {string}")
    public void dragAndDrop(String sourceLocatorType, String sourceLocatorValue, String destinationLocatorType, String destinationLocatorValue) {
        this.driver.get().element().dragAndDrop(ElementSteps.getLocatorFromTypeAndValue(sourceLocatorType, sourceLocatorValue), ElementSteps.getLocatorFromTypeAndValue(destinationLocatorType, destinationLocatorValue));
    }

    @When(value="I Drag the element found by {string}: {string} and drop it by offset x={int} and y={int}")
    public void dragAndDropByOffset(String locatorType, String locatorValue, int xOffset, int yOffset) {
        this.driver.get().element().dragAndDropByOffset(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue), xOffset, yOffset);
    }

    @When(value="I Hover over the element found by {string}: {string}")
    public void hover(String locatorType, String locatorValue) {
        this.driver.get().element().hover(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue));
    }

    @When(value="I Select {string} from the drop-down list element found by {string}: {string}")
    public void select(String text, String locatorType, String locatorValue) {
        this.driver.get().element().select(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue), text);
    }

    @When(value="I Set the value {string} into the element found by {string}: {string}")
    public void setValueUsingJavaScript(String value, String locatorType, String locatorValue) {
        this.driver.get().element().setValueUsingJavaScript(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue), value);
    }

    @When(value="I Submit the form found by {string}: {string}")
    public void submitFormUsingJavaScript(String locatorType, String locatorValue) {
        this.driver.get().element().submitFormUsingJavaScript(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue));
    }

    @When(value="I Wait for the element found by {string}: {string} to be present")
    public void waitForElementToBePresent(String locatorType, String locatorValue) {
        this.driver.get().element().waitToBeReady(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue));
    }

    @When(value="I Wait for the element found by {string}: {string} to be not present")
    public void waitForElementToBeNotPresent(String locatorType, String locatorValue) {
        this.driver.get().element().waitToBeInvisible(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue));
    }

    @When(value="I Wait for the text inside the element found by {string}: {string} to change from the initial value {string}")
    public void waitForTextToChange(String locatorType, String locatorValue, String initialValue) {
        this.driver.get().element().waitForTextToChange(ElementSteps.getLocatorFromTypeAndValue(locatorType, locatorValue), initialValue);
    }

    protected static enum LocatorType {
        ID("id"),
        TAG_NAME("tagname"),
        CLASS_NAME("classname"),
        NAME("name"),
        LINK_TEXT("linktext"),
        PARTIAL_LINK_TEXT("partiallinktext"),
        CSS_SELECTOR("cssselector"),
        XPATH("xpath");

        private final String value;

        private LocatorType(String type) {
            this.value = type;
        }

        private String getValue() {
            return this.value;
        }
    }
}

