/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.db;

import com.shaft.driver.SHAFT;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetProvider;

public class DatabaseActions {
    private final ThreadLocal<ResultSet> resultSetThreadLocal = new ThreadLocal();
    private final ThreadLocal<Integer> rowCountThreadLocal = new ThreadLocal();
    private DatabaseType dbType;
    private String dbServerIP;
    private String dbPort;
    private String dbName;
    private String username;
    private String password;
    private String customConnectionString = "";

    public DatabaseActions(DatabaseType databaseType, String ip, String port, String name, String username, String password) {
        if (!(ip.isEmpty() || port.isEmpty() || name.isEmpty() || username.isEmpty() || password.isEmpty())) {
            this.dbType = databaseType;
            this.dbServerIP = ip;
            this.dbPort = port;
            this.dbName = name;
            this.username = username;
            this.password = password;
        } else {
            DatabaseActions.failAction("Database Type: \"" + String.valueOf((Object)databaseType) + "\", IP: \"" + ip + "\", Port: \"" + port + "\", Name: \"" + name + "\", Username: \"" + username + "\", Password: \"" + password + "\"", new Exception[0]);
        }
    }

    public DatabaseActions(String customConnectionString) {
        if (!"".equals(customConnectionString)) {
            this.customConnectionString = customConnectionString;
        } else {
            DatabaseActions.failAction("Custom Connection String: \"" + customConnectionString + "\"", new Exception[0]);
        }
    }

    public static DatabaseActions getInstance(DatabaseType databaseType, String ip, String port, String name, String username, String password) {
        return new DatabaseActions(databaseType, ip, port, name, username, password);
    }

    public static DatabaseActions getInstance(String customConnectionString) {
        return new DatabaseActions(customConnectionString);
    }

    public static String getResult(ResultSet resultSet) {
        String resultSetString = DatabaseActions.getResultStringValue(resultSet, false);
        DatabaseActions.passAction();
        return resultSetString;
    }

    private static void failAction(String actionName, String testData, Exception ... rootCauseException) {
        String message = DatabaseActions.reportActionResult(actionName, testData, null, false, rootCauseException);
        FailureReporter.fail(DatabaseActions.class, message, rootCauseException[0]);
    }

    public static String getRow(ResultSet resultSet, String columnName, String knownCellValue) {
        String reportMessage = "Column Name: \"" + columnName + "\" | Cell Content: \"" + knownCellValue + "\"";
        StringBuilder str = new StringBuilder();
        boolean foundRow = false;
        try {
            resultSet.beforeFirst();
            if (resultSet.last()) {
                int columnsCount = resultSet.getMetaData().getColumnCount();
                int lastRowID = resultSet.getRow();
                int targetColumnID = resultSet.findColumn(columnName);
                for (int i = 1; i <= lastRowID; ++i) {
                    resultSet.absolute(i);
                    if (!String.valueOf(resultSet.getString(targetColumnID)).trim().equals(knownCellValue.trim())) continue;
                    for (int j = 1; j <= columnsCount; ++j) {
                        str.append(resultSet.getString(j)).append("\t");
                    }
                    str.append("\n");
                    foundRow = true;
                }
            }
        }
        catch (NullPointerException | SQLException rootCauseException) {
            DatabaseActions.failAction(reportMessage, rootCauseException);
        }
        if (Boolean.TRUE.equals(foundRow)) {
            DatabaseActions.passAction(reportMessage);
        } else {
            DatabaseActions.failAction(reportMessage, new Exception[0]);
        }
        return str.toString().trim();
    }

    public static String getColumn(ResultSet resultSet, String columnName) {
        StringBuilder str = new StringBuilder();
        try {
            resultSet.beforeFirst();
            if (resultSet.last()) {
                int lastRowID = resultSet.getRow();
                int targetColumnID = resultSet.findColumn(columnName);
                for (int i = 1; i <= lastRowID; ++i) {
                    resultSet.absolute(i);
                    str.append(resultSet.getString(targetColumnID)).append("\n");
                }
            }
        }
        catch (NullPointerException | SQLException rootCauseException) {
            DatabaseActions.failAction(rootCauseException);
        }
        DatabaseActions.passAction(columnName);
        return str.toString().trim();
    }

    public static int getRowCount(ResultSet resultSet) {
        int rowCount = 0;
        try {
            resultSet.beforeFirst();
            if (resultSet.last()) {
                rowCount = resultSet.getRow();
                resultSet.beforeFirst();
            }
        }
        catch (SQLException rootCauseException) {
            DatabaseActions.failAction(rootCauseException);
        }
        DatabaseActions.passAction();
        return rowCount;
    }

    private static void passAction(String actionName, String testData, String queryResult) {
        DatabaseActions.reportActionResult(actionName, testData, queryResult, true, new Exception[0]);
    }

    private static void passAction(String testData, String queryResult) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        DatabaseActions.passAction(actionName, testData, queryResult);
    }

    private static void passAction(String testData) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        DatabaseActions.passAction(actionName, testData, null);
    }

    private static void passAction() {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        DatabaseActions.passAction(actionName, null, null);
    }

    private static void failAction(String testData, Exception ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        DatabaseActions.failAction(actionName, testData, rootCauseException);
    }

    private static void failAction(Exception ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        DatabaseActions.failAction(actionName, null, rootCauseException);
    }

    private static String reportActionResult(String actionName, String testData, String queryResult, Boolean passFailStatus, Exception ... rootCauseException) {
        List<Object> actualValueAttachment;
        actionName = ((String)actionName).substring(0, 1).toUpperCase() + ((String)actionName).substring(1);
        String message = Boolean.TRUE.equals(passFailStatus) ? "Database Action \"" + (String)actionName + "\" successfully performed." : "Database Action \"" + (String)actionName + "\" failed.";
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        if (testData != null && testData.length() >= 500) {
            actualValueAttachment = Arrays.asList("Database Action Test Data - " + (String)actionName, "Actual Value", testData);
            attachments.add(actualValueAttachment);
        } else if (testData != null && !testData.isEmpty()) {
            message = message + " With the following test data \"" + testData + "\".";
        }
        if (queryResult != null && !queryResult.trim().isEmpty()) {
            attachments.add(Arrays.asList("Database Action Actual Result", "Query Result", queryResult));
        }
        if (rootCauseException != null && rootCauseException.length >= 1) {
            actualValueAttachment = Arrays.asList("Database Action Exception - " + (String)actionName, "Stacktrace", ReportManagerHelper.formatStackTraceToLogEntry(rootCauseException[0]));
            attachments.add(actualValueAttachment);
        }
        if (!attachments.equals(new ArrayList())) {
            ReportManagerHelper.log(message, attachments);
        } else {
            ReportManager.log(message);
        }
        return message;
    }

    private static StringBuilder readColumnHeaders(ResultSet resultSet, boolean readColumnNames, int columnsCount) throws SQLException {
        StringBuilder str = new StringBuilder();
        if (readColumnNames) {
            for (int i = 1; i <= columnsCount; ++i) {
                str.append(resultSet.getMetaData().getColumnName(i));
                if (i == columnsCount) continue;
                str.append("\t");
            }
            str.append("\n");
        }
        return str;
    }

    private static StringBuilder readColumnData(ResultSet resultSet, int columnsCount, int lastRowID) throws SQLException {
        StringBuilder str = new StringBuilder();
        for (int i = 1; i <= lastRowID; ++i) {
            resultSet.absolute(i);
            for (int j = 1; j <= columnsCount; ++j) {
                str.append(resultSet.getString(j));
                if (j == columnsCount) continue;
                str.append("\t");
            }
            str.append("\n");
        }
        return str;
    }

    private static String getResultStringValue(ResultSet resultSet, boolean readColumnNames) {
        StringBuilder str = new StringBuilder();
        try {
            resultSet.beforeFirst();
            if (resultSet.last()) {
                int columnsCount = resultSet.getMetaData().getColumnCount();
                int lastRowID = resultSet.getRow();
                str.append((CharSequence)DatabaseActions.readColumnHeaders(resultSet, readColumnNames, columnsCount));
                str.append((CharSequence)DatabaseActions.readColumnData(resultSet, columnsCount, lastRowID));
            }
        }
        catch (NullPointerException | SQLException rootCauseException) {
            DatabaseActions.failAction(rootCauseException);
        }
        return str.toString().trim();
    }

    public String getResult() {
        return DatabaseActions.getResult(this.resultSetThreadLocal.get());
    }

    public String getRow(String columnName, String knownCellValue) {
        return DatabaseActions.getRow(this.resultSetThreadLocal.get(), columnName, knownCellValue);
    }

    public String getColumn(String columnName) {
        return DatabaseActions.getColumn(this.resultSetThreadLocal.get(), columnName);
    }

    public int getRowCount() {
        return this.rowCountThreadLocal.get();
    }

    private void setRowCountForSelectStatement(ResultSet resultSet) {
        int rowCount = 0;
        try {
            resultSet.beforeFirst();
            if (resultSet.last()) {
                rowCount = resultSet.getRow();
                resultSet.beforeFirst();
            }
        }
        catch (SQLException rootCauseException) {
            DatabaseActions.failAction(rootCauseException);
        }
        this.rowCountThreadLocal.set(rowCount);
    }

    public ResultSet executeSelectQuery(String sql) {
        ResultSet resultSet = null;
        try (Connection connection = this.createConnection();){
            resultSet = this.createStatement(connection).executeQuery(sql);
            if (resultSet != null) {
                CachedRowSet crs = RowSetProvider.newFactory().createCachedRowSet();
                crs.populate(resultSet);
                this.resultSetThreadLocal.set(crs);
                this.setRowCountForSelectStatement(crs);
                DatabaseActions.passAction(this.getReportMessage("SELECT", sql), DatabaseActions.getResultStringValue(crs, true));
            } else {
                DatabaseActions.failAction("Null or no resultSet was returned from executing this query \"" + sql + "\"", new Exception[0]);
            }
        }
        catch (NullPointerException | SQLException rootCauseException) {
            DatabaseActions.failAction(this.getReportMessage("SELECT", sql), rootCauseException);
        }
        return resultSet;
    }

    private int executeDataManipulationQueries(String sql, String queryType) {
        int affectedRows = 0;
        try (Connection connection = this.createConnection();){
            affectedRows = this.createStatement(connection).executeUpdate(sql);
            DatabaseActions.passAction(sql);
        }
        catch (NullPointerException | SQLException rootCauseException) {
            DatabaseActions.failAction(this.getReportMessage(queryType, sql), rootCauseException);
        }
        this.rowCountThreadLocal.set(affectedRows);
        return affectedRows;
    }

    public int executeUpdateQuery(String sql) {
        return this.executeDataManipulationQueries(sql, "UPDATE");
    }

    public void executeDDLStatement(String sql) {
        this.executeDataManipulationQueries(sql, "DDL");
    }

    public int executeInsertQuery(String sql) {
        return this.executeDataManipulationQueries(sql, "INSERT");
    }

    public int executeDeleteQuery(String sql) {
        return this.executeDataManipulationQueries(sql, "DELETE");
    }

    private Connection createConnection() {
        Connection connection = null;
        Object connectionString = "";
        if (!this.customConnectionString.isEmpty()) {
            connectionString = this.customConnectionString;
        } else {
            switch (this.dbType.ordinal()) {
                case 0: {
                    connectionString = "jdbc:mysql://" + this.dbServerIP + ":" + this.dbPort + "/" + this.dbName;
                    break;
                }
                case 1: {
                    connectionString = "jdbc:sqlserver://" + this.dbServerIP + ":" + this.dbPort + ";databaseName=" + this.dbName;
                    break;
                }
                case 2: {
                    connectionString = "jdbc:postgresql://" + this.dbServerIP + ":" + this.dbPort + "/" + this.dbName;
                    break;
                }
                case 3: {
                    connectionString = "jdbc:oracle:thin:@" + this.dbServerIP + ":" + this.dbPort + ":" + this.dbName;
                    break;
                }
                case 4: {
                    connectionString = "jdbc:oracle:thin:@" + this.dbServerIP + ":" + this.dbPort + "/" + this.dbName;
                    break;
                }
                case 5: {
                    connectionString = "jdbc:db2://" + this.dbServerIP + ":" + this.dbPort + "/" + this.dbName;
                    break;
                }
                default: {
                    ReportManager.log("Database not supported");
                    DatabaseActions.failAction(this.dbType.toString(), new Exception[0]);
                }
            }
        }
        try {
            DriverManager.setLoginTimeout(SHAFT.Properties.timeouts.databaseLoginTimeout());
            connection = DriverManager.getConnection((String)connectionString, this.username, this.password);
            if (!this.dbType.toString().equals("MY_SQL") && !this.dbType.toString().equals("POSTGRES_SQL")) {
                connection.setNetworkTimeout(Executors.newFixedThreadPool(1), SHAFT.Properties.timeouts.databaseNetworkTimeout() * 60000);
            }
        }
        catch (SQLException rootCauseException) {
            DatabaseActions.failAction((String)connectionString, rootCauseException);
        }
        if (connection != null) {
            ReportManager.logDiscrete("Connection created successfully");
        } else {
            DatabaseActions.failAction("Failed to create a connection with this string \"" + (String)connectionString + "\" due to an unhandled exception.", new Exception[0]);
        }
        return connection;
    }

    private Statement createStatement(Connection connection) {
        Statement statement = null;
        try {
            statement = connection.createStatement(1004, 1007);
            statement.setQueryTimeout(SHAFT.Properties.timeouts.databaseQueryTimeout());
        }
        catch (SQLFeatureNotSupportedException rootCauseException) {
            if (!rootCauseException.getMessage().contains("org.postgresql.jdbc4.Jdbc4Statement.setQueryTimeout")) {
                DatabaseActions.failAction(connection.toString(), rootCauseException);
            }
        }
        catch (SQLException rootCauseException) {
            DatabaseActions.failAction(connection.toString(), rootCauseException);
        }
        if (statement != null) {
            ReportManager.logDiscrete("Statement created successfully");
        } else {
            DatabaseActions.failAction("Failed to create a statement with this string \"" + String.valueOf(connection) + "\" due to an unhandled exception.", new Exception[0]);
        }
        return statement;
    }

    private String getReportMessage(String queryType, String query) {
        return "Database Type: \"" + String.valueOf((Object)this.dbType) + "\"| Server: \"" + this.dbServerIP + ":" + this.dbPort + "\"| Name: \"" + this.dbName + "\"| Username: \"" + this.username + "\"| Password: \"" + this.password.replaceAll(".", "*") + "\"| Query Type: \"" + queryType + "\"| Query: \"" + query + "\"";
    }

    public static enum DatabaseType {
        MY_SQL,
        SQL_SERVER,
        POSTGRES_SQL,
        ORACLE,
        ORACLE_SERVICE_NAME,
        IBM_DB2;

    }
}

