/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.driver;

import com.shaft.api.RestActions;
import com.shaft.cli.TerminalActions;
import com.shaft.db.DatabaseActions;
import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.BrowserStackHelper;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.driver.internal.DriverFactory.LambdaTestHelper;
import com.shaft.listeners.TestNGListener;
import com.shaft.listeners.internal.TestNGListenerHelper;
import com.shaft.tools.io.internal.ProjectStructureManager;
import java.util.Map;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Browser;

public class DriverFactory {
    private DriverFactoryHelper helper;

    private static void readLastMinuteUpdatedProperties() {
        DriverFactory.reloadProperties();
        if (TestNGListener.getXmlTest() != null) {
            System.getProperties().putAll((Map<?, ?>)TestNGListener.getXmlTest().getAllParameters());
            String testName = TestNGListenerHelper.getTestName().toLowerCase();
            if (testName.contains("firefox") || testName.contains("chrome") || testName.contains("safari")) {
                SHAFT.Properties.platform.set().targetPlatform(Platform.LINUX.name());
            }
        }
    }

    public static void reloadProperties() {
        if (SHAFT.Properties.platform == null) {
            System.out.println("Execution Listeners are not loaded properly... Self-Healing... Initializing minimalistic test run...");
            ProjectStructureManager.RunType runType = TestNGListener.identifyRunType();
            if (runType.equals((Object)ProjectStructureManager.RunType.CUCUMBER)) {
                System.out.println("To unlock the full capabilities of SHAFT kindly follow these steps to configure SHAFT's Cucumber plugin:");
                System.out.println("https://github.com/ShaftHQ/SHAFT_ENGINE#stop-reinventing-the-wheel-start-using-shaft");
            }
            TestNGListener.engineSetup(runType);
        }
    }

    public static RestActions getAPIDriver(String serviceURI) {
        return new RestActions(serviceURI);
    }

    public static TerminalActions getTerminalDriver() {
        return new TerminalActions();
    }

    public static DatabaseActions getDatabaseDriver(DatabaseActions.DatabaseType databaseType, String ip, String port, String name, String username, String password) {
        return new DatabaseActions(databaseType, ip, port, name, username, password);
    }

    public DriverFactoryHelper getHelper() {
        if (this.helper == null) {
            DriverFactory.readLastMinuteUpdatedProperties();
            if (SHAFT.Properties.platform.executionAddress().toLowerCase().contains("browserstack")) {
                return this.getHelper(DriverType.BROWSERSTACK, new MutableCapabilities());
            }
            if (SHAFT.Properties.platform.executionAddress().toLowerCase().contains("lambdatest")) {
                return this.getHelper(DriverType.LAMBDATEST, new MutableCapabilities());
            }
            DriverFactoryHelper helper = new DriverFactoryHelper();
            helper.initializeDriver();
            this.helper = helper;
        }
        return this.helper;
    }

    public WebDriver getDriver() {
        return this.getHelper().getDriver();
    }

    public DriverFactoryHelper getHelper(DriverType driverType) {
        return this.getHelper(driverType, new MutableCapabilities());
    }

    public DriverFactoryHelper getHelper(DriverType driverType, MutableCapabilities customDriverOptions) {
        DriverFactory.readLastMinuteUpdatedProperties();
        if (driverType.equals((Object)DriverType.BROWSERSTACK)) {
            return BrowserStackHelper.getBrowserStackDriver(customDriverOptions);
        }
        if (driverType.equals((Object)DriverType.LAMBDATEST)) {
            return LambdaTestHelper.getLambdaTestDriver(customDriverOptions);
        }
        DriverFactoryHelper helper = new DriverFactoryHelper();
        helper.initializeDriver(driverType, customDriverOptions);
        return helper;
    }

    public void setHelper(DriverFactoryHelper helper) {
        this.helper = helper;
    }

    public static enum DriverType {
        SIKULI("SikuliActions"),
        BROWSERSTACK("BrowserStack"),
        LAMBDATEST("LambdaTest"),
        DATABASE("DatabaseActions"),
        TERMINAL("TerminalActions"),
        API("RestActions"),
        FIREFOX(Browser.FIREFOX.browserName()),
        CHROME(Browser.CHROME.browserName()),
        SAFARI(Browser.SAFARI.browserName()),
        IE(Browser.IE.browserName()),
        EDGE(Browser.EDGE.browserName()),
        CHROMIUM("Chromium"),
        WEBKIT("Webkit"),
        APPIUM_CHROME("chrome"),
        APPIUM_CHROMIUM("Chromium"),
        APPIUM_BROWSER("Browser"),
        APPIUM_SAMSUNG_BROWSER("samsung"),
        APPIUM_MOBILE_NATIVE("NativeMobileApp");

        private final String value;

        private DriverType(String type) {
            this.value = type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

