/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.driver;

import com.shaft.api.RequestBuilder;
import com.shaft.api.RestActions;
import com.shaft.cli.FileActions;
import com.shaft.cli.TerminalActions;
import com.shaft.db.DatabaseActions;
import com.shaft.driver.DriverFactory;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.driver.internal.WizardHelpers;
import com.shaft.gui.browser.BrowserActions;
import com.shaft.gui.element.AlertActions;
import com.shaft.gui.element.AsyncElementActions;
import com.shaft.gui.element.ElementActions;
import com.shaft.gui.element.TouchActions;
import com.shaft.gui.internal.locator.Locator;
import com.shaft.gui.waits.WaitActions;
import com.shaft.listeners.internal.WebDriverListener;
import com.shaft.tools.io.ExcelFileManager;
import com.shaft.tools.io.JSONFileManager;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.YAMLFileManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import com.shaft.validation.internal.RestValidationsBuilder;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.restassured.response.Response;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.List;
import java.util.function.Function;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.EventFiringDecorator;

public class SHAFT {

    public static class Report {
        private Report() {
            throw new IllegalStateException("Utility class");
        }

        public static void log(String message) {
            ReportManager.logDiscrete(message);
        }

        public static void report(String message) {
            ReportManager.log(message);
        }

        public static void attach(String attachmentType, String attachmentName, String attachmentContent) {
            ReportManagerHelper.attach(attachmentType, attachmentName, attachmentContent);
        }

        public static void attach(String attachmentType, String attachmentName, InputStream attachmentContent) {
            ReportManagerHelper.attach(attachmentType, attachmentName, attachmentContent);
        }
    }

    public static class Properties
    extends com.shaft.properties.internal.Properties {
    }

    public static class TestData {

        public static class YAML
        extends YAMLFileManager {
            public YAML(String yamlFilePath) {
                super(yamlFilePath);
            }

            public static YAMLFileManager getInstance(String yamlFilePath) {
                return new YAMLFileManager(yamlFilePath);
            }
        }

        public static class EXCEL
        extends ExcelFileManager {
            public EXCEL(String excelFilePath) {
                super(excelFilePath);
            }

            public static ExcelFileManager getInstance(String excelFilePath) {
                return new ExcelFileManager(excelFilePath);
            }
        }

        public static class JSON
        extends JSONFileManager {
            public JSON(String jsonFilePath) {
                super(jsonFilePath);
            }

            public static JSONFileManager getInstance(String jsonFilePath) {
                return new JSONFileManager(jsonFilePath);
            }
        }
    }

    public static class Validations {
        private Validations() {
            throw new IllegalStateException("Utility class");
        }

        public static WizardHelpers.StandaloneAssertions assertThat() {
            return new WizardHelpers.StandaloneAssertions();
        }

        public static WizardHelpers.StandaloneVerifications verifyThat() {
            return new WizardHelpers.StandaloneVerifications();
        }
    }

    public static class DB
    extends DatabaseActions {
        public DB(String customConnectionString) {
            super(customConnectionString);
        }

        public DB(DatabaseActions.DatabaseType databaseType, String ip, String port, String name, String username, String password) {
            super(databaseType, ip, port, name, username, password);
        }

        public static DB getInstance(DatabaseActions.DatabaseType databaseType, String ip, String port, String name, String username, String password) {
            return new DB(databaseType, ip, port, name, username, password);
        }

        public static DB getInstance(String customConnectionString) {
            return new DB(customConnectionString);
        }

        public static String getResult(ResultSet resultSet) {
            return DatabaseActions.getResult(resultSet);
        }

        public static String getColumn(ResultSet resultSet, String columnName) {
            return DatabaseActions.getColumn(resultSet, columnName);
        }

        public static String getRow(ResultSet resultSet, String columnName, String knownCellValue) {
            return DatabaseActions.getRow(resultSet, columnName, knownCellValue);
        }

        public static int getRowCount(ResultSet resultSet) {
            return DatabaseActions.getRowCount(resultSet);
        }
    }

    public static class CLI {
        private CLI() {
            throw new IllegalStateException("Utility class");
        }

        public static TerminalActions terminal() {
            return new TerminalActions();
        }

        public static FileActions file() {
            return new FileActions();
        }
    }

    public static class API {
        private final RestActions session;
        private String serviceURI;

        public API(String serviceURI) {
            this.session = new RestActions(serviceURI);
        }

        public static API getInstance(String serviceURI) {
            return new API(serviceURI);
        }

        public RequestBuilder get(String serviceName) {
            return this.session.buildNewRequest(serviceName, RestActions.RequestType.GET);
        }

        public RequestBuilder post(String serviceName) {
            return this.session.buildNewRequest(serviceName, RestActions.RequestType.POST);
        }

        public RequestBuilder patch(String serviceName) {
            return this.session.buildNewRequest(serviceName, RestActions.RequestType.PATCH);
        }

        public RequestBuilder delete(String serviceName) {
            return this.session.buildNewRequest(serviceName, RestActions.RequestType.DELETE);
        }

        public RequestBuilder put(String serviceName) {
            return this.session.buildNewRequest(serviceName, RestActions.RequestType.PUT);
        }

        public void addHeader(String key, String value) {
            this.session.addHeaderVariable(key, value);
        }

        public void addCookie(String key, String value) {
            this.session.addCookieVariable(key, value);
        }

        public RestValidationsBuilder assertThatResponse() {
            return com.shaft.validation.Validations.assertThat().response(RestActions.getLastResponse());
        }

        public RestValidationsBuilder verifyThatResponse() {
            return com.shaft.validation.Validations.verifyThat().response(RestActions.getLastResponse());
        }

        public Response getResponse() {
            return RestActions.getLastResponse();
        }

        public String getResponseBody() {
            return RestActions.getResponseBody(RestActions.getLastResponse());
        }

        public int getResponseStatusCode() {
            return RestActions.getResponseStatusCode(RestActions.getLastResponse());
        }

        public long getResponseTime() {
            return RestActions.getResponseTime(RestActions.getLastResponse());
        }

        public String getResponseJSONValue(String jsonPath) {
            return RestActions.getResponseJSONValue(RestActions.getLastResponse(), jsonPath);
        }

        public List<Object> getResponseJSONValueAsList(String jsonPath) {
            return RestActions.getResponseJSONValueAsList(RestActions.getLastResponse(), jsonPath);
        }

        public String getResponseXMLValue(String xmlPath) {
            return RestActions.getResponseXMLValue(RestActions.getLastResponse(), xmlPath);
        }

        public List<Object> getResponseXMLValueAsList(String xmlPath) {
            return RestActions.getResponseXMLValueAsList(RestActions.getLastResponse(), xmlPath);
        }
    }

    public static class GUI {

        public static class Locator
        extends com.shaft.gui.internal.locator.Locator {
        }

        public static class WebDriver {
            DriverFactoryHelper helper;
            DriverFactory factory = new DriverFactory();

            public WebDriver() {
                this.helper = this.factory.getHelper();
            }

            public WebDriver(DriverFactory.DriverType driverType) {
                this.helper = this.factory.getHelper(driverType);
            }

            public WebDriver(DriverFactory.DriverType driverType, MutableCapabilities mutableCapabilities) {
                this.helper = this.factory.getHelper(driverType, mutableCapabilities);
            }

            public void quit() {
                this.helper.closeDriver();
                this.factory.setHelper(null);
                this.helper = null;
                this.factory = null;
            }

            public ElementActions element() {
                return new ElementActions(this.helper);
            }

            public TouchActions touch() {
                return new TouchActions(this.helper);
            }

            public BrowserActions browser() {
                return new BrowserActions(this.helper);
            }

            public AlertActions alert() {
                return new AlertActions(this.helper);
            }

            public WaitActions waitUntil(Function<? super org.openqa.selenium.WebDriver, ?> conditions) {
                return new WaitActions(this.helper).waitUntil(conditions);
            }

            public WizardHelpers.WebDriverAssertions assertThat() {
                return new WizardHelpers.WebDriverAssertions(this.helper);
            }

            public WizardHelpers.WebDriverVerifications verifyThat() {
                return new WizardHelpers.WebDriverVerifications(this.helper);
            }

            public org.openqa.selenium.WebDriver getDriver() {
                org.openqa.selenium.WebDriver webDriver = this.helper.getDriver();
                if (webDriver instanceof AndroidDriver) {
                    AndroidDriver androidDriver = (AndroidDriver)webDriver;
                    return this.helper.getDriver();
                }
                webDriver = this.helper.getDriver();
                if (webDriver instanceof IOSDriver) {
                    IOSDriver iosDriver = (IOSDriver)webDriver;
                    return this.helper.getDriver();
                }
                if (!Properties.flags.enableTrueNativeMode()) {
                    return new EventFiringDecorator(org.openqa.selenium.WebDriver.class, new org.openqa.selenium.support.events.WebDriverListener[]{new WebDriverListener()}).decorate(this.helper.getDriver());
                }
                return this.helper.getDriver();
            }

            public Async async() {
                return new Async();
            }

            public class Async {
                public AsyncElementActions element() {
                    return new AsyncElementActions(WebDriver.this.helper);
                }
            }
        }
    }
}

