/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.driver.internal.DriverFactory;

import com.shaft.api.RequestBuilder;
import com.shaft.api.RestActions;
import com.shaft.cli.FileActions;
import com.shaft.driver.DriverFactory;
import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;

public class BrowserStackHelper {
    private static final String hubUrl = "hub-cloud.browserstack.com";
    private static final String serviceUri = "https://api-cloud.browserstack.com/";
    private static final String appUploadServiceName = "app-automate/upload";

    public static DriverFactoryHelper getBrowserStackDriver(MutableCapabilities browserStackOptions) {
        String appUrl = SHAFT.Properties.browserStack.appUrl();
        DriverFactoryHelper helper = new DriverFactoryHelper();
        if ("".equals(appUrl)) {
            if ("".equals(SHAFT.Properties.browserStack.appRelativeFilePath())) {
                browserStackOptions = DriverFactoryHelper.isMobileWebExecution() ? BrowserStackHelper.setupMobileWebExecution().merge((Capabilities)browserStackOptions) : BrowserStackHelper.setupDesktopWebExecution().merge((Capabilities)browserStackOptions);
                helper.initializeDriver(browserStackOptions);
            } else {
                browserStackOptions = BrowserStackHelper.setupNativeAppExecution(SHAFT.Properties.browserStack.username(), SHAFT.Properties.browserStack.accessKey(), SHAFT.Properties.browserStack.deviceName(), SHAFT.Properties.browserStack.platformVersion(), SHAFT.Properties.browserStack.appRelativeFilePath(), SHAFT.Properties.browserStack.appName()).merge((Capabilities)browserStackOptions);
                helper.initializeDriver(DriverFactory.DriverType.APPIUM_MOBILE_NATIVE, browserStackOptions);
            }
        } else {
            browserStackOptions = BrowserStackHelper.setupNativeAppExecution(SHAFT.Properties.browserStack.username(), SHAFT.Properties.browserStack.accessKey(), SHAFT.Properties.browserStack.deviceName(), SHAFT.Properties.browserStack.platformVersion(), appUrl).merge((Capabilities)browserStackOptions);
            helper.initializeDriver(DriverFactory.DriverType.APPIUM_MOBILE_NATIVE, browserStackOptions);
        }
        return helper;
    }

    private static MutableCapabilities setupNativeAppExecution(String username, String password, String deviceName, String osVersion, String relativePathToAppFile, String appName) {
        SHAFT.Properties.timeouts.set().apiSocketTimeout(600);
        ReportManager.logDiscrete("Setting up BrowserStack configuration for new native app version...");
        String testData = "Username: " + username + ", Password: " + "\u2022".repeat(password.length()) + ", Device Name: " + deviceName + ", OS Version: " + osVersion + ", Relative Path to App File: " + relativePathToAppFile + ", App Name: " + appName;
        ArrayList<Object> apkFile = new ArrayList<Object>();
        apkFile.add("file");
        String appPath = FileActions.getInstance(true).getAbsolutePath(relativePathToAppFile);
        apkFile.add(new File(appPath));
        ReportManager.logDiscrete("BrowserStack appPath: " + appPath);
        ArrayList<String> customID = new ArrayList<String>();
        customID.add("custom_id");
        String userProvidedCustomID = SHAFT.Properties.browserStack.customID();
        String custom_id = "".equals(userProvidedCustomID) ? "SHAFT_Engine_" + appName.replaceAll(" ", "_") : userProvidedCustomID;
        customID.add(custom_id);
        ReportManager.logDiscrete("BrowserStack custom_id: " + custom_id);
        ArrayList<List<Object>> parameters = new ArrayList<List<Object>>();
        parameters.add(apkFile);
        parameters.add(customID);
        String appUrl = "";
        try {
            appUrl = Objects.requireNonNull(RestActions.getResponseJSONValue(new RestActions(serviceUri).buildNewRequest(appUploadServiceName, RestActions.RequestType.POST).setParameters(parameters, RestActions.ParametersType.FORM).setAuthentication(username, password, RequestBuilder.AuthenticationType.BASIC).performRequest(), "app_url"));
            ReportManager.logDiscrete("BrowserStack app_url: " + appUrl);
        }
        catch (NullPointerException exception) {
            BrowserStackHelper.failAction(testData, exception);
        }
        MutableCapabilities browserStackCapabilities = BrowserStackHelper.setBrowserStackProperties(username, password, deviceName, osVersion, appUrl);
        testData = testData + ", App URL: " + appUrl;
        BrowserStackHelper.passAction(testData);
        return browserStackCapabilities;
    }

    private static MutableCapabilities setupNativeAppExecution(String username, String password, String deviceName, String osVersion, String appUrl) {
        ReportManager.logDiscrete("Setting up BrowserStack configuration for existing native app version...");
        String testData = "Username: " + username + ", Password: " + password + ", Device Name: " + deviceName + ", OS Version: " + osVersion + ", App URL: " + appUrl;
        MutableCapabilities browserStackCapabilities = BrowserStackHelper.setBrowserStackProperties(username, password, deviceName, osVersion, appUrl);
        BrowserStackHelper.passAction(testData);
        return browserStackCapabilities;
    }

    private static MutableCapabilities setupMobileWebExecution() {
        ReportManager.logDiscrete("Setting up BrowserStack configuration for mobile web execution...");
        String username = SHAFT.Properties.browserStack.username();
        String password = SHAFT.Properties.browserStack.accessKey();
        String os = SHAFT.Properties.platform.targetPlatform();
        String osVersion = SHAFT.Properties.browserStack.osVersion();
        String testData = "Username: " + username + ", Password: " + password + ", Operating System: " + os + ", Operating System Version: " + osVersion;
        SHAFT.Properties.platform.set().executionAddress(username + ":" + password + "@hub-cloud.browserstack.com");
        MutableCapabilities browserStackCapabilities = new MutableCapabilities();
        HashMap<String, Object> browserstackOptions = new HashMap<String, Object>();
        browserstackOptions.put("osVersion", osVersion);
        browserstackOptions.put("local", SHAFT.Properties.browserStack.local());
        browserstackOptions.put("appiumVersion", SHAFT.Properties.browserStack.appiumVersion());
        browserstackOptions.put("deviceName", SHAFT.Properties.browserStack.deviceName());
        String[] pathItems = System.getProperty("user.dir").split(Pattern.quote(File.separator));
        LocalDateTime time = LocalDateTime.now();
        browserstackOptions.put("projectName", ReportManagerHelper.getTestClassName());
        browserstackOptions.put("buildName", pathItems[pathItems.length - 1] + "_" + time.getYear() + time.getMonthValue() + time.getDayOfMonth());
        browserStackCapabilities.setCapability("bstack:options", browserstackOptions);
        BrowserStackHelper.passAction(testData);
        return browserStackCapabilities;
    }

    private static MutableCapabilities setupDesktopWebExecution() {
        ReportManager.logDiscrete("Setting up BrowserStack configuration for desktop web execution...");
        String username = SHAFT.Properties.browserStack.username();
        String password = SHAFT.Properties.browserStack.accessKey();
        String os = SHAFT.Properties.platform.targetPlatform();
        String osVersion = SHAFT.Properties.browserStack.osVersion();
        String testData = "Username: " + username + ", Password: " + password + ", Operating System: " + os + ", Operating System Version: " + osVersion;
        SHAFT.Properties.platform.set().executionAddress(username + ":" + password + "@hub-cloud.browserstack.com");
        SHAFT.Properties.mobile.set().browserName(SHAFT.Properties.web.targetBrowserName());
        MutableCapabilities browserStackCapabilities = new MutableCapabilities();
        String browserVersion = SHAFT.Properties.browserStack.browserVersion();
        if (browserVersion != null && !browserVersion.trim().isEmpty()) {
            browserStackCapabilities.setCapability("browserVersion", SHAFT.Properties.browserStack.browserVersion());
        }
        HashMap<String, Object> browserstackOptions = new HashMap<String, Object>();
        if (os.toLowerCase().contains("mac")) {
            browserstackOptions.put("os", "OS X");
        } else if (os.toLowerCase().contains("windows")) {
            browserstackOptions.put("os", "Windows");
        }
        browserstackOptions.put("osVersion", osVersion);
        browserstackOptions.put("local", SHAFT.Properties.browserStack.local());
        browserstackOptions.put("seleniumVersion", SHAFT.Properties.browserStack.seleniumVersion());
        String geoLocation = SHAFT.Properties.browserStack.geoLocation();
        if (geoLocation != null && !geoLocation.isEmpty()) {
            browserstackOptions.put("geoLocation", SHAFT.Properties.browserStack.geoLocation());
        }
        String[] pathItems = System.getProperty("user.dir").split(Pattern.quote(File.separator));
        LocalDateTime time = LocalDateTime.now();
        browserstackOptions.put("projectName", ReportManagerHelper.getTestClassName());
        browserstackOptions.put("buildName", pathItems[pathItems.length - 1] + "_" + time.getYear() + time.getMonthValue() + time.getDayOfMonth());
        browserStackCapabilities.setCapability("bstack:options", browserstackOptions);
        BrowserStackHelper.passAction(testData);
        return browserStackCapabilities;
    }

    private static MutableCapabilities setBrowserStackProperties(String username, String password, String deviceName, String osVersion, String appUrl) {
        SHAFT.Properties.platform.set().executionAddress(username + ":" + password + "@hub-cloud.browserstack.com");
        SHAFT.Properties.mobile.set().deviceName(deviceName);
        SHAFT.Properties.mobile.set().platformVersion(osVersion);
        SHAFT.Properties.mobile.set().app(appUrl);
        MutableCapabilities browserStackCapabilities = new MutableCapabilities();
        HashMap<String, Object> browserstackOptions = new HashMap<String, Object>();
        browserstackOptions.put("appiumVersion", SHAFT.Properties.browserStack.appiumVersion());
        browserstackOptions.put("acceptInsecureCerts", SHAFT.Properties.browserStack.acceptInsecureCerts());
        browserstackOptions.put("debug", SHAFT.Properties.browserStack.debug());
        browserstackOptions.put("networkLogs", SHAFT.Properties.browserStack.networkLogs());
        String[] pathItems = System.getProperty("user.dir").split(Pattern.quote(File.separator));
        LocalDateTime time = LocalDateTime.now();
        browserstackOptions.put("projectName", ReportManagerHelper.getTestClassName());
        browserstackOptions.put("buildName", pathItems[pathItems.length - 1] + "_" + time.getYear() + time.getMonthValue() + time.getDayOfMonth());
        browserStackCapabilities.setCapability("bstack:options", browserstackOptions);
        return browserStackCapabilities;
    }

    private static void passAction(String testData) {
        BrowserStackHelper.reportActionResult(Thread.currentThread().getStackTrace()[2].getMethodName(), testData, true, new Throwable[0]);
    }

    private static void failAction(String testData, Throwable ... rootCauseException) {
        String message = BrowserStackHelper.reportActionResult(Thread.currentThread().getStackTrace()[2].getMethodName(), testData, false, rootCauseException);
        FailureReporter.fail(BrowserStackHelper.class, message, rootCauseException[0]);
    }

    private static String reportActionResult(String actionName, String testData, Boolean passFailStatus, Throwable ... rootCauseException) {
        actionName = ((String)actionName).substring(0, 1).toUpperCase() + ((String)actionName).substring(1);
        String message = Boolean.TRUE.equals(passFailStatus) ? "BrowserStack API Action \"" + (String)actionName + "\" successfully performed." : "BrowserStack API Action \"" + (String)actionName + "\" failed.";
        if (testData != null && !testData.isEmpty()) {
            message = message + " With the following test data \"" + testData + "\".";
        }
        if (rootCauseException != null && rootCauseException.length >= 1) {
            ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
            List<Object> actualValueAttachment = Arrays.asList("BrowserStack Action Exception - " + (String)actionName, "Stacktrace", ReportManagerHelper.formatStackTraceToLogEntry(rootCauseException[0]));
            attachments.add(actualValueAttachment);
            ReportManagerHelper.log(message, attachments);
        } else {
            ReportManager.logDiscrete(message);
        }
        return message;
    }
}

