/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.driver.internal.DriverFactory;

import com.epam.healenium.SelfHealingDriver;
import com.google.common.base.Throwables;
import com.shaft.driver.DriverFactory;
import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.OptionsManager;
import com.shaft.gui.browser.BrowserActions;
import com.shaft.gui.internal.video.RecordManager;
import com.shaft.properties.internal.Properties;
import com.shaft.properties.internal.PropertiesHelper;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.Setting;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import io.qameta.allure.Step;
import io.restassured.response.Response;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.logging.log4j.Level;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.v120.network.Network;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.safari.SafariDriver;
import org.testng.Reporter;

public class DriverFactoryHelper {
    private static final String WEB_DRIVER_MANAGER_MESSAGE = "Identifying OS/Driver combination. Please note that if a new browser/driver executable will be downloaded it may take some time depending on your connection...";
    private static final String WEB_DRIVER_MANAGER_DOCKERIZED_MESSAGE = "Identifying target OS/Browser and setting up the dockerized environment automatically. Please note that if a new docker container will be downloaded it may take some time depending on your connection...";
    private static final ThreadLocal<WebDriverManager> webDriverManager = new ThreadLocal();
    private static final Dimension TARGET_WINDOW_SIZE = new Dimension(1920, 1080);
    private static final long appiumServerInitializationTimeout = TimeUnit.MINUTES.toSeconds(SHAFT.Properties.timeouts.timeoutForRemoteServerToBeUp());
    private static final int appiumServerInitializationPollingInterval = 1;
    private static final long remoteServerInstanceCreationTimeout = TimeUnit.MINUTES.toSeconds(SHAFT.Properties.timeouts.remoteServerInstanceCreationTimeout());
    private static final int appiumServerPreparationPollingInterval = 1;
    private static String TARGET_HUB_URL;
    private static String targetBrowserName;
    private static boolean killSwitch;
    private final OptionsManager optionsManager = new OptionsManager();
    private WebDriver driver;

    public DriverFactoryHelper() {
    }

    public DriverFactoryHelper(WebDriver driver) {
        this.driver = driver;
    }

    public static boolean isMobileNativeExecution() {
        boolean isMobileExecution = Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform()) || Platform.IOS.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform());
        boolean isNativeExecution = SHAFT.Properties.mobile.browserName().isBlank();
        return isMobileExecution && isNativeExecution;
    }

    public static boolean isMobileWebExecution() {
        boolean isMobileExecution = Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform()) || Platform.IOS.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform());
        boolean isNativeExecution = SHAFT.Properties.mobile.browserName().isBlank();
        return isMobileExecution && !isNativeExecution;
    }

    public static boolean isWebExecution() {
        boolean isMobileExecution = Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform()) || Platform.IOS.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform());
        return !isMobileExecution;
    }

    protected static void failAction(String testData, Throwable ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        String message = "Driver Factory Action \"" + actionName + "\" failed.";
        if (testData != null) {
            message = message + " With the following test data \"" + testData + "\".";
        }
        if (rootCauseException != null && rootCauseException.length >= 1) {
            FailureReporter.fail(DriverFactoryHelper.class, message, rootCauseException[0]);
        } else {
            FailureReporter.fail(message);
        }
    }

    private static DriverFactory.DriverType getDriverTypeFromName(String driverName) {
        int values = DriverFactory.DriverType.values().length;
        for (int i = 0; i < values; ++i) {
            if (!driverName.trim().toLowerCase().contains(Arrays.asList(DriverFactory.DriverType.values()).get(i).getValue().toLowerCase())) continue;
            return Arrays.asList(DriverFactory.DriverType.values()).get(i);
        }
        DriverFactoryHelper.failAction("Unsupported Driver Type \"" + driverName + "\".", new Throwable[0]);
        return DriverFactory.DriverType.CHROME;
    }

    private static int attemptRemoteServerPing() {
        boolean serverReady = false;
        SHAFT.API session = new SHAFT.API(TARGET_HUB_URL);
        int statusCode = 500;
        long startTime = System.currentTimeMillis();
        do {
            try {
                statusCode = ((Response)session.get("status/").perform().andReturn()).statusCode();
                if (statusCode >= 200 && statusCode < 300) {
                    serverReady = true;
                }
            }
            catch (Throwable throwable1) {
                try {
                    statusCode = ((Response)session.get("wd/hub/status/").perform().andReturn()).statusCode();
                    if (statusCode >= 200 && statusCode < 300) {
                        serverReady = true;
                    }
                }
                catch (Throwable throwable2) {
                    ReportManagerHelper.logDiscrete(throwable1, Level.DEBUG);
                    ReportManagerHelper.logDiscrete(throwable2, Level.DEBUG);
                }
            }
            if (serverReady) continue;
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        } while (!serverReady && System.currentTimeMillis() - startTime < TimeUnit.SECONDS.toMillis(appiumServerInitializationTimeout));
        if (!serverReady) {
            DriverFactoryHelper.failAction("Failed to connect to remote server. It was still not ready after " + TimeUnit.SECONDS.toMinutes(appiumServerInitializationTimeout) + " minutes.", new Throwable[0]);
        }
        return statusCode;
    }

    private static WebDriver attemptRemoteServerConnection(Capabilities capabilities) {
        WebDriver driver = null;
        boolean isRemoteConnectionEstablished = false;
        long startTime = System.currentTimeMillis();
        String exception = "";
        do {
            try {
                driver = DriverFactoryHelper.connectToRemoteServer(capabilities, false);
                isRemoteConnectionEstablished = true;
            }
            catch (URISyntaxException | SessionNotCreatedException sessionNotCreatedException1) {
                exception = sessionNotCreatedException1.getMessage();
                try {
                    driver = DriverFactoryHelper.connectToRemoteServer(capabilities, true);
                    isRemoteConnectionEstablished = true;
                }
                catch (URISyntaxException | SessionNotCreatedException sessionNotCreatedException2) {
                    ReportManagerHelper.logDiscrete(sessionNotCreatedException1, Level.DEBUG);
                    ReportManagerHelper.logDiscrete(sessionNotCreatedException2, Level.DEBUG);
                }
            }
            if (isRemoteConnectionEstablished) continue;
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        } while (!isRemoteConnectionEstablished && System.currentTimeMillis() - startTime < TimeUnit.SECONDS.toMillis(remoteServerInstanceCreationTimeout));
        if (!isRemoteConnectionEstablished) {
            DriverFactoryHelper.failAction("Failed to connect to remote server. Session was still not created after " + TimeUnit.SECONDS.toMinutes(remoteServerInstanceCreationTimeout) + " minutes.\nOriginal Error is : " + exception, new Throwable[0]);
        }
        return driver;
    }

    private static WebDriver connectToRemoteServer(Capabilities capabilities, boolean isLegacy) throws MalformedURLException, URISyntaxException {
        Object targetHubUrl = isLegacy ? TARGET_HUB_URL + "wd/hub" : TARGET_HUB_URL;
        String targetLambdaTestHubURL = ((String)targetHubUrl).replace("http", "https");
        String targetPlatform = Properties.platform.targetPlatform();
        String targetMobileHubUrl = ((String)targetHubUrl).replace("@", "@mobile-").replace("http", "https");
        if (targetPlatform.equalsIgnoreCase(Platform.ANDROID.toString())) {
            if (SHAFT.Properties.platform.executionAddress().contains("lambdatest") && !DriverFactoryHelper.isMobileWebExecution()) {
                return new AndroidDriver(new URI(targetMobileHubUrl).toURL(), capabilities);
            }
            if (SHAFT.Properties.platform.executionAddress().contains("lambdatest")) {
                return new AndroidDriver(new URI(targetLambdaTestHubURL).toURL(), capabilities);
            }
            return new AndroidDriver(new URI((String)targetHubUrl).toURL(), capabilities);
        }
        if (targetPlatform.equalsIgnoreCase(Platform.IOS.toString())) {
            if (SHAFT.Properties.platform.executionAddress().contains("lambdatest") && !DriverFactoryHelper.isMobileWebExecution()) {
                return new IOSDriver(new URI(targetMobileHubUrl).toURL(), capabilities);
            }
            if (SHAFT.Properties.platform.executionAddress().contains("lambdatest")) {
                return new IOSDriver(new URI(targetLambdaTestHubURL).toURL(), capabilities);
            }
            return new IOSDriver(new URI((String)targetHubUrl).toURL(), capabilities);
        }
        if (SHAFT.Properties.platform.executionAddress().contains("lambdatest")) {
            return new RemoteWebDriver(new URI(targetLambdaTestHubURL).toURL(), capabilities, false);
        }
        return new RemoteWebDriver(new URI((String)targetHubUrl).toURL(), capabilities, false);
    }

    public static void initializeSystemProperties() {
        PropertiesHelper.postProcessing();
        TARGET_HUB_URL = SHAFT.Properties.platform.executionAddress().trim().toLowerCase().startsWith("http") ? SHAFT.Properties.platform.executionAddress() : "http://" + SHAFT.Properties.platform.executionAddress() + "/";
    }

    public void closeDriver() {
        this.closeDriver(this.driver);
        this.driver = null;
    }

    public void closeDriver(WebDriver driver) {
        if (driver != null) {
            if (SHAFT.Properties.visuals.videoParamsScope().equals("DriverSession")) {
                RecordManager.attachVideoRecording();
            }
            try {
                this.attachWebDriverLogs();
                if (SHAFT.Properties.platform.executionAddress().toLowerCase().contains("dockerized")) {
                    Path pathToRecording = webDriverManager.get().getDockerRecordingPath(driver);
                    webDriverManager.get().quit(driver);
                    RecordManager.attachVideoRecording(pathToRecording);
                }
                driver.quit();
            }
            catch (NullPointerException | WebDriverException pathToRecording) {
            }
            catch (Exception e) {
                ReportManagerHelper.logDiscrete(e);
            }
            finally {
                webDriverManager.remove();
                ReportManager.log("Successfully Closed Driver.");
            }
        } else {
            ReportManager.log("Driver is already closed.");
        }
    }

    private void disableCacheEdgeAndChrome() {
        WebDriver webDriver;
        if (SHAFT.Properties.flags.disableCache() && (webDriver = this.driver) instanceof HasDevTools) {
            HasDevTools hasDevToolsDriver = (HasDevTools)webDriver;
            DevTools devTools = hasDevToolsDriver.getDevTools();
            devTools.createSessionIfThereIsNotOne();
            devTools.send(Network.enable(Optional.empty(), Optional.empty(), Optional.of(100000000)));
            devTools.send(Network.setCacheDisabled((Boolean)true));
            devTools.send(Network.clearBrowserCookies());
            devTools.addListener(Network.responseReceived(), responseReceived -> {
                if (responseReceived.getResponse().getFromDiskCache().isPresent() && ((Boolean)responseReceived.getResponse().getFromDiskCache().get()).equals(true)) {
                    DriverFactoryHelper.failAction("Cache wasn't cleared", new Throwable[0]);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewLocalDriverInstance(DriverFactory.DriverType driverType, int retryAttempts) {
        String targetPlatform = Properties.platform.targetPlatform().toLowerCase();
        Object initialLog = "Attempting to run locally on: \"" + targetPlatform + " | " + JavaHelper.convertToSentenceCase(driverType.getValue()) + "\"";
        if (SHAFT.Properties.web.headlessExecution()) {
            initialLog = (String)initialLog + ", Headless Execution";
        }
        initialLog = ((String)initialLog).replace(targetPlatform, JavaHelper.convertToSentenceCase(targetPlatform));
        ReportManager.logDiscrete((String)initialLog + ".");
        try {
            ReportManager.logDiscrete(WEB_DRIVER_MANAGER_MESSAGE);
            switch (driverType) {
                case FIREFOX: {
                    this.driver = new FirefoxDriver(this.optionsManager.getFfOptions());
                    break;
                }
                case IE: {
                    this.driver = new InternetExplorerDriver(this.optionsManager.getIeOptions());
                    break;
                }
                case CHROME: {
                    this.driver = new ChromeDriver(this.optionsManager.getChOptions());
                    this.disableCacheEdgeAndChrome();
                    break;
                }
                case EDGE: {
                    this.driver = new EdgeDriver(this.optionsManager.getEdOptions());
                    this.disableCacheEdgeAndChrome();
                    break;
                }
                case SAFARI: {
                    this.driver = new SafariDriver(this.optionsManager.getSfOptions());
                    break;
                }
                default: {
                    DriverFactoryHelper.failAction("Unsupported Driver Type \"" + JavaHelper.convertToSentenceCase(driverType.getValue()) + "\".", new Throwable[0]);
                }
            }
            ReportManager.log(((String)initialLog).replace("Attempting to run locally on", "Successfully Opened") + ".");
        }
        catch (Exception exception) {
            if (driverType.equals((Object)DriverFactory.DriverType.SAFARI) && Throwables.getRootCause((Throwable)exception).getMessage().toLowerCase().contains("safari instance is already paired with another webdriver session")) {
                try {
                    SHAFT.CLI.terminal().performTerminalCommand("osascript -e \"tell application \\\"Safari\\\" to quit\"\n");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                this.driver.quit();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.driver = null;
            }
            if (exception.getMessage().contains("java.util.concurrent.TimeoutException")) {
                try {
                    Thread.sleep(26000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (retryAttempts > 0) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.createNewLocalDriverInstance(driverType, retryAttempts - 1);
            }
            DriverFactoryHelper.failAction("Failed to create new Browser Session", exception);
        }
    }

    private void createNewDockerizedDriverInstance(DriverFactory.DriverType driverType) {
        String initialLog = "Attempting to run dockerized on: \"" + Properties.platform.targetPlatform() + " | " + JavaHelper.convertToSentenceCase(driverType.getValue()) + "\"";
        if (SHAFT.Properties.web.headlessExecution()) {
            initialLog = initialLog + ", Headless Execution";
        }
        ReportManager.log(initialLog + ".");
        try {
            ReportManager.logDiscrete(WEB_DRIVER_MANAGER_DOCKERIZED_MESSAGE);
            switch (driverType) {
                case FIREFOX: {
                    webDriverManager.set(WebDriverManager.firefoxdriver().capabilities((Capabilities)this.optionsManager.getFfOptions()));
                    break;
                }
                case CHROME: {
                    webDriverManager.set(WebDriverManager.chromedriver().capabilities((Capabilities)this.optionsManager.getChOptions()));
                    break;
                }
                case EDGE: {
                    webDriverManager.set(WebDriverManager.edgedriver().capabilities((Capabilities)this.optionsManager.getEdOptions()));
                    break;
                }
                case SAFARI: {
                    webDriverManager.set(WebDriverManager.safaridriver().capabilities((Capabilities)this.optionsManager.getSfOptions()));
                    break;
                }
                default: {
                    DriverFactoryHelper.failAction("Unsupported Driver Type \"" + JavaHelper.convertToSentenceCase(driverType.getValue()) + "\". We only support Chrome, Edge, Firefox, and Safari in this dockerized mode.", new Throwable[0]);
                }
            }
            RemoteWebDriver remoteWebDriver = (RemoteWebDriver)webDriverManager.get().proxy(SHAFT.Properties.platform.proxy()).browserInDocker().dockerShmSize("2g").enableVnc().viewOnly().avoidUseChromiumDriverSnap().dockerScreenResolution(TARGET_WINDOW_SIZE.getWidth() + "x" + TARGET_WINDOW_SIZE.getHeight() + "x24").enableRecording().dockerRecordingOutput(SHAFT.Properties.paths.video()).create();
            remoteWebDriver.setFileDetector((FileDetector)new LocalFileDetector());
            this.driver = remoteWebDriver;
            ReportManager.log("Successfully Opened " + JavaHelper.convertToSentenceCase(driverType.getValue()) + ".");
        }
        catch (WebDriverManagerException exception) {
            DriverFactoryHelper.failAction("Failed to create new Dockerized Browser Session, are you sure Docker is available on your machine?", exception);
        }
    }

    private void createNewRemoteDriverInstance(DriverFactory.DriverType driverType) {
        StringBuilder initialLog = new StringBuilder();
        initialLog.append("Attempting to run remotely on: \"").append(Properties.platform.targetPlatform());
        if (!Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform()) && !Platform.IOS.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform())) {
            initialLog.append(" | ").append(JavaHelper.convertToSentenceCase(driverType.getValue()));
        }
        initialLog.append(" | ").append(TARGET_HUB_URL).append("\"");
        if (SHAFT.Properties.web.headlessExecution() && !Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform()) && !Platform.IOS.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform())) {
            initialLog.append(", Headless Execution");
        }
        ReportManager.log(String.valueOf(initialLog) + ".");
        if (Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform()) || Platform.IOS.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform())) {
            this.optionsManager.initializeMobileDesiredCapabilities();
        }
        try {
            this.configureRemoteDriverInstance(driverType, this.optionsManager.getAppiumCapabilities());
        }
        catch (UnreachableBrowserException e) {
            killSwitch = true;
            DriverFactoryHelper.failAction("Unreachable Browser, terminated test suite execution.", e);
        }
        catch (WebDriverException e) {
            if (e.getMessage().contains("Error forwarding the new session cannot find")) {
                ReportManager.logDiscrete("Failed to run remotely on: \"" + Properties.platform.targetPlatform() + "\", \"" + JavaHelper.convertToSentenceCase(driverType.getValue()) + "\", \"" + TARGET_HUB_URL + "\".");
                DriverFactoryHelper.failAction("Error forwarding the new session: Couldn't find a node that matches the desired capabilities.", e);
            } else {
                ReportManager.logDiscrete("Failed to run remotely on: \"" + Properties.platform.targetPlatform() + "\", \"" + JavaHelper.convertToSentenceCase(driverType.getValue()) + "\", \"" + TARGET_HUB_URL + "\".");
                DriverFactoryHelper.failAction("Unhandled Error.", e);
            }
        }
        catch (NoClassDefFoundError e) {
            DriverFactoryHelper.failAction("Failed to create Remote WebDriver instance", e);
        }
    }

    @Step(value="Setting up remote driver instance")
    private void setRemoteDriverInstance(Capabilities capabilities) {
        if (SHAFT.Properties.timeouts.waitForRemoteServerToBeUp().booleanValue()) {
            ReportManager.logDiscrete("Attempting to connect to remote server for up to " + TimeUnit.SECONDS.toMinutes(appiumServerInitializationTimeout) + "min.");
            try {
                String string = TARGET_HUB_URL = TARGET_HUB_URL.contains("0.0.0.0") ? TARGET_HUB_URL.replace("0.0.0.0", "localhost") : TARGET_HUB_URL;
                if (Properties.flags.forceCheckStatusOfRemoteServer()) {
                    int statusCode = DriverFactoryHelper.attemptRemoteServerPing();
                    ReportManager.logDiscrete("Remote server is online, established successful connection with status code: " + statusCode + ".");
                }
            }
            catch (Throwable throwable) {
                ReportManagerHelper.logDiscrete(throwable, Level.DEBUG);
                DriverFactoryHelper.failAction("Failed to connect to remote server.", throwable);
            }
        }
        ReportManager.logDiscrete("Attempting to instantiate remote driver instance for up to " + TimeUnit.SECONDS.toMinutes(remoteServerInstanceCreationTimeout) + "min.");
        try {
            this.driver = DriverFactoryHelper.attemptRemoteServerConnection(capabilities);
            ((RemoteWebDriver)this.driver).setFileDetector((FileDetector)new LocalFileDetector());
            if (!DriverFactoryHelper.isWebExecution() && SHAFT.Properties.platform.targetPlatform().equalsIgnoreCase("Android")) {
                ((AppiumDriver)this.driver).setSetting(Setting.WAIT_FOR_IDLE_TIMEOUT, (Object)5000);
                ((AppiumDriver)this.driver).setSetting(Setting.ALLOW_INVISIBLE_ELEMENTS, (Object)true);
                ((AppiumDriver)this.driver).setSetting(Setting.IGNORE_UNIMPORTANT_VIEWS, (Object)false);
                ((AppiumDriver)this.driver).setSetting("enableMultiWindows", (Object)true);
                ((AppiumDriver)this.driver).setSetting(Setting.MJPEG_SCALING_FACTOR, (Object)25);
                ((AppiumDriver)this.driver).setSetting(Setting.MJPEG_SERVER_SCREENSHOT_QUALITY, (Object)100);
                ((AppiumDriver)this.driver).setSetting("mjpegBilinearFiltering", (Object)true);
            }
            ReportManager.logDiscrete("Successfully instantiated remote driver instance.");
        }
        catch (Throwable throwable) {
            DriverFactoryHelper.failAction("Failed to instantiate remote driver instance.", throwable);
        }
    }

    private void configureRemoteDriverInstance(DriverFactory.DriverType driverType, DesiredCapabilities appiumDesiredCapabilities) {
        switch (driverType) {
            case FIREFOX: {
                this.setRemoteDriverInstance((Capabilities)this.optionsManager.getFfOptions());
                break;
            }
            case IE: {
                this.setRemoteDriverInstance((Capabilities)this.optionsManager.getIeOptions());
                break;
            }
            case CHROME: 
            case CHROMIUM: {
                this.setRemoteDriverInstance((Capabilities)this.optionsManager.getChOptions());
                break;
            }
            case EDGE: {
                this.setRemoteDriverInstance((Capabilities)this.optionsManager.getEdOptions());
                break;
            }
            case SAFARI: 
            case WEBKIT: {
                if (!Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform()) && !Platform.IOS.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform())) {
                    this.setRemoteDriverInstance((Capabilities)this.optionsManager.getSfOptions());
                    break;
                }
                this.setRemoteDriverInstance((Capabilities)appiumDesiredCapabilities);
                break;
            }
            case APPIUM_CHROME: 
            case APPIUM_CHROMIUM: {
                WebDriverManager.chromedriver().browserVersion(SHAFT.Properties.mobile.browserVersion()).setup();
                appiumDesiredCapabilities.setCapability("chromedriverExecutable", WebDriverManager.chromedriver().getDownloadedDriverPath());
                this.setRemoteDriverInstance((Capabilities)appiumDesiredCapabilities);
                break;
            }
            case APPIUM_MOBILE_NATIVE: 
            case APPIUM_SAMSUNG_BROWSER: 
            case APPIUM_BROWSER: {
                this.setRemoteDriverInstance((Capabilities)appiumDesiredCapabilities);
                break;
            }
            default: {
                DriverFactoryHelper.failAction("Unsupported Driver Type \"" + JavaHelper.convertToSentenceCase(driverType.getValue()) + "\".", new Throwable[0]);
            }
        }
        String driverName = driverType.getValue();
        if (driverName.contains("MobileApp")) {
            driverName = driverName.replace("Mobile", Properties.platform.targetPlatform());
        }
        ReportManager.log("Successfully Opened \"" + JavaHelper.convertToSentenceCase(driverName) + "\".");
    }

    private void attachWebDriverLogs() {
        if (SHAFT.Properties.reporting.captureWebDriverLogs()) {
            try {
                Logs driverLogs = this.driver.manage().logs();
                driverLogs.getAvailableLogTypes().forEach(logType -> {
                    StringBuilder logBuilder = new StringBuilder();
                    driverLogs.get(logType).getAll().forEach(logEntry -> logBuilder.append(logEntry.toString()).append(System.lineSeparator()));
                    ReportManagerHelper.attach("Selenium WebDriver Logs", logType, logBuilder.toString());
                });
            }
            catch (WebDriverException webDriverException) {
                // empty catch block
            }
        }
    }

    public void initializeDriver() {
        String overridingBrowserName;
        String mobile_browserName = SHAFT.Properties.mobile.browserName();
        String targetBrowserName = SHAFT.Properties.web.targetBrowserName();
        if (Reporter.getCurrentTestResult() != null && (overridingBrowserName = Reporter.getCurrentTestResult().getTestContext().getCurrentXmlTest().getParameter("targetBrowserName")) != null && !overridingBrowserName.isBlank()) {
            targetBrowserName = overridingBrowserName;
        }
        DriverFactoryHelper.targetBrowserName = targetBrowserName;
        this.initializeDriver(DriverFactoryHelper.getDriverTypeFromName(mobile_browserName.isBlank() ? targetBrowserName : mobile_browserName), null);
    }

    public void initializeDriver(@NonNull DriverFactory.DriverType driverType) {
        if (driverType == null) {
            throw new NullPointerException("driverType is marked non-null but is null");
        }
        this.initializeDriver(driverType, null);
    }

    public void initializeDriver(MutableCapabilities customDriverOptions) {
        String mobile_browserName = SHAFT.Properties.mobile.browserName();
        String overridingBrowserName = Reporter.getCurrentTestResult().getTestContext().getCurrentXmlTest().getParameter("targetBrowserName");
        String targetBrowserName = overridingBrowserName != null && !overridingBrowserName.isBlank() ? overridingBrowserName : SHAFT.Properties.web.targetBrowserName();
        DriverFactoryHelper.targetBrowserName = mobile_browserName == null || mobile_browserName.isBlank() ? targetBrowserName : mobile_browserName;
        this.initializeDriver(DriverFactoryHelper.getDriverTypeFromName(DriverFactoryHelper.targetBrowserName), customDriverOptions);
    }

    public void initializeDriver(@NonNull DriverFactory.DriverType driverType, MutableCapabilities customDriverOptions) {
        if (driverType == null) {
            throw new NullPointerException("driverType is marked non-null but is null");
        }
        DriverFactoryHelper.initializeSystemProperties();
        try {
            boolean isMobileExecution;
            boolean bl = isMobileExecution = Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform()) || Platform.IOS.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform());
            if (isMobileExecution) {
                if (DriverFactoryHelper.isMobileWebExecution()) {
                    SHAFT.Properties.web.set().headlessExecution(false);
                    driverType = SHAFT.Properties.mobile.browserName().equalsIgnoreCase(DriverFactory.DriverType.APPIUM_SAMSUNG_BROWSER.getValue()) ? DriverFactory.DriverType.APPIUM_SAMSUNG_BROWSER : DriverFactory.DriverType.APPIUM_CHROME;
                } else {
                    driverType = DriverFactory.DriverType.APPIUM_MOBILE_NATIVE;
                }
                this.optionsManager.setDriverOptions(driverType, customDriverOptions);
                this.createNewRemoteDriverInstance(driverType);
            } else {
                this.optionsManager.setDriverOptions(driverType, customDriverOptions);
                switch (SHAFT.Properties.platform.executionAddress()) {
                    case "local": {
                        this.createNewLocalDriverInstance(driverType, 6);
                        break;
                    }
                    case "dockerized": {
                        this.createNewDockerizedDriverInstance(driverType);
                        break;
                    }
                    default: {
                        this.createNewRemoteDriverInstance(driverType);
                    }
                }
            }
            if (SHAFT.Properties.web.headlessExecution()) {
                this.driver.manage().window().setSize(new Dimension(TARGET_WINDOW_SIZE.getWidth(), TARGET_WINDOW_SIZE.getHeight()));
            } else {
                Dimension browserWindowSize = new Dimension(SHAFT.Properties.web.browserWindowWidth(), SHAFT.Properties.web.browserWindowHeight());
                if (!isMobileExecution && !SHAFT.Properties.flags.autoMaximizeBrowserWindow()) {
                    this.driver.manage().window().setSize(browserWindowSize);
                }
            }
            if (!isMobileExecution) {
                String targetBrowserName = SHAFT.Properties.web.targetBrowserName().toLowerCase();
                if (SHAFT.Properties.flags.autoMaximizeBrowserWindow() && (targetBrowserName.contains(Browser.SAFARI.browserName().toLowerCase()) || targetBrowserName.contains(Browser.FIREFOX.browserName().toLowerCase()))) {
                    new BrowserActions(this).maximizeWindow();
                }
            }
            RecordManager.startVideoRecording(this.driver);
        }
        catch (NullPointerException e) {
            FailureReporter.fail(DriverFactoryHelper.class, "Unhandled Exception with Driver Type \"" + JavaHelper.convertToSentenceCase(driverType.getValue()) + "\".", e);
        }
        if (SHAFT.Properties.healenium.healEnabled()) {
            ReportManager.logDiscrete("Initializing Healenium's Self Healing Driver...");
            this.driver = SelfHealingDriver.create((WebDriver)this.driver);
        }
    }

    public static Dimension getTARGET_WINDOW_SIZE() {
        return TARGET_WINDOW_SIZE;
    }

    public static String getTargetBrowserName() {
        return targetBrowserName;
    }

    public static boolean isKillSwitch() {
        return killSwitch;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    static {
        targetBrowserName = "";
        killSwitch = false;
    }
}

