/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.driver.internal.DriverFactory;

import com.shaft.api.RequestBuilder;
import com.shaft.api.RestActions;
import com.shaft.cli.FileActions;
import com.shaft.driver.DriverFactory;
import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;

public class LambdaTestHelper {
    private static final String hubUrl = "hub.lambdatest.com/wd/hub";
    private static final String serviceUri = "https://manual-api.lambdatest.com/";
    private static final String appUploadServiceName = "app/upload/realDevice";

    public static DriverFactoryHelper getLambdaTestDriver(MutableCapabilities lambdaTestOptions) {
        String appUrl = SHAFT.Properties.lambdaTest.appUrl();
        DriverFactoryHelper helper = new DriverFactoryHelper();
        if ("".equals(appUrl)) {
            if ("".equals(SHAFT.Properties.lambdaTest.appRelativeFilePath())) {
                lambdaTestOptions = DriverFactoryHelper.isMobileWebExecution() ? LambdaTestHelper.setupMobileWebExecution().merge((Capabilities)lambdaTestOptions) : LambdaTestHelper.setupDesktopWebExecution().merge((Capabilities)lambdaTestOptions);
                helper.initializeDriver(lambdaTestOptions);
            } else {
                lambdaTestOptions = LambdaTestHelper.setupNativeAppExecution(SHAFT.Properties.lambdaTest.username(), SHAFT.Properties.lambdaTest.accessKey(), SHAFT.Properties.lambdaTest.deviceName(), SHAFT.Properties.lambdaTest.platformVersion(), SHAFT.Properties.lambdaTest.appRelativeFilePath(), SHAFT.Properties.lambdaTest.appName()).merge((Capabilities)lambdaTestOptions);
                helper.initializeDriver(DriverFactory.DriverType.APPIUM_MOBILE_NATIVE, lambdaTestOptions);
            }
        } else {
            lambdaTestOptions = LambdaTestHelper.setupNativeAppExecution(SHAFT.Properties.lambdaTest.username(), SHAFT.Properties.lambdaTest.accessKey(), SHAFT.Properties.lambdaTest.deviceName(), SHAFT.Properties.lambdaTest.platformVersion(), appUrl).merge((Capabilities)lambdaTestOptions);
            helper.initializeDriver(DriverFactory.DriverType.APPIUM_MOBILE_NATIVE, lambdaTestOptions);
        }
        return helper;
    }

    private static MutableCapabilities setupNativeAppExecution(String username, String password, String deviceName, String osVersion, String relativePathToAppFile, String appName) {
        SHAFT.Properties.timeouts.set().apiSocketTimeout(600);
        ReportManager.logDiscrete("Setting up LambdaTest configuration for new native app version...");
        String testData = "Username: " + username + ", Password: " + "\u2022".repeat(password.length()) + ", Device Name: " + deviceName + ", OS Version: " + osVersion + ", Relative Path to App File: " + relativePathToAppFile + ", App Name: " + appName;
        ArrayList<Object> apkFile = new ArrayList<Object>();
        apkFile.add("appFile");
        String appPath = FileActions.getInstance(true).getAbsolutePath(relativePathToAppFile);
        apkFile.add(new File(appPath));
        ReportManager.logDiscrete("LambdaTest appPath: " + appPath);
        ArrayList<String> customID = new ArrayList<String>();
        customID.add("name");
        String userProvidedCustomID = SHAFT.Properties.lambdaTest.customID();
        String custom_id = "".equals(userProvidedCustomID) ? "SHAFT_Engine_" + appName.replaceAll(" ", "_") : userProvidedCustomID;
        customID.add(custom_id);
        ReportManager.logDiscrete("LambdaTest custom_id: " + custom_id);
        ArrayList<List<Object>> parameters = new ArrayList<List<Object>>();
        parameters.add(apkFile);
        parameters.add(customID);
        String appUrl = "";
        try {
            appUrl = Objects.requireNonNull(RestActions.getResponseJSONValue(new SHAFT.API(serviceUri).post(appUploadServiceName).setContentType("multipart/form-data").setParameters(parameters, RestActions.ParametersType.FORM).setAuthentication(username, password, RequestBuilder.AuthenticationType.BASIC).perform(), "app_url"));
            ReportManager.logDiscrete("LambdaTest app_url: " + appUrl);
        }
        catch (NullPointerException exception) {
            LambdaTestHelper.failAction(testData, exception);
        }
        MutableCapabilities lambdaTestCapabilities = LambdaTestHelper.setLambdaTestProperties(username, password, deviceName, osVersion, appUrl);
        testData = testData + ", App URL: " + appUrl;
        LambdaTestHelper.passAction(testData);
        HashMap<String, Object> lambdaTestOptions = new HashMap<String, Object>();
        lambdaTestOptions.put("w3c", SHAFT.Properties.lambdaTest.w3c());
        if (Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform())) {
            lambdaTestOptions.put("platformName", "android");
        } else {
            lambdaTestOptions.put("platformName", "ios");
        }
        lambdaTestOptions.put("deviceName", deviceName);
        lambdaTestOptions.put("platformVersion", osVersion);
        lambdaTestOptions.put("isRealMobile", SHAFT.Properties.lambdaTest.isRealMobile());
        lambdaTestOptions.put("appProfiling", SHAFT.Properties.lambdaTest.appProfiling());
        lambdaTestOptions.put("app", appUrl);
        lambdaTestCapabilities.setCapability("lt:options", lambdaTestOptions);
        return lambdaTestCapabilities;
    }

    private static MutableCapabilities setupNativeAppExecution(String username, String password, String deviceName, String osVersion, String appUrl) {
        ReportManager.logDiscrete("Setting up LambdaTest configuration for existing native app version...");
        String testData = "Username: " + username + ", Password: " + password + ", Device Name: " + deviceName + ", OS Version: " + osVersion + ", App URL: " + appUrl;
        MutableCapabilities LambdaTestCapabilities = LambdaTestHelper.setLambdaTestProperties(username, password, deviceName, osVersion, appUrl);
        LambdaTestHelper.passAction(testData);
        HashMap<String, Object> lambdaTestOptions = new HashMap<String, Object>();
        lambdaTestOptions.put("w3c", SHAFT.Properties.lambdaTest.w3c());
        if (Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform())) {
            lambdaTestOptions.put("platformName", "android");
        } else {
            lambdaTestOptions.put("platformName", "ios");
        }
        lambdaTestOptions.put("deviceName", deviceName);
        lambdaTestOptions.put("platformVersion", osVersion);
        lambdaTestOptions.put("isRealMobile", SHAFT.Properties.lambdaTest.isRealMobile());
        lambdaTestOptions.put("appProfiling", SHAFT.Properties.lambdaTest.appProfiling());
        lambdaTestOptions.put("app", appUrl);
        LambdaTestCapabilities.setCapability("lt:options", lambdaTestOptions);
        return LambdaTestCapabilities;
    }

    private static MutableCapabilities setupMobileWebExecution() {
        ReportManager.logDiscrete("Setting up LambdaTest configuration for mobile web execution...");
        String username = SHAFT.Properties.lambdaTest.username();
        String password = SHAFT.Properties.lambdaTest.accessKey();
        String os = SHAFT.Properties.platform.targetPlatform();
        String osVersion = SHAFT.Properties.lambdaTest.osVersion();
        String testData = "Username: " + username + ", Password: " + password + ", Operating System: " + os + ", Operating System Version: " + osVersion;
        SHAFT.Properties.platform.set().executionAddress(username + ":" + password + "@mobile-hub.lambdatest.com/wd/hub");
        SHAFT.Properties.mobile.set().browserName(SHAFT.Properties.web.targetBrowserName());
        MutableCapabilities lambdaTestCapabilities = new MutableCapabilities();
        String browserVersion = SHAFT.Properties.lambdaTest.browserVersion();
        if (browserVersion != null && !browserVersion.trim().isEmpty()) {
            lambdaTestCapabilities.setCapability("browserVersion", SHAFT.Properties.lambdaTest.browserVersion());
        }
        lambdaTestCapabilities.setCapability("browserName", SHAFT.Properties.web.targetBrowserName());
        HashMap<String, Object> lambdaTestOptions = new HashMap<String, Object>();
        if (Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform())) {
            lambdaTestOptions.put("platformName", "android");
        } else {
            lambdaTestOptions.put("platformName", "ios");
        }
        lambdaTestOptions.put("project", SHAFT.Properties.lambdaTest.project());
        lambdaTestOptions.put("build", SHAFT.Properties.lambdaTest.build());
        lambdaTestOptions.put("w3c", SHAFT.Properties.lambdaTest.w3c());
        lambdaTestOptions.put("deviceName", SHAFT.Properties.lambdaTest.deviceName());
        lambdaTestOptions.put("platformVersion", SHAFT.Properties.lambdaTest.platformVersion());
        lambdaTestOptions.put("selenium_version", SHAFT.Properties.lambdaTest.selenium_version());
        lambdaTestOptions.put("tunnel", SHAFT.Properties.lambdaTest.tunnel());
        lambdaTestOptions.put("tunnelName", SHAFT.Properties.lambdaTest.tunnelName());
        lambdaTestOptions.put("video", SHAFT.Properties.lambdaTest.video());
        lambdaTestOptions.put("name", SHAFT.Properties.lambdaTest.buildName());
        lambdaTestOptions.put("visual", SHAFT.Properties.lambdaTest.visual());
        lambdaTestOptions.put("autoGrantPermissions", SHAFT.Properties.lambdaTest.autoGrantPermissions());
        lambdaTestOptions.put("autoAcceptAlerts", SHAFT.Properties.lambdaTest.autoAcceptAlerts());
        lambdaTestOptions.put("isRealMobile", SHAFT.Properties.lambdaTest.isRealMobile());
        lambdaTestOptions.put("console", SHAFT.Properties.lambdaTest.console());
        String geoLocation = SHAFT.Properties.lambdaTest.geoLocation();
        if (geoLocation != null && !Objects.equals(geoLocation, "")) {
            lambdaTestOptions.put("geoLocation", SHAFT.Properties.lambdaTest.geoLocation());
        }
        lambdaTestCapabilities.setCapability("LT:Options", lambdaTestOptions);
        LambdaTestHelper.passAction(testData);
        return lambdaTestCapabilities;
    }

    private static MutableCapabilities setupDesktopWebExecution() {
        ReportManager.logDiscrete("Setting up LambdaTest configuration for desktop web execution...");
        String username = SHAFT.Properties.lambdaTest.username();
        String password = SHAFT.Properties.lambdaTest.accessKey();
        String os = SHAFT.Properties.platform.targetPlatform();
        String osVersion = SHAFT.Properties.lambdaTest.osVersion();
        String testData = "Username: " + username + ", Password: " + password + ", Operating System: " + os + ", Operating System Version: " + osVersion;
        SHAFT.Properties.platform.set().executionAddress(username + ":" + password + "@hub.lambdatest.com/wd/hub");
        MutableCapabilities lambdaTestCapabilities = new MutableCapabilities();
        String browserVersion = SHAFT.Properties.lambdaTest.browserVersion();
        if (browserVersion != null && !browserVersion.trim().isEmpty()) {
            lambdaTestCapabilities.setCapability("browserVersion", SHAFT.Properties.lambdaTest.browserVersion());
        }
        lambdaTestCapabilities.setCapability("browserName", SHAFT.Properties.web.targetBrowserName());
        if (os.toLowerCase().contains("mac")) {
            lambdaTestCapabilities.setCapability("platformName", "MacOS " + SHAFT.Properties.lambdaTest.osVersion());
        } else if (os.toLowerCase().contains("windows")) {
            lambdaTestCapabilities.setCapability("platformName", "Windows " + SHAFT.Properties.lambdaTest.osVersion());
        }
        HashMap<String, Object> lambdaTestOptions = new HashMap<String, Object>();
        lambdaTestOptions.put("project", SHAFT.Properties.lambdaTest.project());
        lambdaTestOptions.put("build", SHAFT.Properties.lambdaTest.build());
        lambdaTestOptions.put("w3c", SHAFT.Properties.lambdaTest.w3c());
        lambdaTestOptions.put("selenium_version", SHAFT.Properties.lambdaTest.selenium_version());
        lambdaTestOptions.put("tunnel", SHAFT.Properties.lambdaTest.tunnel());
        lambdaTestOptions.put("tunnelName", SHAFT.Properties.lambdaTest.tunnelName());
        lambdaTestOptions.put("video", SHAFT.Properties.lambdaTest.video());
        lambdaTestOptions.put("visual", SHAFT.Properties.lambdaTest.visual());
        lambdaTestOptions.put("name", SHAFT.Properties.lambdaTest.buildName());
        lambdaTestOptions.put("autoGrantPermissions", SHAFT.Properties.lambdaTest.autoGrantPermissions());
        lambdaTestOptions.put("autoAcceptAlerts", SHAFT.Properties.lambdaTest.autoAcceptAlerts());
        lambdaTestOptions.put("isRealMobile", SHAFT.Properties.lambdaTest.isRealMobile());
        lambdaTestOptions.put("console", SHAFT.Properties.lambdaTest.console());
        String geoLocation = SHAFT.Properties.lambdaTest.geoLocation();
        if (geoLocation != null && !Objects.equals(geoLocation, "")) {
            lambdaTestOptions.put("geoLocation", SHAFT.Properties.lambdaTest.geoLocation());
        }
        lambdaTestCapabilities.setCapability("LT:Options", lambdaTestOptions);
        LambdaTestHelper.passAction(testData);
        return lambdaTestCapabilities;
    }

    private static MutableCapabilities setLambdaTestProperties(String username, String password, String deviceName, String osVersion, String appUrl) {
        SHAFT.Properties.platform.set().executionAddress(username + ":" + password + "@hub.lambdatest.com/wd/hub");
        SHAFT.Properties.mobile.set().deviceName(deviceName);
        SHAFT.Properties.mobile.set().platformVersion(osVersion);
        SHAFT.Properties.mobile.set().app(appUrl);
        MutableCapabilities lambdaTestCapabilities = new MutableCapabilities();
        HashMap<String, Object> lambdaTestOptions = new HashMap<String, Object>();
        lambdaTestOptions.put("appiumVersion", SHAFT.Properties.lambdaTest.appiumVersion());
        lambdaTestOptions.put("acceptInsecureCerts", SHAFT.Properties.lambdaTest.acceptInsecureCerts());
        lambdaTestOptions.put("debug", SHAFT.Properties.lambdaTest.debug());
        lambdaTestOptions.put("networkLogs", SHAFT.Properties.lambdaTest.networkLogs());
        lambdaTestCapabilities.setCapability("LT:Options", lambdaTestOptions);
        return lambdaTestCapabilities;
    }

    private static void passAction(String testData) {
        LambdaTestHelper.reportActionResult(Thread.currentThread().getStackTrace()[2].getMethodName(), testData, true, new Throwable[0]);
    }

    private static void failAction(String testData, Throwable ... rootCauseException) {
        String message = LambdaTestHelper.reportActionResult(Thread.currentThread().getStackTrace()[2].getMethodName(), testData, false, rootCauseException);
        FailureReporter.fail(LambdaTestHelper.class, message, rootCauseException[0]);
    }

    private static String reportActionResult(String actionName, String testData, Boolean passFailStatus, Throwable ... rootCauseException) {
        actionName = ((String)actionName).substring(0, 1).toUpperCase() + ((String)actionName).substring(1);
        String message = Boolean.TRUE.equals(passFailStatus) ? "LambdaTest API Action \"" + (String)actionName + "\" successfully performed." : "LambdaTest API Action \"" + (String)actionName + "\" failed.";
        if (testData != null && !testData.isEmpty()) {
            message = message + " With the following test data \"" + testData + "\".";
        }
        if (rootCauseException != null && rootCauseException.length >= 1) {
            ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
            List<Object> actualValueAttachment = Arrays.asList("LambdaTest Action Exception - " + (String)actionName, "Stacktrace", ReportManagerHelper.formatStackTraceToLogEntry(rootCauseException[0]));
            attachments.add(actualValueAttachment);
            ReportManagerHelper.log(message, attachments);
        } else {
            ReportManager.logDiscrete(message);
        }
        return message;
    }
}

