/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.driver.internal.DriverFactory;

import com.mysql.cj.util.StringUtils;
import com.shaft.driver.DriverFactory;
import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.properties.internal.Properties;
import com.shaft.properties.internal.PropertyFileManager;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.ReportManager;
import io.appium.java_client.remote.options.UnhandledPromptBehavior;
import java.io.File;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.safari.SafariOptions;

public class OptionsManager {
    private ChromeOptions chOptions;
    private FirefoxOptions ffOptions;
    private SafariOptions sfOptions;
    private EdgeOptions edOptions;
    private InternetExplorerOptions ieOptions;
    private DesiredCapabilities appiumCapabilities;

    protected void setDriverOptions(DriverFactory.DriverType driverType, MutableCapabilities customDriverOptions) {
        String proxyServerSettings = SHAFT.Properties.platform.proxy();
        switch (driverType) {
            case FIREFOX: {
                this.ffOptions = new FirefoxOptions();
                FirefoxProfile ffProfile = new FirefoxProfile();
                ffProfile.setPreference("browser.download.dir", (Object)(System.getProperty("user.dir") + File.separatorChar + SHAFT.Properties.paths.downloads().replace("/", File.separator)));
                ffProfile.setPreference("browser.download.folderList", (Object)2);
                ffProfile.setPreference("browser.helperApps.neverAsk.saveToDisk", (Object)"application/vnd.hzn-3d-crossword;video/3gpp;video/3gpp2;application/vnd.mseq;application/vnd.3m.post-it-notes;application/vnd.3gpp.pic-bw-large;application/vnd.3gpp.pic-bw-small;application/vnd.3gpp.pic-bw-var;application/vnd.3gp2.tcap;application/x-7z-compressed;application/x-abiword;application/x-ace-compressed;application/vnd.americandynamics.acc;application/vnd.acucobol;application/vnd.acucorp;audio/adpcm;application/x-authorware-bin;application/x-athorware-map;application/x-authorware-seg;application/vnd.adobe.air-application-installer-package+zip;application/x-shockwave-flash;application/vnd.adobe.fxp;application/pdf;application/vnd.cups-ppd;application/x-director;applicaion/vnd.adobe.xdp+xml;application/vnd.adobe.xfdf;audio/x-aac;application/vnd.ahead.space;application/vnd.airzip.filesecure.azf;application/vnd.airzip.filesecure.azs;application/vnd.amazon.ebook;application/vnd.amiga.ami;applicatin/andrew-inset;application/vnd.android.package-archive;application/vnd.anser-web-certificate-issue-initiation;application/vnd.anser-web-funds-transfer-initiation;application/vnd.antix.game-component;application/vnd.apple.installe+xml;application/applixware;application/vnd.hhe.lesson-player;application/vnd.aristanetworks.swi;text/x-asm;application/atomcat+xml;application/atomsvc+xml;application/atom+xml;application/pkix-attr-cert;audio/x-aiff;video/x-msvieo;application/vnd.audiograph;image/vnd.dxf;model/vnd.dwf;text/plain-bas;application/x-bcpio;application/octet-stream;image/bmp;application/x-bittorrent;application/vnd.rim.cod;application/vnd.blueice.multipass;application/vnd.bm;application/x-sh;image/prs.btif;application/vnd.businessobjects;application/x-bzip;application/x-bzip2;application/x-csh;text/x-c;application/vnd.chemdraw+xml;text/css;chemical/x-cdx;chemical/x-cml;chemical/x-csml;application/vn.contact.cmsg;application/vnd.claymore;application/vnd.clonk.c4group;image/vnd.dvb.subtitle;application/cdmi-capability;application/cdmi-container;application/cdmi-domain;application/cdmi-object;application/cdmi-queue;applicationvnd.cluetrust.cartomobile-config;application/vnd.cluetrust.cartomobile-config-pkg;image/x-cmu-raster;model/vnd.collada+xml;text/csv;application/mac-compactpro;application/vnd.wap.wmlc;image/cgm;x-conference/x-cooltalk;image/x-cmx;application/vnd.xara;application/vnd.cosmocaller;application/x-cpio;application/vnd.crick.clicker;application/vnd.crick.clicker.keyboard;application/vnd.crick.clicker.palette;application/vnd.crick.clicker.template;application/vn.crick.clicker.wordbank;application/vnd.criticaltools.wbs+xml;application/vnd.rig.cryptonote;chemical/x-cif;chemical/x-cmdf;application/cu-seeme;application/prs.cww;text/vnd.curl;text/vnd.curl.dcurl;text/vnd.curl.mcurl;text/vnd.crl.scurl;application/vnd.curl.car;application/vnd.curl.pcurl;application/vnd.yellowriver-custom-menu;application/dssc+der;application/dssc+xml;application/x-debian-package;audio/vnd.dece.audio;image/vnd.dece.graphic;video/vnd.dec.hd;video/vnd.dece.mobile;video/vnd.uvvu.mp4;video/vnd.dece.pd;video/vnd.dece.sd;video/vnd.dece.video;application/x-dvi;application/vnd.fdsn.seed;application/x-dtbook+xml;application/x-dtbresource+xml;application/vnd.dvb.ait;applcation/vnd.dvb.service;audio/vnd.digital-winds;image/vnd.djvu;application/xml-dtd;application/vnd.dolby.mlp;application/x-doom;application/vnd.dpgraph;audio/vnd.dra;application/vnd.dreamfactory;audio/vnd.dts;audio/vnd.dts.hd;imag/vnd.dwg;application/vnd.dynageo;application/ecmascript;application/vnd.ecowin.chart;image/vnd.fujixerox.edmics-mmr;image/vnd.fujixerox.edmics-rlc;application/exi;application/vnd.proteus.magazine;application/epub+zip;message/rfc82;application/vnd.enliven;application/vnd.is-xpr;image/vnd.xiff;application/vnd.xfdl;application/emma+xml;application/vnd.ezpix-album;application/vnd.ezpix-package;image/vnd.fst;video/vnd.fvt;image/vnd.fastbidsheet;application/vn.denovo.fcselayout-link;video/x-f4v;video/x-flv;image/vnd.fpx;image/vnd.net-fpx;text/vnd.fmi.flexstor;video/x-fli;application/vnd.fluxtime.clip;application/vnd.fdf;text/x-fortran;application/vnd.mif;application/vnd.framemaker;imae/x-freehand;application/vnd.fsc.weblaunch;application/vnd.frogans.fnc;application/vnd.frogans.ltf;application/vnd.fujixerox.ddd;application/vnd.fujixerox.docuworks;application/vnd.fujixerox.docuworks.binder;application/vnd.fujitu.oasys;application/vnd.fujitsu.oasys2;application/vnd.fujitsu.oasys3;application/vnd.fujitsu.oasysgp;application/vnd.fujitsu.oasysprs;application/x-futuresplash;application/vnd.fuzzysheet;image/g3fax;application/vnd.gmx;model/vn.gtw;application/vnd.genomatix.tuxedo;application/vnd.geogebra.file;application/vnd.geogebra.tool;model/vnd.gdl;application/vnd.geometry-explorer;application/vnd.geonext;application/vnd.geoplan;application/vnd.geospace;applicatio/x-font-ghostscript;application/x-font-bdf;application/x-gtar;application/x-texinfo;application/x-gnumeric;application/vnd.google-earth.kml+xml;application/vnd.google-earth.kmz;application/vnd.grafeq;image/gif;text/vnd.graphviz;aplication/vnd.groove-account;application/vnd.groove-help;application/vnd.groove-identity-message;application/vnd.groove-injector;application/vnd.groove-tool-message;application/vnd.groove-tool-template;application/vnd.groove-vcar;video/h261;video/h263;video/h264;application/vnd.hp-hpid;application/vnd.hp-hps;application/x-hdf;audio/vnd.rip;application/vnd.hbci;application/vnd.hp-jlyt;application/vnd.hp-pcl;application/vnd.hp-hpgl;application/vnd.yamaha.h-script;application/vnd.yamaha.hv-dic;application/vnd.yamaha.hv-voice;application/vnd.hydrostatix.sof-data;application/hyperstudio;application/vnd.hal+xml;text/html;application/vnd.ibm.rights-management;application/vnd.ibm.securecontainer;text/calendar;application/vnd.iccprofile;image/x-icon;application/vnd.igloader;image/ief;application/vnd.immervision-ivp;application/vnd.immervision-ivu;application/reginfo+xml;text/vnd.in3d.3dml;text/vnd.in3d.spot;mode/iges;application/vnd.intergeo;application/vnd.cinderella;application/vnd.intercon.formnet;application/vnd.isac.fcs;application/ipfix;application/pkix-cert;application/pkixcmp;application/pkix-crl;application/pkix-pkipath;applicaion/vnd.insors.igm;application/vnd.ipunplugged.rcprofile;application/vnd.irepository.package+xml;text/vnd.sun.j2me.app-descriptor;application/java-archive;application/java-vm;application/x-java-jnlp-file;application/java-serializd-object;text/x-java-source,java;application/javascript;application/json;application/vnd.joost.joda-archive;video/jpm;image/jpeg;video/jpeg;application/vnd.kahootz;application/vnd.chipnuts.karaoke-mmd;application/vnd.kde.karbon;aplication/vnd.kde.kchart;application/vnd.kde.kformula;application/vnd.kde.kivio;application/vnd.kde.kontour;application/vnd.kde.kpresenter;application/vnd.kde.kspread;application/vnd.kde.kword;application/vnd.kenameaapp;applicatin/vnd.kidspiration;application/vnd.kinar;application/vnd.kodak-descriptor;application/vnd.las.las+xml;application/x-latex;application/vnd.llamagraphics.life-balance.desktop;application/vnd.llamagraphics.life-balance.exchange+xml;application/vnd.jam;application/vnd.lotus-1-2-3;application/vnd.lotus-approach;application/vnd.lotus-freelance;application/vnd.lotus-notes;application/vnd.lotus-organizer;application/vnd.lotus-screencam;application/vnd.lotus-wordro;audio/vnd.lucent.voice;audio/x-mpegurl;video/x-m4v;application/mac-binhex40;application/vnd.macports.portpkg;application/vnd.osgeo.mapguide.package;application/marc;application/marcxml+xml;application/mxf;application/vnd.wolfrm.player;application/mathematica;application/mathml+xml;application/mbox;application/vnd.medcalcdata;application/mediaservercontrol+xml;application/vnd.mediastation.cdkey;application/vnd.mfer;application/vnd.mfmp;model/mesh;appliation/mads+xml;application/mets+xml;application/mods+xml;application/metalink4+xml;application/vnd.ms-powerpoint.template.macroenabled.12;application/vnd.ms-word.document.macroenabled.12;application/vnd.ms-word.template.macroenabed.12;application/vnd.mcd;application/vnd.micrografx.flo;application/vnd.micrografx.igx;application/vnd.eszigno3+xml;application/x-msaccess;video/x-ms-asf;application/x-msdownload;application/vnd.ms-artgalry;application/vnd.ms-ca-compressed;application/vnd.ms-ims;application/x-ms-application;application/x-msclip;image/vnd.ms-modi;application/vnd.ms-fontobject;application/vnd.ms-excel;application/vnd.ms-excel.addin.macroenabled.12;application/vnd.ms-excelsheet.binary.macroenabled.12;application/vnd.ms-excel.template.macroenabled.12;application/vnd.ms-excel.sheet.macroenabled.12;application/vnd.ms-htmlhelp;application/x-mscardfile;application/vnd.ms-lrm;application/x-msmediaview;aplication/x-msmoney;application/vnd.openxmlformats-officedocument.presentationml.presentation;application/vnd.openxmlformats-officedocument.presentationml.slide;application/vnd.openxmlformats-officedocument.presentationml.slideshw;application/vnd.openxmlformats-officedocument.presentationml.template;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;application/vnd.openxmlformats-officedocument.spreadsheetml.template;application/vnd.openxmformats-officedocument.wordprocessingml.document;application/vnd.openxmlformats-officedocument.wordprocessingml.template;application/x-msbinder;application/vnd.ms-officetheme;application/onenote;audio/vnd.ms-playready.media.pya;vdeo/vnd.ms-playready.media.pyv;application/vnd.ms-powerpoint;application/vnd.ms-powerpoint.addin.macroenabled.12;application/vnd.ms-powerpoint.slide.macroenabled.12;application/vnd.ms-powerpoint.presentation.macroenabled.12;appliation/vnd.ms-powerpoint.slideshow.macroenabled.12;application/vnd.ms-project;application/x-mspublisher;application/x-msschedule;application/x-silverlight-app;application/vnd.ms-pki.stl;application/vnd.ms-pki.seccat;application/vn.visio;video/x-ms-wm;audio/x-ms-wma;audio/x-ms-wax;video/x-ms-wmx;application/x-ms-wmd;application/vnd.ms-wpl;application/x-ms-wmz;video/x-ms-wmv;video/x-ms-wvx;application/x-msmetafile;application/x-msterminal;application/msword;application/x-mswrite;application/vnd.ms-works;application/x-ms-xbap;application/vnd.ms-xpsdocument;audio/midi;application/vnd.ibm.minipay;application/vnd.ibm.modcap;application/vnd.jcp.javame.midlet-rms;application/vnd.tmobile-ivetv;application/x-mobipocket-ebook;application/vnd.mobius.mbk;application/vnd.mobius.dis;application/vnd.mobius.plc;application/vnd.mobius.mqy;application/vnd.mobius.msl;application/vnd.mobius.txf;application/vnd.mobius.daf;tex/vnd.fly;application/vnd.mophun.certificate;application/vnd.mophun.application;video/mj2;audio/mpeg;video/vnd.mpegurl;video/mpeg;application/mp21;audio/mp4;video/mp4;application/mp4;application/vnd.apple.mpegurl;application/vnd.msician;application/vnd.muvee.style;application/xv+xml;application/vnd.nokia.n-gage.data;application/vnd.nokia.n-gage.symbian.install;application/x-dtbncx+xml;application/x-netcdf;application/vnd.neurolanguage.nlu;application/vnd.na;application/vnd.noblenet-directory;application/vnd.noblenet-sealer;application/vnd.noblenet-web;application/vnd.nokia.radio-preset;application/vnd.nokia.radio-presets;text/n3;application/vnd.novadigm.edm;application/vnd.novadim.edx;application/vnd.novadigm.ext;application/vnd.flographit;audio/vnd.nuera.ecelp4800;audio/vnd.nuera.ecelp7470;audio/vnd.nuera.ecelp9600;application/oda;application/ogg;audio/ogg;video/ogg;application/vnd.oma.dd2+xml;applicatin/vnd.oasis.opendocument.text-web;application/oebps-package+xml;application/vnd.intu.qbo;application/vnd.openofficeorg.extension;application/vnd.yamaha.openscoreformat;audio/webm;video/webm;application/vnd.oasis.opendocument.char;application/vnd.oasis.opendocument.chart-template;application/vnd.oasis.opendocument.database;application/vnd.oasis.opendocument.formula;application/vnd.oasis.opendocument.formula-template;application/vnd.oasis.opendocument.grapics;application/vnd.oasis.opendocument.graphics-template;application/vnd.oasis.opendocument.image;application/vnd.oasis.opendocument.image-template;application/vnd.oasis.opendocument.presentation;application/vnd.oasis.opendocumen.presentation-template;application/vnd.oasis.opendocument.spreadsheet;application/vnd.oasis.opendocument.spreadsheet-template;application/vnd.oasis.opendocument.text;application/vnd.oasis.opendocument.text-master;application/vnd.asis.opendocument.text-template;image/ktx;application/vnd.sun.xml.calc;application/vnd.sun.xml.calc.template;application/vnd.sun.xml.draw;application/vnd.sun.xml.draw.template;application/vnd.sun.xml.impress;application/vnd.sun.xl.impress.template;application/vnd.sun.xml.math;application/vnd.sun.xml.writer;application/vnd.sun.xml.writer.global;application/vnd.sun.xml.writer.template;application/x-font-otf;application/vnd.yamaha.openscoreformat.osfpvg+xml;application/vnd.osgi.dp;application/vnd.palm;text/x-pascal;application/vnd.pawaafile;application/vnd.hp-pclxl;application/vnd.picsel;image/x-pcx;image/vnd.adobe.photoshop;application/pics-rules;image/x-pict;application/x-chat;aplication/pkcs10;application/x-pkcs12;application/pkcs7-mime;application/pkcs7-signature;application/x-pkcs7-certreqresp;application/x-pkcs7-certificates;application/pkcs8;application/vnd.pocketlearn;image/x-portable-anymap;image/-portable-bitmap;application/x-font-pcf;application/font-tdpfr;application/x-chess-pgn;image/x-portable-graymap;image/png;image/x-portable-pixmap;application/pskc+xml;application/vnd.ctc-posml;application/postscript;application/xfont-type1;application/vnd.powerbuilder6;application/pgp-encrypted;application/pgp-signature;application/vnd.previewsystems.box;application/vnd.pvi.ptid1;application/pls+xml;application/vnd.pg.format;application/vnd.pg.osasli;tex/prs.lines.tag;application/x-font-linux-psf;application/vnd.publishare-delta-tree;application/vnd.pmi.widget;application/vnd.quark.quarkxpress;application/vnd.epson.esf;application/vnd.epson.msf;application/vnd.epson.ssf;applicaton/vnd.epson.quickanime;application/vnd.intu.qfx;video/quicktime;application/x-rar-compressed;audio/x-pn-realaudio;audio/x-pn-realaudio-plugin;application/rsd+xml;application/vnd.rn-realmedia;application/vnd.realvnc.bed;applicatin/vnd.recordare.musicxml;application/vnd.recordare.musicxml+xml;application/relax-ng-compact-syntax;application/vnd.data-vision.rdz;application/rdf+xml;application/vnd.cloanto.rp9;application/vnd.jisp;application/rtf;text/richtex;application/vnd.route66.link66+xml;application/rss+xml;application/shf+xml;application/vnd.sailingtracker.track;image/svg+xml;application/vnd.sus-calendar;application/sru+xml;application/set-payment-initiation;application/set-reistration-initiation;application/vnd.sema;application/vnd.semd;application/vnd.semf;application/vnd.seemail;application/x-font-snf;application/scvp-vp-request;application/scvp-vp-response;application/scvp-cv-request;application/svp-cv-response;application/sdp;text/x-setext;video/x-sgi-movie;application/vnd.shana.informed.formdata;application/vnd.shana.informed.formtemplate;application/vnd.shana.informed.interchange;application/vnd.shana.informed.package;application/thraud+xml;application/x-shar;image/x-rgb;application/vnd.epson.salt;application/vnd.accpac.simply.aso;application/vnd.accpac.simply.imp;application/vnd.simtech-mindmapper;application/vnd.commonspace;application/vnd.ymaha.smaf-audio;application/vnd.smaf;application/vnd.yamaha.smaf-phrase;application/vnd.smart.teacher;application/vnd.svd;application/sparql-query;application/sparql-results+xml;application/srgs;application/srgs+xml;application/sml+xml;application/vnd.koan;text/sgml;application/vnd.stardivision.calc;application/vnd.stardivision.draw;application/vnd.stardivision.impress;application/vnd.stardivision.math;application/vnd.stardivision.writer;application/vnd.tardivision.writer-global;application/vnd.stepmania.stepchart;application/x-stuffit;application/x-stuffitx;application/vnd.solent.sdkm+xml;application/vnd.olpc-sugar;audio/basic;application/vnd.wqd;application/vnd.symbian.install;application/smil+xml;application/vnd.syncml+xml;application/vnd.syncml.dm+wbxml;application/vnd.syncml.dm+xml;application/x-sv4cpio;application/x-sv4crc;application/sbml+xml;text/tab-separated-values;image/tiff;application/vnd.to.intent-module-archive;application/x-tar;application/x-tcl;application/x-tex;application/x-tex-tfm;application/tei+xml;text/plain;application/vnd.spotfire.dxp;application/vnd.spotfire.sfs;application/timestamped-data;applicationvnd.trid.tpt;application/vnd.triscape.mxs;text/troff;application/vnd.trueapp;application/x-font-ttf;text/turtle;application/vnd.umajin;application/vnd.uoml+xml;application/vnd.unity;application/vnd.ufdl;text/uri-list;application/nd.uiq.theme;application/x-ustar;text/x-uuencode;text/x-vcalendar;text/x-vcard;application/x-cdlink;application/vnd.vsf;model/vrml;application/vnd.vcx;model/vnd.mts;model/vnd.vtu;application/vnd.visionary;video/vnd.vivo;applicatin/ccxml+xml,;application/voicexml+xml;application/x-wais-source;application/vnd.wap.wbxml;image/vnd.wap.wbmp;audio/x-wav;application/davmount+xml;application/x-font-woff;application/wspolicy+xml;image/webp;application/vnd.webturb;application/widget;application/winhlp;text/vnd.wap.wml;text/vnd.wap.wmlscript;application/vnd.wap.wmlscriptc;application/vnd.wordperfect;application/vnd.wt.stf;application/wsdl+xml;image/x-xbitmap;image/x-xpixmap;image/x-xwindowump;application/x-x509-ca-cert;application/x-xfig;application/xhtml+xml;application/xml;application/xcap-diff+xml;application/xenc+xml;application/patch-ops-error+xml;application/resource-lists+xml;application/rls-services+xml;aplication/resource-lists-diff+xml;application/xslt+xml;application/xop+xml;application/x-xpinstall;application/xspf+xml;application/vnd.mozilla.xul+xml;chemical/x-xyz;text/yaml;application/yang;application/yin+xml;application/vnd.ul;application/zip;application/vnd.handheld-entertainment+xml;application/vnd.zzazz.deck+xml");
                if (SHAFT.Properties.flags.disableCache()) {
                    ffProfile.setPreference("browser.cache.disk.enable", (Object)false);
                    ffProfile.setPreference("browser.cache.memory.enable", (Object)false);
                    ffProfile.setPreference("browser.cache.offline.enable", (Object)false);
                    ffProfile.setPreference("network.http.use-cache", (Object)false);
                }
                ffProfile.setPreference("browser.contentblocking.enabled", (Object)false);
                this.ffOptions.setProfile(ffProfile);
                if (!SHAFT.Properties.platform.executionAddress().equalsIgnoreCase("local")) {
                    this.ffOptions.setCapability("platformName", Properties.platform.targetPlatform());
                }
                if (SHAFT.Properties.web.headlessExecution()) {
                    this.ffOptions.addArguments(new String[]{"-headless"});
                }
                this.ffOptions.setLogLevel(FirefoxDriverLogLevel.WARN);
                this.ffOptions.setPageLoadStrategy(PageLoadStrategy.NORMAL);
                this.ffOptions.setPageLoadTimeout(Duration.ofSeconds(SHAFT.Properties.timeouts.pageLoadTimeout()));
                this.ffOptions.setScriptTimeout(Duration.ofSeconds(SHAFT.Properties.timeouts.scriptExecutionTimeout()));
                if (SHAFT.Properties.platform.driverProxySettings() && !proxyServerSettings.isBlank()) {
                    Proxy proxy = new Proxy();
                    proxy.setHttpProxy(proxyServerSettings);
                    proxy.setSslProxy(proxyServerSettings);
                    this.ffOptions.setProxy(proxy);
                }
                this.ffOptions.setCapability("unhandledPromptBehavior", (Object)UnhandledPromptBehavior.IGNORE);
                this.ffOptions.setCapability("webSocketUrl", SHAFT.Properties.platform.enableBiDi());
                this.ffOptions = this.ffOptions.merge((Capabilities)PropertyFileManager.getCustomWebDriverDesiredCapabilities());
                if (customDriverOptions != null) {
                    this.ffOptions = this.ffOptions.merge((Capabilities)customDriverOptions);
                }
                ReportManager.logDiscrete(this.ffOptions.toString());
                break;
            }
            case IE: {
                this.ieOptions = new InternetExplorerOptions();
                if (!SHAFT.Properties.platform.executionAddress().equalsIgnoreCase("local")) {
                    this.ieOptions.setCapability("platformName", Properties.platform.targetPlatform());
                }
                this.ieOptions.setPageLoadStrategy(PageLoadStrategy.NORMAL);
                this.ieOptions.setPageLoadTimeout(Duration.ofSeconds(SHAFT.Properties.timeouts.pageLoadTimeout()));
                this.ieOptions.setScriptTimeout(Duration.ofSeconds(SHAFT.Properties.timeouts.scriptExecutionTimeout()));
                if (SHAFT.Properties.platform.driverProxySettings() && !proxyServerSettings.isBlank()) {
                    Proxy proxy = new Proxy();
                    proxy.setHttpProxy(proxyServerSettings);
                    proxy.setSslProxy(proxyServerSettings);
                    this.ieOptions.setProxy(proxy);
                }
                if (SHAFT.Properties.flags.disableCache()) {
                    this.ieOptions.setCapability("ie.ensureCleanSession", true);
                    this.ieOptions.setCapability("applicationCacheEnabled", false);
                }
                this.ieOptions = this.ieOptions.merge((Capabilities)PropertyFileManager.getCustomWebDriverDesiredCapabilities());
                if (customDriverOptions != null) {
                    this.ieOptions = this.ieOptions.merge((Capabilities)customDriverOptions);
                }
                ReportManager.logDiscrete(this.ieOptions.toString());
                break;
            }
            case CHROME: 
            case EDGE: 
            case CHROMIUM: {
                if (driverType.equals((Object)DriverFactory.DriverType.EDGE)) {
                    this.edOptions = (EdgeOptions)this.setupChromiumOptions((ChromiumOptions<?>)new EdgeOptions(), customDriverOptions);
                    break;
                }
                this.chOptions = (ChromeOptions)this.setupChromiumOptions((ChromiumOptions<?>)new ChromeOptions(), customDriverOptions);
                break;
            }
            case SAFARI: 
            case WEBKIT: {
                this.sfOptions = new SafariOptions();
                if (!SHAFT.Properties.platform.executionAddress().equalsIgnoreCase("local")) {
                    this.sfOptions.setCapability("platformName", Properties.platform.targetPlatform());
                }
                this.sfOptions.setCapability("unhandledPromptBehavior", (Object)UnhandledPromptBehavior.IGNORE);
                this.sfOptions.setPageLoadStrategy(PageLoadStrategy.NORMAL);
                this.sfOptions.setPageLoadTimeout(Duration.ofSeconds(SHAFT.Properties.timeouts.pageLoadTimeout()));
                this.sfOptions.setScriptTimeout(Duration.ofSeconds(SHAFT.Properties.timeouts.scriptExecutionTimeout()));
                if (SHAFT.Properties.platform.driverProxySettings() && !proxyServerSettings.isBlank()) {
                    Proxy proxy = new Proxy();
                    proxy.setHttpProxy(proxyServerSettings);
                    proxy.setSslProxy(proxyServerSettings);
                    this.sfOptions.setProxy(proxy);
                }
                if (SHAFT.Properties.flags.disableCache()) {
                    this.sfOptions.setCapability("safari:cleanSession", "true");
                }
                this.sfOptions = this.sfOptions.merge((Capabilities)PropertyFileManager.getCustomWebDriverDesiredCapabilities());
                if (customDriverOptions != null) {
                    this.sfOptions = this.sfOptions.merge((Capabilities)customDriverOptions);
                }
                ReportManager.logDiscrete(this.sfOptions.toString());
                break;
            }
            case APPIUM_MOBILE_NATIVE: 
            case APPIUM_SAMSUNG_BROWSER: 
            case APPIUM_CHROME: 
            case APPIUM_CHROMIUM: {
                this.appiumCapabilities = new DesiredCapabilities((Capabilities)PropertyFileManager.getCustomWebDriverDesiredCapabilities().merge((Capabilities)customDriverOptions));
                break;
            }
            default: {
                DriverFactoryHelper.failAction("Unsupported Driver Type \"" + JavaHelper.convertToSentenceCase(driverType.getValue()) + "\".", new Throwable[0]);
            }
        }
    }

    protected void initializeMobileDesiredCapabilities() {
        if (!DriverFactoryHelper.isMobileWebExecution()) {
            Map<String, String> caps = PropertyFileManager.getAppiumDesiredCapabilities();
            caps.forEach((capabilityName, value) -> {
                if (!value.isBlank()) {
                    if (Arrays.asList("true", "false").contains(value.trim().toLowerCase())) {
                        this.appiumCapabilities.setCapability(capabilityName.replace("mobile_", "appium:"), (Object)Boolean.valueOf(value));
                    } else if (StringUtils.isStrictlyNumeric((CharSequence)value.trim())) {
                        this.appiumCapabilities.setCapability(capabilityName.replace("mobile_", "appium:"), (Object)Integer.valueOf(value));
                    } else {
                        this.appiumCapabilities.setCapability(capabilityName.replace("mobile_", "appium:"), value);
                    }
                }
            });
        }
        if (DriverFactoryHelper.isMobileWebExecution()) {
            this.appiumCapabilities.setCapability("browserName", SHAFT.Properties.mobile.browserName());
            this.appiumCapabilities.setCapability("pageLoadStrategy", (Object)PageLoadStrategy.NONE);
        }
        if (!DriverFactoryHelper.isMobileWebExecution() && Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform())) {
            if (this.appiumCapabilities.getCapability("appium:fullReset") == null) {
                this.appiumCapabilities.setCapability("appium:fullReset", true);
            }
            if (this.appiumCapabilities.getCapability("appium:appWaitActivity") == null) {
                this.appiumCapabilities.setCapability("appium:appWaitActivity", "*");
            }
            if (this.appiumCapabilities.getCapability("appium:printPageSourceOnFindFailure") == null) {
                this.appiumCapabilities.setCapability("appium:printPageSourceOnFindFailure", true);
            }
            if (this.appiumCapabilities.getCapability("appium:disableWindowAnimation") == null) {
                this.appiumCapabilities.setCapability("appium:disableWindowAnimation", true);
            }
            if (this.appiumCapabilities.getCapability("appium:forceAppLaunch") == null) {
                this.appiumCapabilities.setCapability("appium:forceAppLaunch", true);
            }
            if (this.appiumCapabilities.getCapability("appium:autoGrantPermissions") == null) {
                this.appiumCapabilities.setCapability("appium:autoGrantPermissions", true);
            }
            if (this.appiumCapabilities.getCapability("appium:allowTestPackages") == null) {
                this.appiumCapabilities.setCapability("appium:allowTestPackages", true);
            }
            if (this.appiumCapabilities.getCapability("appium:enforceAppInstall") == null) {
                this.appiumCapabilities.setCapability("appium:enforceAppInstall", false);
            }
            if (this.appiumCapabilities.getCapability("appium:clearDeviceLogsOnStart") == null) {
                this.appiumCapabilities.setCapability("appium:clearDeviceLogsOnStart", true);
            }
            if (this.appiumCapabilities.getCapability("appium:ignoreHiddenApiPolicyError") == null) {
                this.appiumCapabilities.setCapability("appium:ignoreHiddenApiPolicyError", true);
            }
            if (this.appiumCapabilities.getCapability("appium:isHeadless") == null) {
                this.appiumCapabilities.setCapability("appium:isHeadless", true);
            }
            if (this.appiumCapabilities.getCapability("appium:noSign") == null) {
                this.appiumCapabilities.setCapability("appium:noSign", true);
            }
            if (this.appiumCapabilities.getCapability("appium:enableWebviewDetailsCollection") == null) {
                this.appiumCapabilities.setCapability("appium:enableWebviewDetailsCollection", true);
            }
            if (this.appiumCapabilities.getCapability("appium:showChromedriverLog") == null) {
                this.appiumCapabilities.setCapability("appium:showChromedriverLog", true);
            }
        }
        ReportManager.log(this.appiumCapabilities.toString());
    }

    private ChromiumOptions<?> setupChromiumOptions(ChromiumOptions<?> options, MutableCapabilities customDriverOptions) {
        String executionAddress = SHAFT.Properties.platform.executionAddress().toLowerCase();
        if (!executionAddress.equalsIgnoreCase("local")) {
            options.setCapability("platformName", Properties.platform.targetPlatform());
        }
        if (SHAFT.Properties.web.headlessExecution()) {
            options.addArguments(new String[]{"--headless=new"});
        }
        if (SHAFT.Properties.web.targetBrowserName().equalsIgnoreCase(Browser.CHROME.browserName()) && SHAFT.Properties.platform.targetPlatform().equalsIgnoreCase(Platform.MAC.name())) {
            options.addArguments(new String[]{"--remote-allow-origins=*", "--enable-automation", "--disable-background-timer-throttling", "--disable-backgrounding-occluded-windows", "--disable-features=CalculateNativeWinOcclusion", "--disable-hang-monitor", "--disable-domain-reliability", "--disable-renderer-backgrounding", "--disable-features=AutofillServerCommunication", "--metrics-recording-only", "--no-first-run", "--no-default-browser-check", "--silent-debugger-extension-api", "--disable-extensions", "--disable-component-extensions-with-background-pages", "--disable-dev-shm-usage", "--disable-features=MediaRouter", "--disable-features=Translate", "--disable-ipc-flooding-protection", "--disable-background-networking", "--mute-audio", "--disable-breakpad", "--ignore-certificate-errors", "--disable-device-discovery-notifications", "--force-color-profile=srgb", "--hide-scrollbars", "--host-resolver-rules", "--no-pings", "--disable-features=AvoidUnnecessaryBeforeUnloadCheckSync", "--disable-features=CertificateTransparencyComponentUpdater", "--disable-sync", "--disable-features=OptimizationHints", "--disable-features=DialMediaRouteProvider", "--disable-features=GlobalMediaControls", "--disable-features=ImprovedCookieControls", "--disable-features=LazyFrameLoading", "--disable-field-trial-config", "--enable-features=NetworkService", "--enable-features=NetworkServiceInProcess", "--enable-use-zoom-for-dsf", "--log-net-log", "--net-log-capture-mode", "--disable-client-side-phishing-detection", "--disable-default-apps", "--disable-features=InterestFeedContentSuggestions"});
        }
        if (SHAFT.Properties.performance.isEnabled()) {
            options.addArguments(new String[]{"--remote-debugging-port=" + SHAFT.Properties.performance.port()});
            options.addArguments(new String[]{"--no-sandbox"});
        }
        if (SHAFT.Properties.flags.autoMaximizeBrowserWindow() && !Platform.ANDROID.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform()) && !Platform.IOS.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform()) && !Platform.MAC.toString().equalsIgnoreCase(SHAFT.Properties.platform.targetPlatform())) {
            options.addArguments(new String[]{"--start-maximized"});
        } else {
            options.addArguments(new String[]{"--window-position=0,0", "--window-size=" + DriverFactoryHelper.getTARGET_WINDOW_SIZE().getWidth() + "," + DriverFactoryHelper.getTARGET_WINDOW_SIZE().getHeight()});
        }
        if (!SHAFT.Properties.flags.autoCloseDriverInstance()) {
            options.setExperimentalOption("detach", (Object)true);
        }
        HashMap<String, Object> chromePreferences = new HashMap<String, Object>();
        chromePreferences.put("profile.default_content_settings.popups", 0);
        chromePreferences.put("download.prompt_for_download", "false");
        chromePreferences.put("download.default_directory", System.getProperty("user.dir") + File.separatorChar + SHAFT.Properties.paths.downloads().replace("/", File.separator));
        options.setExperimentalOption("prefs", chromePreferences);
        options.setUnhandledPromptBehaviour(UnexpectedAlertBehaviour.IGNORE);
        options.setCapability("acceptInsecureCerts", true);
        options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        options.setPageLoadTimeout(Duration.ofSeconds(SHAFT.Properties.timeouts.pageLoadTimeout()));
        options.setScriptTimeout(Duration.ofSeconds(SHAFT.Properties.timeouts.scriptExecutionTimeout()));
        options.setCapability("unhandledPromptBehavior", (Object)UnhandledPromptBehavior.IGNORE);
        String proxy = Properties.platform.proxy();
        if (SHAFT.Properties.platform.driverProxySettings() && !"".equals(proxy)) {
            options.setProxy(new Proxy().setHttpProxy(proxy).setSslProxy(proxy));
        }
        if (SHAFT.Properties.reporting.captureWebDriverLogs()) {
            options.setCapability("goog:loggingPrefs", (Object)this.configureLoggingPreferences());
        }
        if (SHAFT.Properties.web.isMobileEmulation() && DriverFactoryHelper.isWebExecution()) {
            HashMap<String, Object> mobileEmulation = new HashMap<String, Object>();
            if (!SHAFT.Properties.web.mobileEmulationIsCustomDevice() && !SHAFT.Properties.web.mobileEmulationDeviceName().isBlank()) {
                mobileEmulation.put("deviceName", SHAFT.Properties.web.mobileEmulationDeviceName());
            } else if (SHAFT.Properties.web.mobileEmulationIsCustomDevice()) {
                if (SHAFT.Properties.web.mobileEmulationWidth() != 0 && SHAFT.Properties.web.mobileEmulationHeight() != 0) {
                    HashMap<String, Number> deviceMetrics = new HashMap<String, Number>();
                    deviceMetrics.put("width", SHAFT.Properties.web.mobileEmulationWidth());
                    deviceMetrics.put("height", SHAFT.Properties.web.mobileEmulationHeight());
                    if (SHAFT.Properties.web.mobileEmulationPixelRatio() != 0.0) {
                        deviceMetrics.put("pixelRatio", SHAFT.Properties.web.mobileEmulationPixelRatio());
                    }
                    mobileEmulation.put("deviceMetrics", deviceMetrics);
                }
                if (!SHAFT.Properties.web.mobileEmulationUserAgent().isEmpty()) {
                    mobileEmulation.put("userAgent", SHAFT.Properties.web.mobileEmulationUserAgent());
                }
            }
            options.setExperimentalOption("mobileEmulation", mobileEmulation);
        }
        options.setCapability("webSocketUrl", SHAFT.Properties.platform.enableBiDi());
        options = (ChromiumOptions)options.merge((Capabilities)PropertyFileManager.getCustomWebDriverDesiredCapabilities());
        if (customDriverOptions != null) {
            options = (ChromiumOptions)options.merge((Capabilities)customDriverOptions);
        }
        if (!SHAFT.Properties.flags.autoCloseDriverInstance()) {
            HashMap<String, Boolean> chromeOptions = new HashMap<String, Boolean>((Map)options.getCapability("goog:chromeOptions"));
            chromeOptions.put("detach", true);
            options.setCapability("goog:chromeOptions", chromeOptions);
        }
        ReportManager.logDiscrete(options.toString());
        return options;
    }

    private LoggingPreferences configureLoggingPreferences() {
        LoggingPreferences logPrefs = new LoggingPreferences();
        logPrefs.enable("performance", Level.ALL);
        logPrefs.enable("driver", Level.ALL);
        logPrefs.enable("browser", Level.ALL);
        logPrefs.enable("driver", Level.ALL);
        return logPrefs;
    }

    public ChromeOptions getChOptions() {
        return this.chOptions;
    }

    public FirefoxOptions getFfOptions() {
        return this.ffOptions;
    }

    public SafariOptions getSfOptions() {
        return this.sfOptions;
    }

    public EdgeOptions getEdOptions() {
        return this.edOptions;
    }

    public InternetExplorerOptions getIeOptions() {
        return this.ieOptions;
    }

    public DesiredCapabilities getAppiumCapabilities() {
        return this.appiumCapabilities;
    }
}

