/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.browser;

import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.driver.internal.FluentWebDriverAction;
import com.shaft.driver.internal.WizardHelpers;
import com.shaft.enums.internal.NavigationAction;
import com.shaft.enums.internal.Screenshots;
import com.shaft.gui.browser.internal.BrowserActionsHelper;
import com.shaft.gui.browser.internal.JavaScriptWaitManager;
import com.shaft.gui.element.internal.ElementActionsHelper;
import com.shaft.gui.internal.image.ScreenshotManager;
import com.shaft.gui.internal.locator.LocatorBuilder;
import com.shaft.gui.internal.locator.ShadowLocatorBuilder;
import com.shaft.gui.waits.WaitActions;
import com.shaft.performance.internal.LightHouseGenerateReport;
import com.shaft.tools.internal.support.JavaScriptHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import com.shaft.validation.internal.WebDriverBrowserValidationsBuilder;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasAuthentication;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.NetworkInterceptor;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class BrowserActions
extends FluentWebDriverAction {
    public BrowserActions() {
        this.initialize();
    }

    public BrowserActions(WebDriver driver) {
        this.initialize(driver);
    }

    public BrowserActions(DriverFactoryHelper helper) {
        this.initialize(helper);
    }

    @Override
    public BrowserActions and() {
        return this;
    }

    public WebDriverBrowserValidationsBuilder assertThat() {
        return new WizardHelpers.WebDriverAssertions(this.helper).browser();
    }

    public WebDriverBrowserValidationsBuilder verifyThat() {
        return new WizardHelpers.WebDriverVerifications(this.helper).browser();
    }

    public BrowserActions capturePageSnapshot() {
        String serializedPageData = BrowserActionsHelper.capturePageSnapshot(this.driver);
        BrowserActionsHelper.passAction(this.driver, serializedPageData);
        return this;
    }

    public String getCurrentURL() {
        String currentURL = "";
        try {
            currentURL = this.driver.getCurrentUrl();
            BrowserActionsHelper.passAction(this.driver, currentURL);
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(this.driver, currentURL, rootCauseException);
        }
        return currentURL;
    }

    public String getCurrentWindowTitle() {
        String currentWindowTitle = "";
        try {
            currentWindowTitle = this.driver.getTitle();
            BrowserActionsHelper.passAction(this.driver, currentWindowTitle);
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(this.driver, currentWindowTitle, rootCauseException);
        }
        return currentWindowTitle;
    }

    public String getPageSource() {
        String pageSource = "";
        try {
            pageSource = this.driver.getPageSource();
            BrowserActionsHelper.passAction(this.driver, pageSource);
        }
        catch (JavascriptException javascriptException) {
            JavaScriptWaitManager.waitForLazyLoading(this.driver);
            return this.getPageSource();
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(this.driver, pageSource, rootCauseException);
        }
        return pageSource;
    }

    public String getWindowHandle() {
        String windowHandle = "";
        try {
            windowHandle = this.driver.getWindowHandle();
            BrowserActionsHelper.passAction(this.driver, windowHandle);
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(this.driver, windowHandle, rootCauseException);
        }
        return windowHandle;
    }

    public String getWindowPosition() {
        String windowPosition = "";
        try {
            windowPosition = this.driver.manage().window().getPosition().toString();
            BrowserActionsHelper.passAction(this.driver, windowPosition);
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(this.driver, windowPosition, rootCauseException);
        }
        return windowPosition;
    }

    public String getWindowSize() {
        String windowSize = "";
        try {
            windowSize = this.driver.manage().window().getSize().toString();
            BrowserActionsHelper.passAction(this.driver, windowSize);
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(this.driver, windowSize, rootCauseException);
        }
        return windowSize;
    }

    public String getWindowHeight() {
        String windowHeight = "";
        try {
            windowHeight = String.valueOf(this.driver.manage().window().getSize().getHeight());
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(this.driver, windowHeight, rootCauseException);
        }
        return windowHeight;
    }

    public String getWindowWidth() {
        String windowWidth = "";
        try {
            windowWidth = String.valueOf(this.driver.manage().window().getSize().getWidth());
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(this.driver, windowWidth, rootCauseException);
        }
        return windowWidth;
    }

    public BrowserActions navigateToURL(String targetUrl) {
        return this.navigateToURL(targetUrl, targetUrl);
    }

    public BrowserActions navigateToURL(String targetUrl, WindowType windowType) {
        String handleBeforeNavigation = this.driver.getWindowHandle();
        try {
            switch (windowType) {
                case TAB: {
                    this.driver.switchTo().newWindow(WindowType.TAB).navigate().to(targetUrl);
                    break;
                }
                case WINDOW: {
                    this.driver.switchTo().newWindow(WindowType.WINDOW).navigate().to(targetUrl);
                }
            }
            JavaScriptWaitManager.waitForLazyLoading(this.driver);
            String handleAfterNavigation = this.driver.getWindowHandle();
            if (!handleBeforeNavigation.equals(handleAfterNavigation)) {
                ReportManager.logDiscrete("Old Tab Handle: \"" + handleBeforeNavigation + "\", New Tab handle : \"" + handleAfterNavigation + "\"");
                BrowserActionsHelper.passAction(this.driver, targetUrl);
            } else {
                BrowserActionsHelper.failAction(this.driver, targetUrl, new Exception[0]);
            }
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(this.driver, targetUrl, rootCauseException);
        }
        return this;
    }

    public BrowserActions navigateToURL(String targetUrl, String targetUrlAfterRedirection) {
        LocatorBuilder.setIFrameLocator(null);
        ShadowLocatorBuilder.shadowDomLocator = null;
        Object modifiedTargetUrl = targetUrl;
        String baseUrl = SHAFT.Properties.web.baseURL();
        if (!baseUrl.isBlank() && targetUrl.startsWith("./")) {
            Object object = modifiedTargetUrl = baseUrl.endsWith("/") ? baseUrl + targetUrl.replace("./", "") : baseUrl + targetUrl.replace("./", "/");
        }
        if (targetUrl.equals(targetUrlAfterRedirection)) {
            ReportManager.logDiscrete("Target URL: \"" + (String)modifiedTargetUrl + "\"");
        } else {
            ReportManager.logDiscrete("Target URL: \"" + (String)modifiedTargetUrl + "\", and after redirection: \"" + targetUrlAfterRedirection + "\"");
        }
        this.forceStopCurrentNavigation();
        try {
            String initialURL;
            WebDriver webDriver = this.driver;
            if (webDriver instanceof AppiumDriver) {
                AppiumDriver appiumDriver = (AppiumDriver)webDriver;
                initialURL = appiumDriver.getCurrentUrl();
            } else {
                initialURL = this.driver.getCurrentUrl();
            }
            if (initialURL.endsWith("/")) {
                initialURL = initialURL.substring(0, initialURL.length() - 1);
            }
            ReportManager.logDiscrete("Initial URL: \"" + initialURL + "\"");
            if (!initialURL.equals(modifiedTargetUrl)) {
                BrowserActionsHelper.navigateToNewUrl(this.driver, initialURL, (String)modifiedTargetUrl, targetUrlAfterRedirection);
            } else {
                this.driver.navigate().refresh();
            }
            JavaScriptWaitManager.waitForLazyLoading(this.driver);
            if (!targetUrl.contains("\n")) {
                BrowserActionsHelper.confirmThatWebsiteIsNotDown(this.driver, (String)modifiedTargetUrl);
            }
            BrowserActionsHelper.passAction(this.driver, (String)modifiedTargetUrl);
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(this.driver, (String)modifiedTargetUrl, rootCauseException);
        }
        return this;
    }

    private void forceStopCurrentNavigation() {
        try {
            JavaScriptWaitManager.waitForLazyLoading(this.driver);
            ((JavascriptExecutor)this.driver).executeScript("return window.stop;", new Object[0]);
        }
        catch (Exception rootCauseException) {
            ReportManagerHelper.logDiscrete(rootCauseException);
        }
    }

    public BrowserActions navigateToURLWithBasicAuthentication(String targetUrl, String username, String password, String targetUrlAfterAuthentication) {
        try {
            String domainName = BrowserActionsHelper.getDomainNameFromUrl(targetUrl);
            if (SHAFT.Properties.platform.executionAddress().equals("local")) {
                Predicate<URI> uriPredicate = uri -> uri.getHost().contains(domainName);
                ((HasAuthentication)this.driver).register(uriPredicate, UsernameAndPassword.of((String)username, (String)password));
            } else {
                AtomicReference<DevTools> devToolsAtomicReference = new AtomicReference<DevTools>();
                this.helper.setDriver(new Augmenter().addDriverAugmentation("chrome", HasAuthentication.class, (caps, exec) -> (whenThisMatches, useTheseCredentials) -> {
                    ((DevTools)devToolsAtomicReference.get()).createSessionIfThereIsNotOne();
                    ((DevTools)devToolsAtomicReference.get()).getDomains().network().addAuthHandler(whenThisMatches, useTheseCredentials);
                }).augment(this.driver));
                DevTools devTools = ((HasDevTools)this.driver).getDevTools();
                devTools.createSession();
                devToolsAtomicReference.set(devTools);
                ((HasAuthentication)this.driver).register(UsernameAndPassword.of((String)username, (String)password));
            }
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
            targetUrl = BrowserActionsHelper.formatUrlForBasicAuthentication(username, password, targetUrl);
        }
        return this.navigateToURL(targetUrl, targetUrlAfterAuthentication);
    }

    public BrowserActions navigateBack() {
        return this.performNavigationAction(NavigationAction.BACK);
    }

    public BrowserActions navigateForward() {
        return this.performNavigationAction(NavigationAction.FORWARD);
    }

    public BrowserActions refreshCurrentPage() {
        return this.performNavigationAction(NavigationAction.REFRESH);
    }

    private BrowserActions performNavigationAction(NavigationAction navigationAction) {
        String newURL = "";
        try {
            String initialURL = this.driver.getCurrentUrl();
            this.forceStopCurrentNavigation();
            switch (navigationAction) {
                case FORWARD: {
                    this.driver.navigate().forward();
                    break;
                }
                case BACK: {
                    this.driver.navigate().back();
                    break;
                }
                case REFRESH: {
                    this.driver.navigate().refresh();
                }
            }
            JavaScriptWaitManager.waitForLazyLoading(this.driver);
            if (!navigationAction.equals((Object)NavigationAction.REFRESH)) {
                BrowserActionsHelper.waitUntilUrlIsNot(this.driver, initialURL);
                newURL = this.driver.getCurrentUrl();
                if (!newURL.equals(initialURL)) {
                    BrowserActionsHelper.passAction(this.driver, "Navigate " + String.valueOf((Object)navigationAction) + " to " + newURL);
                } else {
                    BrowserActionsHelper.failAction(this.driver, newURL, new Exception[0]);
                }
            } else {
                BrowserActionsHelper.passAction(this.driver, "Navigate " + String.valueOf((Object)navigationAction) + " to " + newURL);
            }
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(this.driver, newURL, rootCauseException);
        }
        return this;
    }

    public BrowserActions closeCurrentWindow() {
        block6: {
            if (this.driver != null) {
                try {
                    String lastPageSource = this.driver.getPageSource();
                    this.helper.closeDriver(this.driver);
                    BrowserActionsHelper.passAction(lastPageSource);
                }
                catch (WebDriverException rootCauseException) {
                    if (rootCauseException.getMessage() != null && (rootCauseException.getMessage().contains("was terminated due to TIMEOUT") || rootCauseException.getMessage().contains("Session ID is null"))) {
                        BrowserActionsHelper.passAction(null);
                        break block6;
                    }
                    BrowserActionsHelper.failAction(new Exception[]{rootCauseException});
                }
                catch (Exception rootCauseException) {
                    BrowserActionsHelper.failAction(rootCauseException);
                }
            } else {
                ReportManager.logDiscrete("Window is already closed and driver object is null.");
                BrowserActionsHelper.passAction(null);
            }
        }
        return this;
    }

    public BrowserActions maximizeWindow() {
        int targetWidth = 1920;
        int targetHeight = 1080;
        Dimension initialWindowSize = this.driver.manage().window().getSize();
        ReportManager.logDiscrete("Initial window size: " + initialWindowSize.toString());
        String targetBrowserName = SHAFT.Properties.web.targetBrowserName();
        String targetOperatingSystem = SHAFT.Properties.platform.targetPlatform();
        String executionAddress = SHAFT.Properties.platform.executionAddress();
        Dimension currentWindowSize = BrowserActionsHelper.attemptMaximizeUsingSeleniumWebDriver(this.driver, executionAddress, targetBrowserName, targetOperatingSystem);
        if (initialWindowSize.height == currentWindowSize.height && initialWindowSize.width == currentWindowSize.width) {
            currentWindowSize = BrowserActionsHelper.attemptMaximizeUsingToolkitAndJavascript(this.driver, targetWidth, targetHeight);
            if (currentWindowSize.height != targetHeight || currentWindowSize.width != targetWidth) {
                currentWindowSize = BrowserActionsHelper.attemptMaximizeUsingSeleniumWebDriverManageWindow(this.driver, targetWidth, targetHeight);
            }
            if (currentWindowSize.height != targetHeight || currentWindowSize.width != targetWidth) {
                this.fullScreenWindow();
                currentWindowSize = this.driver.manage().window().getSize();
                ReportManager.logDiscrete("Window size after fullScreenWindow: " + currentWindowSize.toString());
            }
            if (currentWindowSize.height != targetHeight || currentWindowSize.width != targetWidth) {
                ReportManager.logDiscrete("skipping window maximization due to unknown error, marking step as passed.");
            }
        }
        BrowserActionsHelper.passAction(this.driver, "New screen size is now: " + String.valueOf(currentWindowSize));
        return this;
    }

    public BrowserActions setWindowSize(int width, int height) {
        Dimension initialWindowSize = this.driver.manage().window().getSize();
        ReportManager.logDiscrete("Initial window size: " + initialWindowSize.toString());
        this.driver.manage().window().setPosition(new Point(0, 0));
        this.driver.manage().window().setSize(new Dimension(width, height));
        Dimension currentWindowSize = this.driver.manage().window().getSize();
        ReportManager.logDiscrete("Window size after SWD: " + currentWindowSize.toString());
        if (initialWindowSize.height == currentWindowSize.height && initialWindowSize.width == currentWindowSize.width) {
            ((JavascriptExecutor)this.driver).executeScript(JavaScriptHelper.WINDOW_FOCUS.getValue(), new Object[0]);
            ((JavascriptExecutor)this.driver).executeScript(JavaScriptHelper.WINDOW_RESET_LOCATION.getValue(), new Object[0]);
            ((JavascriptExecutor)this.driver).executeScript(JavaScriptHelper.WINDOW_RESIZE.getValue().replace("$WIDTH", String.valueOf(width)).replace("$HEIGHT", String.valueOf(height)), new Object[0]);
            currentWindowSize = this.driver.manage().window().getSize();
            ReportManager.logDiscrete("Window size after JavascriptExecutor: " + currentWindowSize.toString());
        }
        if (initialWindowSize.height == currentWindowSize.height && initialWindowSize.width == currentWindowSize.width) {
            ReportManager.logDiscrete("skipping window resizing due to unknown error, marking step as passed.");
        }
        BrowserActionsHelper.passAction(this.driver, "New screen size is now: " + String.valueOf(currentWindowSize));
        return this;
    }

    public LocalStorage getLocalStorage() {
        if (SHAFT.Properties.platform.executionAddress().equals("local")) {
            return ((WebStorage)this.driver).getLocalStorage();
        }
        return (LocalStorage)((JavascriptExecutor)this.driver).executeScript("return window.localStorage;", new Object[0]);
    }

    public SessionStorage getSessionStorage() {
        if (SHAFT.Properties.platform.executionAddress().equals("local")) {
            return ((WebStorage)this.driver).getSessionStorage();
        }
        return (SessionStorage)((JavascriptExecutor)this.driver).executeScript("return window.sessionStorage;", new Object[0]);
    }

    public BrowserActions mock(Predicate<HttpRequest> requestPredicate, HttpResponse mockedResponse) {
        return this.intercept(requestPredicate, mockedResponse);
    }

    public BrowserActions intercept(Predicate<HttpRequest> requestPredicate, HttpResponse mockedResponse) {
        ReportManager.logDiscrete("Attempting to configure network interceptor for \"" + String.valueOf(requestPredicate) + "\", will provide mocked response \"" + String.valueOf(mockedResponse) + "\"");
        try {
            NetworkInterceptor networkInterceptor = new NetworkInterceptor(this.driver, (Routable)Route.matching(requestPredicate).to(() -> req -> mockedResponse));
            BrowserActionsHelper.passAction(this.driver, "Successfully configured network interceptor.");
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(rootCauseException);
        }
        return this;
    }

    public BrowserActions fullScreenWindow() {
        Dimension initialWindowSize = this.driver.manage().window().getSize();
        ReportManager.logDiscrete("Initial Windows Size: " + initialWindowSize.width + "x" + initialWindowSize.height);
        if (!SHAFT.Properties.platform.executionAddress().equalsIgnoreCase("local") && SHAFT.Properties.web.headlessExecution()) {
            this.maximizeWindow();
        } else {
            this.driver.manage().window().fullscreen();
        }
        ReportManager.logDiscrete("Current Windows Size after fullScreen: " + this.driver.manage().window().getSize().width + "x" + this.driver.manage().window().getSize().height);
        BrowserActionsHelper.passAction(this.driver, this.driver.getPageSource());
        return this;
    }

    public BrowserActions switchToWindow(String nameOrHandle) {
        if (this.driver.getWindowHandles().contains(nameOrHandle)) {
            this.driver.switchTo().window(nameOrHandle);
            BrowserActionsHelper.passAction(this.driver, nameOrHandle);
        } else {
            BrowserActionsHelper.failAction(this.driver, nameOrHandle, new Exception[0]);
        }
        return this;
    }

    public BrowserActions addCookie(String key, String value) {
        this.driver.manage().addCookie(new Cookie(key, value));
        BrowserActionsHelper.passAction(this.driver, "Add Cookie", "Key: " + key + " | Value: " + value);
        return this;
    }

    public Cookie getCookie(String cookieName) {
        Cookie cookie = this.driver.manage().getCookieNamed(cookieName);
        if (cookie == null) {
            BrowserActionsHelper.failAction(this.driver, "Get Cookie: " + cookieName, new Exception[0]);
        }
        return cookie;
    }

    public Set<Cookie> getAllCookies() {
        Set cookies = this.driver.manage().getCookies();
        BrowserActionsHelper.passAction("");
        return cookies;
    }

    public String getCookieDomain(String cookieName) {
        String cookieDomain = this.getCookie(cookieName).getDomain();
        BrowserActionsHelper.passAction(this.driver, "Get Cookie Domain with name: " + cookieName, cookieDomain);
        return cookieDomain;
    }

    public String getCookieValue(String cookieName) {
        String cookieValue = this.getCookie(cookieName).getValue();
        BrowserActionsHelper.passAction(this.driver, "Get Cookie Value with name: " + cookieName, cookieValue);
        return cookieValue;
    }

    public String getCookiePath(String cookieName) {
        String cookiePath = this.getCookie(cookieName).getPath();
        BrowserActionsHelper.passAction(this.driver, "Get Cookie Path with name: " + cookieName, cookiePath);
        return cookiePath;
    }

    public BrowserActions deleteCookie(String cookieName) {
        this.driver.manage().deleteCookieNamed(cookieName);
        BrowserActionsHelper.passAction(this.driver, "Delete Cookie", cookieName);
        return this;
    }

    public BrowserActions deleteAllCookies() {
        this.driver.manage().deleteAllCookies();
        BrowserActionsHelper.passAction("");
        return this;
    }

    public BrowserActions captureScreenshot() {
        return this.captureScreenshot(Screenshots.FULL);
    }

    public BrowserActions captureScreenshot(Screenshots type) {
        String logText = "Capture " + type.name().toLowerCase() + " screenshot";
        ReportManagerHelper.log(logText, Collections.singletonList(ScreenshotManager.prepareImageForReport(ScreenshotManager.takeScreenshot(this.driver), "captureScreenshot")));
        return this;
    }

    public BrowserActions captureSnapshot() {
        String logMessage = "";
        String pageSnapshot = BrowserActionsHelper.capturePageSnapshot(this.driver);
        if (pageSnapshot.startsWith("From: <Saved by Blink>")) {
            logMessage = "Capture page snapshot";
        } else if (pageSnapshot.startsWith("<html")) {
            logMessage = "Capture page HTML";
        }
        ReportManagerHelper.log(logMessage, List.of(Arrays.asList(logMessage, ScreenshotManager.generateAttachmentFileName("captureSnapshot", null), new ByteArrayInputStream(pageSnapshot.getBytes()))));
        return this;
    }

    public void generateLightHouseReport() {
        new LightHouseGenerateReport(this.driver).generateLightHouseReport();
    }

    public BrowserActions waitForLazyLoading() {
        JavaScriptWaitManager.waitForLazyLoading(this.driver);
        return this;
    }

    public BrowserActions waitUntilTitleIs(String title) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.titleIs((String)title), BrowserActionsHelper.NAVIGATION_TIMEOUT_INTEGER);
        return this;
    }

    public BrowserActions waitUntilTitleContains(String title) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.titleContains((String)title), BrowserActionsHelper.NAVIGATION_TIMEOUT_INTEGER);
        return this;
    }

    public BrowserActions waitUntilTitleNotContains(String title) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.not((ExpectedCondition)ExpectedConditions.titleContains((String)title)), BrowserActionsHelper.NAVIGATION_TIMEOUT_INTEGER);
        return this;
    }

    public BrowserActions waitUntilUrlContains(String url) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.urlContains((String)url), BrowserActionsHelper.NAVIGATION_TIMEOUT_INTEGER);
        return this;
    }

    public BrowserActions waitUntilUrlNotContains(String url) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.not((ExpectedCondition)ExpectedConditions.urlContains((String)url)), BrowserActionsHelper.NAVIGATION_TIMEOUT_INTEGER);
        return this;
    }

    public BrowserActions waitUntilUrlToBe(String url) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.urlToBe((String)url), BrowserActionsHelper.NAVIGATION_TIMEOUT_INTEGER);
        return this;
    }

    public BrowserActions waitUntilUrlNotToBe(String url) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.not((ExpectedCondition)ExpectedConditions.urlToBe((String)url)), BrowserActionsHelper.NAVIGATION_TIMEOUT_INTEGER);
        return this;
    }

    public BrowserActions waitUntilUrlMatches(String urlRegex) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.urlMatches((String)urlRegex), BrowserActionsHelper.NAVIGATION_TIMEOUT_INTEGER);
        return this;
    }

    public BrowserActions waitUntilNumberOfWindowsToBe(int numberOfWindows) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.numberOfWindowsToBe((int)numberOfWindows), BrowserActionsHelper.NAVIGATION_TIMEOUT_INTEGER);
        return this;
    }

    public String getContext() {
        String context = "";
        WebDriver webDriver = this.driver;
        if (webDriver instanceof AndroidDriver) {
            AndroidDriver androidDriver = (AndroidDriver)webDriver;
            context = androidDriver.getContext();
        } else {
            webDriver = this.driver;
            if (webDriver instanceof IOSDriver) {
                IOSDriver iosDriver = (IOSDriver)webDriver;
                context = iosDriver.getContext();
            } else {
                ElementActionsHelper.failAction(this.driver, null, new Throwable[0]);
            }
        }
        ElementActionsHelper.passAction(this.driver, null, Thread.currentThread().getStackTrace()[1].getMethodName(), context, null, null);
        return context;
    }

    public BrowserActions setContext(String context) {
        WebDriver webDriver = this.driver;
        if (webDriver instanceof AndroidDriver) {
            AndroidDriver androidDriver = (AndroidDriver)webDriver;
            androidDriver.context(context);
        } else {
            webDriver = this.driver;
            if (webDriver instanceof IOSDriver) {
                IOSDriver iosDriver = (IOSDriver)webDriver;
                iosDriver.context(context);
            } else {
                ElementActionsHelper.failAction(this.driver, context, null, new Throwable[0]);
            }
        }
        ElementActionsHelper.passAction(this.driver, null, Thread.currentThread().getStackTrace()[1].getMethodName(), context, null, null);
        return this;
    }

    public List<String> getWindowHandles() {
        ArrayList<String> windowHandles = new ArrayList<String>(this.driver.getWindowHandles());
        ElementActionsHelper.passAction(this.driver, null, Thread.currentThread().getStackTrace()[1].getMethodName(), String.valueOf(windowHandles), null, null);
        return windowHandles;
    }

    public List<String> getContextHandles() {
        ArrayList<String> windowHandles = new ArrayList<String>();
        WebDriver webDriver = this.driver;
        if (webDriver instanceof AndroidDriver) {
            AndroidDriver androidDriver = (AndroidDriver)webDriver;
            windowHandles.addAll(androidDriver.getContextHandles());
        } else {
            webDriver = this.driver;
            if (webDriver instanceof IOSDriver) {
                IOSDriver iosDriver = (IOSDriver)webDriver;
                windowHandles.addAll(iosDriver.getContextHandles());
            } else {
                ElementActionsHelper.failAction(this.driver, null, new Throwable[0]);
            }
        }
        ElementActionsHelper.passAction(this.driver, null, Thread.currentThread().getStackTrace()[1].getMethodName(), String.valueOf(windowHandles), null, null);
        return windowHandles;
    }
}

