/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.browser.internal;

import com.google.common.net.InternetDomainName;
import com.shaft.db.DatabaseActions;
import com.shaft.driver.SHAFT;
import com.shaft.gui.browser.internal.JavaScriptWaitManager;
import com.shaft.gui.internal.image.ScreenshotManager;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.internal.support.JavaScriptHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.File;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.Level;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.bidi.BiDiException;
import org.openqa.selenium.bidi.browsingcontext.BrowsingContext;
import org.openqa.selenium.bidi.browsingcontext.ReadinessState;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class BrowserActionsHelper {
    public static final int NAVIGATION_TIMEOUT_INTEGER = SHAFT.Properties.timeouts.browserNavigationTimeout();
    private static final Boolean HEADLESS_EXECUTION = SHAFT.Properties.web.headlessExecution();

    public static void passAction(String testData) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        BrowserActionsHelper.passAction(null, actionName, testData);
    }

    public static void passAction(WebDriver driver, String testData) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        BrowserActionsHelper.passAction(driver, actionName, testData);
    }

    public static void passAction(WebDriver driver, String actionName, String testData) {
        BrowserActionsHelper.reportActionResult(driver, actionName, testData, true, new Exception[0]);
    }

    public static void failAction(Exception ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        BrowserActionsHelper.failAction(null, actionName, "", rootCauseException);
    }

    public static void failAction(WebDriver driver, String testData, Exception ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        BrowserActionsHelper.failAction(driver, actionName, testData, rootCauseException);
    }

    public static void failAction(WebDriver driver, String actionName, String testData, Exception ... rootCauseException) {
        String message = BrowserActionsHelper.reportActionResult(driver, actionName, testData, false, rootCauseException);
        if (rootCauseException != null && rootCauseException.length > 0) {
            FailureReporter.fail(DatabaseActions.class, message, rootCauseException[0]);
        } else {
            FailureReporter.fail(message);
        }
    }

    private static String reportActionResult(WebDriver driver, String actionName, String testData, Boolean passFailStatus, Exception ... rootCauseException) {
        List<Object> actualValueAttachment;
        actionName = JavaHelper.convertToSentenceCase(actionName);
        Object message = Boolean.TRUE.equals(passFailStatus) ? "Browser Action: " + actionName : "Browser Action: " + actionName + " failed";
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        if (testData != null && !testData.isEmpty()) {
            if (testData.length() >= 500 || testData.contains("</iframe>") || testData.contains("</html>") || testData.startsWith("From: <Saved by Blink>")) {
                actualValueAttachment = Arrays.asList("Browser Action Test Data - " + actionName, "Actual Value", testData);
                attachments.add(actualValueAttachment);
            } else {
                message = (String)message + " \"" + testData.trim() + "\"";
            }
        }
        if (rootCauseException != null && rootCauseException.length >= 1) {
            actualValueAttachment = Arrays.asList("Browser Action Exception - " + actionName, "Stacktrace", ReportManagerHelper.formatStackTraceToLogEntry(rootCauseException[0]));
            attachments.add(actualValueAttachment);
        }
        message = (String)message + ".";
        message = ((String)message).replace("Browser Action: ", "");
        if (driver != null && !((String)message).equals("Capture page snapshot.")) {
            attachments.add(ScreenshotManager.takeScreenshot(driver, null, actionName, passFailStatus));
            ReportManagerHelper.log((String)message, attachments);
        } else if (!attachments.equals(new ArrayList())) {
            ReportManagerHelper.log((String)message, attachments);
        } else {
            ReportManager.log((String)message);
        }
        return message;
    }

    public static void confirmThatWebsiteIsNotDown(WebDriver driver, String targetUrl) {
        if (SHAFT.Properties.flags.forceCheckNavigationWasSuccessful()) {
            List<String> navigationErrorMessages = Arrays.asList("This site can\u2019t be reached", "Unable to connect", "Safari Can\u2019t Connect to the Server", "This page can't be displayed", "Invalid URL", "<head></head><body></body>");
            try {
                navigationErrorMessages.forEach(errorMessage -> {
                    String pageSource = driver.getPageSource();
                    if (pageSource != null && pageSource.contains((CharSequence)errorMessage)) {
                        BrowserActionsHelper.failAction(driver, "Error message: \"" + errorMessage + "\", Target URL: \"" + targetUrl + "\"", new Exception[0]);
                    }
                });
            }
            catch (JavascriptException javascriptException) {
                JavaScriptWaitManager.waitForLazyLoading(driver);
                BrowserActionsHelper.confirmThatWebsiteIsNotDown(driver, targetUrl);
            }
        }
    }

    public static void navigateToNewUrl(WebDriver driver, String initialURL, String targetUrl, String targetUrlAfterRedirection) {
        Object internalURL = targetUrl;
        try {
            if (targetUrl.startsWith(SHAFT.Properties.paths.testData())) {
                internalURL = "file://" + new File(targetUrl).getAbsolutePath();
            }
        }
        catch (Exception exception) {
            ReportManagerHelper.logDiscrete(exception, Level.DEBUG);
        }
        try {
            new BrowsingContext(driver, driver.getWindowHandle()).navigate((String)internalURL, ReadinessState.COMPLETE);
        }
        catch (IllegalArgumentException | TimeoutException | BiDiException illegalArgumentException) {
            driver.navigate().to((String)internalURL);
        }
        catch (WebDriverException rootCauseException) {
            BrowserActionsHelper.failAction(driver, targetUrl, new Exception[]{rootCauseException});
        }
        if (SHAFT.Properties.flags.forceCheckNavigationWasSuccessful() && !targetUrl.contains("\n")) {
            BrowserActionsHelper.checkNavigationWasSuccessful(driver, initialURL, targetUrl, targetUrlAfterRedirection);
        }
    }

    public static void checkNavigationWasSuccessful(WebDriver driver, String initialURL, String targetUrl, String targetUrlAfterRedirection) {
        if (!targetUrl.equals(targetUrlAfterRedirection)) {
            BrowserActionsHelper.waitUntilUrlIsNot(driver, initialURL);
        } else {
            BrowserActionsHelper.waitUntilUrlIsNot(driver, initialURL);
            String modifiedTargetUrlAfterRedirection = targetUrlAfterRedirection.startsWith("./") ? targetUrl : targetUrlAfterRedirection;
            BrowserActionsHelper.waitUntilUrlContains(driver, modifiedTargetUrlAfterRedirection);
        }
    }

    public static void waitUntilUrlIsNot(WebDriver driver, String initialURL) {
        try {
            new WebDriverWait(driver, Duration.ofSeconds(NAVIGATION_TIMEOUT_INTEGER)).until((Function)ExpectedConditions.not((ExpectedCondition)ExpectedConditions.urlToBe((String)initialURL)));
        }
        catch (TimeoutException rootCauseException) {
            BrowserActionsHelper.failAction(driver, "Waited for " + NAVIGATION_TIMEOUT_INTEGER + " seconds to navigate away from \"" + initialURL + "\" but didn't.", new Exception[]{rootCauseException});
        }
    }

    private static void waitUntilUrlContains(WebDriver driver, String targetURL) {
        try {
            new WebDriverWait(driver, Duration.ofSeconds(NAVIGATION_TIMEOUT_INTEGER)).until((Function)ExpectedConditions.urlContains((String)targetURL));
        }
        catch (TimeoutException rootCauseException) {
            BrowserActionsHelper.failAction(driver, "Waited for " + NAVIGATION_TIMEOUT_INTEGER + " seconds to navigate to \"" + targetURL + "\" but didn't.", new Exception[]{rootCauseException});
        }
    }

    public static Dimension attemptMaximizeUsingSeleniumWebDriver(WebDriver driver, String executionAddress, String targetBrowserName, String targetOperatingSystem) {
        if (!"local".equals(executionAddress) && !"GoogleChrome".equals(targetBrowserName) || "local".equals(executionAddress) && (!"GoogleChrome".equals(targetBrowserName) || !"Mac".equals(targetOperatingSystem))) {
            try {
                driver.manage().window().maximize();
                Dimension currentWindowSize = driver.manage().window().getSize();
                ReportManager.logDiscrete("Window size after SWD Maximize: " + currentWindowSize.toString());
                return currentWindowSize;
            }
            catch (WebDriverException rootCauseException) {
                ReportManagerHelper.logDiscrete(rootCauseException);
            }
        }
        return driver.manage().window().getSize();
    }

    public static Dimension attemptMaximizeUsingToolkitAndJavascript(WebDriver driver, int width, int height) {
        int targetWidth = width;
        int targetHeight = height;
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (Boolean.FALSE.equals(HEADLESS_EXECUTION)) {
                targetWidth = (int)toolkit.getScreenSize().getWidth();
                targetHeight = (int)toolkit.getScreenSize().getHeight();
            }
            driver.manage().window().setPosition(new Point(0, 0));
            driver.manage().window().setSize(new Dimension(targetWidth, targetHeight));
            ReportManager.logDiscrete("Window size after Toolkit: " + driver.manage().window().getSize().toString());
            return driver.manage().window().getSize();
        }
        catch (HeadlessException e) {
            ((JavascriptExecutor)driver).executeScript(JavaScriptHelper.WINDOW_FOCUS.getValue(), new Object[0]);
            ((JavascriptExecutor)driver).executeScript(JavaScriptHelper.WINDOW_RESET_LOCATION.getValue(), new Object[0]);
            ((JavascriptExecutor)driver).executeScript(JavaScriptHelper.WINDOW_RESIZE.getValue().replace("$WIDTH", String.valueOf(targetWidth)).replace("$HEIGHT", String.valueOf(targetHeight)), new Object[0]);
            ReportManager.logDiscrete("Window size after JavascriptExecutor: " + driver.manage().window().getSize().toString());
            return driver.manage().window().getSize();
        }
    }

    public static Dimension attemptMaximizeUsingSeleniumWebDriverManageWindow(WebDriver driver, int width, int height) {
        driver.manage().window().setPosition(new Point(0, 0));
        driver.manage().window().setSize(new Dimension(width, height));
        ReportManager.logDiscrete("Window size after WebDriver.Manage.Window: " + driver.manage().window().getSize().toString());
        return driver.manage().window().getSize();
    }

    public static String capturePageSnapshot(WebDriver driver) {
        String serializedPageData = "";
        try {
            if (driver instanceof ChromiumDriver) {
                ChromiumDriver chromiumDriver = (ChromiumDriver)driver;
                Map result = chromiumDriver.executeCdpCommand("Page.captureSnapshot", new HashMap());
                serializedPageData = (String)result.get("data");
            } else {
                serializedPageData = driver.getPageSource();
            }
            return serializedPageData;
        }
        catch (BiDiException | DevToolsException exception) {
            ReportManagerHelper.logDiscrete(exception);
            return BrowserActionsHelper.capturePageSnapshot(driver);
        }
        catch (WebDriverException webDriverException) {
            return BrowserActionsHelper.capturePageSnapshot(driver);
        }
        catch (Exception rootCauseException) {
            BrowserActionsHelper.failAction(driver, serializedPageData, rootCauseException);
            return serializedPageData;
        }
    }

    public static String formatUrlForBasicAuthentication(String username, String password, String targetUrl) {
        if (targetUrl.startsWith("https://")) {
            return new URI("https://" + URLEncoder.encode(username, StandardCharsets.UTF_8) + ":" + URLEncoder.encode(password, StandardCharsets.UTF_8) + "@" + targetUrl.substring("https://".length())).toString();
        }
        return new URI("http://" + URLEncoder.encode(username, StandardCharsets.UTF_8) + ":" + URLEncoder.encode(password, StandardCharsets.UTF_8) + "@" + targetUrl.substring("http://".length())).toString();
    }

    public static String getDomainNameFromUrl(String url) {
        URI uri = new URI(url);
        String host = uri.getHost();
        InternetDomainName internetDomainName = InternetDomainName.from((String)host).topPrivateDomain();
        return internetDomainName.toString();
    }
}

