/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.browser.internal;

import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.tools.internal.support.JavaScriptHelper;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class JavaScriptWaitManager {
    private static final String TARGET_DOCUMENT_READY_STATE = "complete";
    private static final ThreadLocal<WebDriver> jsWaitDriver = new ThreadLocal();
    private static final int delayBetweenPolls = 20;
    private static int WAIT_DURATION_INTEGER;
    private static JavascriptExecutor jsExec;

    private JavaScriptWaitManager() {
        throw new IllegalStateException("Utility class");
    }

    private static void setDriver(WebDriver driver) {
        jsWaitDriver.set(driver);
        jsExec = (JavascriptExecutor)jsWaitDriver.get();
        WAIT_DURATION_INTEGER = SHAFT.Properties.timeouts.lazyLoadingTimeout();
    }

    public static void waitForLazyLoading(WebDriver driver) {
        JavaScriptWaitManager.setDriver(driver);
        if (SHAFT.Properties.timeouts.waitForLazyLoading().booleanValue() && !DriverFactoryHelper.isMobileNativeExecution()) {
            ArrayList<Thread> lazyLoadingThreads = new ArrayList<Thread>();
            lazyLoadingThreads.add(Thread.ofVirtual().start(JavaScriptWaitManager::waitForJQueryLoadIfDefined));
            lazyLoadingThreads.add(Thread.ofVirtual().start(JavaScriptWaitManager::waitForAngularIfDefined));
            lazyLoadingThreads.add(Thread.ofVirtual().start(JavaScriptWaitManager::waitForJSLoadIfDefined));
            lazyLoadingThreads.forEach(thread -> {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
    }

    private static void waitForJQueryLoadIfDefined() {
        block7: {
            try {
                Boolean jQueryDefined = (Boolean)jsExec.executeScript("return typeof jQuery != 'undefined'", new Object[0]);
                if (!Boolean.TRUE.equals(jQueryDefined)) break block7;
                ExpectedCondition jQueryLoad = null;
                try {
                    jQueryLoad = driver -> (Long)((JavascriptExecutor)jsWaitDriver.get()).executeScript("return jQuery.active", new Object[0]) == 0L;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                boolean jqueryReady = (Boolean)jsExec.executeScript("return jQuery.active==0", new Object[0]);
                if (jqueryReady) break block7;
                for (int tryCounter = 0; !jqueryReady && tryCounter < 5; ++tryCounter) {
                    try {
                        new WebDriverWait(jsWaitDriver.get(), Duration.ofSeconds(WAIT_DURATION_INTEGER)).until((Function)jQueryLoad);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    JavaScriptWaitManager.sleep();
                    jqueryReady = (Boolean)jsExec.executeScript("return jQuery.active == 0", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void waitForAngularLoad() {
        JavascriptExecutor jsExec = (JavascriptExecutor)jsWaitDriver.get();
        String angularReadyScript = "return angular.element(document).injector().get('$http').pendingRequests.length === 0";
        ExpectedCondition angularLoad = driver -> Boolean.valueOf(((JavascriptExecutor)Objects.requireNonNull(driver)).executeScript(angularReadyScript, new Object[0]).toString());
        boolean angularReady = Boolean.parseBoolean(jsExec.executeScript(angularReadyScript, new Object[0]).toString());
        if (!angularReady) {
            for (int tryCounter = 0; !angularReady && tryCounter < 5; ++tryCounter) {
                new WebDriverWait(jsWaitDriver.get(), Duration.ofSeconds(WAIT_DURATION_INTEGER)).until((Function)angularLoad);
                JavaScriptWaitManager.sleep();
                angularReady = Boolean.parseBoolean(jsExec.executeScript(angularReadyScript, new Object[0]).toString());
            }
        }
    }

    private static void waitForJSLoadIfDefined() {
        block5: {
            try {
                JavascriptExecutor jsExec = (JavascriptExecutor)jsWaitDriver.get();
                ExpectedCondition jsLoad = driver -> ((JavascriptExecutor)jsWaitDriver.get()).executeScript(JavaScriptHelper.DOCUMENT_READYSTATE.getValue(), new Object[0]).toString().trim().equalsIgnoreCase(TARGET_DOCUMENT_READY_STATE);
                boolean jsReady = jsExec.executeScript(JavaScriptHelper.DOCUMENT_READYSTATE.getValue(), new Object[0]).toString().trim().equalsIgnoreCase(TARGET_DOCUMENT_READY_STATE);
                if (jsReady) break block5;
                for (int tryCounter = 0; !jsReady && tryCounter < 5; ++tryCounter) {
                    try {
                        new WebDriverWait(jsWaitDriver.get(), Duration.ofSeconds(WAIT_DURATION_INTEGER)).until((Function)jsLoad);
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    JavaScriptWaitManager.sleep();
                    jsReady = jsExec.executeScript(JavaScriptHelper.DOCUMENT_READYSTATE.getValue(), new Object[0]).toString().trim().equalsIgnoreCase(TARGET_DOCUMENT_READY_STATE);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void waitForAngularIfDefined() {
        try {
            Boolean angularInjectorDefined;
            Boolean angularDefined = (Boolean)jsExec.executeScript("return window.angular === undefined", new Object[0]) == false;
            if (Boolean.TRUE.equals(angularDefined) && Boolean.TRUE.equals(angularInjectorDefined = Boolean.valueOf((Boolean)jsExec.executeScript("return angular.element(document).injector() === undefined", new Object[0]) == false))) {
                JavaScriptWaitManager.waitForAngularLoad();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void sleep() {
        try {
            Thread.sleep(20L);
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
        }
    }
}

