/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.element;

import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.driver.internal.FluentWebDriverAction;
import com.shaft.gui.element.internal.ElementActionsHelper;
import com.shaft.tools.io.ReportManager;
import java.time.Duration;
import java.util.function.Function;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class AlertActions
extends FluentWebDriverAction {
    public AlertActions() {
        this.initialize();
        this.waitForAlertToBePresent();
    }

    public AlertActions(WebDriver driver) {
        this.initialize(driver);
        this.waitForAlertToBePresent();
    }

    public AlertActions(DriverFactoryHelper helper) {
        this.initialize(helper);
        this.waitForAlertToBePresent();
    }

    private void waitForAlertToBePresent() {
        try {
            new WebDriverWait(this.helper.getDriver(), Duration.ofSeconds((long)SHAFT.Properties.timeouts.defaultElementIdentificationTimeout())).until((Function)ExpectedConditions.alertIsPresent());
            this.helper.getDriver().switchTo().alert();
            ReportManager.logDiscrete("Alert is present");
        }
        catch (Exception rootCauseException) {
            ReportManager.logDiscrete("Alert is not present");
            ElementActionsHelper.failAction(this.helper.getDriver(), null, rootCauseException);
        }
    }

    public boolean isAlertPresent() {
        try {
            this.waitForAlertToBePresent();
            ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, null);
            ReportManager.logDiscrete("Alert is present");
            return true;
        }
        catch (NoAlertPresentException exception) {
            ElementActionsHelper.failAction(this.helper.getDriver(), null, exception);
            ReportManager.logDiscrete("Alert is not present");
            return false;
        }
        catch (Exception rootCauseException) {
            ElementActionsHelper.failAction(this.helper.getDriver(), null, rootCauseException);
            return false;
        }
    }

    public AlertActions acceptAlert() {
        try {
            this.waitForAlertToBePresent();
            this.helper.getDriver().switchTo().alert().accept();
            ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, null);
        }
        catch (Exception rootCauseException) {
            ElementActionsHelper.failAction(this.helper.getDriver(), null, rootCauseException);
        }
        return this;
    }

    public AlertActions dismissAlert() {
        try {
            this.waitForAlertToBePresent();
            this.helper.getDriver().switchTo().alert().dismiss();
            ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, null);
        }
        catch (Exception rootCauseException) {
            ElementActionsHelper.failAction(this.helper.getDriver(), null, rootCauseException);
        }
        return this;
    }

    public String getAlertText() {
        try {
            this.waitForAlertToBePresent();
            String alertText = this.helper.getDriver().switchTo().alert().getText();
            ReportManager.logDiscrete("Alert Text is: [" + alertText + "]");
            ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, null);
            return alertText;
        }
        catch (Exception rootCauseException) {
            ElementActionsHelper.failAction(this.helper.getDriver(), null, rootCauseException);
            return null;
        }
    }

    public AlertActions typeIntoPromptAlert(String text) {
        try {
            this.waitForAlertToBePresent();
            this.helper.getDriver().switchTo().alert().sendKeys(text);
            ReportManager.logDiscrete("Text typed into Alert is: [" + text + "]");
            ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, null);
        }
        catch (Exception rootCauseException) {
            ElementActionsHelper.failAction(this.helper.getDriver(), null, rootCauseException);
        }
        return this;
    }
}

