/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.element;

import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.driver.internal.FluentWebDriverAction;
import com.shaft.enums.internal.ClipboardAction;
import com.shaft.gui.element.ElementActions;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.util.ArrayList;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

@Beta
public class AsyncElementActions
extends FluentWebDriverAction {
    private final ArrayList<Thread> actionThreads = new ArrayList();
    private final ElementActions elementActions;

    public AsyncElementActions(DriverFactoryHelper helper) {
        this.initialize(helper);
        this.elementActions = new ElementActions(helper);
    }

    public AsyncElementActions type(By elementLocator, String text) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.type(elementLocator, text)));
        return this;
    }

    public AsyncElementActions click(By elementLocator) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.click(elementLocator)));
        return this;
    }

    public AsyncElementActions select(By elementLocator, String text) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.select(elementLocator, text)));
        return this;
    }

    public AsyncElementActions clear(By elementLocator) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.clear(elementLocator)));
        return this;
    }

    public AsyncElementActions doubleClick(By elementLocator) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.doubleClick(elementLocator)));
        return this;
    }

    public AsyncElementActions clickUsingJavascript(By elementLocator) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.clickUsingJavascript(elementLocator)));
        return this;
    }

    public AsyncElementActions keyPress(By elementLocator, Keys key) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.keyPress(elementLocator, key)));
        return this;
    }

    public AsyncElementActions clipboardActions(By elementLocator, ClipboardAction action) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.clipboardActions(elementLocator, action)));
        return this;
    }

    public AsyncElementActions captureScreenshot(By elementLocator) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.captureScreenshot(elementLocator)));
        return this;
    }

    public AsyncElementActions hover(By elementLocator) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.hover(elementLocator)));
        return this;
    }

    public AsyncElementActions typeAppend(By elementLocator, String text) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.typeAppend(elementLocator, text)));
        return this;
    }

    public AsyncElementActions clickAndHold(By elementLocator) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.clickAndHold(elementLocator)));
        return this;
    }

    public AsyncElementActions setValueUsingJavaScript(By elementLocator, String value) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.setValueUsingJavaScript(elementLocator, value)));
        return this;
    }

    public AsyncElementActions typeSecure(By elementLocator, String text) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.typeSecure(elementLocator, text)));
        return this;
    }

    public AsyncElementActions submitFormUsingJavaScript(By elementLocator) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.submitFormUsingJavaScript(elementLocator)));
        return this;
    }

    public AsyncElementActions typeFileLocationForUpload(By elementLocator, String filePath) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.typeFileLocationForUpload(elementLocator, filePath)));
        return this;
    }

    public AsyncElementActions dragAndDrop(By sourceElementLocator, By destinationElementLocator) {
        this.actionThreads.add(Thread.ofVirtual().start(() -> this.elementActions.dragAndDrop(sourceElementLocator, destinationElementLocator)));
        return this;
    }

    public AsyncElementActions join() {
        return this.synchronize();
    }

    public AsyncElementActions synchronize() {
        this.actionThreads.forEach(actionThread -> {
            try {
                actionThread.join();
            }
            catch (InterruptedException e) {
                ReportManagerHelper.log(e);
            }
        });
        return this;
    }

    public AsyncElementActions sync() {
        return this.synchronize();
    }
}

