/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.element;

import com.shaft.cli.FileActions;
import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.driver.internal.FluentWebDriverAction;
import com.shaft.driver.internal.WizardHelpers;
import com.shaft.enums.internal.ClipboardAction;
import com.shaft.enums.internal.ElementAction;
import com.shaft.enums.internal.Screenshots;
import com.shaft.gui.element.TouchActions;
import com.shaft.gui.element.internal.ElementActionsHelper;
import com.shaft.gui.element.internal.ElementInformation;
import com.shaft.gui.internal.image.ScreenshotManager;
import com.shaft.gui.internal.locator.LocatorBuilder;
import com.shaft.gui.waits.WaitActions;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import com.shaft.validation.internal.WebDriverElementValidationsBuilder;
import java.nio.file.FileSystems;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.locators.RelativeLocator;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.UnexpectedTagNameException;
import org.openqa.selenium.support.ui.WebDriverWait;

public class ElementActions
extends FluentWebDriverAction {
    public ElementActions() {
        this.initialize();
    }

    public ElementActions(WebDriver driver) {
        this.initialize(driver);
    }

    public ElementActions(DriverFactoryHelper helper) {
        this.initialize(helper);
    }

    @Override
    public ElementActions and() {
        return this;
    }

    public WebDriverElementValidationsBuilder assertThat(By elementLocator) {
        return new WizardHelpers.WebDriverAssertions(this.helper).element(elementLocator);
    }

    public WebDriverElementValidationsBuilder verifyThat(By elementLocator) {
        return new WizardHelpers.WebDriverVerifications(this.helper).element(elementLocator);
    }

    public int getElementsCount(By elementLocator) {
        return ElementActionsHelper.getElementsCount(this.driver, elementLocator);
    }

    public String getSelectedText(By elementLocator) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            StringBuilder elementSelectedText = new StringBuilder();
            try {
                new Select((WebElement)ElementActionsHelper.identifyUniqueElementIgnoringVisibility(this.driver, elementLocator).get(1)).getAllSelectedOptions().forEach(selectedOption -> elementSelectedText.append(selectedOption.getText()));
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), elementSelectedText.toString().trim(), null, elementName);
                return elementSelectedText.toString().trim();
            }
            catch (UnexpectedTagNameException rootCauseException) {
                ElementActionsHelper.failAction(this.driver, elementLocator, rootCauseException);
                return null;
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
            return null;
        }
    }

    public ElementActions executeNativeMobileCommand(String command, Map<String, String> parameters) {
        try {
            ElementActionsHelper.executeNativeMobileCommandUsingJavascript(this.driver, command, parameters);
            String testData = "Command: " + command + ", Parameters: " + String.valueOf(parameters);
            ElementActionsHelper.passAction(this.driver, null, Thread.currentThread().getStackTrace()[1].getMethodName(), testData, null, null);
        }
        catch (Exception rootCauseException) {
            ElementActionsHelper.failAction(this.driver, null, rootCauseException);
        }
        return this;
    }

    public ElementActions click(By elementLocator) {
        if (DriverFactoryHelper.isMobileNativeExecution()) {
            new TouchActions(this.helper).tap(elementLocator);
        } else {
            List<Object> screenshot = ElementActionsHelper.takeScreenshot(this.driver, elementLocator, "click", null, true);
            ElementInformation elementInformation = new ElementInformation();
            try {
                elementInformation = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElementIgnoringVisibility(this.driver, elementLocator, new Object[]{ElementAction.CLICK}));
            }
            catch (Throwable throwable) {
                ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
            }
            String elementName = elementInformation.getElementName();
            ElementActionsHelper.passAction(this.driver, elementLocator, "", screenshot, elementName);
        }
        return this;
    }

    public ElementActions clickUsingJavascript(By elementLocator) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            List<Object> screenshot = ElementActionsHelper.takeScreenshot(this.driver, elementLocator, "clickUsingJavascript", null, true);
            ElementActionsHelper.clickUsingJavascript(this.driver, elementLocator);
            ElementActionsHelper.passAction(this.driver, elementLocator, "", screenshot, elementName);
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions scrollToElement(By elementLocator) {
        if (DriverFactoryHelper.isMobileNativeExecution()) {
            this.performTouchAction().swipeElementIntoView(elementLocator, TouchActions.SwipeDirection.DOWN);
        }
        try {
            ElementActionsHelper.scrollToFindElement(this.driver, elementLocator);
            ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, ElementActionsHelper.getElementName(this.driver, elementLocator));
        }
        catch (Exception throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions clickAndHold(By elementLocator) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            List<Object> screenshot = ElementActionsHelper.takeScreenshot(this.driver, elementLocator, "clickAndHold", null, true);
            WebElement element = (WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, elementLocator).get(1);
            if (Boolean.FALSE.equals(ElementActionsHelper.waitForElementToBeClickable(this.driver, elementLocator, "clickAndHold"))) {
                ElementActionsHelper.failAction(this.driver, "element is not clickable", elementLocator, new Throwable[0]);
            }
            ElementActionsHelper.passAction(this.driver, elementLocator, "", screenshot, elementName);
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions clipboardActions(By elementLocator, ClipboardAction action) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            boolean wasActionPerformed = ElementActionsHelper.performClipboardActions(this.driver, action);
            if (Boolean.TRUE.equals(wasActionPerformed)) {
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), action.getValue(), null, elementName);
            } else {
                ElementActionsHelper.failAction(this.driver, action.getValue(), elementLocator, new Throwable[0]);
            }
        }
        catch (Exception throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions doubleClick(By elementLocator) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            List<Object> screenshot = ElementActionsHelper.takeScreenshot(this.driver, elementLocator, "doubleClick", null, true);
            LinkedList<List<Object>> attachments = new LinkedList<List<Object>>();
            attachments.add(screenshot);
            try {
                new Actions(this.driver).moveToElement((WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, elementLocator).get(1)).doubleClick().perform();
            }
            catch (Exception e) {
                ElementActionsHelper.failAction(this.driver, elementLocator, e);
            }
            ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), null, attachments, elementName);
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions dragAndDrop(By sourceElementLocator, By destinationElementLocator) {
        block10: {
            try {
                Exception exception = new Exception();
                String elementName = ElementActionsHelper.getElementName(this.driver, sourceElementLocator);
                String startLocation = ((WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, sourceElementLocator).get(1)).getLocation().toString();
                try {
                    ElementActionsHelper.dragAndDropUsingJavascript(this.driver, sourceElementLocator, destinationElementLocator);
                }
                catch (Exception rootCauseException) {
                    exception = rootCauseException;
                    ReportManagerHelper.logDiscrete(rootCauseException);
                }
                String endLocation = ((WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, sourceElementLocator).get(1)).getLocation().toString();
                String reportMessage = "Start point: " + startLocation + ", End point: " + endLocation;
                if (!endLocation.equals(startLocation)) {
                    ElementActionsHelper.passAction(this.driver, sourceElementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), reportMessage, null, elementName);
                    break block10;
                }
                try {
                    ElementActionsHelper.dragAndDropUsingActions(this.driver, sourceElementLocator, destinationElementLocator);
                }
                catch (Exception rootCauseException) {
                    if (!exception.equals(new Exception())) {
                        rootCauseException.addSuppressed(exception);
                    }
                    ElementActionsHelper.failAction(this.driver, sourceElementLocator, rootCauseException);
                }
                endLocation = ((WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, sourceElementLocator).get(1)).getLocation().toString();
                if (!endLocation.equals(startLocation)) {
                    ElementActionsHelper.passAction(this.driver, sourceElementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), reportMessage, null, elementName);
                } else {
                    ElementActionsHelper.failAction(this.driver, reportMessage, sourceElementLocator, new Throwable[0]);
                }
            }
            catch (Throwable throwable) {
                ElementActionsHelper.failAction(this.driver, sourceElementLocator, throwable);
            }
        }
        return this;
    }

    public ElementActions dragAndDropByOffset(By sourceElementLocator, int xOffset, int yOffset) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, sourceElementLocator);
            WebElement sourceElement = (WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, sourceElementLocator).get(1);
            String startLocation = sourceElement.getLocation().toString();
            try {
                new Actions(this.driver).dragAndDropBy((WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, sourceElementLocator).get(1), xOffset, yOffset).build().perform();
            }
            catch (Exception rootCauseException) {
                ElementActionsHelper.failAction(this.driver, sourceElementLocator, rootCauseException);
            }
            String endLocation = ((WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, sourceElementLocator).get(1)).getLocation().toString();
            if (!endLocation.equals(startLocation)) {
                ElementActionsHelper.passAction(this.driver, sourceElementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), "Start point: " + startLocation + ", End point: " + endLocation, null, elementName);
            } else {
                ElementActionsHelper.failAction(this.driver, "Start point = End point: " + endLocation, sourceElementLocator, new Throwable[0]);
            }
        }
        catch (Exception throwable) {
            ElementActionsHelper.failAction(this.driver, sourceElementLocator, throwable);
        }
        return this;
    }

    public String getAttribute(By elementLocator, String attributeName) {
        ReportManager.logDiscrete("Attempting to getAttribute \"" + attributeName + "\" from elementLocator \"" + String.valueOf(elementLocator) + "\".");
        try {
            ElementInformation elementInformation = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElementIgnoringVisibility(this.driver, elementLocator, new Object[]{ElementAction.GET_ATTRIBUTE, attributeName}));
            try {
                String elementAttribute = elementInformation.getActionResult();
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), elementAttribute, null, elementInformation.getElementName());
                return elementAttribute;
            }
            catch (UnsupportedCommandException rootCauseException) {
                ElementActionsHelper.failAction(this.driver, elementLocator, rootCauseException);
                return null;
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
            return null;
        }
    }

    public String getCSSProperty(By elementLocator, String propertyName) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            String elementCssProperty = ((WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, elementLocator).get(1)).getCssValue(propertyName);
            ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), elementCssProperty, null, elementName);
            return elementCssProperty;
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
            return null;
        }
    }

    public String getText(By elementLocator) {
        try {
            String elementText;
            ElementInformation elementInformation = ElementInformation.fromList(ElementActionsHelper.identifyUniqueElementIgnoringVisibility(this.driver, elementLocator));
            String elementName = elementInformation.getElementName();
            try {
                elementText = elementInformation.getFirstElement().getText();
            }
            catch (WebDriverException webDriverException) {
                elementText = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElementIgnoringVisibility(this.driver, elementInformation.getLocator(), new Object[]{ElementAction.GET_TEXT})).getActionResult();
            }
            if ((elementText == null || elementText.isBlank()) && !DriverFactoryHelper.isMobileNativeExecution()) {
                try {
                    elementText = elementInformation.getFirstElement().getAttribute(ElementActionsHelper.TextDetectionStrategy.CONTENT.getValue());
                }
                catch (WebDriverException webDriverException) {
                    elementText = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElementIgnoringVisibility(this.driver, elementInformation.getLocator(), new Object[]{ElementAction.GET_CONTENT})).getActionResult();
                }
            }
            if ((elementText == null || elementText.isBlank()) && !DriverFactoryHelper.isMobileNativeExecution()) {
                try {
                    elementText = elementInformation.getFirstElement().getAttribute(ElementActionsHelper.TextDetectionStrategy.VALUE.getValue());
                }
                catch (WebDriverException webDriverException) {
                    elementText = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElementIgnoringVisibility(this.driver, elementInformation.getLocator(), new Object[]{ElementAction.GET_VALUE})).getActionResult();
                }
            }
            if (elementText == null) {
                elementText = "";
            }
            ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), elementText, null, elementName);
            return elementText;
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
            return null;
        }
    }

    public ElementActions hover(By elementLocator) {
        try {
            ElementInformation elementInformation = ElementInformation.fromList(ElementActionsHelper.identifyUniqueElementIgnoringVisibility(this.driver, elementLocator));
            String elementName = elementInformation.getElementName();
            ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElement(this.driver, elementInformation.getLocator(), new Object[]{ElementAction.HOVER})).getActionResult();
            ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, elementName);
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions hoverAndClick(List<By> hoverElementLocators, By clickableElementLocator) {
        hoverElementLocators.forEach(this::hover);
        this.click(clickableElementLocator);
        return this;
    }

    public ElementActions keyPress(By elementLocator, Keys key) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            List<Object> screenshot = ElementActionsHelper.takeScreenshot(this.driver, elementLocator, "keyPress", null, true);
            ((WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, elementLocator).get(1)).sendKeys(new CharSequence[]{key});
            ElementActionsHelper.passAction(this.driver, elementLocator, key.name(), screenshot, elementName);
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, key.name(), elementLocator, throwable);
        }
        return this;
    }

    public ElementActions select(By elementLocator, String valueOrVisibleText) {
        ElementInformation elementInformation = ElementInformation.fromList(ElementActionsHelper.identifyUniqueElement(this.driver, elementLocator));
        String elementTag = elementInformation.getElementTag();
        if (!elementTag.equals("select")) {
            if (SHAFT.Properties.flags.handleNonSelectDropDown()) {
                this.click(elementInformation.getLocator());
                elementInformation = ElementInformation.fromList(ElementActionsHelper.identifyUniqueElement(this.driver, elementLocator));
                try {
                    RelativeLocator.RelativeBy relativeBy = SHAFT.GUI.Locator.hasAnyTagName().and().containsText(valueOrVisibleText).relativeBy().below(elementInformation.getLocator());
                    elementInformation = ElementInformation.fromList(ElementActionsHelper.identifyUniqueElement(this.driver, (By)relativeBy));
                }
                catch (Throwable var9) {
                    ReportManager.logDiscrete("Cannot Find Element with the following Locator in the DropDown Options: " + String.valueOf(By.xpath((String)("//*[text()='" + valueOrVisibleText + "']"))));
                    ElementActionsHelper.failAction(this.driver, By.xpath((String)("//*[text()='" + valueOrVisibleText + "']")).toString(), elementLocator, var9);
                }
                this.click(elementInformation.getLocator());
            } else {
                ReportManager.logDiscrete("Cannot Find Element with the following Locator in the DropDown Options: " + String.valueOf(By.xpath((String)("//*[text()='" + valueOrVisibleText + "']"))));
                ElementActionsHelper.failAction(this.driver, "Select: ", valueOrVisibleText + "\" from Element :  Tag should be <Select, yet it was found to be <" + elementTag, elementLocator, null, new Throwable[0]);
            }
        } else {
            try {
                String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
                if (!Boolean.TRUE.equals(ElementActionsHelper.waitForElementTextToBeNot(this.driver, elementLocator, ""))) {
                    ElementActionsHelper.failAction(this.driver, valueOrVisibleText, elementLocator, new Throwable[0]);
                }
                boolean isOptionFound = false;
                List availableOptionsList = new Select((WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, elementLocator).get(1)).getOptions();
                for (int i = 0; i < availableOptionsList.size(); ++i) {
                    String visibleText = ((WebElement)availableOptionsList.get(i)).getText();
                    String value = ((WebElement)availableOptionsList.get(i)).getAttribute("value");
                    if (!visibleText.trim().equals(valueOrVisibleText) && !value.trim().equals(valueOrVisibleText)) continue;
                    new Select((WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, elementLocator).get(1)).selectByIndex(i);
                    ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), valueOrVisibleText, null, elementName);
                    isOptionFound = true;
                    break;
                }
                if (Boolean.FALSE.equals(isOptionFound)) {
                    throw new NoSuchElementException("Cannot locate option with Value or Visible text =" + valueOrVisibleText);
                }
            }
            catch (Throwable var9) {
                ElementActionsHelper.failAction(this.driver, valueOrVisibleText, elementLocator, var9);
            }
        }
        return this;
    }

    public ElementActions setValueUsingJavaScript(By elementLocator, String value) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            Boolean valueSetSuccessfully = ElementActionsHelper.setValueUsingJavascript(this.driver, elementLocator, value);
            if (Boolean.TRUE.equals(valueSetSuccessfully)) {
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), value, null, elementName);
            } else {
                ElementActionsHelper.failAction(this.driver, elementLocator, new Throwable[0]);
            }
        }
        catch (Exception throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions submitFormUsingJavaScript(By elementLocator) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            List<Object> screenshot = null;
            try {
                screenshot = ElementActionsHelper.takeScreenshot(this.driver, elementLocator, "submitFormUsingJavaScript", null, true);
                ElementActionsHelper.submitFormUsingJavascript(this.driver, elementLocator);
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), null, Collections.singletonList(screenshot), elementName);
            }
            catch (JavascriptException javascriptException) {
                if (screenshot == null) {
                    screenshot = ElementActionsHelper.takeScreenshot(this.driver, elementLocator, "submitFormUsingJavaScript", null, true);
                }
                this.driver.findElement(elementLocator).submit();
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), null, Collections.singletonList(screenshot), elementName);
            }
            catch (Exception rootCauseException) {
                ElementActionsHelper.failAction(this.driver, elementLocator, rootCauseException);
            }
        }
        catch (Exception throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions switchToIframe(By elementLocator) {
        try {
            ElementInformation elementInformation = ElementInformation.fromList(ElementActionsHelper.identifyUniqueElement(this.driver, elementLocator));
            LocatorBuilder.setIFrameLocator(elementInformation.getLocator());
            this.driver.switchTo().frame(elementInformation.getFirstElement());
            boolean discreetLoggingState = ReportManagerHelper.getDiscreteLogging();
            ReportManagerHelper.setDiscreteLogging(true);
            ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), String.valueOf(elementLocator), null, elementInformation.getElementName());
            ReportManagerHelper.setDiscreteLogging(discreetLoggingState);
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions switchToDefaultContent() {
        try {
            this.driver.switchTo().defaultContent();
            LocatorBuilder.setIFrameLocator(null);
            boolean discreetLoggingState = ReportManagerHelper.getDiscreteLogging();
            ReportManagerHelper.setDiscreteLogging(true);
            ElementActionsHelper.passAction(this.driver, null, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, null);
            ReportManagerHelper.setDiscreteLogging(discreetLoggingState);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public String getCurrentFrame() {
        String currentFrame = (String)((JavascriptExecutor)this.driver).executeScript("return self.name", new Object[0]);
        ReportManager.logDiscrete("Current frame name: \"" + currentFrame + "\"");
        return currentFrame;
    }

    public ElementActions type(By elementLocator, String text) {
        try {
            ElementInformation elementInformation = ElementInformation.fromList(ElementActionsHelper.identifyUniqueElementIgnoringVisibility(this.driver, elementLocator));
            String actualTextAfterTyping = ElementActionsHelper.typeWrapper(this.driver, elementInformation, text);
            String elementName = elementInformation.getElementName();
            if (actualTextAfterTyping.equals(text)) {
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), text, null, elementName);
            } else {
                ElementActionsHelper.failAction(this.driver, "Expected to type: \"" + text + "\", but ended up with: \"" + actualTextAfterTyping + "\"", elementLocator, new Throwable[0]);
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions clear(By elementLocator) {
        try {
            ElementInformation elementInformation = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElement(this.driver, elementLocator, new Object[]{ElementAction.CLEAR}));
            String elementName = elementInformation.getElementName();
            elementInformation.getFirstElement().clear();
            String currentText = this.getText(elementLocator);
            if (currentText.isBlank()) {
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), "", null, elementName);
            } else {
                for (char ignored : currentText.toCharArray()) {
                    try {
                        elementInformation.getFirstElement().sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                    }
                    catch (WebDriverException webDriverException) {
                        ElementActionsHelper.performActionAgainstUniqueElement(this.driver, elementInformation.getLocator(), new Object[]{ElementAction.BACKSPACE});
                    }
                }
                String currentTextAfterClearingUsingBackSpace = this.getText(elementLocator);
                if (currentText.isBlank()) {
                    ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), "", null, elementName);
                } else {
                    ElementActionsHelper.failAction(this.driver, "Expected to clear existing text, but ended up with: \"" + currentText + "\"", elementLocator, new Throwable[0]);
                }
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions typeAppend(By elementLocator, String text) {
        try {
            if (text != null) {
                ElementInformation elementInformation = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElement(this.driver, elementLocator, new Object[]{ElementAction.SEND_KEYS, text}));
                String elementName = elementInformation.getElementName();
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), text, null, elementName);
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions typeFileLocationForUpload(By elementLocator, String filePath) {
        String absoluteFilePath = filePath;
        if (filePath.startsWith("src")) {
            absoluteFilePath = FileActions.getInstance(true).getAbsolutePath(filePath);
        }
        String internalAbsoluteFilePath = absoluteFilePath.replace("/", FileSystems.getDefault().getSeparator());
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            List<Object> screenshot = ElementActionsHelper.takeScreenshot(this.driver, elementLocator, "typeFileLocationForUpload", null, true);
            try {
                ((WebElement)ElementActionsHelper.identifyUniqueElementIgnoringVisibility(this.driver, elementLocator).get(1)).sendKeys(new CharSequence[]{internalAbsoluteFilePath});
            }
            catch (InvalidArgumentException e) {
                ElementActionsHelper.failAction(this.driver, internalAbsoluteFilePath, elementLocator, e);
            }
            catch (ElementNotInteractableException | NoSuchElementException exception1) {
                ElementActionsHelper.changeWebElementVisibilityUsingJavascript(this.driver, elementLocator, true);
                try {
                    ((WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, elementLocator).get(1)).sendKeys(new CharSequence[]{internalAbsoluteFilePath});
                }
                catch (WebDriverException rootCauseException) {
                    rootCauseException.addSuppressed(exception1);
                    ElementActionsHelper.failAction(this.driver, internalAbsoluteFilePath, elementLocator, rootCauseException);
                }
                try {
                    ElementActionsHelper.changeWebElementVisibilityUsingJavascript(this.driver, elementLocator, false);
                }
                catch (NoSuchElementException | StaleElementReferenceException e) {
                    ReportManagerHelper.logDiscrete(e);
                }
            }
            ElementActionsHelper.passAction(this.driver, elementLocator, internalAbsoluteFilePath, screenshot, elementName);
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions typeSecure(By elementLocator, String text) {
        try {
            ElementInformation elementInformation = ElementInformation.fromList(ElementActionsHelper.identifyUniqueElementIgnoringVisibility(this.driver, elementLocator));
            String actualResult = ElementActionsHelper.typeWrapper(this.driver, elementInformation, text);
            String elementName = elementInformation.getElementName();
            if (actualResult.equals(text)) {
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), "\u2022".repeat(text.length()), null, elementName);
            } else {
                ElementActionsHelper.failAction(this.driver, "Expected to type: \"" + text + "\", but ended up with: \"" + actualResult + "\"", elementLocator, new Throwable[0]);
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions waitToBeReady(By elementLocator) {
        return this.waitToBeReady(elementLocator, true);
    }

    public ElementActions waitToBeReady(By elementLocator, boolean isExpectedToBeVisible) {
        ReportManager.logDiscrete("Waiting for element to be present; elementLocator \"" + String.valueOf(elementLocator) + "\", isExpectedToBeVisible\"" + isExpectedToBeVisible + "\"...");
        String reportMessage = "Waited for the element's state of visibility to be (" + isExpectedToBeVisible + "). Element locator (" + ElementActionsHelper.formatLocatorToString(elementLocator) + ")";
        try {
            ElementInformation elementInformation = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElementIgnoringVisibility(this.driver, elementLocator, new Object[]{ElementAction.IS_DISPLAYED}));
            boolean isDisplayed = Boolean.parseBoolean(elementInformation.getActionResult());
            if (isExpectedToBeVisible == isDisplayed) {
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), reportMessage, null, elementInformation.getElementName());
            } else if (!isExpectedToBeVisible && isDisplayed) {
                if (ElementActionsHelper.waitForElementInvisibility(this.driver, elementLocator)) {
                    ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), reportMessage, null, elementInformation.getElementName());
                } else {
                    ElementActionsHelper.failAction(this.driver, reportMessage, elementLocator, new Throwable[0]);
                }
            } else {
                ElementActionsHelper.failAction(this.driver, reportMessage, elementLocator, new Throwable[0]);
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, reportMessage, null, throwable);
        }
        return this;
    }

    public ElementActions waitToBeInvisible(By elementLocator) {
        return this.waitToBeReady(elementLocator, false);
    }

    public ElementActions waitForTextToChange(By elementLocator, String initialValue) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            if (!Boolean.TRUE.equals(ElementActionsHelper.waitForElementTextToBeNot(this.driver, elementLocator, initialValue))) {
                ElementActionsHelper.failAction(this.driver, initialValue, elementLocator, new Throwable[0]);
            }
            try {
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), "from: \"" + initialValue + "\", to: \"" + this.getText(elementLocator) + "\"", null, elementName);
            }
            catch (Exception e) {
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), "from: \"" + initialValue + "\", to a new value.", null, elementName);
            }
        }
        catch (Exception throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public ElementActions waitToAttribute(By elementLocator, String att, String expectedAttValue) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            if (Boolean.FALSE.equals(ElementActionsHelper.waitForElementAttributeToBe(this.driver, elementLocator, att, expectedAttValue))) {
                ElementActionsHelper.failAction(this.driver, elementLocator, new Throwable[0]);
            }
            ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), "wait for element attribute \"" + att + "\" to be \"" + expectedAttValue + "\"", null, elementName);
        }
        catch (Exception throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
        }
        return this;
    }

    public boolean isElementDisplayed(By elementLocator) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            boolean isDisplayed = ((WebElement)ElementActionsHelper.identifyUniqueElement(this.driver, elementLocator).get(1)).isDisplayed();
            ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, elementName);
            return isDisplayed;
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
            return false;
        }
    }

    public boolean isElementClickable(By elementLocator) {
        try {
            String elementName = ElementActionsHelper.getElementName(this.driver, elementLocator);
            if (ElementActionsHelper.waitForElementToBeClickable(this.driver, elementLocator, "")) {
                ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), "element is clickable", null, elementName);
                return true;
            }
            ElementActionsHelper.passAction(this.driver, elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), "element is not clickable", null, elementName);
            return false;
        }
        catch (Exception throwable) {
            ElementActionsHelper.failAction(this.driver, elementLocator, throwable);
            return false;
        }
    }

    public List<Map<String, String>> getTableRowsData(By tableLocator) {
        ArrayList<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
        WebDriverWait wait = new WebDriverWait(this.driver, Duration.ofSeconds(10L));
        try {
            wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)tableLocator));
        }
        catch (Exception throwable) {
            ElementActionsHelper.failAction(this.driver, tableLocator, throwable);
            return null;
        }
        WebElement table = this.driver.findElement(tableLocator);
        try {
            wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"tbody tr")));
        }
        catch (Exception e) {
            ReportManager.logDiscrete("Table\"" + String.valueOf(tableLocator) + "\" is empty");
            return new ArrayList<Map<String, String>>();
        }
        List rows = table.findElement(By.tagName((String)"tbody")).findElements(By.tagName((String)"tr"));
        List headerCells = table.findElement(By.tagName((String)"thead")).findElements(By.tagName((String)"th"));
        for (WebElement row : rows) {
            WebElement currentRow = (WebElement)wait.until((Function)ExpectedConditions.visibilityOf((WebElement)row));
            List cells = row.findElements(By.tagName((String)"td"));
            HashMap<String, String> rowData = new HashMap<String, String>();
            for (int cellIndex = 0; cellIndex < cells.size(); ++cellIndex) {
                String columnName = ((WebElement)headerCells.get(cellIndex)).getText();
                String cellValue = ((WebElement)cells.get(cellIndex)).getText();
                rowData.put(columnName, cellValue);
            }
            tableData.add(rowData);
        }
        return tableData;
    }

    public ElementActions captureScreenshot(By elementLocator) {
        ReportManagerHelper.log("Capture element screenshot", Collections.singletonList(ScreenshotManager.prepareImageForReport(ScreenshotManager.takeScreenshot(this.driver, elementLocator, Screenshots.ELEMENT), "captureScreenshot")));
        return this;
    }

    public ElementActions waitUntilNumberOfElementsToBe(By elementLocator, int numberOfElements) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.numberOfElementsToBe((By)elementLocator, (Integer)numberOfElements), ElementActionsHelper.ELEMENT_IDENTIFICATION_TIMEOUT_INTEGER);
        return this;
    }

    public ElementActions waitUntilNumberOfElementsToBeLessThan(By elementLocator, int numberOfElements) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.numberOfElementsToBeLessThan((By)elementLocator, (Integer)numberOfElements), ElementActionsHelper.ELEMENT_IDENTIFICATION_TIMEOUT_INTEGER);
        return this;
    }

    public ElementActions waitUntilNumberOfElementsToBeMoreThan(By elementLocator, int numberOfElements) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.numberOfElementsToBeMoreThan((By)elementLocator, (Integer)numberOfElements), ElementActionsHelper.ELEMENT_IDENTIFICATION_TIMEOUT_INTEGER);
        return this;
    }

    public ElementActions waitUntilAttributeContains(By elementLocator, String attribute, String attributeContainsValue) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.attributeContains((By)elementLocator, (String)attribute, (String)attributeContainsValue), ElementActionsHelper.ELEMENT_IDENTIFICATION_TIMEOUT_INTEGER);
        return this;
    }

    public ElementActions waitUntilElementTextToBe(By elementLocator, String text) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.textToBe((By)elementLocator, (String)text), ElementActionsHelper.ELEMENT_IDENTIFICATION_TIMEOUT_INTEGER);
        return this;
    }

    public ElementActions waitUntilElementToBeSelected(By elementLocator) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.elementToBeSelected((By)elementLocator), ElementActionsHelper.ELEMENT_IDENTIFICATION_TIMEOUT_INTEGER);
        return this;
    }

    public ElementActions waitUntilPresenceOfAllElementsLocatedBy(By elementLocator) {
        new WaitActions(this.helper).explicitWaits((Function<? super WebDriver, ?>)ExpectedConditions.presenceOfAllElementsLocatedBy((By)elementLocator), ElementActionsHelper.ELEMENT_IDENTIFICATION_TIMEOUT_INTEGER);
        return this;
    }
}

