/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.element;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.driver.internal.FluentWebDriverAction;
import com.shaft.driver.internal.WizardHelpers;
import com.shaft.gui.element.internal.ElementActionsHelper;
import com.shaft.gui.internal.image.ScreenshotManager;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import com.shaft.validation.internal.WebDriverElementValidationsBuilder;
import io.appium.java_client.AppiumBy;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.Pause;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.interactions.WheelInput;
import org.openqa.selenium.remote.RemoteWebDriver;

public class TouchActions
extends FluentWebDriverAction {
    private static final int DEFAULT_NUMBER_OF_ATTEMPTS_TO_SCROLL_TO_ELEMENT = 5;
    private static final boolean CAPTURE_CLICKED_ELEMENT_TEXT = SHAFT.Properties.reporting.captureElementName();

    public TouchActions() {
        this.initialize();
    }

    public TouchActions(WebDriver driver) {
        this.initialize(driver);
    }

    public TouchActions(DriverFactoryHelper helper) {
        this.initialize(helper);
    }

    @Override
    public TouchActions and() {
        return this;
    }

    public WebDriverElementValidationsBuilder assertThat(By elementLocator) {
        return new WizardHelpers.WebDriverAssertions(this.helper).element(elementLocator);
    }

    public WebDriverElementValidationsBuilder verifyThat(By elementLocator) {
        return new WizardHelpers.WebDriverVerifications(this.helper).element(elementLocator);
    }

    public TouchActions nativeKeyboardKeyPress(KeyboardKeys key) {
        try {
            ((RemoteWebDriver)this.helper.getDriver()).executeScript("mobile: performEditorAction", new Object[]{key.getValue()});
            ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), key.name(), null, null);
        }
        catch (Exception rootCauseException) {
            ElementActionsHelper.failAction(this.helper.getDriver(), null, rootCauseException);
        }
        return this;
    }

    public TouchActions hideNativeKeyboard() {
        try {
            WebDriver webDriver = this.helper.getDriver();
            if (webDriver instanceof AndroidDriver) {
                AndroidDriver androidDriver = (AndroidDriver)webDriver;
                androidDriver.hideKeyboard();
            } else {
                webDriver = this.helper.getDriver();
                if (webDriver instanceof IOSDriver) {
                    IOSDriver iosDriver = (IOSDriver)webDriver;
                    iosDriver.hideKeyboard();
                } else {
                    ElementActionsHelper.failAction(this.helper.getDriver(), null, new Throwable[0]);
                }
            }
        }
        catch (Exception rootCauseException) {
            ElementActionsHelper.failAction(this.helper.getDriver(), null, rootCauseException);
        }
        ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, null);
        return this;
    }

    public TouchActions tap(String elementReferenceScreenshot) {
        List<Object> objects = ElementActionsHelper.waitForElementPresence(this.helper.getDriver(), elementReferenceScreenshot);
        byte[] currentScreenImage = (byte[])objects.get(0);
        byte[] referenceImage = (byte[])objects.get(1);
        List coordinates = (List)objects.get(2);
        List<Object> screenshot = ScreenshotManager.prepareImageForReport(currentScreenImage, "tap - Current Screen Image");
        List<Object> referenceScreenshot = ScreenshotManager.prepareImageForReport(referenceImage, "tap - Reference Screenshot");
        LinkedList<List<Object>> attachments = new LinkedList<List<Object>>();
        attachments.add(referenceScreenshot);
        attachments.add(screenshot);
        if (Collections.emptyList().equals(coordinates)) {
            ElementActionsHelper.failAction(this.helper.getDriver(), "Couldn't find reference element on the current screen. If you can see it in the attached image then kindly consider cropping it and updating your reference image under this path \"" + elementReferenceScreenshot + "\".", null, attachments, new Throwable[0]);
        } else {
            PointerInput input = new PointerInput(PointerInput.Kind.TOUCH, "finger1");
            Sequence tap = new Sequence((InputSource)input, 0);
            tap.addAction(input.createPointerMove(Duration.ZERO, PointerInput.Origin.viewport(), ((Integer)coordinates.get(0)).intValue(), ((Integer)coordinates.get(1)).intValue()));
            tap.addAction(input.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
            tap.addAction((Interaction)new Pause((InputSource)input, Duration.ofMillis(200L)));
            tap.addAction(input.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
            try {
                ((RemoteWebDriver)this.helper.getDriver()).perform((Collection)ImmutableList.of((Object)tap));
            }
            catch (UnsupportedCommandException exception) {
                ElementActionsHelper.failAction(this.helper.getDriver(), null, exception);
            }
            ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), null, attachments, null);
        }
        return this;
    }

    public TouchActions tap(By elementLocator) {
        try {
            String elementText = "";
            if (CAPTURE_CLICKED_ELEMENT_TEXT) {
                try {
                    elementText = DriverFactoryHelper.isMobileNativeExecution() ? ((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), elementLocator).get(1)).getAttribute("text") : ((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), elementLocator).get(1)).getText();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            List<Object> screenshot = ElementActionsHelper.takeScreenshot(this.helper.getDriver(), elementLocator, "tap", null, true);
            try {
                ((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), elementLocator).get(1)).click();
            }
            catch (Exception e) {
                ElementActionsHelper.failAction(this.helper.getDriver(), elementLocator, e);
            }
            if (elementText == null || elementText.isEmpty()) {
                elementText = ElementActionsHelper.formatLocatorToString(elementLocator);
            }
            ElementActionsHelper.passAction(this.helper.getDriver(), elementLocator, elementText.replaceAll("\n", " "), screenshot, null);
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.helper.getDriver(), elementLocator, throwable);
        }
        return this;
    }

    public TouchActions doubleTap(By elementLocator) {
        try {
            String elementText = "";
            try {
                elementText = ((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), elementLocator).get(1)).getText();
            }
            catch (Exception exception) {
                // empty catch block
            }
            List<Object> screenshot = ElementActionsHelper.takeScreenshot(this.helper.getDriver(), elementLocator, "doubleTap", null, true);
            LinkedList<List<Object>> attachments = new LinkedList<List<Object>>();
            attachments.add(screenshot);
            try {
                new Actions(this.helper.getDriver()).doubleClick((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), elementLocator).get(1)).perform();
            }
            catch (Exception e) {
                ElementActionsHelper.failAction(this.helper.getDriver(), elementLocator, e);
            }
            if (elementText != null && !elementText.isEmpty()) {
                ElementActionsHelper.passAction(this.helper.getDriver(), elementLocator, elementText.replaceAll("\n", " "), screenshot, null);
            } else {
                ElementActionsHelper.passAction(this.helper.getDriver(), elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), null, attachments, null);
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.helper.getDriver(), elementLocator, throwable);
        }
        return this;
    }

    public TouchActions longTap(By elementLocator) {
        try {
            String elementText = "";
            try {
                elementText = ((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), elementLocator).get(1)).getText();
            }
            catch (Exception exception) {
                // empty catch block
            }
            List<Object> screenshot = ElementActionsHelper.takeScreenshot(this.helper.getDriver(), elementLocator, "longPress", null, true);
            LinkedList<List<Object>> attachments = new LinkedList<List<Object>>();
            attachments.add(screenshot);
            try {
                new Actions(this.helper.getDriver()).clickAndHold((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), elementLocator).get(1)).perform();
            }
            catch (Exception e) {
                ElementActionsHelper.failAction(this.helper.getDriver(), elementLocator, e);
            }
            if (elementText != null && !elementText.isEmpty()) {
                ElementActionsHelper.passAction(this.helper.getDriver(), elementLocator, elementText.replaceAll("\n", " "), screenshot, null);
            } else {
                ElementActionsHelper.passAction(this.helper.getDriver(), elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), null, attachments, null);
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.helper.getDriver(), elementLocator, throwable);
        }
        return this;
    }

    public TouchActions sendAppToBackground(int secondsToSpendInTheBackground) {
        if (DriverFactoryHelper.isMobileNativeExecution()) {
            WebDriver webDriver = this.helper.getDriver();
            if (webDriver instanceof AndroidDriver) {
                AndroidDriver androidDriver = (AndroidDriver)webDriver;
                androidDriver.runAppInBackground(Duration.ofSeconds(secondsToSpendInTheBackground));
            } else {
                webDriver = this.helper.getDriver();
                if (webDriver instanceof IOSDriver) {
                    IOSDriver iosDriver = (IOSDriver)webDriver;
                    iosDriver.runAppInBackground(Duration.ofSeconds(secondsToSpendInTheBackground));
                } else {
                    ElementActionsHelper.failAction(this.helper.getDriver(), null, new Throwable[0]);
                }
            }
            ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, null);
        } else {
            ElementActionsHelper.failAction(this.helper.getDriver(), null, new Throwable[0]);
        }
        return this;
    }

    public TouchActions sendAppToBackground() {
        return this.sendAppToBackground(-1);
    }

    public TouchActions activateAppFromBackground(String appPackageName) {
        if (DriverFactoryHelper.isMobileNativeExecution()) {
            WebDriver webDriver = this.helper.getDriver();
            if (webDriver instanceof AndroidDriver) {
                AndroidDriver androidDriver = (AndroidDriver)webDriver;
                androidDriver.activateApp(appPackageName);
            } else {
                webDriver = this.helper.getDriver();
                if (webDriver instanceof IOSDriver) {
                    IOSDriver iosDriver = (IOSDriver)webDriver;
                    iosDriver.activateApp(appPackageName);
                } else {
                    ElementActionsHelper.failAction(this.helper.getDriver(), null, new Throwable[0]);
                }
            }
            ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, null);
        } else {
            ElementActionsHelper.failAction(this.helper.getDriver(), null, new Throwable[0]);
        }
        return this;
    }

    public TouchActions swipeToElement(By sourceElementLocator, By destinationElementLocator) {
        try {
            WebElement sourceElement = (WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), sourceElementLocator).get(1);
            WebElement destinationElement = (WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), destinationElementLocator).get(1);
            String startLocation = sourceElement.getLocation().toString();
            try {
                new Actions(this.helper.getDriver()).dragAndDrop(sourceElement, destinationElement).perform();
            }
            catch (Exception e) {
                ElementActionsHelper.failAction(this.helper.getDriver(), sourceElementLocator, e);
            }
            String endLocation = ((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), sourceElementLocator).get(1)).getLocation().toString();
            String reportMessage = "Start point: " + startLocation + ", End point: " + endLocation;
            if (SHAFT.Properties.flags.validateSwipeToElement()) {
                if (!endLocation.equals(startLocation)) {
                    ElementActionsHelper.passAction(this.helper.getDriver(), sourceElementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), reportMessage, null, null);
                } else {
                    ElementActionsHelper.failAction(this.helper.getDriver(), reportMessage, sourceElementLocator, new Throwable[0]);
                }
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.helper.getDriver(), sourceElementLocator, throwable);
        }
        return this;
    }

    public TouchActions swipeByOffset(By elementLocator, int xOffset, int yOffset) {
        try {
            WebElement sourceElement = (WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), elementLocator).get(1);
            Point elementLocation = sourceElement.getLocation();
            String startLocation = elementLocation.toString();
            try {
                new Actions(this.helper.getDriver()).dragAndDropBy(sourceElement, xOffset, yOffset).perform();
            }
            catch (Exception e) {
                ElementActionsHelper.failAction(this.helper.getDriver(), elementLocator, e);
            }
            String endLocation = ((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), elementLocator).get(1)).getLocation().toString();
            String reportMessage = "Start point: " + startLocation + ", End point: " + endLocation;
            if (!endLocation.equals(startLocation)) {
                ElementActionsHelper.passAction(this.helper.getDriver(), elementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), reportMessage, null, null);
            } else {
                ElementActionsHelper.failAction(this.helper.getDriver(), reportMessage, elementLocator, new Throwable[0]);
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.helper.getDriver(), elementLocator, throwable);
        }
        return this;
    }

    public TouchActions swipeElementIntoView(By targetElementLocator, SwipeDirection swipeDirection) {
        return this.swipeElementIntoView(null, targetElementLocator, swipeDirection);
    }

    public TouchActions waitUntilElementIsVisible(String elementReferenceScreenshot) {
        List<Object> visualIdentificationObjects = ElementActionsHelper.waitForElementPresence(this.helper.getDriver(), elementReferenceScreenshot);
        byte[] currentScreenImage = (byte[])visualIdentificationObjects.get(0);
        byte[] referenceImage = (byte[])visualIdentificationObjects.get(1);
        List coordinates = (List)visualIdentificationObjects.get(2);
        List<Object> screenshot = ScreenshotManager.prepareImageForReport(currentScreenImage, "waitUntilElementIsVisible - Current Screen Image");
        List<Object> referenceScreenshot = ScreenshotManager.prepareImageForReport(referenceImage, "waitUntilElementIsVisible - Reference Screenshot");
        LinkedList<List<Object>> attachments = new LinkedList<List<Object>>();
        attachments.add(referenceScreenshot);
        attachments.add(screenshot);
        if (!Collections.emptyList().equals(coordinates)) {
            ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), null, attachments, null);
        } else {
            ElementActionsHelper.failAction(this.helper.getDriver(), "Couldn't find reference element on the current screen. If you can see it in the attached image then kindly consider cropping it and updating your reference image under this path \"" + elementReferenceScreenshot + "\".", null, attachments, new Throwable[0]);
        }
        return this;
    }

    public TouchActions swipeElementIntoView(String elementReferenceScreenshot, SwipeDirection swipeDirection) {
        return this.swipeElementIntoView(null, elementReferenceScreenshot, swipeDirection);
    }

    public TouchActions swipeElementIntoView(By scrollableElementLocator, String elementReferenceScreenshot, SwipeDirection swipeDirection) {
        LinkedList<List<Object>> attachments = new LinkedList<List<Object>>();
        try {
            try {
                WebDriver webDriver = this.helper.getDriver();
                if (webDriver instanceof AppiumDriver) {
                    AppiumDriver appiumDriver = (AppiumDriver)webDriver;
                    List<Object> visualIdentificationObjects = this.attemptToSwipeElementIntoViewInNativeApp(scrollableElementLocator, elementReferenceScreenshot, swipeDirection);
                    byte[] currentScreenImage = (byte[])visualIdentificationObjects.get(0);
                    byte[] referenceImage = (byte[])visualIdentificationObjects.get(1);
                    List coordinates = (List)visualIdentificationObjects.get(2);
                    List<Object> screenshot = ScreenshotManager.prepareImageForReport(currentScreenImage, "swipeElementIntoView - Current Screen Image");
                    List<Object> referenceScreenshot = ScreenshotManager.prepareImageForReport(referenceImage, "swipeElementIntoView - Reference Screenshot");
                    attachments = new LinkedList();
                    attachments.add(referenceScreenshot);
                    attachments.add(screenshot);
                    if (Collections.emptyList().equals(coordinates)) {
                        ElementActionsHelper.failAction(this.helper.getDriver(), "Couldn't find reference element on the current screen. If you can see it in the attached image then kindly consider cropping it and updating your reference image.", null, attachments, new Throwable[0]);
                    }
                } else {
                    List<Object> objects = ElementActionsHelper.waitForElementPresence(this.helper.getDriver(), elementReferenceScreenshot);
                    byte[] currentScreenImage = (byte[])objects.get(0);
                    byte[] referenceImage = (byte[])objects.get(1);
                    List coordinates = (List)objects.get(2);
                    List<Object> screenshot = ScreenshotManager.prepareImageForReport(currentScreenImage, "swipeElementIntoView - Current Screen Image");
                    List<Object> referenceScreenshot = ScreenshotManager.prepareImageForReport(referenceImage, "swipeElementIntoView - Reference Screenshot");
                    attachments = new LinkedList();
                    attachments.add(referenceScreenshot);
                    attachments.add(screenshot);
                    if (Collections.emptyList().equals(coordinates)) {
                        ElementActionsHelper.failAction(this.helper.getDriver(), "Couldn't find reference element on the current screen. If you can see it in the attached image then kindly consider cropping it and updating your reference image.", null, attachments, new Throwable[0]);
                    } else {
                        new Actions(this.helper.getDriver()).scrollFromOrigin(WheelInput.ScrollOrigin.fromViewport(), ((Integer)coordinates.get(0)).intValue(), ((Integer)coordinates.get(1)).intValue()).perform();
                    }
                }
                ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), null, attachments, null);
            }
            catch (AssertionError assertionError) {
                throw assertionError;
            }
            catch (Exception exception) {
                ElementActionsHelper.failAction(this.helper.getDriver(), "Couldn't find reference element on the current screen. If you can see it in the attached image then kindly consider cropping it and updating your reference image.", null, attachments, exception);
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.helper.getDriver(), scrollableElementLocator, throwable);
        }
        return this;
    }

    public TouchActions swipeElementIntoView(By scrollableElementLocator, By targetElementLocator, SwipeDirection swipeDirection) {
        try {
            try {
                WebDriver webDriver = this.helper.getDriver();
                if (webDriver instanceof AppiumDriver) {
                    AppiumDriver appiumDriver = (AppiumDriver)webDriver;
                    boolean isElementFound = this.attemptToSwipeElementIntoViewInNativeApp(scrollableElementLocator, targetElementLocator, swipeDirection);
                    if (Boolean.FALSE.equals(isElementFound)) {
                        ElementActionsHelper.failAction((WebDriver)appiumDriver, targetElementLocator, new Throwable[0]);
                    }
                } else if (scrollableElementLocator != null) {
                    new Actions(this.helper.getDriver()).moveToElement((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), scrollableElementLocator).get(1)).scrollToElement((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), targetElementLocator).get(1)).perform();
                } else {
                    new Actions(this.helper.getDriver()).scrollToElement((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), targetElementLocator).get(1)).perform();
                }
                ElementActionsHelper.passAction(this.helper.getDriver(), targetElementLocator, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, null);
            }
            catch (Exception e) {
                ElementActionsHelper.failAction(this.helper.getDriver(), targetElementLocator, e);
            }
        }
        catch (Throwable throwable) {
            ElementActionsHelper.failAction(this.helper.getDriver(), scrollableElementLocator, throwable);
        }
        return this;
    }

    public TouchActions swipeElementIntoView(String targetText) {
        this.helper.getDriver().findElement(AppiumBy.androidUIAutomator((String)("new UiScrollable(new UiSelector().scrollable(true)).scrollIntoView(new UiSelector().textContains(\"" + targetText + "\"))")));
        return this;
    }

    public TouchActions swipeElementIntoView(String targetText, SwipeMovement movement) {
        switch (movement.ordinal()) {
            case 1: {
                this.helper.getDriver().findElement(AppiumBy.androidUIAutomator((String)("new UiScrollable(new UiSelector().scrollable(true)).scrollIntoView(new UiSelector().textContains(\"" + targetText + "\"))")));
                break;
            }
            case 0: {
                this.helper.getDriver().findElement(AppiumBy.androidUIAutomator((String)("new UiScrollable(new UiSelector()).setAsHorizontalList().scrollIntoView(new UiSelector().textContains(\"" + targetText + "\"));")));
            }
        }
        return this;
    }

    public TouchActions rotate(ScreenOrientation orientation) {
        ((AndroidDriver)this.helper.getDriver()).rotate(orientation);
        return this;
    }

    private List<Object> attemptToSwipeElementIntoViewInNativeApp(By scrollableElementLocator, String targetElementImage, SwipeDirection swipeDirection) {
        List<Object> visualIdentificationObjects;
        boolean isElementFound = false;
        boolean canStillScroll = true;
        boolean isDiscrete = ReportManagerHelper.getDiscreteLogging();
        ReportManagerHelper.setDiscreteLogging(true);
        int blindScrollingAttempts = 0;
        do {
            visualIdentificationObjects = ElementActionsHelper.waitForElementPresence(this.helper.getDriver(), targetElementImage);
            List coordinates = (List)visualIdentificationObjects.get(2);
            if (!Collections.emptyList().equals(coordinates)) {
                isElementFound = true;
                ReportManager.logDiscrete("Element found on screen.");
                continue;
            }
            ElementActionsHelper.takeScreenshot(this.helper.getDriver(), null, "swipeElementIntoView", null, true);
            canStillScroll = this.attemptW3cCompliantActionsScroll(swipeDirection, scrollableElementLocator, null);
            if (canStillScroll) continue;
            visualIdentificationObjects = ElementActionsHelper.waitForElementPresence(this.helper.getDriver(), targetElementImage);
            coordinates = (List)visualIdentificationObjects.get(2);
            if (Collections.emptyList().equals(coordinates)) continue;
            isElementFound = true;
            ReportManager.logDiscrete("Element found on screen.");
        } while (Boolean.FALSE.equals(isElementFound) && (++blindScrollingAttempts < 5 || Boolean.TRUE.equals(canStillScroll)));
        ReportManagerHelper.setDiscreteLogging(isDiscrete);
        return visualIdentificationObjects;
    }

    private boolean attemptToSwipeElementIntoViewInNativeApp(By scrollableElementLocator, By targetElementLocator, SwipeDirection swipeDirection) {
        boolean isElementFound = false;
        boolean canStillScroll = true;
        boolean isDiscrete = ReportManagerHelper.getDiscreteLogging();
        ReportManagerHelper.setDiscreteLogging(true);
        int blindScrollingAttempts = 0;
        do {
            if (ElementActionsHelper.waitForElementPresenceWithReducedTimeout(this.helper.getDriver(), targetElementLocator) > 0) {
                isElementFound = true;
                ReportManager.logDiscrete("Element found on screen.");
                continue;
            }
            ElementActionsHelper.takeScreenshot(this.helper.getDriver(), null, "swipeElementIntoView", null, true);
            canStillScroll = this.attemptW3cCompliantActionsScroll(swipeDirection, scrollableElementLocator, targetElementLocator);
            if (canStillScroll || ElementActionsHelper.waitForElementPresenceWithReducedTimeout(this.helper.getDriver(), targetElementLocator) <= 0) continue;
            isElementFound = true;
            ReportManager.logDiscrete("Element found on screen.");
        } while (Boolean.FALSE.equals(isElementFound) && (++blindScrollingAttempts < 5 || Boolean.TRUE.equals(canStillScroll)));
        ReportManagerHelper.setDiscreteLogging(isDiscrete);
        return isElementFound;
    }

    private void attemptUISelectorScroll(SwipeDirection swipeDirection, int scrollableElementInstanceNumber) {
        ReportManager.logDiscrete("Swiping to find Element using UiSelector.");
        int scrollingSpeed = 100;
        String scrollDirection = "Forward";
        ReportManager.logDiscrete("Swiping to find Element using UiSelector.");
        By androidUIAutomator = AppiumBy.androidUIAutomator((String)("new UiScrollable(new UiSelector().scrollable(true).instance(" + scrollableElementInstanceNumber + ")).scroll" + scrollDirection + "(" + scrollingSpeed + ")"));
        ElementActionsHelper.getElementsCount(this.helper.getDriver(), androidUIAutomator);
    }

    private boolean attemptW3cCompliantActionsScroll(SwipeDirection swipeDirection, By scrollableElementLocator, By targetElementLocator) {
        String logMessage = "Swiping to find Element using W3C Compliant Actions. SwipeDirection \"" + String.valueOf((Object)swipeDirection) + "\"";
        if (targetElementLocator != null) {
            logMessage = logMessage + ", TargetElementLocator \"" + String.valueOf(targetElementLocator) + "\"";
        }
        if (scrollableElementLocator != null) {
            logMessage = logMessage + ", inside ScrollableElement \"" + String.valueOf(scrollableElementLocator) + "\"";
        }
        logMessage = logMessage + ".";
        ReportManager.logDiscrete(logMessage);
        Dimension screenSize = this.helper.getDriver().manage().window().getSize();
        boolean canScrollMore = true;
        HashMap scrollParameters = new HashMap();
        if (scrollableElementLocator != null) {
            Rectangle elementRectangle = ((WebElement)ElementActionsHelper.identifyUniqueElement(this.helper.getDriver(), scrollableElementLocator).get(1)).getRect();
            scrollParameters.putAll(ImmutableMap.of((Object)"height", (Object)(elementRectangle.getHeight() * 90 / 100)));
            switch (swipeDirection.ordinal()) {
                case 0: {
                    scrollParameters.putAll(ImmutableMap.of((Object)"percent", (Object)0.8, (Object)"height", (Object)(elementRectangle.getHeight() * 90 / 100), (Object)"width", (Object)elementRectangle.getWidth(), (Object)"left", (Object)elementRectangle.getX(), (Object)"top", (Object)(elementRectangle.getHeight() - 100)));
                    break;
                }
                case 1: {
                    scrollParameters.putAll(ImmutableMap.of((Object)"percent", (Object)0.8, (Object)"height", (Object)(elementRectangle.getHeight() * 90 / 100), (Object)"width", (Object)elementRectangle.getWidth(), (Object)"left", (Object)elementRectangle.getX(), (Object)"top", (Object)100));
                    break;
                }
                case 3: {
                    scrollParameters.putAll(ImmutableMap.of((Object)"percent", (Object)1, (Object)"height", (Object)elementRectangle.getHeight(), (Object)"width", (Object)(elementRectangle.getWidth() * 70 / 100), (Object)"left", (Object)100, (Object)"top", (Object)elementRectangle.getY()));
                    break;
                }
                case 2: {
                    scrollParameters.putAll(ImmutableMap.of((Object)"percent", (Object)1, (Object)"height", (Object)elementRectangle.getHeight(), (Object)"width", (Object)elementRectangle.getWidth(), (Object)"left", (Object)(elementRectangle.getX() + elementRectangle.getWidth() * 50 / 100), (Object)"top", (Object)elementRectangle.getY()));
                }
            }
        } else {
            scrollParameters.putAll(ImmutableMap.of((Object)"width", (Object)screenSize.getWidth(), (Object)"height", (Object)(screenSize.getHeight() * 90 / 100), (Object)"percent", (Object)0.8));
            switch (swipeDirection.ordinal()) {
                case 0: {
                    scrollParameters.putAll(ImmutableMap.of((Object)"left", (Object)0, (Object)"top", (Object)(screenSize.getHeight() - 100)));
                    break;
                }
                case 1: {
                    scrollParameters.putAll(ImmutableMap.of((Object)"left", (Object)0, (Object)"top", (Object)100));
                    break;
                }
                case 3: {
                    scrollParameters.putAll(ImmutableMap.of((Object)"left", (Object)100, (Object)"top", (Object)0));
                    break;
                }
                case 2: {
                    scrollParameters.putAll(ImmutableMap.of((Object)"left", (Object)(screenSize.getWidth() - 100), (Object)"top", (Object)0));
                }
            }
        }
        WebDriver webDriver = this.helper.getDriver();
        if (webDriver instanceof AndroidDriver) {
            AndroidDriver androidDriver = (AndroidDriver)webDriver;
            scrollParameters.putAll(ImmutableMap.of((Object)"direction", (Object)swipeDirection.toString()));
            canScrollMore = (Boolean)androidDriver.executeScript("mobile: scrollGesture", new Object[]{scrollParameters});
        } else {
            webDriver = this.helper.getDriver();
            if (webDriver instanceof IOSDriver) {
                IOSDriver iosDriver = (IOSDriver)webDriver;
                scrollParameters.putAll(ImmutableMap.of((Object)"direction", (Object)swipeDirection.toString()));
                Object ret = iosDriver.executeScript("mobile: scroll", new Object[]{scrollParameters});
                canScrollMore = ret == null || (Boolean)ret != false;
            }
        }
        String logMessageAfter = "Attempted to scroll using these parameters: \"" + String.valueOf(scrollParameters) + "\"";
        logMessageAfter = canScrollMore ? logMessageAfter + ", there is still more room to keep scrolling." : logMessageAfter + ", there is no more room to keep scrolling.";
        ReportManager.logDiscrete(logMessageAfter);
        return canScrollMore;
    }

    private void attemptPinchToZoomIn() {
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
        PointerInput finger2 = new PointerInput(PointerInput.Kind.TOUCH, "finger2");
        Dimension size = this.helper.getDriver().manage().window().getSize();
        Point source = new Point(size.getWidth(), size.getHeight());
        Sequence pinchAndZoom1 = new Sequence((InputSource)finger, 0);
        pinchAndZoom1.addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), source.x / 2, source.y / 2)).addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(110L))).addAction(finger.createPointerMove(Duration.ofMillis(600L), PointerInput.Origin.viewport(), source.x / 3, source.y / 3)).addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        Sequence pinchAndZoom2 = new Sequence((InputSource)finger2, 0);
        pinchAndZoom2.addAction(finger2.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), source.x / 2, source.y / 2)).addAction(finger2.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction(finger2.createPointerMove(Duration.ofMillis(600L), PointerInput.Origin.viewport(), source.x * 3 / 4, source.y * 3 / 4)).addAction(finger2.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        ((RemoteWebDriver)this.helper.getDriver()).perform(Arrays.asList(pinchAndZoom1, pinchAndZoom2));
    }

    private void attemptPinchToZoomOut() {
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
        PointerInput finger2 = new PointerInput(PointerInput.Kind.TOUCH, "finger2");
        Dimension size = this.helper.getDriver().manage().window().getSize();
        Point source = new Point(size.getWidth(), size.getHeight());
        Sequence pinchAndZoom1 = new Sequence((InputSource)finger, 0);
        pinchAndZoom1.addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), source.x / 3, source.y / 3)).addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(110L))).addAction(finger.createPointerMove(Duration.ofMillis(600L), PointerInput.Origin.viewport(), source.x / 2, source.y / 2)).addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        Sequence pinchAndZoom2 = new Sequence((InputSource)finger2, 0);
        pinchAndZoom2.addAction(finger2.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), source.x * 3 / 4, source.y * 3 / 4)).addAction(finger2.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(100L))).addAction(finger2.createPointerMove(Duration.ofMillis(600L), PointerInput.Origin.viewport(), source.x / 2, source.y / 2)).addAction(finger2.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        ((RemoteWebDriver)this.helper.getDriver()).perform(Arrays.asList(pinchAndZoom1, pinchAndZoom2));
    }

    public TouchActions pinchToZoom(ZoomDirection zoomDirection) {
        try {
            switch (zoomDirection.ordinal()) {
                case 0: {
                    this.attemptPinchToZoomIn();
                    break;
                }
                case 1: {
                    this.attemptPinchToZoomOut();
                }
            }
        }
        catch (Exception rootCauseException) {
            ElementActionsHelper.failAction(this.helper.getDriver(), null, rootCauseException);
        }
        ElementActionsHelper.passAction(this.helper.getDriver(), null, Thread.currentThread().getStackTrace()[1].getMethodName(), zoomDirection.name(), null, null);
        return this;
    }

    public static enum KeyboardKeys {
        GO(ImmutableMap.of((Object)"action", (Object)"go")),
        DONE(ImmutableMap.of((Object)"action", (Object)"done")),
        SEARCH(ImmutableMap.of((Object)"action", (Object)"search")),
        SEND(ImmutableMap.of((Object)"action", (Object)"send")),
        NEXT(ImmutableMap.of((Object)"action", (Object)"next")),
        PREVIOUS(ImmutableMap.of((Object)"action", (Object)"previous")),
        NORMAL(ImmutableMap.of((Object)"action", (Object)"normal")),
        UNSPECIFIED(ImmutableMap.of((Object)"action", (Object)"unspecified")),
        NONE(ImmutableMap.of((Object)"action", (Object)"none"));

        private final ImmutableMap<?, ?> value;

        private KeyboardKeys(ImmutableMap<?, ?> type) {
            this.value = type;
        }

        private ImmutableMap<?, ?> getValue() {
            return this.value;
        }
    }

    public static enum SwipeDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    public static enum SwipeMovement {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum ZoomDirection {
        IN,
        OUT;

    }

    public static enum SwipeTechnique {
        W3C_ACTIONS,
        UI_SELECTOR;

    }
}

