/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.element.internal;

import com.google.common.base.Throwables;
import com.shaft.cli.FileActions;
import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.enums.internal.ClipboardAction;
import com.shaft.enums.internal.ElementAction;
import com.shaft.gui.browser.internal.BrowserActionsHelper;
import com.shaft.gui.element.ElementActions;
import com.shaft.gui.element.internal.ElementInformation;
import com.shaft.gui.internal.exceptions.MultipleElementsFoundException;
import com.shaft.gui.internal.image.ImageProcessingActions;
import com.shaft.gui.internal.image.ScreenshotManager;
import com.shaft.gui.internal.locator.LocatorBuilder;
import com.shaft.gui.internal.locator.ShadowLocatorBuilder;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.internal.support.JavaScriptHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportHelper;
import com.shaft.tools.io.internal.ReportManagerHelper;
import com.shaft.validation.internal.ValidationsHelper;
import io.appium.java_client.AppiumDriver;
import java.awt.HeadlessException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.apache.logging.log4j.Level;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementClickInterceptedException;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Platform;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.support.locators.RelativeLocator;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.testng.Assert;

public class ElementActionsHelper {
    public static final String OBFUSCATED_STRING = "\u2022";
    public static final int ELEMENT_IDENTIFICATION_TIMEOUT_INTEGER = (int)SHAFT.Properties.timeouts.defaultElementIdentificationTimeout();
    private static final boolean GET_ELEMENT_HTML = true;
    private static final boolean FORCE_CHECK_FOR_ELEMENT_VISIBILITY = SHAFT.Properties.flags.forceCheckForElementVisibility();
    private static final int ELEMENT_IDENTIFICATION_POLLING_DELAY = 100;
    private static final String WHEN_TO_TAKE_PAGE_SOURCE_SNAPSHOT = SHAFT.Properties.visuals.whenToTakePageSourceSnapshot();

    private ElementActionsHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static int waitForElementPresenceWithReducedTimeout(WebDriver driver, By elementLocator) {
        List<Object> numberOfFoundElements;
        double defaultElementIdentificationTimeout = SHAFT.Properties.timeouts.defaultElementIdentificationTimeout();
        SHAFT.Properties.timeouts.set().defaultElementIdentificationTimeout(0.3);
        try {
            numberOfFoundElements = ElementActionsHelper.waitForElementPresence(driver, elementLocator);
        }
        finally {
            SHAFT.Properties.timeouts.set().defaultElementIdentificationTimeout(defaultElementIdentificationTimeout);
        }
        return Integer.parseInt(numberOfFoundElements.getFirst().toString());
    }

    public static List<Object> waitForElementPresence(WebDriver driver, By elementLocator) {
        return ElementActionsHelper.waitForElementPresence(driver, elementLocator, 1, FORCE_CHECK_FOR_ELEMENT_VISIBILITY, new Object[0]);
    }

    public static List<Object> waitForElementPresence(WebDriver driver, String elementReferenceScreenshot) {
        long startTime = System.currentTimeMillis();
        boolean isFound = false;
        LinkedList<Object> returnedValue = new LinkedList<Object>();
        if (FileActions.getInstance(true).doesFileExist(elementReferenceScreenshot)) {
            List<Integer> coordinates;
            byte[] currentScreenImage;
            long elapsedTime;
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    ReportManagerHelper.logDiscrete(e);
                }
                currentScreenImage = ScreenshotManager.takeScreenshot(driver);
                coordinates = ImageProcessingActions.findImageWithinCurrentPage(elementReferenceScreenshot, currentScreenImage);
                if (!Collections.emptyList().equals(coordinates)) {
                    isFound = true;
                }
                elapsedTime = System.currentTimeMillis() - startTime;
            } while (!isFound && (double)elapsedTime < SHAFT.Properties.timeouts.defaultElementIdentificationTimeout() * 1000.0);
            returnedValue.add(currentScreenImage);
            returnedValue.add(FileActions.getInstance(true).readFileAsByteArray(elementReferenceScreenshot));
            returnedValue.add(coordinates);
        } else {
            ReportManager.log("Reference screenshot not found. Kindly confirm the image exists under this path: \"" + elementReferenceScreenshot + "\"");
            byte[] currentScreenImage = ScreenshotManager.takeScreenshot(driver);
            returnedValue.add(currentScreenImage);
            returnedValue.add(new byte[0]);
            returnedValue.add(Collections.emptyList());
        }
        return returnedValue;
    }

    public static boolean waitForElementInvisibility(WebDriver driver, By elementLocator) {
        new WebDriverWait(driver, Duration.ofMillis((long)(SHAFT.Properties.timeouts.defaultElementIdentificationTimeout() * 1000.0))).until((Function)ExpectedConditions.invisibilityOfElementLocated((By)elementLocator));
        return true;
    }

    private static boolean isValidToCheckForVisibility(By elementLocator, boolean checkForVisibility) {
        String locatorString = ElementActionsHelper.formatLocatorToString(elementLocator).toLowerCase();
        return checkForVisibility && !locatorString.contains("type='file'") && !locatorString.contains("type=\"file\"") && !locatorString.contains("frame") && !elementLocator.equals((Object)By.tagName((String)"html"));
    }

    public static ArrayList<Class<? extends Exception>> getExpectedExceptions(boolean isValidToCheckForVisibility) {
        ArrayList<Class<? extends Exception>> expectedExceptions = new ArrayList<Class<? extends Exception>>();
        expectedExceptions.add(ClassCastException.class);
        expectedExceptions.add(NoSuchElementException.class);
        expectedExceptions.add(StaleElementReferenceException.class);
        expectedExceptions.add(JavascriptException.class);
        expectedExceptions.add(ElementClickInterceptedException.class);
        if (isValidToCheckForVisibility) {
            expectedExceptions.add(ElementNotInteractableException.class);
            expectedExceptions.add(InvalidElementStateException.class);
            expectedExceptions.add(MoveTargetOutOfBoundsException.class);
        }
        if (SHAFT.Properties.web.targetBrowserName().equalsIgnoreCase(Browser.SAFARI.browserName())) {
            expectedExceptions.add(WebDriverException.class);
        }
        expectedExceptions.add(ExecutionException.class);
        expectedExceptions.add(InterruptedException.class);
        expectedExceptions.add(RuntimeException.class);
        return expectedExceptions;
    }

    public static List<Object> waitForElementPresence(WebDriver driver, By elementLocator, int numberOfAttempts, boolean checkForVisibility, Object ... action) {
        boolean isValidToCheckForVisibility = ElementActionsHelper.isValidToCheckForVisibility(elementLocator, checkForVisibility);
        boolean isMobileExecution = DriverFactoryHelper.isMobileNativeExecution() || DriverFactoryHelper.isMobileWebExecution();
        try {
            return (List)new FluentWait((Object)driver).withTimeout(Duration.ofMillis((long)(SHAFT.Properties.timeouts.defaultElementIdentificationTimeout() * 1000.0 * (double)numberOfAttempts))).pollingEvery(Duration.ofMillis(100L)).ignoreAll(ElementActionsHelper.getExpectedExceptions(isValidToCheckForVisibility)).until(nestedDriver -> {
                ExecutorService myExecutor = Executors.newVirtualThreadPerTaskExecutor();
                try {
                    WebElement[] targetElement = new WebElement[1];
                    ElementInformation elementInformation = new ElementInformation();
                    if (ShadowLocatorBuilder.shadowDomLocator != null && ShadowLocatorBuilder.cssSelector == elementLocator) {
                        targetElement[0] = driver.findElement(ShadowLocatorBuilder.shadowDomLocator).getShadowRoot().findElement(ShadowLocatorBuilder.cssSelector);
                    } else if (LocatorBuilder.getIFrameLocator() != null) {
                        try {
                            targetElement[0] = driver.switchTo().frame(driver.findElement(LocatorBuilder.getIFrameLocator())).findElement(elementLocator);
                        }
                        catch (NoSuchElementException exception) {
                            targetElement[0] = driver.findElement(elementLocator);
                        }
                    } else {
                        try {
                            targetElement[0] = driver.findElement(elementLocator);
                        }
                        catch (InvalidSelectorException invalidSelectorException) {
                            FailureReporter.fail(ElementActionsHelper.class, "Failed to identify unique element", invalidSelectorException);
                        }
                    }
                    Future<?> threadRect = myExecutor.submit(() -> {
                        try {
                            elementInformation.setElementRect(targetElement[0].getRect());
                        }
                        catch (ElementNotInteractableException elementNotInteractableException) {
                            // empty catch block
                        }
                    });
                    Future<?> threadLocate = myExecutor.submit(() -> {
                        if (isValidToCheckForVisibility) {
                            if (!isMobileExecution) {
                                try {
                                    Object object = ((JavascriptExecutor)driver).executeScript("arguments[0].scrollIntoView({behavior: \"smooth\", block: \"center\", inline: \"center\"});", new Object[]{targetElement[0]});
                                }
                                catch (Throwable throwable) {
                                    try {
                                        new Actions(driver).scrollToElement(targetElement[0]).perform();
                                    }
                                    catch (Throwable throwable1) {
                                        ((Locatable)driver).getCoordinates().inViewPort();
                                    }
                                }
                            } else {
                                targetElement[0].isDisplayed();
                            }
                        }
                    });
                    Future<?> threadCount = myExecutor.submit(() -> {
                        if (ShadowLocatorBuilder.shadowDomLocator != null && ShadowLocatorBuilder.cssSelector == elementLocator) {
                            elementInformation.setNumberOfFoundElements(driver.findElement(ShadowLocatorBuilder.shadowDomLocator).getShadowRoot().findElements(ShadowLocatorBuilder.cssSelector).size());
                        } else {
                            elementInformation.setNumberOfFoundElements(driver.findElements(elementLocator).size());
                        }
                    });
                    Future<?> threadHTML = myExecutor.submit(() -> {
                        if (!isMobileExecution) {
                            elementInformation.setOuterHTML(targetElement[0].getAttribute("outerHTML"));
                            elementInformation.setInnerHTML(targetElement[0].getAttribute("innerHTML"));
                        }
                    });
                    Future<?> threadName = myExecutor.submit(() -> {
                        if (SHAFT.Properties.reporting.captureElementName()) {
                            String elementName = ElementActionsHelper.formatLocatorToString(elementLocator);
                            try {
                                String accessibleName = targetElement[0].getAccessibleName();
                                if (accessibleName != null && !accessibleName.isBlank()) {
                                    elementName = accessibleName;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            elementInformation.setElementName(elementName);
                        }
                    });
                    threadRect.get();
                    threadLocate.get();
                    threadCount.get();
                    threadHTML.get();
                    threadName.get();
                    elementInformation.setFirstElement(targetElement[0]);
                    elementInformation.setLocator(elementLocator);
                    if (action != null && action.length > 0) {
                        if (elementInformation.getNumberOfFoundElements() > 1 && SHAFT.Properties.flags.forceCheckElementLocatorIsUnique() && !(elementLocator instanceof RelativeLocator.RelativeBy)) {
                            FailureReporter.fail(ElementActionsHelper.class, "Failed to identify unique element", new MultipleElementsFoundException("Multiple elements found matching this locator \"" + ElementActionsHelper.formatLocatorToString(elementLocator) + "\""));
                        }
                        switch (action.length) {
                            case 1: {
                                elementInformation.setActionResult(ElementActionsHelper.performAction(driver, elementInformation, (ElementAction)((Object)((Object)action[0])), ""));
                                break;
                            }
                            case 2: {
                                elementInformation.setActionResult(ElementActionsHelper.performAction(driver, elementInformation, (ElementAction)((Object)((Object)action[0])), action[1]));
                            }
                        }
                    }
                    List<Object> list = elementInformation.toList();
                    if (myExecutor != null) {
                        myExecutor.close();
                    }
                    return list;
                }
                catch (Throwable throwable) {
                    try {
                        if (myExecutor != null) {
                            try {
                                myExecutor.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (TimeoutException timeoutException) {
            String causeMessage = timeoutException.getCause().getMessage();
            causeMessage = !causeMessage.isBlank() && causeMessage.contains("\n") ? timeoutException.getMessage() + " || " + causeMessage.substring(0, causeMessage.indexOf("\n")) : timeoutException.getMessage();
            ReportManager.logDiscrete(causeMessage);
            ArrayList<Object> elementInformation = new ArrayList<Object>();
            elementInformation.add(0);
            elementInformation.add(null);
            elementInformation.add((Object)timeoutException);
            return elementInformation;
        }
        catch (InvalidSelectorException invalidSelectorException) {
            ReportManager.logDiscrete(invalidSelectorException.getMessage());
            ArrayList<Object> elementInformation = new ArrayList<Object>();
            elementInformation.add(0);
            elementInformation.add(null);
            elementInformation.add((Object)invalidSelectorException);
            return elementInformation;
        }
    }

    private static String performAction(WebDriver driver, ElementInformation elementInformation, ElementAction action, Object parameter) {
        switch (action) {
            case CLICK: {
                try {
                    new Actions(driver).moveToElement(elementInformation.getFirstElement()).perform();
                    ReportManager.logDiscrete("Moved the mouse to the middle of the element.");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    elementInformation.getFirstElement().click();
                    break;
                }
                catch (Throwable throwable) {
                    if (!DriverFactoryHelper.isWebExecution()) break;
                    if (SHAFT.Properties.flags.clickUsingJavascriptWhenWebDriverClickFails()) {
                        Object scriptResult = ((JavascriptExecutor)driver).executeScript("arguments[0].click();", new Object[]{elementInformation.getFirstElement()});
                        ReportManager.logDiscrete("Performed Click using JavaScript.");
                        ReportManager.logDiscrete("If the report is showing that the click passed but you observe that no action was taken, we recommend trying a different element locator.");
                        break;
                    }
                    throw throwable;
                }
            }
            case CLEAR: {
                elementInformation.getFirstElement().clear();
                break;
            }
            case BACKSPACE: {
                elementInformation.getFirstElement().sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                break;
            }
            case GET_TEXT: {
                return elementInformation.getFirstElement().getText();
            }
            case GET_VALUE: {
                return elementInformation.getFirstElement().getAttribute(TextDetectionStrategy.VALUE.getValue());
            }
            case GET_CONTENT: {
                return elementInformation.getFirstElement().getAttribute(TextDetectionStrategy.CONTENT.getValue());
            }
            case GET_ATTRIBUTE: {
                return elementInformation.getFirstElement().getAttribute((String)parameter);
            }
            case SEND_KEYS: {
                elementInformation.getFirstElement().sendKeys(new CharSequence[]{(CharSequence)parameter});
                break;
            }
            case IS_DISPLAYED: {
                return String.valueOf(elementInformation.getFirstElement().isDisplayed());
            }
            case SET_VALUE_USING_JAVASCRIPT: {
                ((JavascriptExecutor)driver).executeScript("arguments[0].value = arguments[1];", new Object[]{elementInformation.getFirstElement(), parameter});
                break;
            }
            case HOVER: {
                new Actions(driver).pause(Duration.ofMillis(400L)).moveToElement(elementInformation.getFirstElement()).perform();
            }
        }
        return "";
    }

    public static List<Object> scrollToFindElement(WebDriver driver, By elementLocator) {
        try {
            return (List)new FluentWait((Object)driver).withTimeout(Duration.ofMillis((long)(SHAFT.Properties.timeouts.defaultElementIdentificationTimeout() * 1000.0))).pollingEvery(Duration.ofMillis(100L)).ignoreAll(ElementActionsHelper.getExpectedExceptions(true)).until(nestedDriver -> {
                WebElement targetElement;
                try {
                    targetElement = nestedDriver.findElement(elementLocator);
                }
                catch (NoSuchElementException noSuchElementException) {
                    new Actions(nestedDriver).scrollByAmount(0, nestedDriver.manage().window().getSize().getHeight()).perform();
                    targetElement = nestedDriver.findElement(elementLocator);
                }
                ArrayList<Integer> elementInformation = new ArrayList<Integer>();
                elementInformation.add(nestedDriver.findElements(elementLocator).size());
                elementInformation.add((Integer)targetElement);
                return elementInformation;
            });
        }
        catch (TimeoutException timeoutException) {
            ReportManager.logDiscrete(timeoutException.getMessage() + " || " + timeoutException.getCause().getMessage().substring(0, timeoutException.getCause().getMessage().indexOf("\n")));
            ArrayList<Object> elementInformation = new ArrayList<Object>();
            elementInformation.add(0);
            elementInformation.add(null);
            elementInformation.add((Object)timeoutException);
            return elementInformation;
        }
    }

    public static boolean waitForElementToBeClickable(WebDriver driver, By elementLocator, String actionToExecute) {
        boolean clickUsingJavascriptWhenWebDriverClickFails = SHAFT.Properties.flags.clickUsingJavascriptWhenWebDriverClickFails();
        if (!DriverFactoryHelper.isMobileNativeExecution()) {
            try {
                new WebDriverWait(driver, Duration.ofMillis((long)(SHAFT.Properties.timeouts.defaultElementIdentificationTimeout() * 1000.0))).until((Function)ExpectedConditions.elementToBeClickable((By)elementLocator));
                ArrayList<Class<? extends Exception>> expectedExceptions = ElementActionsHelper.getExpectedExceptions(true);
                if (!clickUsingJavascriptWhenWebDriverClickFails) {
                    expectedExceptions.add(ElementClickInterceptedException.class);
                }
                return (Boolean)new FluentWait((Object)driver).withTimeout(Duration.ofMillis((long)(SHAFT.Properties.timeouts.defaultElementIdentificationTimeout() * 1000.0))).pollingEvery(Duration.ofMillis(100L)).ignoreAll(expectedExceptions).until(nestedDriver -> {
                    if (!actionToExecute.isEmpty() && actionToExecute.equalsIgnoreCase("ClickAndHold")) {
                        new Actions(driver).clickAndHold((WebElement)ElementActionsHelper.identifyUniqueElement(driver, elementLocator).get(1)).build().perform();
                    }
                    return true;
                });
            }
            catch (TimeoutException e) {
                ReportManagerHelper.logDiscrete(e);
                return false;
            }
        }
        return true;
    }

    public static boolean waitForElementTextToBeNot(WebDriver driver, By elementLocator, String textShouldNotBe) {
        try {
            new WebDriverWait(driver, Duration.ofMillis((long)(SHAFT.Properties.timeouts.defaultElementIdentificationTimeout() * 1000.0))).until((Function)ExpectedConditions.not((ExpectedCondition)ExpectedConditions.textToBe((By)elementLocator, (String)textShouldNotBe)));
        }
        catch (TimeoutException e) {
            ReportManagerHelper.logDiscrete(e);
            return false;
        }
        return true;
    }

    public static boolean waitForElementAttributeToBe(WebDriver driver, By elementLocator, String att, String expectedValue) {
        try {
            new WebDriverWait(driver, Duration.ofMillis((long)(SHAFT.Properties.timeouts.defaultElementIdentificationTimeout() * 1000.0))).until((Function)ExpectedConditions.attributeToBe((By)elementLocator, (String)att, (String)expectedValue));
        }
        catch (TimeoutException e) {
            ReportManagerHelper.logDiscrete(e);
            return false;
        }
        return true;
    }

    public static WebElement getWebElementFromPointUsingJavascript(WebDriver driver, List<Integer> point, boolean scrollToElement) {
        if (DriverFactoryHelper.isWebExecution()) {
            if (Boolean.TRUE.equals(scrollToElement)) {
                return (WebElement)((JavascriptExecutor)driver).executeScript(JavaScriptHelper.ELEMENT_SCROLL_TO_VIEWPORT.getValue(), new Object[]{point.get(0), point.get(1)});
            }
            return (WebElement)((JavascriptExecutor)driver).executeScript("return document.elementFromPoint(arguments[0], arguments[1])", new Object[]{point.get(0), point.get(1)});
        }
        return null;
    }

    public static void clickUsingJavascript(WebDriver driver, By elementLocator) {
        if (DriverFactoryHelper.isWebExecution()) {
            ((JavascriptExecutor)driver).executeScript("arguments[arguments.length - 1].click();", new Object[]{ElementActionsHelper.identifyUniqueElement(driver, elementLocator).get(1)});
        }
    }

    public static void dragAndDropUsingJavascript(WebDriver driver, By sourceElementLocator, By destinationElementLocator) {
        if (DriverFactoryHelper.isWebExecution()) {
            JavascriptExecutor js = (JavascriptExecutor)driver;
            String jQueryLoader = JavaScriptHelper.LOAD_JQUERY.getValue();
            js.executeAsyncScript(jQueryLoader, new Object[0]);
            Object dragAndDropHelper = JavaScriptHelper.ELEMENT_DRAG_AND_DROP.getValue();
            dragAndDropHelper = (String)dragAndDropHelper + "$(arguments[0]).simulateDragDrop({dropTarget:arguments[1]});";
            ((JavascriptExecutor)driver).executeScript((String)dragAndDropHelper, new Object[]{ElementActionsHelper.identifyUniqueElement(driver, sourceElementLocator).get(1), ElementActionsHelper.identifyUniqueElement(driver, destinationElementLocator).get(1)});
        }
    }

    public static void dragAndDropUsingActions(WebDriver driver, By sourceElementLocator, By destinationElementLocator) {
        new Actions(driver).dragAndDrop((WebElement)ElementActionsHelper.identifyUniqueElement(driver, sourceElementLocator).get(1), (WebElement)ElementActionsHelper.identifyUniqueElement(driver, destinationElementLocator).get(1)).build().perform();
    }

    public static void executeNativeMobileCommandUsingJavascript(WebDriver driver, String command, Map<String, String> parameters) {
        ((JavascriptExecutor)driver).executeScript(command, new Object[]{parameters});
    }

    public static void submitFormUsingJavascript(WebDriver driver, By elementLocator) {
        if (DriverFactoryHelper.isWebExecution()) {
            ((JavascriptExecutor)driver).executeScript("arguments[0].submit();", new Object[]{ElementActionsHelper.identifyUniqueElement(driver, elementLocator).get(1)});
        }
    }

    public static void changeWebElementVisibilityUsingJavascript(WebDriver driver, By elementLocator, boolean desiredIsVisibleState) {
        if (DriverFactoryHelper.isWebExecution()) {
            if (Boolean.TRUE.equals(desiredIsVisibleState)) {
                ((JavascriptExecutor)driver).executeScript("arguments[0].setAttribute('style', 'display:block !important;');", new Object[]{ElementActionsHelper.identifyUniqueElement(driver, elementLocator).get(1)});
            } else {
                ((JavascriptExecutor)driver).executeScript("arguments[0].setAttribute('style', 'display:none');", new Object[]{ElementActionsHelper.identifyUniqueElement(driver, elementLocator).get(1)});
            }
        }
    }

    public static boolean setValueUsingJavascript(WebDriver driver, By elementLocator, String value) {
        try {
            if (DriverFactoryHelper.isWebExecution()) {
                ElementActionsHelper.performActionAgainstUniqueElementIgnoringVisibility(driver, elementLocator, new Object[]{ElementAction.SET_VALUE_USING_JAVASCRIPT, value});
            }
            return true;
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
            return false;
        }
    }

    public static boolean setValueUsingJavascript(WebDriver driver, ElementInformation elementInformation, String value) {
        try {
            if (DriverFactoryHelper.isWebExecution()) {
                try {
                    ((JavascriptExecutor)driver).executeScript("arguments[0].value = arguments[1];", new Object[]{elementInformation.getFirstElement(), value});
                }
                catch (WebDriverException webDriverException) {
                    ElementActionsHelper.performActionAgainstUniqueElementIgnoringVisibility(driver, elementInformation.getLocator(), new Object[]{ElementAction.SET_VALUE_USING_JAVASCRIPT, value});
                }
            }
            return true;
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
            return false;
        }
    }

    public static String suggestNewXpathUsingJavascript(WebDriver driver, WebElement targetElement) {
        ReportHelper.disableLogging();
        String suggestedXpath = ElementActionsHelper.suggestNewXpathUsingJavascript(driver, targetElement, null);
        ReportHelper.enableLogging();
        return suggestedXpath;
    }

    public static String suggestNewXpathUsingJavascript(WebDriver driver, WebElement targetElement, By deprecatedElementLocator) {
        if (DriverFactoryHelper.isWebExecution()) {
            int maximumXpathNodes = 6;
            String newXpath = "";
            for (int i = 0; i < maximumXpathNodes; ++i) {
                String xpathFindingAlgorithm = ElementActionsHelper.getXpathFindingAlgorithm(i);
                try {
                    newXpath = (String)((JavascriptExecutor)driver).executeScript(xpathFindingAlgorithm, new Object[]{targetElement});
                    if (newXpath == null || driver.findElements(By.xpath((String)newXpath)).size() != 1) continue;
                    break;
                }
                catch (JavascriptException e) {
                    ReportManagerHelper.logDiscrete(e);
                    ReportManager.logDiscrete("Failed to suggest a new XPath for the target element with this deprecated locator \"" + String.valueOf(deprecatedElementLocator) + "\"");
                }
            }
            if (newXpath != null) {
                boolean initialLoggingState = ReportManagerHelper.getDiscreteLogging();
                ReportManagerHelper.setDiscreteLogging(false);
                ReportManager.log("New AI-Suggested XPath \"" + newXpath.replace("\"", "'") + "\"");
                ReportManagerHelper.setDiscreteLogging(initialLoggingState);
                return newXpath;
            }
            ReportManager.log("Failed to suggest a new XPath for the target element with this deprecated locator \"" + String.valueOf(deprecatedElementLocator) + "\"");
            return null;
        }
        return null;
    }

    private static String getXpathFindingAlgorithm(int i) {
        String getText;
        String xpathFindingAlgorithm = JavaScriptHelper.ELEMENT_GET_XPATH.getValue();
        String maxCount = String.valueOf(i);
        String getId = String.valueOf(true);
        String getClass = getText = String.valueOf(false);
        String getType = getText;
        String getName = getText;
        String getIndex = getText;
        if (i == 0) {
            maxCount = String.valueOf(1);
        } else if (i == 1 || i == 2) {
            getName = String.valueOf(true);
            getType = String.valueOf(true);
            getText = String.valueOf(true);
        } else if (i == 3 || i == 4) {
            getName = String.valueOf(true);
            getType = String.valueOf(true);
            getClass = String.valueOf(true);
            getText = String.valueOf(true);
        } else {
            getIndex = String.valueOf(true);
            getName = String.valueOf(true);
            getType = String.valueOf(true);
            getText = String.valueOf(true);
            getClass = String.valueOf(true);
        }
        xpathFindingAlgorithm = xpathFindingAlgorithm.replaceAll("\\$\\$MaxCount\\$\\$", maxCount).replaceAll("\\$\\$GetId\\$\\$", getId).replaceAll("\\$\\$GetIndex\\$\\$", getIndex).replaceAll("\\$\\$GetName\\$\\$", getName).replaceAll("\\$\\$GetType\\$\\$", getType).replaceAll("\\$\\$GetClass\\$\\$", getClass).replaceAll("\\$\\$GetText\\$\\$", getText);
        return xpathFindingAlgorithm;
    }

    public static List<Object> takeScreenshot(WebDriver driver, By elementLocator, String actionName, String testData, boolean passFailStatus) {
        block5: {
            if (passFailStatus) {
                try {
                    if (elementLocator != null) {
                        return ScreenshotManager.takeScreenshot(driver, elementLocator, actionName, true);
                    }
                    if (testData != null) {
                        return ScreenshotManager.takeScreenshot(driver, null, actionName, true);
                    }
                    break block5;
                }
                catch (Exception e) {
                    ReportManagerHelper.logDiscrete(e);
                    ReportManager.logDiscrete("Failed to take a screenshot of the element as it doesn't exist anymore. Taking a screenshot of the whole page.");
                    return ScreenshotManager.takeScreenshot(driver, null, actionName, true);
                }
            }
            return ScreenshotManager.takeScreenshot(driver, null, actionName, false);
        }
        return new ArrayList<Object>();
    }

    public static String getElementName(WebDriver driver, By elementLocator) {
        block4: {
            if (SHAFT.Properties.reporting.captureElementName()) {
                try {
                    String accessibleName = ((WebElement)ElementActionsHelper.identifyUniqueElementIgnoringVisibility(driver, elementLocator).get(1)).getAccessibleName();
                    if (accessibleName != null && !accessibleName.isBlank()) {
                        return accessibleName;
                    }
                }
                catch (Throwable throwable) {
                    Class<?> rootCause = Throwables.getRootCause((Throwable)throwable).getClass();
                    if (!rootCause.equals(NoSuchElementException.class) && !rootCause.equals(InvalidSelectorException.class) && !rootCause.equals(MultipleElementsFoundException.class)) break block4;
                    throw throwable;
                }
            }
        }
        return ElementActionsHelper.formatLocatorToString(elementLocator);
    }

    private static String confirmTypingWasSuccessful(WebDriver driver, ElementInformation elementInformation, TextDetectionStrategy successfulTextLocationStrategy) {
        ElementInformation updatedElementInformation = ElementInformation.fromList(ElementActionsHelper.identifyUniqueElementIgnoringVisibility(driver, elementInformation.getLocator()));
        TextDetectionStrategy updatedSuccessfulTextLocationStrategy = successfulTextLocationStrategy;
        if (updatedSuccessfulTextLocationStrategy.equals((Object)TextDetectionStrategy.UNDEFINED)) {
            updatedSuccessfulTextLocationStrategy = ElementActionsHelper.determineSuccessfulTextLocationStrategy(updatedElementInformation);
        }
        return ElementActionsHelper.readTextBasedOnSuccessfulLocationStrategy(driver, updatedElementInformation, updatedSuccessfulTextLocationStrategy);
    }

    private static TextDetectionStrategy determineSuccessfulTextLocationStrategy(ElementInformation elementInformation) {
        if (DriverFactoryHelper.isMobileNativeExecution()) {
            return TextDetectionStrategy.TEXT;
        }
        String outerHTML = elementInformation.getOuterHTML();
        String innerHTML = elementInformation.getInnerHTML();
        if (!outerHTML.isEmpty()) {
            Element element = ((Element)Jsoup.parse((String)outerHTML).getElementsByTag("body").getFirst()).child(0);
            if (element.hasText() && !element.text().isEmpty()) {
                return TextDetectionStrategy.TEXT;
            }
            if (element.hasAttr("value") && !element.attr("value").isEmpty()) {
                return TextDetectionStrategy.VALUE;
            }
            if (!innerHTML.isEmpty() && !innerHTML.contains("<")) {
                return TextDetectionStrategy.CONTENT;
            }
            return TextDetectionStrategy.UNDEFINED;
        }
        return TextDetectionStrategy.UNDEFINED;
    }

    private static String readTextBasedOnSuccessfulLocationStrategy(WebDriver driver, ElementInformation elementInformation, TextDetectionStrategy successfulTextLocationStrategy) {
        switch (successfulTextLocationStrategy.ordinal()) {
            case 0: 
            case 3: {
                String temp;
                try {
                    temp = elementInformation.getFirstElement().getText();
                }
                catch (WebDriverException webDriverException) {
                    temp = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElement(driver, elementInformation.getLocator(), new Object[]{ElementAction.GET_TEXT})).getActionResult();
                }
                return temp == null ? "" : temp;
            }
            case 1: {
                String temp;
                try {
                    temp = elementInformation.getFirstElement().getAttribute(TextDetectionStrategy.CONTENT.getValue());
                }
                catch (WebDriverException webDriverException) {
                    temp = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElement(driver, elementInformation.getLocator(), new Object[]{ElementAction.GET_CONTENT})).getActionResult();
                }
                return temp == null ? "" : temp;
            }
            case 2: {
                String temp;
                try {
                    temp = elementInformation.getFirstElement().getAttribute(TextDetectionStrategy.VALUE.getValue());
                }
                catch (WebDriverException webDriverException) {
                    temp = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElement(driver, elementInformation.getLocator(), new Object[]{ElementAction.GET_VALUE})).getActionResult();
                }
                return temp == null ? "" : temp;
            }
        }
        return "";
    }

    public static boolean performClipboardActions(WebDriver driver, ClipboardAction action) {
        try {
            Keys cmdCtrl = SHAFT.Properties.platform.targetPlatform().equalsIgnoreCase(Platform.MAC.name()) ? Keys.COMMAND : Keys.CONTROL;
            switch (action) {
                case COPY: {
                    new Actions(driver).keyDown((CharSequence)cmdCtrl).sendKeys(new CharSequence[]{"c"}).keyUp((CharSequence)cmdCtrl).perform();
                    break;
                }
                case PASTE: {
                    new Actions(driver).keyDown((CharSequence)cmdCtrl).sendKeys(new CharSequence[]{"v"}).keyUp((CharSequence)cmdCtrl).perform();
                    break;
                }
                case CUT: {
                    new Actions(driver).keyDown((CharSequence)cmdCtrl).sendKeys(new CharSequence[]{"x"}).keyUp((CharSequence)cmdCtrl).perform();
                    break;
                }
                case SELECT_ALL: {
                    new Actions(driver).keyDown((CharSequence)cmdCtrl).sendKeys(new CharSequence[]{"a"}).keyUp((CharSequence)cmdCtrl).perform();
                    break;
                }
                case UNSELECT_ALL: {
                    new Actions(driver).sendKeys(new CharSequence[]{Keys.ESCAPE}).perform();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (HeadlessException e) {
            ReportManagerHelper.logDiscrete(e);
            return false;
        }
    }

    private static void performType(WebDriver driver, ElementInformation elementInformation, String text) {
        if (driver instanceof AppiumDriver) {
            AppiumDriver appiumDriver = (AppiumDriver)driver;
            try {
                elementInformation.getFirstElement().sendKeys(new CharSequence[]{text});
            }
            catch (WebDriverException webDriverException2) {
                ElementActionsHelper.performActionAgainstUniqueElement((WebDriver)appiumDriver, elementInformation.getLocator(), new Object[]{ElementAction.SEND_KEYS, text});
            }
        } else if (SHAFT.Properties.flags.attemptToClickBeforeTyping()) {
            try {
                elementInformation.getFirstElement().click();
                elementInformation.getFirstElement().sendKeys(new CharSequence[]{text});
            }
            catch (WebDriverException webDriverException) {
                try {
                    elementInformation.getFirstElement().sendKeys(new CharSequence[]{text});
                }
                catch (WebDriverException webDriverException2) {
                    ElementActionsHelper.performActionAgainstUniqueElement(driver, elementInformation.getLocator(), new Object[]{ElementAction.SEND_KEYS, text});
                }
            }
        } else {
            try {
                elementInformation.getFirstElement().sendKeys(new CharSequence[]{text});
            }
            catch (WebDriverException webDriverException2) {
                ElementActionsHelper.performActionAgainstUniqueElement(driver, elementInformation.getLocator(), new Object[]{ElementAction.SEND_KEYS, text});
            }
        }
    }

    public static String readElementText(WebDriver driver, ElementInformation elementInformation) {
        String elementText;
        try {
            elementText = elementInformation.getFirstElement().getText();
        }
        catch (WebDriverException webDriverException) {
            elementText = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElementIgnoringVisibility(driver, elementInformation.getLocator(), new Object[]{ElementAction.GET_TEXT})).getActionResult();
        }
        if ((elementText == null || elementText.isBlank()) && !DriverFactoryHelper.isMobileNativeExecution()) {
            try {
                elementText = elementInformation.getFirstElement().getAttribute(TextDetectionStrategy.CONTENT.getValue());
            }
            catch (WebDriverException webDriverException) {
                elementText = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElementIgnoringVisibility(driver, elementInformation.getLocator(), new Object[]{ElementAction.GET_CONTENT})).getActionResult();
            }
        }
        if ((elementText == null || elementText.isBlank()) && !DriverFactoryHelper.isMobileNativeExecution()) {
            try {
                elementText = elementInformation.getFirstElement().getAttribute(TextDetectionStrategy.VALUE.getValue());
            }
            catch (WebDriverException webDriverException) {
                elementText = ElementInformation.fromList(ElementActionsHelper.performActionAgainstUniqueElementIgnoringVisibility(driver, elementInformation.getLocator(), new Object[]{ElementAction.GET_VALUE})).getActionResult();
            }
        }
        if (elementText == null) {
            elementText = "";
        }
        return elementText;
    }

    private static void clearBeforeTyping(WebDriver driver, ElementInformation elementInformation) {
        if (SHAFT.Properties.flags.attemptClearBeforeTyping()) {
            if (SHAFT.Properties.flags.attemptClearBeforeTypingUsingBackspace()) {
                ElementActionsHelper.clearBeforeTypingUsingBackSpace(driver, elementInformation);
            } else {
                ElementActionsHelper.clearBeforeTypingUsingNativeClear(driver, elementInformation);
            }
        }
    }

    private static void clearBeforeTypingUsingNativeClear(WebDriver driver, ElementInformation elementInformation) {
        try {
            elementInformation.getFirstElement().clear();
        }
        catch (Throwable throwable) {
            ElementActionsHelper.performActionAgainstUniqueElement(driver, elementInformation.getLocator(), new Object[]{ElementAction.CLEAR});
        }
        String currentTextAfterClearingUsingNativeClear = ElementActionsHelper.readElementText(driver, elementInformation);
        if (currentTextAfterClearingUsingNativeClear.isBlank()) {
            ReportManagerHelper.logDiscrete("Text cleared Using Native Clear", Level.DEBUG);
        } else {
            ElementActionsHelper.failAction(driver, "Expected to clear existing text, but ended up with: \"" + currentTextAfterClearingUsingNativeClear + "\"", elementInformation.getLocator(), new Throwable[0]);
        }
    }

    private static void clearBeforeTypingUsingBackSpace(WebDriver driver, ElementInformation elementInformation) {
        String currentText = ElementActionsHelper.readElementText(driver, elementInformation);
        for (char ignored : currentText.toCharArray()) {
            try {
                elementInformation.getFirstElement().sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            }
            catch (WebDriverException webDriverException) {
                ElementActionsHelper.performActionAgainstUniqueElement(driver, elementInformation.getLocator(), new Object[]{ElementAction.BACKSPACE});
            }
        }
        String currentTextAfterClearingUsingBackSpace = ElementActionsHelper.readElementText(driver, elementInformation);
        if (currentTextAfterClearingUsingBackSpace.isBlank()) {
            ReportManagerHelper.logDiscrete("Text cleared Using Backspace.", Level.DEBUG);
        } else {
            ElementActionsHelper.failAction(driver, "Expected to clear existing text, but ended up with: \"" + currentTextAfterClearingUsingBackSpace + "\"", elementInformation.getLocator(), new Throwable[0]);
        }
    }

    private static String confirmTextWasTypedCorrectly(WebDriver driver, ElementInformation elementInformation, String adjustedTargetText) {
        ElementInformation updatedElementInformation = ElementInformation.fromList(ElementActionsHelper.identifyUniqueElementIgnoringVisibility(driver, elementInformation.getLocator()));
        String actualTextAfterPerformType = ElementActionsHelper.readElementText(driver, elementInformation);
        if (adjustedTargetText.equals(actualTextAfterPerformType) || OBFUSCATED_STRING.repeat(adjustedTargetText.length()).equals(actualTextAfterPerformType)) {
            return adjustedTargetText;
        }
        ElementActionsHelper.setValueUsingJavascript(driver, elementInformation, adjustedTargetText);
        String textAfterSettingValueUsingJavascript = new ElementActions(driver).getText(elementInformation.getLocator());
        if (textAfterSettingValueUsingJavascript.isEmpty()) {
            return adjustedTargetText;
        }
        return textAfterSettingValueUsingJavascript;
    }

    public static String typeWrapper(WebDriver driver, ElementInformation elementInformation, String targetText) {
        ElementActionsHelper.clearBeforeTyping(driver, elementInformation);
        String adjustedTargetText = targetText != null && !targetText.isEmpty() ? targetText : "";
        ElementActionsHelper.performType(driver, elementInformation, adjustedTargetText);
        if (SHAFT.Properties.flags.forceCheckTextWasTypedCorrectly()) {
            return ElementActionsHelper.confirmTextWasTypedCorrectly(driver, elementInformation, adjustedTargetText);
        }
        return adjustedTargetText;
    }

    public static boolean isFoundInStacktrace(Class<?> classObject, Throwable throwable) {
        String targetClassName = classObject.getName();
        for (StackTraceElement element : throwable.getStackTrace()) {
            if (!element.getClassName().equals(targetClassName)) continue;
            return true;
        }
        return false;
    }

    public static List<Object> performActionAgainstUniqueElement(WebDriver driver, By elementLocator, Object ... action) {
        return ElementActionsHelper.identifyUniqueElement(driver, elementLocator, true, action);
    }

    public static List<Object> performActionAgainstUniqueElementIgnoringVisibility(WebDriver driver, By elementLocator, Object ... action) {
        return ElementActionsHelper.identifyUniqueElement(driver, elementLocator, false, action);
    }

    public static List<Object> identifyUniqueElement(WebDriver driver, By elementLocator) {
        return ElementActionsHelper.identifyUniqueElement(driver, elementLocator, true, new Object[0]);
    }

    public static List<Object> identifyUniqueElementIgnoringVisibility(WebDriver driver, By elementLocator) {
        return ElementActionsHelper.identifyUniqueElement(driver, elementLocator, false, new Object[0]);
    }

    private static List<Object> identifyUniqueElement(WebDriver driver, By elementLocator, boolean checkForVisibility, Object ... action) {
        List<Object> matchingElementsInformation;
        block7: {
            block6: {
                matchingElementsInformation = ElementActionsHelper.getMatchingElementsInformation(driver, elementLocator, 1, checkForVisibility, action);
                if (elementLocator == null) break block6;
                switch (Integer.parseInt(matchingElementsInformation.get(0).toString())) {
                    case 0: {
                        if (matchingElementsInformation.size() > 2 && matchingElementsInformation.get(2) instanceof Throwable) {
                            FailureReporter.fail(ElementActionsHelper.class, "Failed to identify unique element using this locator \"" + ElementActionsHelper.formatLocatorToString(elementLocator) + "\"", (Throwable)matchingElementsInformation.get(2));
                        }
                        FailureReporter.fail("Failed to identify unique element using this locator \"" + ElementActionsHelper.formatLocatorToString(elementLocator) + "\"");
                        break block7;
                    }
                    case 1: {
                        return matchingElementsInformation;
                    }
                    default: {
                        if (SHAFT.Properties.flags.forceCheckElementLocatorIsUnique() && !(elementLocator instanceof RelativeLocator.RelativeBy)) {
                            FailureReporter.fail(ElementActionsHelper.class, "Failed to identify unique element", new MultipleElementsFoundException("Multiple elements found matching this locator \"" + ElementActionsHelper.formatLocatorToString(elementLocator) + "\""));
                        }
                        return matchingElementsInformation;
                    }
                }
            }
            ElementActionsHelper.failAction(driver, "element locator is NULL.", null, new Throwable[0]);
        }
        return matchingElementsInformation;
    }

    public static List<Object> getMatchingElementsInformation(WebDriver driver, By elementLocator, int numberOfAttempts, boolean checkForVisibility, Object ... action) {
        if (elementLocator == null) {
            ArrayList<Object> elementInformation = new ArrayList<Object>();
            elementInformation.add(0);
            elementInformation.add(null);
            return elementInformation;
        }
        if (!elementLocator.equals((Object)By.tagName((String)"html"))) {
            return ElementActionsHelper.waitForElementPresence(driver, elementLocator, numberOfAttempts, checkForVisibility, action);
        }
        ArrayList<Object> elementInformation = new ArrayList<Object>();
        elementInformation.add(1);
        elementInformation.add(null);
        return elementInformation;
    }

    public static int getElementsCount(WebDriver driver, By elementLocator) {
        return Integer.parseInt(ElementActionsHelper.getMatchingElementsInformation(driver, elementLocator, 1, false, new Object[0]).getFirst().toString());
    }

    public static int getElementsCount(WebDriver driver, By elementLocator, int numberOfAttempts) {
        return Integer.parseInt(ElementActionsHelper.getMatchingElementsInformation(driver, elementLocator, numberOfAttempts, false, new Object[0]).getFirst().toString());
    }

    public static void passAction(WebDriver driver, By elementLocator, String testData, List<Object> screenshot, String elementName) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        LinkedList<List<Object>> attachments = new LinkedList<List<Object>>();
        attachments.add(screenshot);
        ElementActionsHelper.passAction(driver, elementLocator, actionName, testData, attachments, elementName);
    }

    public static void passAction(WebDriver driver, By elementLocator, String actionName, String testData, List<List<Object>> screenshots, String elementName) {
        ElementActionsHelper.reportActionResult(driver, actionName, testData, elementLocator, screenshots, elementName, true, new Throwable[0]);
    }

    public static void failAction(WebDriver driver, By elementLocator, Throwable ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        ElementActionsHelper.failAction(driver, actionName, null, elementLocator, null, rootCauseException);
    }

    public static void failAction(WebDriver driver, String testData, By elementLocator, Throwable ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        ElementActionsHelper.failAction(driver, actionName, testData, elementLocator, null, rootCauseException);
    }

    public static void failAction(WebDriver driver, String testData, By elementLocator, List<List<Object>> attachments, Throwable ... rootCauseException) {
        String actionName = Thread.currentThread().getStackTrace()[2].getMethodName();
        ElementActionsHelper.failAction(driver, actionName, testData, elementLocator, attachments, rootCauseException);
    }

    public static void failAction(WebDriver driver, String actionName, String testData, By elementLocator, List<List<Object>> screenshots, Throwable ... rootCauseException) {
        String message;
        String elementName;
        boolean skipPageScreenshot = rootCauseException.length >= 1 && ElementActionsHelper.isFoundInStacktrace(ValidationsHelper.class, rootCauseException[0]) && ElementActionsHelper.isFoundInStacktrace(ElementActionsHelper.class, rootCauseException[0]);
        String string = elementName = elementLocator != null ? ElementActionsHelper.formatLocatorToString(elementLocator) : "";
        if (elementLocator != null && rootCauseException.length >= 1 && Throwables.getRootCause((Throwable)rootCauseException[0]).getClass() != MultipleElementsFoundException.class && Throwables.getRootCause((Throwable)rootCauseException[0]).getClass() != NoSuchElementException.class && Throwables.getRootCause((Throwable)rootCauseException[0]).getClass() != InvalidSelectorException.class) {
            try {
                String accessibleName = ((WebElement)ElementActionsHelper.identifyUniqueElement(driver, elementLocator).get(1)).getAccessibleName();
                if (accessibleName != null && !accessibleName.isBlank()) {
                    elementName = accessibleName;
                }
            }
            catch (WebDriverException accessibleName) {
                // empty catch block
            }
        }
        if (skipPageScreenshot) {
            message = ElementActionsHelper.createReportMessage(actionName, testData, elementName, false);
            ReportManager.logDiscrete(message);
        } else {
            message = rootCauseException.length >= 1 ? ElementActionsHelper.reportActionResult(driver, actionName, testData, elementLocator, screenshots, elementName, false, rootCauseException[0]) : ElementActionsHelper.reportActionResult(driver, actionName, testData, null, screenshots, elementName, false, new Throwable[0]);
        }
        if (rootCauseException.length >= 1) {
            Assert.fail((String)message, (Throwable)rootCauseException[0]);
        } else {
            Assert.fail((String)message);
        }
    }

    public static String createReportMessage(String actionName, String testData, String elementName, Boolean passFailStatus) {
        Object message = "";
        if (Boolean.FALSE.equals(passFailStatus)) {
            message = (String)message + "Failed to ";
        }
        actionName = JavaHelper.convertToSentenceCase(actionName);
        message = (String)message + actionName;
        if (testData != null && !testData.isEmpty() && testData.length() < 500) {
            message = (String)message + " \"" + testData.trim() + "\"";
        }
        if (elementName != null && !elementName.isEmpty()) {
            String preposition = ElementActionsHelper.getPreposition(actionName);
            message = (String)message + preposition + "\"" + elementName.trim() + "\"";
        }
        message = (String)message + ".";
        return message;
    }

    private static String getPreposition(String actionName) {
        String preposition = " ";
        if (actionName.toLowerCase().contains("type") || actionName.toLowerCase().contains("setproperty value using javascript")) {
            preposition = " into ";
        } else if (actionName.toLowerCase().contains("get") || actionName.toLowerCase().contains("select")) {
            preposition = " from ";
        } else if (actionName.toLowerCase().contains("clipboard")) {
            preposition = " on ";
        } else if (actionName.toLowerCase().contains("drag and drop") || actionName.toLowerCase().contains("key press") || actionName.toLowerCase().contains("wait") || actionName.toLowerCase().contains("submit") || actionName.toLowerCase().contains("switch")) {
            preposition = " against ";
        } else if (actionName.toLowerCase().contains("hover")) {
            preposition = " over ";
        }
        return preposition;
    }

    private static List<List<Object>> createReportAttachments(WebDriver driver, String actionName, String testData, By elementLocator, List<List<Object>> screenshots, Boolean passFailStatus, Throwable ... rootCauseException) {
        List<Object> newScreenshot;
        List<Object> actualValueAttachment;
        actionName = JavaHelper.convertToSentenceCase(actionName);
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        if (testData != null && testData.length() >= 500) {
            actualValueAttachment = Arrays.asList("Element Action Test Data - " + actionName, "Actual Value", testData);
            attachments.add(actualValueAttachment);
        }
        if (screenshots != null && !screenshots.equals(new ArrayList())) {
            attachments.addAll(screenshots);
        } else if (driver != null && (newScreenshot = actionName.equals("Identify unique element") ? ElementActionsHelper.takeScreenshot(driver, null, actionName, testData, passFailStatus) : ElementActionsHelper.takeScreenshot(driver, elementLocator, actionName, testData, passFailStatus)) != null && !newScreenshot.equals(new ArrayList())) {
            attachments.add(newScreenshot);
        }
        if (driver != null && !WHEN_TO_TAKE_PAGE_SOURCE_SNAPSHOT.equalsIgnoreCase("Never") && (WHEN_TO_TAKE_PAGE_SOURCE_SNAPSHOT.equalsIgnoreCase("Always") || Boolean.FALSE.equals(passFailStatus) && WHEN_TO_TAKE_PAGE_SOURCE_SNAPSHOT.equalsIgnoreCase("FailuresOnly"))) {
            String logMessage = "";
            String pageSnapshot = BrowserActionsHelper.capturePageSnapshot(driver);
            if (pageSnapshot.startsWith("From: <Saved by Blink>")) {
                logMessage = "page snapshot";
            } else if (pageSnapshot.startsWith("<html")) {
                logMessage = "page HTML";
            }
            List<Object> sourceAttachment = Arrays.asList(actionName, logMessage, pageSnapshot);
            attachments.add(sourceAttachment);
        }
        if (rootCauseException != null && rootCauseException.length >= 1) {
            actualValueAttachment = Arrays.asList("Element Action Exception - " + actionName, "Stacktrace", ReportManagerHelper.formatStackTraceToLogEntry(rootCauseException[0]));
            attachments.add(actualValueAttachment);
        }
        if (attachments.size() == 1 && ((List)attachments.getFirst()).isEmpty()) {
            return null;
        }
        return attachments;
    }

    public static String reportActionResult(WebDriver driver, String actionName, String testData, By elementLocator, List<List<Object>> screenshots, String elementName, Boolean passFailStatus, Throwable ... rootCauseException) {
        Object message = ElementActionsHelper.createReportMessage(actionName, testData, elementName, passFailStatus);
        List<List<Object>> attachments = ElementActionsHelper.createReportAttachments(driver, actionName, testData, elementLocator, screenshots, passFailStatus, rootCauseException);
        if (((String)message).contains("Failed") && rootCauseException != null && rootCauseException.length > 0) {
            String rootCause = " Root cause: \"" + Throwables.getRootCause((Throwable)rootCauseException[0]).getClass().getName() + ": " + Throwables.getRootCause((Throwable)rootCauseException[0]).getLocalizedMessage().split("\n")[0] + "\"";
            message = (String)message + rootCause;
        }
        if (attachments != null && !attachments.equals(new ArrayList())) {
            ReportManagerHelper.log((String)message, attachments);
        } else {
            ReportManager.log((String)message);
        }
        return message;
    }

    public static String formatLocatorToString(By locator) {
        if (locator instanceof RelativeLocator.RelativeBy) {
            RelativeLocator.RelativeBy relativeLocator = (RelativeLocator.RelativeBy)locator;
            return "Relative Locator: " + relativeLocator.getRemoteParameters().value().toString();
        }
        return locator.toString();
    }

    public static enum TextDetectionStrategy {
        TEXT("text"),
        CONTENT("textContent"),
        VALUE("value"),
        UNDEFINED("undefined");

        private final String value;

        private TextDetectionStrategy(String strategy) {
            this.value = strategy;
        }

        public String getValue() {
            return this.value;
        }
    }
}

