/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.element.internal;

import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.openqa.selenium.By;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;

public class ElementInformation {
    private int numberOfFoundElements = 0;
    private WebElement firstElement = null;
    private By locator = null;
    private String outerHTML = "";
    private String innerHTML = "";
    private String elementName = "";
    private String actionResult = "";
    private String elementText = "";
    private String elementTag = "";
    private Rectangle elementRect = null;
    private Element element = null;

    public static ElementInformation fromList(List<Object> elementInformation) {
        ElementInformation temp = new ElementInformation();
        temp.setNumberOfFoundElements((Integer)elementInformation.get(0));
        temp.setFirstElement((WebElement)elementInformation.get(1));
        temp.setLocator((By)elementInformation.get(2));
        temp.setOuterHTML((String)elementInformation.get(3));
        temp.setInnerHTML((String)elementInformation.get(4));
        temp.setElementName((String)elementInformation.get(5));
        temp.setActionResult((String)elementInformation.get(6));
        temp.setElementRect((Rectangle)elementInformation.get(7));
        return temp;
    }

    private static String parseElementText(ElementInformation elementInformation) {
        if (!elementInformation.outerHTML.isEmpty()) {
            if (elementInformation.element.hasText() && !elementInformation.element.text().isEmpty()) {
                return elementInformation.element.text();
            }
            if (elementInformation.element.hasAttr("value") && !elementInformation.element.attr("value").isEmpty()) {
                return elementInformation.element.attr("value");
            }
            if (!elementInformation.innerHTML.isEmpty() && !elementInformation.innerHTML.contains("<")) {
                return elementInformation.innerHTML;
            }
        }
        return "";
    }

    private static Element parseElement(ElementInformation elementInformation) {
        if (!elementInformation.outerHTML.isEmpty()) {
            return ((Element)Jsoup.parse((String)elementInformation.outerHTML).getElementsByTag("body").getFirst()).child(0);
        }
        return new Element("");
    }

    public String getElementText() {
        if (this.element == null) {
            this.setElement(ElementInformation.parseElement(this));
        }
        this.setElementText(ElementInformation.parseElementText(this));
        return this.elementText;
    }

    public String getElementTag() {
        if (this.element == null) {
            this.setElement(ElementInformation.parseElement(this));
        }
        this.setElementTag(ElementInformation.parseElement(this).tagName());
        return this.elementTag;
    }

    public List<Object> toList() {
        ArrayList<Object> temp = new ArrayList<Object>();
        temp.add(this.numberOfFoundElements);
        temp.add(this.firstElement);
        temp.add(this.locator);
        temp.add(this.outerHTML);
        temp.add(this.innerHTML);
        temp.add(this.elementName);
        temp.add(this.actionResult);
        temp.add(this.elementRect);
        return temp;
    }

    public void setNumberOfFoundElements(int numberOfFoundElements) {
        this.numberOfFoundElements = numberOfFoundElements;
    }

    public void setFirstElement(WebElement firstElement) {
        this.firstElement = firstElement;
    }

    public void setLocator(By locator) {
        this.locator = locator;
    }

    public void setOuterHTML(String outerHTML) {
        this.outerHTML = outerHTML;
    }

    public void setInnerHTML(String innerHTML) {
        this.innerHTML = innerHTML;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public void setActionResult(String actionResult) {
        this.actionResult = actionResult;
    }

    public void setElementText(String elementText) {
        this.elementText = elementText;
    }

    public void setElementTag(String elementTag) {
        this.elementTag = elementTag;
    }

    public void setElementRect(Rectangle elementRect) {
        this.elementRect = elementRect;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public int getNumberOfFoundElements() {
        return this.numberOfFoundElements;
    }

    public WebElement getFirstElement() {
        return this.firstElement;
    }

    public By getLocator() {
        return this.locator;
    }

    public String getOuterHTML() {
        return this.outerHTML;
    }

    public String getInnerHTML() {
        return this.innerHTML;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getActionResult() {
        return this.actionResult;
    }

    public Rectangle getElementRect() {
        return this.elementRect;
    }

    public Element getElement() {
        return this.element;
    }
}

