/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.internal.image;

import com.shaft.cli.FileActions;
import com.shaft.driver.SHAFT;
import com.shaft.gui.internal.image.ScreenshotHelper;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.imgscalr.Scalr;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.WebDriverException;

public class AnimatedGifManager {
    private static final ThreadLocal<ImageWriter> gifWriter = new ThreadLocal();
    private static final ThreadLocal<ImageWriteParam> imageWriteParam = new ThreadLocal();
    private static final ThreadLocal<IIOMetadata> imageMetaData = new ThreadLocal();
    protected static final Boolean DETAILED_GIF = true;
    protected static final String DETAILED_GIF_REGEX = "(verify.*)|(assert.*)|(click.*)|(tap.*)|(key.*)|(navigate.*)|(type.*)";
    private static final int GIF_SIZE = 1280;
    private static String gifRelativePathWithFileName = "";
    private static ThreadLocal<ImageOutputStream> gifOutputStream = new ThreadLocal();
    private static ThreadLocal<AnimatedGifManager> gifManager = new ThreadLocal();

    public static String attachAnimatedGif() {
        if (Boolean.TRUE.equals(SHAFT.Properties.visuals.createAnimatedGif()) && !"".equals(gifRelativePathWithFileName)) {
            try {
                ReportManagerHelper.attach("Animated Gif", String.valueOf(System.currentTimeMillis()), new FileInputStream(gifRelativePathWithFileName));
                if (!gifWriter.equals(new ThreadLocal())) {
                    gifManager.get().close();
                }
                if (!gifOutputStream.equals(new ThreadLocal())) {
                    gifOutputStream.get().close();
                }
                gifOutputStream = new ThreadLocal();
                gifManager = new ThreadLocal();
                String gifRelativePath = gifRelativePathWithFileName;
                gifRelativePathWithFileName = "";
                return gifRelativePath;
            }
            catch (FileNotFoundException gifRelativePath) {
            }
            catch (IOException | IllegalStateException | NullPointerException e) {
                ReportManagerHelper.logDiscrete(e);
            }
        }
        return "";
    }

    static void startOrAppendToAnimatedGif(byte[] screenshot) {
        if (Boolean.TRUE.equals(SHAFT.Properties.visuals.createAnimatedGif())) {
            if (gifRelativePathWithFileName.isEmpty()) {
                AnimatedGifManager.startAnimatedGif(screenshot);
            } else {
                AnimatedGifManager.appendToAnimatedGif(screenshot);
            }
        }
    }

    private static void appendToAnimatedGif(byte[] screenshot) {
        try {
            if (screenshot != null && gifManager.get() != null && gifWriter.get() != null) {
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(screenshot));
                image = Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.BALANCED, (int)1280, (BufferedImageOp[])new BufferedImageOp[0]);
                gifManager.get().writeToSequence(ScreenshotHelper.overlayShaftEngineLogo(image));
            }
        }
        catch (NoSuchSessionException image) {
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | NullPointerException | WebDriverException e) {
            ReportManagerHelper.logDiscrete(e);
        }
    }

    protected static void startAnimatedGif(byte[] screenshot) {
        if (Boolean.TRUE.equals(SHAFT.Properties.visuals.createAnimatedGif()) && screenshot != null) {
            try {
                String gifFileName = FileSystems.getDefault().getSeparator() + System.currentTimeMillis() + ".gif";
                gifRelativePathWithFileName = SHAFT.Properties.paths.allureResults() + "/screenshots/" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + gifFileName;
                BufferedImage firstImage = ImageIO.read(new ByteArrayInputStream(screenshot));
                firstImage = Scalr.resize((BufferedImage)firstImage, (Scalr.Method)Scalr.Method.BALANCED, (int)1280, (BufferedImageOp[])new BufferedImageOp[0]);
                FileActions.getInstance(true).createFile(gifRelativePathWithFileName.replace(gifFileName, ""), gifFileName);
                gifOutputStream.set(new FileImageOutputStream(new File(gifRelativePathWithFileName)));
                gifManager.set(new AnimatedGifManager(gifOutputStream.get(), firstImage.getType(), SHAFT.Properties.visuals.animatedGifFrameDelay()));
                BufferedImage initialImage = new BufferedImage(firstImage.getWidth(), firstImage.getHeight(), firstImage.getType());
                Graphics2D initialImageGraphics = initialImage.createGraphics();
                initialImageGraphics.setBackground(Color.WHITE);
                initialImageGraphics.setColor(Color.WHITE);
                initialImageGraphics.clearRect(0, 0, firstImage.getWidth(), firstImage.getHeight());
                gifManager.get().writeToSequence(initialImage);
                initialImageGraphics.dispose();
                gifManager.get().writeToSequence(ScreenshotHelper.overlayShaftEngineLogo(ScreenshotHelper.toBufferedImage(firstImage)));
            }
            catch (NullPointerException | NoSuchSessionException gifFileName) {
            }
            catch (IOException | WebDriverException e) {
                ReportManagerHelper.logDiscrete(e);
            }
        }
    }

    protected AnimatedGifManager(ImageOutputStream outputStream, int imageType, int timeBetweenFramesMS) throws IOException {
        this.initialize(outputStream, imageType, timeBetweenFramesMS);
    }

    private static ImageWriter getWriter() throws IIOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix("gif");
        if (!iterator.hasNext()) {
            throw new IIOException("No GIF Image Writers Exist");
        }
        return iterator.next();
    }

    private static IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            if (rootNode.item(i).getNodeName().compareToIgnoreCase(nodeName) != 0) continue;
            return (IIOMetadataNode)rootNode.item(i);
        }
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        rootNode.appendChild(node);
        return node;
    }

    protected void writeToSequence(RenderedImage img) throws IOException {
        gifWriter.get().writeToSequence(new IIOImage(img, null, imageMetaData.get()), imageWriteParam.get());
    }

    protected void close() throws IOException {
        gifWriter.get().endWriteSequence();
    }

    private void initialize(ImageOutputStream outputStream, int imageType, int timeBetweenFramesMS) throws IOException {
        gifWriter.set(AnimatedGifManager.getWriter());
        imageWriteParam.set(gifWriter.get().getDefaultWriteParam());
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(imageType);
        imageMetaData.set(gifWriter.get().getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam.get()));
        String metaFormatName = imageMetaData.get().getNativeMetadataFormatName();
        IIOMetadataNode root = (IIOMetadataNode)imageMetaData.get().getAsTree(metaFormatName);
        IIOMetadataNode graphicsControlExtensionNode = AnimatedGifManager.getNode(root, "GraphicControlExtension");
        graphicsControlExtensionNode.setAttribute("disposalMethod", "none");
        graphicsControlExtensionNode.setAttribute("userInputFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("transparentColorFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("delayTime", Integer.toString(timeBetweenFramesMS / 10));
        graphicsControlExtensionNode.setAttribute("transparentColorIndex", "0");
        IIOMetadataNode commentsNode = AnimatedGifManager.getNode(root, "CommentExtensions");
        commentsNode.setAttribute("CommentExtension", "Created by MAH");
        IIOMetadataNode appExtensionsNode = AnimatedGifManager.getNode(root, "ApplicationExtensions");
        IIOMetadataNode child = new IIOMetadataNode("ApplicationExtension");
        child.setAttribute("applicationID", "NETSCAPE");
        child.setAttribute("authenticationCode", "2.0");
        int loop = 0;
        child.setUserObject(new byte[]{1, (byte)(loop & 0xFF), (byte)(loop >> 8 & 0xFF)});
        appExtensionsNode.appendChild(child);
        imageMetaData.get().setFromTree(metaFormatName, root);
        gifWriter.get().setOutput(outputStream);
        gifWriter.get().prepareWriteSequence(null);
    }
}

