/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.internal.image;

import com.applitools.eyes.LogHandler;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.exceptions.DiffsFoundException;
import com.applitools.eyes.images.Eyes;
import com.assertthat.selenium_shutterbug.core.CaptureElement;
import com.assertthat.selenium_shutterbug.core.ElementSnapshot;
import com.assertthat.selenium_shutterbug.core.Shutterbug;
import com.assertthat.selenium_shutterbug.utils.image.UnableToCompareImagesException;
import com.shaft.cli.FileActions;
import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.gui.element.internal.ElementActionsHelper;
import com.shaft.gui.internal.image.ScreenshotHelper;
import com.shaft.gui.internal.image.ScreenshotManager;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import com.shaft.validation.Validations;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import nu.pattern.OpenCV;
import org.opencv.core.Core;
import org.opencv.core.CvException;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.highgui.HighGui;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.openqa.selenium.By;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Browser;

public class ImageProcessingActions {
    private static final String DIRECTORY_PROCESSING = "/processingDirectory/";
    private static final String DIRECTORY_FAILED = "/failedImagesDirectory/";
    private static final int CV_THRESH_OTSU = 8;
    private static final int CV_THRESH_BINARY = 0;
    private static String aiFolderPath = "";

    private ImageProcessingActions() {
        throw new IllegalStateException("Utility class");
    }

    public static void compareImageFolders(String referenceFolderPath, String testFolderPath, double threshold) {
        try {
            long fileCounter = 1L;
            File referenceFolder = new File(referenceFolderPath);
            File testFolder = new File(testFolderPath);
            FileActions.getInstance(true).deleteFolder(referenceFolder.getAbsolutePath() + DIRECTORY_PROCESSING);
            FileActions.getInstance(true).deleteFolder(testFolder.getAbsolutePath() + DIRECTORY_PROCESSING);
            FileActions.getInstance(true).deleteFolder(testFolder.getAbsolutePath() + DIRECTORY_FAILED);
            Object[] referenceFiles = referenceFolder.listFiles();
            Object[] testFiles = testFolder.listFiles();
            ReportManager.log("Comparing [" + Objects.requireNonNull(testFiles).length + "] image files from the testFolder [" + testFolder.getPath() + "] against [" + Objects.requireNonNull(referenceFiles).length + "] image files from the referenceFolder [" + testFolder.getPath() + "]");
            Arrays.sort(referenceFiles);
            Arrays.sort(testFiles);
            if (referenceFiles.length == testFiles.length) {
                for (Object referenceScreenshot : referenceFiles) {
                    FileActions.getInstance(true).copyFile(((File)referenceScreenshot).getAbsolutePath(), ((File)referenceScreenshot).getParent() + DIRECTORY_PROCESSING + fileCounter);
                    ++fileCounter;
                }
                fileCounter = 1L;
                for (Object testScreenshot : testFiles) {
                    FileActions.getInstance(true).copyFile(((File)testScreenshot).getAbsolutePath(), ((File)testScreenshot).getParent() + DIRECTORY_PROCESSING + fileCounter);
                    ++fileCounter;
                }
                File referenceProcessingFolder = new File(referenceFolderPath + DIRECTORY_PROCESSING);
                File testProcessingFolder = new File(testFolderPath + DIRECTORY_PROCESSING);
                Object[] testProcessingFiles = testProcessingFolder.listFiles();
                if (testProcessingFiles != null) {
                    Arrays.sort(testProcessingFiles);
                }
                ImageProcessingActions.compareImageFolders((File[])referenceFiles, (File[])testFiles, (File[])Objects.requireNonNull(testProcessingFiles), referenceProcessingFolder, testProcessingFolder, threshold);
                FileActions.getInstance(true).deleteFolder(referenceFolder.getAbsolutePath() + DIRECTORY_PROCESSING);
                FileActions.getInstance(true).deleteFolder(testFolder.getAbsolutePath() + DIRECTORY_PROCESSING);
            } else {
                String message = "Number of screenshots  [" + testFiles.length + "] from the test folder [" + testFolderPath + "] do not match the number of screenshots [" + referenceFiles.length + "] from the reference folder [" + referenceFolderPath + "].";
                FailureReporter.fail(message);
            }
        }
        catch (IOException | NullPointerException e) {
            ReportManagerHelper.logDiscrete(e);
            ReportManager.log("Failed to compare image files ...");
        }
    }

    public static byte[] highlightElementInScreenshot(byte[] targetScreenshot, Rectangle elementLocation, Color highlightColor) {
        Mat img = Imgcodecs.imdecode((Mat)new MatOfByte(targetScreenshot), (int)1);
        int outlineThickness = 5;
        double elementHeight = elementLocation.getHeight();
        double elementWidth = elementLocation.getWidth();
        double xPos = elementLocation.getX();
        double yPos = elementLocation.getY();
        if (SHAFT.Properties.platform.targetPlatform().equalsIgnoreCase(Platform.IOS.name()) || SHAFT.Properties.platform.targetPlatform().equalsIgnoreCase(Platform.MAC.name()) || SHAFT.Properties.platform.targetPlatform().equalsIgnoreCase(Platform.LINUX.name()) && SHAFT.Properties.visuals.screenshotParamsScalingFactor() != Double.parseDouble("1") || SHAFT.Properties.platform.targetPlatform().equalsIgnoreCase(Platform.LINUX.name()) && SHAFT.Properties.visuals.screenshotParamsScalingFactor() != Double.parseDouble("1")) {
            elementHeight *= 2.0;
            elementWidth *= 2.0;
            xPos *= 2.0;
            yPos *= 2.0;
        }
        if (SHAFT.Properties.platform.targetPlatform().equalsIgnoreCase(Platform.IOS.name()) && SHAFT.Properties.mobile.browserName().equalsIgnoreCase(Browser.SAFARI.browserName())) {
            yPos += elementHeight + (double)(2 * outlineThickness);
        }
        if (SHAFT.Properties.platform.targetPlatform().equalsIgnoreCase(Platform.ANDROID.name()) && SHAFT.Properties.mobile.appPackage().equalsIgnoreCase("com.android.chrome")) {
            yPos += (double)(2 * outlineThickness);
        }
        if (SHAFT.Properties.platform.targetPlatform().equalsIgnoreCase(Platform.MAC.name())) {
            yPos += (double)(2 * outlineThickness);
        }
        if (SHAFT.Properties.platform.targetPlatform().equalsIgnoreCase(Platform.WINDOWS.name())) {
            double scalingFactor = SHAFT.Properties.visuals.screenshotParamsScalingFactor();
            elementHeight *= scalingFactor;
            elementWidth *= scalingFactor;
            xPos *= scalingFactor;
            yPos *= scalingFactor;
        }
        Point startPoint = new Point(xPos - (double)outlineThickness, yPos - (double)outlineThickness);
        Point endPoint = new Point(xPos + elementWidth + (double)outlineThickness, yPos + elementHeight + (double)outlineThickness);
        Scalar highlightColorScalar = new Scalar((double)highlightColor.getBlue(), (double)highlightColor.getGreen(), (double)highlightColor.getRed());
        Imgproc.rectangle((Mat)img, (Point)startPoint, (Point)endPoint, (Scalar)highlightColorScalar, (int)outlineThickness, (int)8, (int)0);
        Image tmpImg = HighGui.toBufferedImage((Mat)img);
        BufferedImage image = (BufferedImage)tmpImg;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "jpg", baos);
        }
        catch (IOException e) {
            ReportManagerHelper.logDiscrete(e);
        }
        return baos.toByteArray();
    }

    private static Mat preprocess(byte[] image) {
        Mat imgGray = new Mat();
        Mat imgGaussianBlur = new Mat();
        Mat imgSobel = new Mat();
        Mat imgThreshold = new Mat();
        Mat img = Imgcodecs.imdecode((Mat)new MatOfByte(image), (int)1);
        Imgproc.cvtColor((Mat)img, (Mat)imgGray, (int)6);
        Imgproc.GaussianBlur((Mat)imgGray, (Mat)imgGaussianBlur, (Size)new Size(3.0, 3.0), (double)0.0);
        Imgproc.Sobel((Mat)imgGaussianBlur, (Mat)imgSobel, (int)-1, (int)1, (int)0);
        Imgproc.threshold((Mat)imgSobel, (Mat)imgThreshold, (double)0.0, (double)255.0, (int)8);
        if (SHAFT.Properties.reporting.debugMode()) {
            FileActions.getInstance(true).createFolder("target/openCV/temp/");
            String timestamp = String.valueOf(System.currentTimeMillis());
            Imgcodecs.imwrite((String)("target/openCV/temp/" + timestamp + "_1_True_Image.png"), (Mat)img);
            Imgcodecs.imwrite((String)("target/openCV/temp/" + timestamp + "_2_imgGray.png"), (Mat)imgGray);
            Imgcodecs.imwrite((String)("target/openCV/temp/" + timestamp + "_3_imgGaussianBlur.png"), (Mat)imgGaussianBlur);
            Imgcodecs.imwrite((String)("target/openCV/temp/" + timestamp + "_4_imgSobel.png"), (Mat)imgSobel);
            Imgcodecs.imwrite((String)("target/openCV/temp/" + timestamp + "_5_imgThreshold.png"), (Mat)imgThreshold);
        }
        return imgThreshold;
    }

    private static List<Integer> attemptToFindImageUsingOpenCV(String referenceImagePath, byte[] currentPageScreenshot, int attemptNumber) {
        if (currentPageScreenshot == null || Arrays.equals(currentPageScreenshot, new byte[0])) {
            ReportManager.log("Failed to identify the element using AI; target screenshot is empty.");
        } else {
            Mat img_original = Imgcodecs.imdecode((Mat)new MatOfByte(currentPageScreenshot), (int)1);
            Mat templ_original = Imgcodecs.imread((String)referenceImagePath, (int)1);
            Mat img = ImageProcessingActions.preprocess(currentPageScreenshot);
            Mat templ = ImageProcessingActions.preprocess(FileActions.getInstance(true).readFileAsByteArray(referenceImagePath));
            int resultCols = img.cols() - templ.cols() + 1;
            int resultRows = img.rows() - templ.rows() + 1;
            Mat result = new Mat(resultRows, resultCols, CvType.CV_32FC1);
            try {
                double matchAccuracy;
                Point matchLoc;
                int matchMethod = 5;
                double threshold = SHAFT.Properties.visuals.visualMatchingThreshold();
                switch (attemptNumber) {
                    case 1: {
                        matchMethod = 1;
                        break;
                    }
                    case 2: {
                        matchMethod = 3;
                    }
                }
                Imgproc.matchTemplate((Mat)img, (Mat)templ, (Mat)result, (int)matchMethod);
                Core.MinMaxLocResult mmr = Core.minMaxLoc((Mat)result);
                if (matchMethod == 0 || matchMethod == 1) {
                    matchLoc = mmr.minLoc;
                    double minMaxVal = mmr.minVal;
                    matchAccuracy = 1.0 - minMaxVal;
                } else {
                    double minMaxVal;
                    matchLoc = mmr.maxLoc;
                    matchAccuracy = minMaxVal = mmr.maxVal;
                }
                String accuracyMessage = "Match accuracy is " + (int)Math.round(matchAccuracy * 100.0) + "% and threshold is " + (int)Math.round(threshold * 100.0) + "%. Match Method: " + matchMethod + ".";
                ReportManager.logDiscrete(accuracyMessage);
                if (SHAFT.Properties.reporting.debugMode()) {
                    try {
                        FileActions.getInstance(true).createFolder("target/openCV/");
                        String timestamp = String.valueOf(System.currentTimeMillis());
                        File output = new File("target/openCV/" + timestamp + "_1_templ.png");
                        ImageIO.write((RenderedImage)((BufferedImage)HighGui.toBufferedImage((Mat)templ_original)), "png", output);
                        output = new File("target/openCV/" + timestamp + "_3_img.png");
                        ImageIO.write((RenderedImage)((BufferedImage)HighGui.toBufferedImage((Mat)img_original)), "png", output);
                        Imgproc.rectangle((Mat)img_original, (Point)matchLoc, (Point)new Point(matchLoc.x + (double)templ.cols(), matchLoc.y + (double)templ.rows()), (Scalar)new Scalar(0.0, 0.0, 0.0), (int)2, (int)8, (int)0);
                        output = new File("target/openCV/" + timestamp + "_5_output.png");
                        ImageIO.write((RenderedImage)((BufferedImage)HighGui.toBufferedImage((Mat)img_original)), "png", output);
                    }
                    catch (IOException e) {
                        ReportManagerHelper.logDiscrete(e);
                        return Collections.emptyList();
                    }
                }
                if (matchAccuracy < threshold) {
                    return Collections.emptyList();
                }
                int x = Integer.parseInt(String.valueOf(matchLoc.x + 1.0).split("\\.")[0]);
                int y = Integer.parseInt(String.valueOf(matchLoc.y + 1.0).split("\\.")[0]);
                try {
                    Imgproc.rectangle((Mat)img_original, (Point)matchLoc, (Point)new Point(matchLoc.x + (double)templ.cols(), matchLoc.y + (double)templ.rows()), (Scalar)new Scalar(67.0, 176.0, 42.0), (int)2, (int)8, (int)0);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)((BufferedImage)HighGui.toBufferedImage((Mat)img_original)), "png", baos);
                    List<Object> screenshot = ScreenshotManager.prepareImageForReport(baos.toByteArray(), "AI identified element");
                    LinkedList<List<Object>> attachments = new LinkedList<List<Object>>();
                    attachments.add(screenshot);
                    ReportManagerHelper.log("Successfully identified the element using AI; OpenCV. " + accuracyMessage, attachments);
                }
                catch (IOException e) {
                    ReportManager.log("Successfully identified the element using AI; OpenCV. " + accuracyMessage);
                }
                return Arrays.asList(x, y);
            }
            catch (CvException e) {
                ReportManagerHelper.logDiscrete(e);
                ReportManager.log("Failed to identify the element using AI; openCV core exception.");
            }
        }
        return Collections.emptyList();
    }

    public static List<Integer> findImageWithinCurrentPage(String referenceImagePath, byte[] currentPageScreenshot) {
        int maxNumberOfAttempts = 3;
        int attempts = 0;
        List<Integer> foundLocation = Collections.emptyList();
        do {
            try {
                foundLocation = ImageProcessingActions.attemptToFindImageUsingOpenCV(referenceImagePath, currentPageScreenshot, attempts);
            }
            catch (Exception e) {
                ReportManagerHelper.logDiscrete(e);
            }
        } while (Collections.emptyList().equals(foundLocation) && ++attempts < maxNumberOfAttempts);
        return foundLocation;
    }

    public static String formatElementLocatorToImagePath(By elementLocator) {
        String elementFileName = ReportManagerHelper.getCallingMethodFullName() + "_" + ElementActionsHelper.formatLocatorToString(elementLocator);
        return elementFileName.replaceAll("[\\[\\]\\'\\/:]", "").replaceAll("[\\W\\s]", "_").replaceAll("_{2}", "_").replaceAll("_{2}", "_").replaceAll("contains", "_contains").replaceAll("_$", "");
    }

    public static byte[] getReferenceImage(By elementLocator) {
        String hashedLocatorName = ImageProcessingActions.formatElementLocatorToImagePath(elementLocator);
        if (aiFolderPath.isEmpty()) {
            aiFolderPath = ScreenshotHelper.getAiAidedElementIdentificationFolderPath();
        }
        String referenceImagePath = aiFolderPath + hashedLocatorName + ".png";
        if (FileActions.getInstance(true).doesFileExist(referenceImagePath)) {
            return FileActions.getInstance(true).readFileAsByteArray(referenceImagePath);
        }
        return new byte[0];
    }

    public static byte[] getShutterbugDifferencesImage(By elementLocator) {
        String hashedLocatorName = ImageProcessingActions.formatElementLocatorToImagePath(elementLocator);
        String referenceImagePath = aiFolderPath + hashedLocatorName + "_shutterbug.png";
        if (FileActions.getInstance(true).doesFileExist(referenceImagePath)) {
            return FileActions.getInstance(true).readFileAsByteArray(referenceImagePath);
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean compareAgainstBaseline(WebDriver driver, By elementLocator, byte[] elementScreenshot, VisualValidationEngine visualValidationEngine) {
        String hashedLocatorName = ImageProcessingActions.formatElementLocatorToImagePath(elementLocator);
        if (visualValidationEngine == VisualValidationEngine.EXACT_SHUTTERBUG) {
            String referenceImagePath = aiFolderPath + hashedLocatorName + ".png";
            String resultingImagePath = aiFolderPath + hashedLocatorName + "_shutterbug";
            boolean doesReferenceFileExist = FileActions.getInstance(true).doesFileExist(referenceImagePath);
            if (doesReferenceFileExist && elementScreenshot != null && elementScreenshot.length > 0) {
                boolean actualResult = false;
                try {
                    ElementSnapshot snapshot = Shutterbug.shootElement((WebDriver)driver, (By)elementLocator, (CaptureElement)CaptureElement.VIEWPORT, (boolean)true);
                    actualResult = snapshot.equalsWithDiff(referenceImagePath, resultingImagePath, 0.1);
                }
                catch (IOException e) {
                    ReportManagerHelper.logDiscrete(e);
                }
                catch (UnableToCompareImagesException | UnsupportedCommandException exception) {
                    ReportManager.logDiscrete("Failed to locate element using \"" + String.valueOf((Object)VisualValidationEngine.EXACT_SHUTTERBUG) + "\", attempting to use \"" + String.valueOf((Object)VisualValidationEngine.EXACT_OPENCV) + "\".");
                    actualResult = ImageProcessingActions.compareAgainstBaseline(driver, elementLocator, elementScreenshot, VisualValidationEngine.EXACT_OPENCV);
                }
                return actualResult;
            }
            ReportManager.logDiscrete("Passing the test and saving a reference image");
            FileActions.getInstance(true).writeToFile(aiFolderPath, hashedLocatorName + ".png", elementScreenshot);
            return true;
        }
        if (visualValidationEngine == VisualValidationEngine.EXACT_OPENCV) {
            String referenceImagePath = aiFolderPath + hashedLocatorName + ".png";
            boolean doesReferenceFileExist = FileActions.getInstance(true).doesFileExist(referenceImagePath);
            if (!doesReferenceFileExist || !ImageProcessingActions.findImageWithinCurrentPage(referenceImagePath, elementScreenshot).equals(Collections.emptyList())) {
                if (!doesReferenceFileExist) {
                    ReportManager.logDiscrete("Passing the test and saving a reference image");
                    FileActions.getInstance(true).writeToFile(aiFolderPath, hashedLocatorName + ".png", elementScreenshot);
                }
                return true;
            }
            return false;
        }
        Eyes eyes = new Eyes();
        eyes.setLogHandler(new LogHandler(){

            public void open() {
            }

            public void onMessage(boolean b, String s) {
                ReportManager.logDiscrete(s);
            }

            public void close() {
            }
        });
        eyes.setApiKey(SHAFT.Properties.paths.applitoolsApiKey());
        MatchLevel targetMatchLevel = MatchLevel.STRICT;
        switch (visualValidationEngine.ordinal()) {
            case 2: {
                targetMatchLevel = MatchLevel.EXACT;
                break;
            }
            case 4: {
                targetMatchLevel = MatchLevel.CONTENT;
                break;
            }
            case 5: {
                targetMatchLevel = MatchLevel.LAYOUT;
                break;
            }
        }
        eyes.setMatchLevel(targetMatchLevel);
        if (DriverFactoryHelper.isMobileNativeExecution()) {
            eyes.setHostOS(SHAFT.Properties.mobile.platformName() + "_" + SHAFT.Properties.mobile.platformVersion());
            eyes.setHostApp("NativeMobileExecution");
        } else if (DriverFactoryHelper.isMobileWebExecution()) {
            eyes.setHostOS(SHAFT.Properties.mobile.platformName() + "_" + SHAFT.Properties.mobile.platformVersion());
            eyes.setHostApp(SHAFT.Properties.mobile.browserName());
        } else {
            eyes.setHostOS(SHAFT.Properties.platform.targetPlatform());
            eyes.setHostApp(SHAFT.Properties.web.targetBrowserName());
        }
        try {
            eyes.open("SHAFT_Engine", ReportManagerHelper.getCallingMethodFullName());
            eyes.checkImage(elementScreenshot, hashedLocatorName);
            TestResults eyesValidationResult = eyes.close();
            ReportManager.logDiscrete("Successfully validated the element using AI; Applitools Eyes.");
            Boolean bl = eyesValidationResult.isNew() || eyesValidationResult.isPassed();
            return bl;
        }
        catch (DiffsFoundException e) {
            ReportManagerHelper.logDiscrete(e);
            Boolean bl = false;
            return bl;
        }
        finally {
            eyes.abortIfNotClosed();
        }
    }

    private static void compareImageFolders(File[] referenceFiles, File[] testFiles, File[] testProcessingFiles, File referenceProcessingFolder, File testProcessingFolder, double threshold) throws IOException {
        int passedImagesCount = 0;
        int failedImagesCount = 0;
        for (File screenshot : testProcessingFiles) {
            float percentage = 0.0f;
            BufferedImage biA = ImageIO.read(screenshot);
            DataBuffer dbA = biA.getData().getDataBuffer();
            float sizeA = dbA.getSize();
            BufferedImage biB = ImageIO.read(new File(String.valueOf(referenceProcessingFolder) + FileSystems.getDefault().getSeparator() + screenshot.getName()));
            DataBuffer dbB = biB.getData().getDataBuffer();
            float sizeB = dbB.getSize();
            float count = 0.0f;
            if (sizeA == sizeB) {
                int i = 0;
                while ((float)i < sizeA) {
                    if (dbA.getElem(i) == dbB.getElem(i)) {
                        count += 1.0f;
                    }
                    ++i;
                }
                percentage = count * 100.0f / sizeA;
            } else {
                ReportManager.log("Both the images are not of same size");
            }
            String relatedReferenceFileName = referenceFiles[Integer.parseInt(screenshot.getName()) - 1].getName();
            List<Object> referenceScreenshotAttachment = Arrays.asList("Reference Screenshot", relatedReferenceFileName, new FileInputStream(String.valueOf(referenceProcessingFolder) + FileSystems.getDefault().getSeparator() + screenshot.getName()));
            String relatedTestFileName = testFiles[Integer.parseInt(screenshot.getName()) - 1].getName();
            List<Object> testScreenshotAttachment = Arrays.asList("Test Screenshot", relatedTestFileName, new FileInputStream(screenshot));
            ReportManagerHelper.log("Test Screenshot [" + relatedTestFileName + "] and related Reference Image [" + relatedReferenceFileName + "] match by [" + percentage + "] percent.", Arrays.asList(referenceScreenshotAttachment, testScreenshotAttachment));
            boolean discreetLoggingState = ReportManagerHelper.getDiscreteLogging();
            try {
                ReportManagerHelper.setDiscreteLogging(true);
                Validations.assertThat().number(Float.valueOf(percentage)).isGreaterThanOrEquals(threshold).perform();
                ReportManagerHelper.setDiscreteLogging(discreetLoggingState);
                ++passedImagesCount;
            }
            catch (AssertionError e) {
                ReportManagerHelper.setDiscreteLogging(discreetLoggingState);
                FileActions.getInstance(true).copyFile(screenshot.getAbsolutePath(), testProcessingFolder.getParent() + DIRECTORY_FAILED + relatedTestFileName + "_testImage");
                FileActions.getInstance(true).copyFile(String.valueOf(referenceProcessingFolder) + FileSystems.getDefault().getSeparator() + screenshot.getName(), testProcessingFolder.getParent() + DIRECTORY_FAILED + relatedTestFileName + "_referenceImage");
                ++failedImagesCount;
            }
            Validations.verifyThat().number(Float.valueOf(percentage)).isGreaterThanOrEquals(threshold).perform();
        }
        ReportManager.log("[" + passedImagesCount + "] images passed, and [" + failedImagesCount + "] images failed the threshold of [" + threshold + "%] matching.");
    }

    public static void loadOpenCV() {
        String libName = "";
        try {
            libName = Core.NATIVE_LIBRARY_NAME;
            OpenCV.loadLocally();
            ReportManager.logDiscrete("Loaded OpenCV \"" + libName + "\".");
        }
        catch (Throwable throwable) {
            ReportManagerHelper.logDiscrete(throwable);
            if (!libName.isEmpty()) {
                ReportManager.logDiscrete("Failed to load OpenCV \"" + libName + "\". Try installing the binaries manually https://opencv.org/releases/, switching element highlighting to JavaScript...");
            } else {
                ReportManager.logDiscrete("Failed to load OpenCV. Try installing the binaries manually https://opencv.org/releases/, switching element highlighting to JavaScript...");
            }
            SHAFT.Properties.visuals.set().screenshotParamsHighlightMethod("JavaScript");
        }
    }

    public static enum VisualValidationEngine {
        EXACT_SHUTTERBUG,
        EXACT_OPENCV,
        EXACT_EYES,
        STRICT_EYES,
        CONTENT_EYES,
        LAYOUT_EYES;

    }
}

