/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.internal.image;

import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.enums.internal.Screenshots;
import com.shaft.gui.internal.image.ScreenshotManager;
import com.shaft.properties.internal.Properties;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.Level;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chromium.HasCdp;
import org.openqa.selenium.firefox.FirefoxDriver;

public class ScreenshotHelper {
    private static final String JS_RETRIEVE_DEVICE_PIXEL_RATIO = "var pr = window.devicePixelRatio; if (pr != undefined && pr != null)return pr; else return 1.0;";
    private static String AI_AIDED_ELEMENT_IDENTIFICATION_FOLDER_PATH = "";
    private static BufferedImage shaftLogo = null;

    private ScreenshotHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static String getAiAidedElementIdentificationFolderPath() {
        if (AI_AIDED_ELEMENT_IDENTIFICATION_FOLDER_PATH.isEmpty()) {
            AI_AIDED_ELEMENT_IDENTIFICATION_FOLDER_PATH = Properties.paths.dynamicObjectRepository() + Properties.platform.targetPlatform() + "/";
            if (DriverFactoryHelper.isMobileNativeExecution()) {
                if (!Properties.mobile.platformVersion().isEmpty()) {
                    AI_AIDED_ELEMENT_IDENTIFICATION_FOLDER_PATH = AI_AIDED_ELEMENT_IDENTIFICATION_FOLDER_PATH + Properties.mobile.platformVersion() + "/";
                }
            } else {
                AI_AIDED_ELEMENT_IDENTIFICATION_FOLDER_PATH = AI_AIDED_ELEMENT_IDENTIFICATION_FOLDER_PATH + Properties.web.targetBrowserName() + "/";
            }
            return AI_AIDED_ELEMENT_IDENTIFICATION_FOLDER_PATH.replace(".", "_").replace(" ", "_");
        }
        return AI_AIDED_ELEMENT_IDENTIFICATION_FOLDER_PATH;
    }

    protected static BufferedImage overlayShaftEngineLogo(BufferedImage screenshot) {
        if (Boolean.TRUE.equals(SHAFT.Properties.visuals.screenshotParamsWatermark())) {
            try {
                Graphics2D screenshotGraphics = screenshot.createGraphics();
                screenshotGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                screenshotGraphics.drawImage((Image)screenshot, 0, 0, null);
                screenshotGraphics.setComposite(AlphaComposite.getInstance(3, SHAFT.Properties.visuals.screenshotParamsWatermarkOpacity()));
                if (shaftLogo == null) {
                    String watermarkImagePath = Properties.internal.watermarkImagePath();
                    shaftLogo = ImageIO.read(URI.create(watermarkImagePath).toURL());
                    shaftLogo = ScreenshotHelper.toBufferedImage(shaftLogo.getScaledInstance(screenshot.getWidth() / 8, -1, 4));
                }
                screenshotGraphics.drawImage((Image)shaftLogo, screenshot.getWidth() - shaftLogo.getWidth(), screenshot.getHeight() - shaftLogo.getHeight(), null);
                screenshotGraphics.dispose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return screenshot;
    }

    protected static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bufferedImage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bufferedImage;
    }

    protected static byte[] makeFullScreenshot(WebDriver driver, WebElement ... skipElements) throws IOException {
        if (driver instanceof FirefoxDriver) {
            FirefoxDriver firefoxDriver = (FirefoxDriver)driver;
            return (byte[])firefoxDriver.getFullPageScreenshotAs(OutputType.BYTES);
        }
        if (driver instanceof HasCdp) {
            HasCdp cdpDriver = (HasCdp)driver;
            return ScreenshotHelper.takeFullPageScreenshotUsingCDP(driver, cdpDriver);
        }
        return ScreenshotHelper.takeFullPageScreenshotManually(driver, skipElements);
    }

    protected static byte[] takeViewportScreenshot(WebDriver driver, int retryAttempts) {
        try {
            return (byte[])((TakesScreenshot)driver).getScreenshotAs(OutputType.BYTES);
        }
        catch (RuntimeException exception) {
            if (retryAttempts <= 0) {
                ReportManagerHelper.logDiscrete(exception, Level.WARN);
                ReportManagerHelper.logDiscrete("Failed to take a screenshot after 5 attempts.", Level.WARN);
                return null;
            }
            if (exception.getMessage().contains("Permission denied to access property \"pageXOffset\" on cross-origin object") || exception.getMessage().contains("not connected to DevTools") || exception.getMessage().contains("unhandled inspector error: {\"code\":-32000,\"message\":\"Unable to capture screenshot\"}")) {
                driver.switchTo().defaultContent();
                return ScreenshotHelper.takeViewportScreenshot(driver, retryAttempts - 1);
            }
            FailureReporter.fail(ScreenshotManager.class, "Failed to capture a screenshot", exception);
            return null;
        }
    }

    private static byte[] takeFullPageScreenshotUsingCDP(WebDriver driver, HasCdp cdpDriver) throws IOException {
        try {
            Map page_rect = cdpDriver.executeCdpCommand("Page.getLayoutMetrics", new HashMap());
            Map contentSize = (Map)page_rect.get("contentSize");
            Number contentWidth = (Number)contentSize.get("width");
            Number contentHeight = (Number)contentSize.get("height");
            HashMap<String, Number> clip = new HashMap<String, Number>();
            clip.put("width", (double)((Long)contentWidth).longValue() / SHAFT.Properties.visuals.screenshotParamsScalingFactor());
            clip.put("height", (double)((Long)contentHeight).longValue() / SHAFT.Properties.visuals.screenshotParamsScalingFactor());
            clip.put("x", 0);
            clip.put("y", 0);
            clip.put("scale", 1);
            HashMap<String, Serializable> screenshot_config = new HashMap<String, Serializable>();
            screenshot_config.put("optimizeForSpeed", Boolean.valueOf(true));
            screenshot_config.put("captureBeyondViewport", Boolean.valueOf(true));
            screenshot_config.put("fromSurface", Boolean.valueOf(true));
            screenshot_config.put("clip", clip);
            Map result = cdpDriver.executeCdpCommand("Page.captureScreenshot", screenshot_config);
            String base64EncodedPng = (String)result.get("data");
            return (byte[])OutputType.BYTES.convertFromBase64Png(base64EncodedPng);
        }
        catch (TimeoutException timeoutException) {
            return ScreenshotHelper.takeFullPageScreenshotManually(driver, new WebElement[0]);
        }
    }

    private static byte[] takeFullPageScreenshotManually(WebDriver driver, WebElement ... skipElements) throws IOException {
        BufferedImage resultingImage;
        ScreenshotHelper.scrollVerticallyTo(driver, 0);
        ScreenshotHelper.hideScroll(driver);
        byte[] bytes = ScreenshotManager.takeScreenshot(driver, null, Screenshots.VIEWPORT);
        ScreenshotHelper.showHideElements(driver, true, skipElements);
        long longScrollHeight = (Long)((JavascriptExecutor)driver).executeScript("return Math.max(document.body.scrollHeight, document.documentElement.scrollHeight,document.body.offsetHeight, document.documentElement.offsetHeight,document.body.clientHeight, document.documentElement.clientHeight);", new Object[0]);
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(bytes));
        int capturedWidth = image.getWidth();
        int capturedHeight = image.getHeight();
        double devicePixelRatio = ((Number)((JavascriptExecutor)driver).executeScript(JS_RETRIEVE_DEVICE_PIXEL_RATIO, new Object[0])).doubleValue();
        int scrollHeight = (int)longScrollHeight;
        int adaptedCapturedHeight = (int)((double)capturedHeight / devicePixelRatio);
        if (Math.abs(adaptedCapturedHeight - scrollHeight) > 40) {
            int times = scrollHeight / adaptedCapturedHeight;
            int leftover = scrollHeight % adaptedCapturedHeight;
            BufferedImage tiledImage = new BufferedImage(capturedWidth, (int)((double)scrollHeight * devicePixelRatio), 1);
            Graphics2D g2dTile = tiledImage.createGraphics();
            g2dTile.drawImage((Image)image, 0, 0, null);
            int scroll = 0;
            for (int i = 0; i < times - 1; ++i) {
                ScreenshotHelper.scrollVerticallyTo(driver, scroll += adaptedCapturedHeight);
                BufferedImage nextImage = ImageIO.read(new ByteArrayInputStream(ScreenshotManager.takeScreenshot(driver, null, Screenshots.VIEWPORT)));
                g2dTile.drawImage((Image)nextImage, 0, (i + 1) * capturedHeight, null);
            }
            if (leftover > 0) {
                ScreenshotHelper.scrollVerticallyTo(driver, scroll += adaptedCapturedHeight);
                BufferedImage nextImage = ImageIO.read(new ByteArrayInputStream(ScreenshotManager.takeScreenshot(driver, null, Screenshots.VIEWPORT)));
                BufferedImage lastPart = nextImage.getSubimage(0, nextImage.getHeight() - (int)((double)leftover * devicePixelRatio), nextImage.getWidth(), leftover);
                g2dTile.drawImage((Image)lastPart, 0, times * capturedHeight, null);
            }
            ScreenshotHelper.scrollVerticallyTo(driver, 0);
            resultingImage = tiledImage;
        } else {
            resultingImage = image;
        }
        ScreenshotHelper.showScroll(driver);
        ScreenshotHelper.showHideElements(driver, false, skipElements);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)resultingImage, "png", (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static void hideScroll(WebDriver driver) {
        ((JavascriptExecutor)driver).executeScript("document.documentElement.style.overflow = 'hidden';", new Object[0]);
    }

    private static void showScroll(WebDriver driver) {
        ((JavascriptExecutor)driver).executeScript("document.documentElement.style.overflow = 'visible';", new Object[0]);
    }

    private static void showHideElements(WebDriver driver, Boolean hide, WebElement ... skipElements) {
        String display = Boolean.TRUE.equals(hide) ? "none" : "block";
        if (skipElements != null) {
            for (WebElement skipElement : skipElements) {
                ((JavascriptExecutor)driver).executeScript("arguments[0].style.display = arguments[1];", new Object[]{skipElement, display});
            }
        }
    }

    private static void scrollVerticallyTo(WebDriver driver, int scroll) {
        ((JavascriptExecutor)driver).executeScript("window.scrollTo(0, \"arguments[0]\");", new Object[]{scroll});
        try {
            ScreenshotHelper.waitUntilItIsScrolledToPosition(driver, scroll);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void waitUntilItIsScrolledToPosition(WebDriver driver, int scrollPosition) throws InterruptedException {
        boolean isScrolledToPosition = false;
        for (int time = 250; time >= 0 && !isScrolledToPosition; time -= 50) {
            Thread.sleep(50L);
            isScrolledToPosition = Math.abs(ScreenshotHelper.obtainVerticalScrollPosition(driver) - scrollPosition) < 3;
        }
    }

    private static int obtainVerticalScrollPosition(WebDriver driver) {
        Long scrollLong = (Long)((JavascriptExecutor)driver).executeScript("return (window.pageYOffset !== undefined) ? window.pageYOffset : (document.documentElement || document.body.parentNode || document.body).scrollTop;", new Object[0]);
        return scrollLong.intValue();
    }
}

