/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.internal.image;

import com.epam.healenium.SelfHealingDriver;
import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.enums.internal.Screenshots;
import com.shaft.gui.browser.internal.JavaScriptWaitManager;
import com.shaft.gui.element.internal.ElementActionsHelper;
import com.shaft.gui.element.internal.ElementInformation;
import com.shaft.gui.internal.image.AnimatedGifManager;
import com.shaft.gui.internal.image.ImageProcessingActions;
import com.shaft.gui.internal.image.ScreenshotHelper;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.locators.RelativeLocator;

public class ScreenshotManager {
    private static final int RETRIES_BEFORE_THROWING_ELEMENT_NOT_FOUND_EXCEPTION = 1;
    private static String screenshotFileName = "shot";
    private static By targetElementLocator;
    private static boolean globalPassFailStatus;
    private static String globalPassFailAppendedText;

    private ScreenshotManager() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Object> takeScreenshot(WebDriver driver, By elementLocator, String actionName, boolean passFailStatus) {
        globalPassFailStatus = passFailStatus;
        targetElementLocator = elementLocator;
        globalPassFailAppendedText = passFailStatus ? "passed" : "failed";
        return ScreenshotManager.internalCaptureScreenShot(driver, targetElementLocator, actionName, globalPassFailAppendedText, ScreenshotManager.shouldTakeScreenshot(actionName, passFailStatus));
    }

    public static byte[] takeScreenshot(WebDriver driver, By targetElementLocator, Screenshots type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Screenshots.ELEMENT -> ScreenshotManager.takeElementScreenshot(driver, targetElementLocator, false);
            case Screenshots.VIEWPORT -> ScreenshotManager.takeViewportScreenshot(driver);
            case Screenshots.FULL -> ScreenshotManager.takeFullPageScreenshot(driver);
        };
    }

    public static byte[] takeScreenshot(WebDriver driver) {
        if (driver instanceof SelfHealingDriver) {
            SelfHealingDriver selfHealingDriver = (SelfHealingDriver)driver;
            driver = selfHealingDriver.getDelegate();
        }
        if (DriverFactoryHelper.isWebExecution()) {
            return switch (Screenshots.getType()) {
                case Screenshots.FULL -> {
                    byte[] var1_1;
                    try {
                        yield var1_1 = ScreenshotManager.takeFullPageScreenshot(driver);
                    }
                    catch (Throwable throwable) {
                        ReportManagerHelper.logDiscrete(throwable);
                        SHAFT.Properties.visuals.set().screenshotParamsScreenshotType(String.valueOf((Object)Screenshots.VIEWPORT));
                        yield var1_1 = ScreenshotManager.takeScreenshot(driver);
                    }
                }
                case Screenshots.ELEMENT -> {
                    byte[] var1_1;
                    yield var1_1 = ScreenshotManager.takeElementScreenshot(driver, targetElementLocator, true);
                }
                default -> {
                    byte[] var1_1;
                    yield var1_1 = ScreenshotManager.takeViewportScreenshot(driver);
                }
            };
        }
        if (Screenshots.getType().equals((Object)Screenshots.ELEMENT)) {
            return ScreenshotManager.takeElementScreenshot(driver, targetElementLocator, true);
        }
        return ScreenshotManager.takeViewportScreenshot(driver);
    }

    public static String generateAttachmentFileName(String actionName, String appendedText) {
        if (appendedText != null && !appendedText.isBlank()) {
            return actionName + "_" + appendedText + "_" + System.currentTimeMillis();
        }
        return actionName + "_" + System.currentTimeMillis();
    }

    public static List<Object> prepareImageForReport(byte[] image, String actionName) {
        if (image != null && image.length > 0) {
            screenshotFileName = ScreenshotManager.generateAttachmentFileName(actionName, globalPassFailAppendedText);
            try {
                BufferedImage screenshotImage = ImageIO.read(new ByteArrayInputStream(image));
                ScreenshotHelper.overlayShaftEngineLogo(screenshotImage);
                ByteArrayOutputStream screenshotOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)screenshotImage, "png", screenshotOutputStream);
                return Arrays.asList("Screenshot", screenshotFileName, new ByteArrayInputStream(screenshotOutputStream.toByteArray()));
            }
            catch (IOException e) {
                ReportManagerHelper.logDiscrete(e);
                return null;
            }
        }
        return null;
    }

    private static boolean shouldTakeScreenshot(String actionName, boolean passFailStatus) {
        return SHAFT.Properties.visuals.screenshotParamsWhenToTakeAScreenshot().equals("Always") || SHAFT.Properties.visuals.createAnimatedGif() && (AnimatedGifManager.DETAILED_GIF != false || actionName.matches("(verify.*)|(assert.*)|(click.*)|(tap.*)|(key.*)|(navigate.*)|(type.*)")) || SHAFT.Properties.visuals.screenshotParamsWhenToTakeAScreenshot().equals("ValidationPointsOnly") && (actionName.toLowerCase().contains("assert") || actionName.toLowerCase().contains("verify") || actionName.toLowerCase().contains("validate")) || !passFailStatus;
    }

    private static byte[] takeViewportScreenshot(WebDriver driver) {
        return ScreenshotHelper.takeViewportScreenshot(driver, 6);
    }

    private static byte[] takeFullPageScreenshot(WebDriver driver) {
        if (!SHAFT.Properties.testNG.parallel().equals("NONE")) {
            return ScreenshotManager.takeViewportScreenshot(driver);
        }
        if (!SHAFT.Properties.visuals.screenshotParamsSkippedElementsFromScreenshot().isEmpty()) {
            String[] skippedElementLocators;
            ArrayList<WebElement> skippedElementsList = new ArrayList<WebElement>();
            for (String locator : skippedElementLocators = SHAFT.Properties.visuals.screenshotParamsSkippedElementsFromScreenshot().split(";")) {
                if (ElementActionsHelper.getElementsCount(driver, By.xpath((String)locator), 1) != 1) continue;
                skippedElementsList.add((WebElement)ElementActionsHelper.identifyUniqueElementIgnoringVisibility(driver, By.xpath((String)locator)).get(1));
            }
            WebElement[] skippedElementsArray = new WebElement[skippedElementsList.size()];
            skippedElementsArray = skippedElementsList.toArray(skippedElementsArray);
            return ScreenshotHelper.makeFullScreenshot(driver, skippedElementsArray);
        }
        return ScreenshotHelper.makeFullScreenshot(driver, new WebElement[0]);
    }

    private static byte[] takeElementScreenshot(WebDriver driver, By targetElementLocator, Boolean returnRegularScreenshotInCaseOfFailure) {
        try {
            if (targetElementLocator != null && ElementActionsHelper.getElementsCount(driver, targetElementLocator, 1) == 1) {
                return (byte[])((WebElement)ElementActionsHelper.identifyUniqueElementIgnoringVisibility(driver, targetElementLocator).get(1)).getScreenshotAs(OutputType.BYTES);
            }
            if (returnRegularScreenshotInCaseOfFailure.booleanValue()) {
                return ScreenshotManager.takeViewportScreenshot(driver);
            }
            return new byte[0];
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
            if (returnRegularScreenshotInCaseOfFailure.booleanValue()) {
                return ScreenshotManager.takeViewportScreenshot(driver);
            }
            return new byte[0];
        }
    }

    private static List<Object> internalCaptureScreenShot(WebDriver driver, By elementLocator, String actionName, String appendedText, boolean shouldCaptureScreenshot) {
        byte[] src = new byte[]{};
        if (shouldCaptureScreenshot || SHAFT.Properties.visuals.createAnimatedGif() && (AnimatedGifManager.DETAILED_GIF.booleanValue() || actionName.matches("(verify.*)|(assert.*)|(click.*)|(tap.*)|(key.*)|(navigate.*)|(type.*)"))) {
            src = "JavaScript".equals(SHAFT.Properties.visuals.screenshotParamsHighlightMethod()) ? ScreenshotManager.takeJavaScriptHighlightedScreenshot(driver, elementLocator, actionName, appendedText) : ScreenshotManager.takeAIHighlightedScreenshot(driver, elementLocator, actionName, appendedText);
        }
        if (shouldCaptureScreenshot) {
            return ScreenshotManager.prepareImageForReport(src, actionName);
        }
        return new ArrayList<Object>();
    }

    private static byte[] takeAIHighlightedScreenshot(WebDriver driver, By elementLocator, String actionName, String appendedText) {
        Rectangle elementLocation = null;
        if (Boolean.TRUE.equals(SHAFT.Properties.visuals.screenshotParamsHighlightElements()) && elementLocator != null) {
            int elementCount = ElementActionsHelper.getElementsCount(driver, elementLocator, 1);
            boolean isRelativeLocator = elementLocator instanceof RelativeLocator.RelativeBy;
            if (!isRelativeLocator && elementCount == 1 || isRelativeLocator && elementCount >= 1) {
                elementLocation = ElementInformation.fromList(ElementActionsHelper.identifyUniqueElementIgnoringVisibility(driver, elementLocator)).getElementRect();
            }
        }
        try {
            byte[] src = ScreenshotManager.takeScreenshot(driver);
            screenshotFileName = actionName + "_" + appendedText + "_" + System.currentTimeMillis();
            if (elementLocation != null) {
                Color color = globalPassFailStatus ? new Color(67, 176, 42) : new Color(255, 255, 153);
                src = ImageProcessingActions.highlightElementInScreenshot(src, elementLocation, color);
            }
            AnimatedGifManager.startOrAppendToAnimatedGif(src);
            return src;
        }
        catch (WebDriverException e) {
            ReportManagerHelper.logDiscrete(e);
            return new byte[0];
        }
    }

    private static byte[] takeJavaScriptHighlightedScreenshot(WebDriver driver, By elementLocator, String actionName, String appendedText) {
        String regularElementStyle = "";
        JavascriptExecutor js = null;
        WebElement element = null;
        if (Boolean.TRUE.equals(SHAFT.Properties.visuals.screenshotParamsHighlightElements()) && elementLocator != null) {
            int elementCount = ElementActionsHelper.getElementsCount(driver, elementLocator, 1);
            boolean isRelativeLocator = elementLocator instanceof RelativeLocator.RelativeBy;
            if (!isRelativeLocator && elementCount == 1 || isRelativeLocator && elementCount >= 1) {
                element = (WebElement)ElementActionsHelper.identifyUniqueElementIgnoringVisibility(driver, elementLocator).get(1);
                js = (JavascriptExecutor)driver;
                regularElementStyle = ScreenshotManager.highlightElementAndReturnDefaultStyle(driver, element, js, ScreenshotManager.setHighlightedElementStyle());
            }
        }
        try {
            byte[] src = ScreenshotManager.takeScreenshot(driver);
            screenshotFileName = actionName + "_" + appendedText + "_" + System.currentTimeMillis();
            AnimatedGifManager.startOrAppendToAnimatedGif(src);
            if (SHAFT.Properties.visuals.screenshotParamsHighlightMethod().equals("JavaScript") && js != null) {
                js.executeScript("arguments[0].setAttribute('style', arguments[1]);", new Object[]{element, regularElementStyle});
            }
            return src;
        }
        catch (WebDriverException e) {
            ReportManagerHelper.logDiscrete(e);
            return new byte[0];
        }
    }

    private static String highlightElementAndReturnDefaultStyle(WebDriver driver, WebElement element, JavascriptExecutor js, String highlightedElementStyle) {
        String regularElementStyle = element.getAttribute("style");
        if (regularElementStyle != null && !regularElementStyle.isEmpty()) {
            js.executeScript("arguments[0].style.cssText = arguments[1];", new Object[]{element, regularElementStyle + highlightedElementStyle});
        } else {
            js.executeScript("arguments[0].setAttribute('style', arguments[1]);", new Object[]{element, highlightedElementStyle});
        }
        try {
            JavaScriptWaitManager.waitForLazyLoading(driver);
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
        }
        return regularElementStyle;
    }

    private static String setHighlightedElementStyle() {
        String backgroundColor;
        String background;
        if (globalPassFailStatus) {
            background = "#46aad2";
            backgroundColor = "#A5D2A5";
        } else {
            background = "#FFFF99";
            backgroundColor = "#FFFF99";
        }
        return "outline-offset:-3px !important; outline:3px solid #808080 !important; background:" + background + " !important; background-color:" + backgroundColor + " !important; color:#000000 !important; -webkit-transition: none !important; -moz-transition: none !important; -o-transition: none !important; transition: none !important;";
    }

    static {
        globalPassFailStatus = false;
        globalPassFailAppendedText = "";
    }
}

