/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.internal.locator;

import com.shaft.gui.internal.locator.Locators;
import com.shaft.gui.internal.locator.ShadowLocatorBuilder;
import com.shaft.gui.internal.locator.XpathAxis;
import java.util.ArrayList;
import org.openqa.selenium.By;
import org.openqa.selenium.support.locators.RelativeLocator;

public class LocatorBuilder {
    static By iFrameLocator;
    static By shadowDomLocator;
    private static Locators mode;
    String partialXpath;
    private String tagName = "*";
    private ArrayList<String> parameters = new ArrayList();
    private String order = "";

    private LocatorBuilder() {
    }

    private LocatorBuilder(String tagName, ArrayList<String> parameters, String order) {
        this.tagName = tagName;
        this.parameters = parameters;
        this.order = order;
    }

    public static LocatorBuilder hasTagName(String tagName) {
        return new LocatorBuilder(tagName, new ArrayList<String>(), "");
    }

    public LocatorBuilder hasAttribute(String attribute) {
        this.parameters.add("[@" + attribute + "]");
        return this;
    }

    public LocatorBuilder hasAttribute(String attribute, String value) {
        this.parameters.add("[@" + attribute + "=\"" + value + "\"]");
        return this;
    }

    public LocatorBuilder containsAttribute(String attribute, String value) {
        this.parameters.add("[contains(@" + attribute + ",\"" + value + "\")]");
        return this;
    }

    public LocatorBuilder hasId(String id) {
        this.parameters.add("[@id=\"" + id + "\"]");
        return this;
    }

    public LocatorBuilder containsId(String id) {
        this.parameters.add("[contains(@id,\"" + id + "\")]");
        return this;
    }

    public LocatorBuilder hasClass(String className) {
        this.parameters.add("[@class=\"" + className + "\"]");
        return this;
    }

    public LocatorBuilder containsClass(String className) {
        this.parameters.add("[contains(@class,\"" + className + "\")]");
        return this;
    }

    public LocatorBuilder hasText(String text) {
        this.parameters.add("[.=\"" + text + "\"]");
        return this;
    }

    public LocatorBuilder containsText(String text) {
        this.parameters.add("[contains(.,\"" + text + "\")]");
        return this;
    }

    public LocatorBuilder hasIndex(int index) {
        this.order = String.valueOf(index);
        return this;
    }

    public LocatorBuilder isFirst() {
        this.order = "1";
        return this;
    }

    public LocatorBuilder isLast() {
        this.order = "last()";
        return this;
    }

    public LocatorBuilder and() {
        return this;
    }

    public RelativeLocator.RelativeBy relativeBy() {
        return RelativeLocator.with((By)By.xpath((String)this.buildXpathExpression()));
    }

    public XpathAxis axisBy() {
        mode = Locators.XPATH;
        this.partialXpath = this.buildXpathExpression();
        return new XpathAxis(this);
    }

    public By build() {
        if (mode == Locators.CSS) {
            return By.cssSelector((String)this.buildSelectorExpression());
        }
        return By.xpath((String)this.buildXpathExpression());
    }

    private String buildXpathExpression() {
        StringBuilder xpathExpression;
        if (this.partialXpath == null) {
            xpathExpression = new StringBuilder();
            xpathExpression.append("//").append(this.tagName);
        } else {
            xpathExpression = new StringBuilder(this.partialXpath);
        }
        this.parameters.forEach(xpathExpression::append);
        this.parameters.clear();
        if (!this.order.isEmpty()) {
            return "(" + String.valueOf(xpathExpression) + ")[" + this.order + "]";
        }
        return xpathExpression.toString();
    }

    String buildSelectorExpression() {
        StringBuilder cssExpression = new StringBuilder();
        this.tagName = this.tagName.equals("*") ? "" : this.tagName;
        cssExpression.append(this.tagName);
        this.parameters.forEach(parameter -> cssExpression.append(parameter.replace("@", "")));
        if (!this.order.isEmpty()) {
            if (this.order.matches("[0-9]+")) {
                this.order = ":nth-child(" + this.order + ")";
            } else if (this.order.equals("last()")) {
                this.order = ":last-child";
            }
            return "(" + String.valueOf(cssExpression) + ")" + this.order;
        }
        return cssExpression.toString();
    }

    public ShadowLocatorBuilder insideShadowDom(By shadowDomLocator) {
        return new ShadowLocatorBuilder(shadowDomLocator, By.cssSelector((String)this.buildSelectorExpression()));
    }

    public static void setIFrameLocator(By iFrameLocator) {
        LocatorBuilder.iFrameLocator = iFrameLocator;
    }

    public static By getIFrameLocator() {
        return iFrameLocator;
    }

    public static By getShadowDomLocator() {
        return shadowDomLocator;
    }

    public static void setMode(Locators mode) {
        LocatorBuilder.mode = mode;
    }

    static {
        mode = Locators.XPATH;
    }
}

