/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.gui.waits;

import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.driver.internal.FluentWebDriverAction;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.FailureReporter;
import java.time.Duration;
import java.util.function.Function;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WaitActions
extends FluentWebDriverAction {
    public WaitActions(DriverFactoryHelper helper) {
        this.initialize(helper);
    }

    @Override
    public WaitActions waitUntil(Function<? super WebDriver, ?> conditions) {
        this.explicitWaits(conditions, SHAFT.Properties.timeouts.waitUntilTimeout());
        return this;
    }

    public void explicitWaits(Function<? super WebDriver, ?> conditions, int timeoutWithSeconds) {
        try {
            new WebDriverWait(this.driver, Duration.ofSeconds(timeoutWithSeconds)).until(conditions);
            ReportManager.log("Explicit wait until: \"" + String.valueOf(conditions) + "\".");
        }
        catch (TimeoutException toe) {
            FailureReporter.fail(toe.getMessage().split("\n")[0]);
        }
    }
}

