/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.listeners;

import com.shaft.cli.FileActions;
import com.shaft.driver.SHAFT;
import com.shaft.gui.internal.image.AnimatedGifManager;
import com.shaft.gui.internal.video.RecordManager;
import com.shaft.listeners.internal.CucumberHelper;
import com.shaft.listeners.internal.TestNGListenerHelper;
import com.shaft.tools.io.internal.ReportManagerHelper;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.resource.Resource;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestSourceParsed;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.cucumber7jvm.AllureCucumber7Jvm;
import io.qameta.allure.cucumber7jvm.testsourcemodel.TestSourcesModelProxy;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.util.ResultsUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.testng.Reporter;

public class CucumberFeatureListener
extends AllureCucumber7Jvm {
    private static final String TXT_EXTENSION = ".txt";
    private static final String TEXT_PLAIN = "text/plain";
    private static String lastStartedScenarioName;
    private static Boolean isLastFinishedStepOK;
    private final AllureLifecycle lifecycle;
    private final ConcurrentHashMap<String, String> scenarioUuids = new ConcurrentHashMap();
    private final TestSourcesModelProxy testSources = new TestSourcesModelProxy();
    private final ThreadLocal<Feature> currentFeature = new InheritableThreadLocal<Feature>();
    private final ThreadLocal<URI> currentFeatureFile = new InheritableThreadLocal<URI>();
    private final ThreadLocal<TestCase> currentTestCase = new InheritableThreadLocal<TestCase>();
    private final ThreadLocal<String> currentContainer = new InheritableThreadLocal<String>();
    private final ThreadLocal<Boolean> forbidTestCaseStatusChange = new InheritableThreadLocal<Boolean>();
    private final EventHandler<TestSourceRead> featureStartedHandler = this::handleFeatureStartedHandler;
    private final EventHandler<TestRunFinished> featureFinishedHandler = this::handleFeatureFinishedHandler;
    private final EventHandler<TestCaseStarted> caseStartedHandler = this::handleTestCaseStarted;
    private final EventHandler<TestCaseFinished> caseFinishedHandler = this::handleTestCaseFinished;
    private final EventHandler<TestStepStarted> stepStartedHandler = this::handleTestStepStarted;
    private final EventHandler<TestStepFinished> stepFinishedHandler = this::handleTestStepFinished;
    private final EventHandler<WriteEvent> writeEventHandler = this::handleWriteEvent;
    private final EventHandler<EmbedEvent> embedEventHandler = this::handleEmbedEvent;

    public CucumberFeatureListener() {
        this(Allure.getLifecycle());
    }

    public CucumberFeatureListener(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
        CucumberHelper.shaftSetup();
    }

    private static StringBuilder getStringBuilder(List<List<String>> rowsInTable) {
        StringBuilder dataTableCsv = new StringBuilder();
        for (List<String> columns : rowsInTable) {
            if (columns.isEmpty()) continue;
            for (int i = 0; i < columns.size(); ++i) {
                if (i == columns.size() - 1) {
                    dataTableCsv.append(columns.get(i));
                    continue;
                }
                dataTableCsv.append(columns.get(i));
                dataTableCsv.append('\t');
            }
            dataTableCsv.append('\n');
        }
        return dataTableCsv;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.featureStartedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.featureFinishedHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventHandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventHandler);
        publisher.registerHandlerFor(TestSourceParsed.class, this::handleTestSourceParsed);
    }

    private void handleFeatureStartedHandler(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.getUri(), event);
    }

    private void handleFeatureFinishedHandler(TestRunFinished event) {
        CucumberHelper.shaftTearDown();
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        String description;
        this.currentFeatureFile.set(event.getTestCase().getUri());
        this.currentFeature.set(this.testSources.getFeature(this.currentFeatureFile.get()));
        this.currentTestCase.set(event.getTestCase());
        this.currentContainer.set(UUID.randomUUID().toString());
        this.forbidTestCaseStatusChange.set(false);
        new LinkedList(this.currentTestCase.get().getTags());
        Feature feature = this.currentFeature.get();
        String name = this.currentTestCase.get().getName();
        String featureName = feature.getName();
        TestResult result = new TestResult().setUuid(this.getTestCaseUuid(this.currentTestCase.get())).setHistoryId(this.getHistoryId(this.currentTestCase.get())).setFullName(featureName + ": " + name).setName(name);
        Scenario scenarioDefinition = this.testSources.getScenarioDefinition(this.currentFeatureFile.get(), this.currentTestCase.get().getLocation().getLine());
        if (scenarioDefinition.getExamples() != null) {
            result.setParameters(this.getExamplesAsParameters(scenarioDefinition, this.currentTestCase.get()));
        }
        if (!(description = Stream.of(feature.getDescription(), scenarioDefinition.getDescription()).filter(Objects::nonNull).filter(s -> !s.isEmpty()).collect(Collectors.joining("\n"))).isEmpty()) {
            result.setDescription(description);
        }
        TestResultContainer resultContainer = new TestResultContainer().setName(String.format("%s: %s", scenarioDefinition.getKeyword(), scenarioDefinition.getName())).setUuid(this.getTestContainerUuid()).setChildren(Collections.singletonList(this.getTestCaseUuid(this.currentTestCase.get())));
        this.lifecycle.scheduleTestCase(result);
        this.lifecycle.startTestContainer(this.getTestContainerUuid(), resultContainer);
        this.lifecycle.startTestCase(this.getTestCaseUuid(this.currentTestCase.get()));
        ReportManagerHelper.setFeatureName(featureName);
        lastStartedScenarioName = scenarioDefinition.getName();
        ReportManagerHelper.setTestCaseName(lastStartedScenarioName);
        ReportManagerHelper.setTestCaseDescription(scenarioDefinition.getDescription());
        TestCase testCase = event.getTestCase();
        StringBuilder cleanScenarioSteps = new StringBuilder();
        testCase.getTestSteps().forEach(testStep -> {
            if (testStep instanceof PickleStepTestStep) {
                PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
                cleanScenarioSteps.append(pickleStepTestStep.getStep().getKeyword()).append(pickleStepTestStep.getStep().getText()).append(System.lineSeparator());
            }
        });
        ReportManagerHelper.logScenarioInformation(scenarioDefinition.getKeyword(), lastStartedScenarioName, cleanScenarioSteps.toString());
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        if (Reporter.getCurrentTestResult() == null) {
            if (SHAFT.Properties.visuals.videoParamsScope().equals("TestMethod")) {
                RecordManager.attachVideoRecording();
            }
            AnimatedGifManager.attachAnimatedGif();
            ReportManagerHelper.attachTestLog(lastStartedScenarioName, TestNGListenerHelper.createTestLog(Reporter.getOutput()));
        } else {
            ReportManagerHelper.attachTestLog(lastStartedScenarioName, TestNGListenerHelper.createTestLog(Reporter.getOutput()));
        }
        String uuid = this.getTestCaseUuid(event.getTestCase());
        Optional details = ResultsUtils.getStatusDetails((Throwable)event.getResult().getError());
        details.ifPresent(statusDetails -> this.lifecycle.updateTestCase(uuid, testResult -> testResult.setStatusDetails(statusDetails)));
        this.lifecycle.stopTestCase(uuid);
        this.lifecycle.stopTestContainer(this.getTestContainerUuid());
        this.lifecycle.writeTestCase(uuid);
        this.lifecycle.writeTestContainer(this.getTestContainerUuid());
    }

    private void handleTestStepStarted(TestStepStarted event) {
        TestStep testStep = event.getTestStep();
        if (testStep instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStep = (PickleStepTestStep)testStep;
            String stepKeyword = Optional.ofNullable(this.testSources.getKeywordFromSource(this.currentFeatureFile.get(), pickleStep.getStep().getLine())).orElse("UNDEFINED");
            StepResult stepResult = new StepResult().setName(String.format("%s %s", stepKeyword, pickleStep.getStep().getText())).setStart(Long.valueOf(System.currentTimeMillis()));
            this.lifecycle.startStep(this.getTestCaseUuid(this.currentTestCase.get()), this.getStepUuid(pickleStep), stepResult);
            StepArgument stepArgument = pickleStep.getStep().getArgument();
            if (stepArgument instanceof DataTableArgument) {
                DataTableArgument dataTableArgument = (DataTableArgument)stepArgument;
                this.createDataTableAttachment(dataTableArgument);
            }
        } else if (event.getTestStep() instanceof HookTestStep) {
            this.initHook((HookTestStep)event.getTestStep());
        }
    }

    private void initHook(HookTestStep hook) {
        FixtureResult hookResult = new FixtureResult().setName(hook.getCodeLocation()).setStart(Long.valueOf(System.currentTimeMillis()));
        if (hook.getHookType() == HookType.BEFORE) {
            this.lifecycle.startPrepareFixture(this.getTestContainerUuid(), this.getHookStepUuid(hook), hookResult);
        } else {
            this.lifecycle.startTearDownFixture(this.getTestContainerUuid(), this.getHookStepUuid(hook), hookResult);
        }
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.getTestStep() instanceof HookTestStep) {
            this.handleHookStep(event);
        } else {
            this.handlePickleStep(event);
        }
        isLastFinishedStepOK = event.getResult().getStatus().isOk();
    }

    private void handleWriteEvent(WriteEvent event) {
        this.lifecycle.addAttachment("Text output", TEXT_PLAIN, TXT_EXTENSION, Objects.toString(event.getText()).getBytes(StandardCharsets.UTF_8));
    }

    private void handleEmbedEvent(EmbedEvent event) {
        this.lifecycle.addAttachment(event.name, event.getMediaType(), null, (InputStream)new ByteArrayInputStream(event.getData()));
    }

    private String getTestContainerUuid() {
        return this.currentContainer.get();
    }

    private String getTestCaseUuid(TestCase testCase) {
        return this.scenarioUuids.computeIfAbsent(this.getHistoryId(testCase), it -> UUID.randomUUID().toString());
    }

    private String getStepUuid(PickleStepTestStep step) {
        return this.currentFeature.get().getName() + this.getTestCaseUuid(this.currentTestCase.get()) + step.getStep().getText() + step.getStep().getLine();
    }

    private String getHookStepUuid(HookTestStep step) {
        return this.currentFeature.get().getName() + this.getTestCaseUuid(this.currentTestCase.get()) + step.getHookType().toString() + step.getCodeLocation();
    }

    private String getHistoryId(TestCase testCase) {
        String testCaseLocation = testCase.getUri().toString().substring(testCase.getUri().toString().lastIndexOf(47) + 1) + ":" + testCase.getLocation().getLine();
        return ResultsUtils.md5((String)testCaseLocation);
    }

    private Status translateTestCaseStatus(Result testCaseResult) {
        return switch (testCaseResult.getStatus()) {
            default -> throw new MatchException(null, null);
            case io.cucumber.plugin.event.Status.FAILED -> ResultsUtils.getStatus((Throwable)testCaseResult.getError()).orElse(Status.FAILED);
            case io.cucumber.plugin.event.Status.PASSED -> Status.PASSED;
            case io.cucumber.plugin.event.Status.SKIPPED, io.cucumber.plugin.event.Status.PENDING -> Status.SKIPPED;
            case io.cucumber.plugin.event.Status.AMBIGUOUS, io.cucumber.plugin.event.Status.UNDEFINED, io.cucumber.plugin.event.Status.UNUSED -> null;
        };
    }

    private List<Parameter> getExamplesAsParameters(Scenario scenario, TestCase localCurrentTestCase) {
        Optional<Examples> maybeExample = scenario.getExamples().stream().filter(example -> example.getTableBody().stream().anyMatch(row -> row.getLocation().getLine() == (long)localCurrentTestCase.getLocation().getLine())).findFirst();
        if (maybeExample.isEmpty()) {
            return Collections.emptyList();
        }
        Examples examples = maybeExample.get();
        Optional<TableRow> maybeRow = examples.getTableBody().stream().filter(example -> example.getLocation().getLine() == (long)localCurrentTestCase.getLocation().getLine()).findFirst();
        if (maybeRow.isEmpty()) {
            return Collections.emptyList();
        }
        TableRow row = maybeRow.get();
        if (examples.getTableHeader().isPresent()) {
            return IntStream.range(0, ((TableRow)examples.getTableHeader().get()).getCells().size()).mapToObj(index -> {
                String name = ((TableCell)((TableRow)examples.getTableHeader().get()).getCells().get(index)).getValue();
                String value = ((TableCell)row.getCells().get(index)).getValue();
                return ResultsUtils.createParameter((String)name, (Object)value);
            }).collect(Collectors.toList());
        }
        return null;
    }

    private void createDataTableAttachment(DataTableArgument dataTableArgument) {
        List rowsInTable = dataTableArgument.cells();
        StringBuilder dataTableCsv = CucumberFeatureListener.getStringBuilder(rowsInTable);
        String attachmentSource = this.lifecycle.prepareAttachment("Data table", "text/tab-separated-values", "csv");
        this.lifecycle.writeAttachment(attachmentSource, (InputStream)new ByteArrayInputStream(dataTableCsv.toString().getBytes(StandardCharsets.UTF_8)));
    }

    private void handleHookStep(TestStepFinished event) {
        HookTestStep hookStep = (HookTestStep)event.getTestStep();
        String uuid = this.getHookStepUuid(hookStep);
        FixtureResult fixtureResult = new FixtureResult().setStatus(this.translateTestCaseStatus(event.getResult()));
        if (!Status.PASSED.equals((Object)fixtureResult.getStatus())) {
            TestResult testResult = new TestResult().setStatus(this.translateTestCaseStatus(event.getResult()));
            StatusDetails statusDetails = ResultsUtils.getStatusDetails((Throwable)event.getResult().getError()).orElseGet(StatusDetails::new);
            String errorMessage = event.getResult().getError() == null ? hookStep.getHookType().name() + " is failed." : hookStep.getHookType().name() + " is failed: " + event.getResult().getError().getLocalizedMessage();
            statusDetails.setMessage(errorMessage);
            if (hookStep.getHookType() == HookType.BEFORE) {
                testResult.setStatus(Status.SKIPPED);
                this.updateTestCaseStatus(testResult.getStatus());
                this.forbidTestCaseStatusChange.set(true);
            } else {
                testResult.setStatus(Status.BROKEN);
                this.updateTestCaseStatus(testResult.getStatus());
            }
            fixtureResult.setStatusDetails(statusDetails);
        }
        this.lifecycle.updateFixture(uuid, result -> result.setStatus(fixtureResult.getStatus()).setStatusDetails(fixtureResult.getStatusDetails()));
        this.lifecycle.stopFixture(uuid);
    }

    private void handlePickleStep(TestStepFinished event) {
        StatusDetails statusDetails;
        Status stepStatus = this.translateTestCaseStatus(event.getResult());
        if (event.getResult().getStatus() == io.cucumber.plugin.event.Status.UNDEFINED) {
            this.updateTestCaseStatus(Status.PASSED);
            statusDetails = ResultsUtils.getStatusDetails((Throwable)new IllegalStateException("Undefined Step. Please add step definition")).orElse(new StatusDetails());
            this.lifecycle.updateTestCase(this.getTestCaseUuid(this.currentTestCase.get()), scenarioResult -> scenarioResult.setStatusDetails(statusDetails));
        } else {
            statusDetails = ResultsUtils.getStatusDetails((Throwable)event.getResult().getError()).orElse(new StatusDetails());
            this.updateTestCaseStatus(stepStatus);
        }
        if (!Status.PASSED.equals((Object)stepStatus) && stepStatus != null) {
            this.forbidTestCaseStatusChange.set(true);
        }
        this.lifecycle.updateStep(this.getStepUuid((PickleStepTestStep)event.getTestStep()), stepResult -> stepResult.setStatus(stepStatus).setStatusDetails(statusDetails));
        this.lifecycle.stopStep(this.getStepUuid((PickleStepTestStep)event.getTestStep()));
    }

    private void updateTestCaseStatus(Status status) {
        if (!this.forbidTestCaseStatusChange.get().booleanValue()) {
            this.lifecycle.updateTestCase(this.getTestCaseUuid(this.currentTestCase.get()), result -> result.setStatus(status));
        }
    }

    private void handleTestSourceParsed(TestSourceParsed event) {
        event.getNodes().forEach(node -> {
            Optional<io.cucumber.core.gherkin.Feature> feature = this.getFeature(event.getUri());
            if (feature.isPresent()) {
                if (ReportManagerHelper.getTotalNumberOfTests() == 0) {
                    ReportManagerHelper.setTotalNumberOfTests(feature.get().getPickles().size());
                } else {
                    ReportManagerHelper.setTotalNumberOfTests(ReportManagerHelper.getTotalNumberOfTests() + feature.get().getPickles().size());
                }
            }
        });
    }

    private Optional<io.cucumber.core.gherkin.Feature> getFeature(final URI uri) {
        FeatureParser featureParser = new FeatureParser(() -> new UUID(10L, 1L));
        return featureParser.parseResource(new Resource(){

            public URI getUri() {
                return uri;
            }

            public InputStream getInputStream() {
                return new ByteArrayInputStream(FileActions.getInstance(true).readFile(uri.getPath()).getBytes());
            }
        });
    }

    public static String getLastStartedScenarioName() {
        return lastStartedScenarioName;
    }

    public static Boolean getIsLastFinishedStepOK() {
        return isLastFinishedStepOK;
    }
}

