/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.listeners;

import com.shaft.cli.FileActions;
import com.shaft.driver.SHAFT;
import com.shaft.gui.internal.image.AnimatedGifManager;
import com.shaft.gui.internal.video.RecordManager;
import com.shaft.listeners.internal.TestNGListenerHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.resource.Resource;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestSourceParsed;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepStarted;
import io.qameta.allure.cucumber7jvm.AllureCucumber7Jvm;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import java.util.UUID;
import org.testng.Reporter;

public class CucumberTestRunnerListener
extends AllureCucumber7Jvm {
    private static String lastStartedScenarioName;

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceParsed.class, this::handleTestSourceParsed);
        publisher.registerHandlerFor(TestCaseStarted.class, this::caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this::caseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this::stepStartedHandler);
        super.setEventPublisher(publisher);
    }

    private void handleTestSourceParsed(TestSourceParsed event) {
        event.getNodes().forEach(node -> {
            Optional<Feature> feature = this.getFeature(event.getUri());
            if (feature.isPresent()) {
                if (ReportManagerHelper.getTotalNumberOfTests() == 0) {
                    ReportManagerHelper.setTotalNumberOfTests(feature.get().getPickles().size());
                } else {
                    ReportManagerHelper.setTotalNumberOfTests(ReportManagerHelper.getTotalNumberOfTests() + feature.get().getPickles().size());
                }
            }
        });
    }

    private void caseStartedHandler(TestCaseStarted event) {
        TestCase testCase = event.getTestCase();
        StringBuilder scenarioSteps = new StringBuilder();
        StringBuilder cleanScenarioSteps = new StringBuilder();
        testCase.getTestSteps().forEach(testStep -> {
            if (testStep instanceof PickleStepTestStep) {
                PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
                scenarioSteps.append("<b style=\"color:ForestGreen;\">").append(pickleStepTestStep.getStep().getKeyword()).append("</b>").append(pickleStepTestStep.getStep().getText()).append("<br/>");
                cleanScenarioSteps.append(pickleStepTestStep.getStep().getKeyword()).append(pickleStepTestStep.getStep().getText()).append(System.lineSeparator());
            }
        });
        Optional<Feature> feature = this.getFeature(testCase.getUri());
        if (feature.isPresent() && feature.get().getName().isPresent()) {
            ReportManagerHelper.setFeatureName((String)feature.get().getName().get());
        }
        ReportManagerHelper.setTestCaseName(testCase.getName());
        ReportManagerHelper.setTestCaseDescription(scenarioSteps.toString());
        lastStartedScenarioName = testCase.getName();
        ReportManagerHelper.logScenarioInformation(testCase.getKeyword(), lastStartedScenarioName, cleanScenarioSteps.toString());
    }

    private void caseFinishedHandler(TestCaseFinished event) {
        if (Reporter.getCurrentTestResult() == null) {
            if (SHAFT.Properties.visuals.videoParamsScope().equals("TestMethod")) {
                RecordManager.attachVideoRecording();
            }
            AnimatedGifManager.attachAnimatedGif();
            ReportManagerHelper.attachTestLog(lastStartedScenarioName, TestNGListenerHelper.createTestLog(Reporter.getOutput()));
        }
    }

    private Optional<Feature> getFeature(final URI uri) {
        FeatureParser featureParser = new FeatureParser(() -> new UUID(10L, 1L));
        return featureParser.parseResource(new Resource(){

            public URI getUri() {
                return uri;
            }

            public InputStream getInputStream() {
                return new ByteArrayInputStream(FileActions.getInstance(true).readFile(uri.getPath()).getBytes());
            }
        });
    }

    private void stepStartedHandler(TestStepStarted event) {
        TestStep testStep = event.getTestStep();
        if (testStep instanceof HookTestStep) {
            HookTestStep hookTestStep = (HookTestStep)testStep;
            ReportManager.logDiscrete("Scenario Hook: " + hookTestStep.getHookType().name());
        }
        if (testStep instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
            ReportManager.logDiscrete("Scenario Step: " + pickleStepTestStep.getStep().getKeyword() + pickleStepTestStep.getStep().getText());
        }
    }
}

