/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.listeners;

import com.shaft.driver.SHAFT;
import com.shaft.gui.internal.image.ImageProcessingActions;
import com.shaft.listeners.internal.JiraHelper;
import com.shaft.listeners.internal.JunitListenerHelper;
import com.shaft.listeners.internal.TestNGListenerHelper;
import com.shaft.listeners.internal.UpdateChecker;
import com.shaft.properties.internal.PropertiesHelper;
import com.shaft.tools.internal.security.GoogleTink;
import com.shaft.tools.io.internal.AllureManager;
import com.shaft.tools.io.internal.ExecutionSummaryReport;
import com.shaft.tools.io.internal.ProjectStructureManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import io.qameta.allure.Allure;
import java.util.ArrayList;
import java.util.List;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.testng.Reporter;

public class JunitListener
implements LauncherSessionListener {
    private static final List<TestIdentifier> passedTests = new ArrayList<TestIdentifier>();
    private static final List<TestIdentifier> failedTests = new ArrayList<TestIdentifier>();
    private static final List<TestIdentifier> skippedTests = new ArrayList<TestIdentifier>();
    private static long executionStartTime;
    private static boolean isEngineReady;

    public void launcherSessionOpened(LauncherSession session) {
        if (!isEngineReady) {
            session.getLauncher().registerTestExecutionListeners(new TestExecutionListener[]{new TestExecutionListener(){

                public void testPlanExecutionStarted(TestPlan testPlan) {
                    executionStartTime = System.currentTimeMillis();
                    JunitListener.this.engineSetup();
                    isEngineReady = true;
                }

                public void testPlanExecutionFinished(TestPlan testPlan) {
                    JunitListener.this.engineTearDown();
                }

                public void executionSkipped(TestIdentifier testIdentifier, String reason) {
                    JunitListener.this.afterInvocation();
                    JunitListener.this.onTestSkipped(testIdentifier, reason);
                }

                public void executionStarted(TestIdentifier testIdentifier) {
                    JunitListenerHelper.setTestName(testIdentifier);
                    JunitListenerHelper.logTestInformation(testIdentifier);
                }

                public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
                    JunitListener.this.afterInvocation();
                    if (testIdentifier.isTest()) {
                        switch (testExecutionResult.getStatus()) {
                            case SUCCESSFUL: {
                                JunitListener.this.onTestSuccess(testIdentifier);
                                break;
                            }
                            case FAILED: 
                            case ABORTED: {
                                Object throwable = testExecutionResult.getThrowable().isPresent() ? (Throwable)testExecutionResult.getThrowable().get() : new AssertionError((Object)"Test Failed");
                                JunitListener.this.onTestFailure(testIdentifier, (Throwable)throwable);
                            }
                        }
                    }
                }
            }});
        }
    }

    private void engineSetup() {
        ReportManagerHelper.setDiscreteLogging(true);
        PropertiesHelper.initialize();
        SHAFT.Properties.reporting.set().disableLogging(true);
        Allure.getLifecycle();
        Reporter.setEscapeHtml((boolean)false);
        ProjectStructureManager.initialize(ProjectStructureManager.RunType.JUNIT);
        TestNGListenerHelper.configureJVMProxy();
        GoogleTink.initialize();
        GoogleTink.decrypt();
        SHAFT.Properties.reporting.set().disableLogging(false);
        ReportManagerHelper.logEngineVersion();
        UpdateChecker.check();
        ImageProcessingActions.loadOpenCV();
        AllureManager.initializeAllureReportingEnvironment();
        ReportManagerHelper.cleanExecutionSummaryReportDirectory();
        ReportManagerHelper.setDiscreteLogging(SHAFT.Properties.reporting.alwaysLogDiscreetly());
        ReportManagerHelper.setDebugMode(SHAFT.Properties.reporting.debugMode());
    }

    private void engineTearDown() {
        ReportManagerHelper.setDiscreteLogging(true);
        JiraHelper.reportExecutionStatusToJira();
        GoogleTink.encrypt();
        AllureManager.generateAllureReportArchive();
        AllureManager.openAllureReportAfterExecution();
        long executionEndTime = System.currentTimeMillis();
        ExecutionSummaryReport.generateExecutionSummaryReport(passedTests.size(), failedTests.size(), skippedTests.size(), executionStartTime, executionEndTime);
        ReportManagerHelper.logEngineClosure();
    }

    private void afterInvocation() {
        ReportManagerHelper.setDiscreteLogging(SHAFT.Properties.reporting.alwaysLogDiscreetly());
    }

    private void onTestSuccess(TestIdentifier testIdentifier) {
        passedTests.add(testIdentifier);
        this.appendToExecutionSummaryReport(testIdentifier, "", ExecutionSummaryReport.StatusIcon.PASSED, ExecutionSummaryReport.Status.PASSED);
    }

    private void onTestFailure(TestIdentifier testIdentifier, Throwable throwable) {
        failedTests.add(testIdentifier);
        this.appendToExecutionSummaryReport(testIdentifier, throwable.getMessage(), ExecutionSummaryReport.StatusIcon.FAILED, ExecutionSummaryReport.Status.FAILED);
    }

    private void onTestSkipped(TestIdentifier testIdentifier, String reason) {
        skippedTests.add(testIdentifier);
        this.appendToExecutionSummaryReport(testIdentifier, reason, ExecutionSummaryReport.StatusIcon.SKIPPED, ExecutionSummaryReport.Status.SKIPPED);
    }

    private void appendToExecutionSummaryReport(TestIdentifier testIdentifier, String errorMessage, ExecutionSummaryReport.StatusIcon statusIcon, ExecutionSummaryReport.Status status) {
        if (testIdentifier.getType().isTest()) {
            String caseSuite = ((UniqueId.Segment)testIdentifier.getUniqueIdObject().getSegments().get(1)).getValue() + "." + testIdentifier.getUniqueIdObject().getLastSegment().getValue();
            String caseName = testIdentifier.getDisplayName();
            String caseDescription = testIdentifier.getLegacyReportingName();
            String statusMessage = statusIcon.getValue() + status.name();
            ExecutionSummaryReport.casesDetailsIncrement("", caseSuite, caseName, caseDescription, errorMessage, statusMessage, "");
        }
    }

    static {
        isEngineReady = false;
    }
}

