/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.listeners;

import com.shaft.driver.SHAFT;
import com.shaft.gui.internal.image.ImageProcessingActions;
import com.shaft.listeners.internal.CucumberHelper;
import com.shaft.listeners.internal.JiraHelper;
import com.shaft.listeners.internal.RetryAnalyzer;
import com.shaft.listeners.internal.TestNGListenerHelper;
import com.shaft.listeners.internal.UpdateChecker;
import com.shaft.properties.internal.PropertiesHelper;
import com.shaft.tools.internal.security.GoogleTink;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.AllureManager;
import com.shaft.tools.io.internal.ExecutionSummaryReport;
import com.shaft.tools.io.internal.IssueReporter;
import com.shaft.tools.io.internal.ProjectStructureManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import io.cucumber.core.runner.Runner;
import io.qameta.allure.Allure;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.platform.launcher.core.EngineDiscoveryOrchestrator;
import org.testng.IAlterSuiteListener;
import org.testng.IAnnotationTransformer;
import org.testng.IExecutionListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SkipException;
import org.testng.TestNG;
import org.testng.annotations.ITestAnnotation;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestNGListener
implements IAlterSuiteListener,
IAnnotationTransformer,
IExecutionListener,
ISuiteListener,
IInvokedMethodListener,
ITestListener {
    private static final List<ITestNGMethod> passedTests = new ArrayList<ITestNGMethod>();
    private static final List<ITestNGMethod> failedTests = new ArrayList<ITestNGMethod>();
    private static final List<ITestNGMethod> skippedTests = new ArrayList<ITestNGMethod>();
    private static ITestResult iTestResult;
    private static long executionStartTime;
    private static XmlTest xmlTest;

    public static ProjectStructureManager.RunType identifyRunType() {
        Supplier<Stream> stacktraceSupplier = () -> Arrays.stream(new Throwable().getStackTrace()).map(StackTraceElement::getClassName);
        boolean isUsingJunitDiscovery = stacktraceSupplier.get().anyMatch(EngineDiscoveryOrchestrator.class.getCanonicalName()::equals);
        boolean isUsingTestNG = stacktraceSupplier.get().anyMatch(TestNG.class.getCanonicalName()::equals);
        boolean isUsingCucumber = stacktraceSupplier.get().anyMatch(Runner.class.getCanonicalName()::equals);
        if (isUsingJunitDiscovery || isUsingTestNG) {
            System.out.println("TestNG run detected...");
            return ProjectStructureManager.RunType.TESTNG;
        }
        if (isUsingCucumber) {
            System.out.println("Cucumber run detected...");
            return ProjectStructureManager.RunType.CUCUMBER;
        }
        System.out.println("JUnit5 run detected...");
        return ProjectStructureManager.RunType.JUNIT;
    }

    public static void engineSetup(ProjectStructureManager.RunType runType) {
        Allure.getLifecycle();
        Reporter.setEscapeHtml((boolean)false);
        ReportManagerHelper.setDiscreteLogging(true);
        PropertiesHelper.initialize();
        ReportManager.logDiscrete("Initializing Engine Setup...");
        SHAFT.Properties.reporting.set().disableLogging(true);
        switch (runType) {
            case TESTNG: {
                Thread.ofVirtual().start(() -> ProjectStructureManager.initialize(ProjectStructureManager.RunType.TESTNG));
                break;
            }
            case CUCUMBER: {
                Thread.ofVirtual().start(() -> ProjectStructureManager.initialize(ProjectStructureManager.RunType.CUCUMBER));
                break;
            }
            case JUNIT: {
                Thread.ofVirtual().start(() -> ProjectStructureManager.initialize(ProjectStructureManager.RunType.JUNIT));
            }
        }
        TestNGListenerHelper.configureJVMProxy();
        Thread.ofVirtual().start(() -> {
            GoogleTink.initialize();
            GoogleTink.decrypt();
        });
        SHAFT.Properties.reporting.set().disableLogging(false);
        ReportManagerHelper.logEngineVersion();
        Thread.ofVirtual().start(UpdateChecker::check);
        Thread.ofVirtual().start(ImageProcessingActions::loadOpenCV);
        Thread.ofVirtual().start(AllureManager::initializeAllureReportingEnvironment);
        Thread.ofVirtual().start(ReportManagerHelper::cleanExecutionSummaryReportDirectory);
        ReportManagerHelper.setDiscreteLogging(SHAFT.Properties.reporting.alwaysLogDiscreetly());
        ReportManagerHelper.setDebugMode(SHAFT.Properties.reporting.debugMode());
    }

    public void onExecutionStart() {
        TestNGListener.engineSetup(ProjectStructureManager.RunType.TESTNG);
    }

    public void alter(List<XmlSuite> suites) {
        switch (TestNGListener.identifyRunType()) {
            case TESTNG: {
                TestNGListenerHelper.configureTestNGProperties(suites);
                break;
            }
            case CUCUMBER: {
                CucumberHelper.configureCucumberProperties(suites);
            }
        }
        TestNGListenerHelper.attachConfigurationHelperClass(suites);
        TestNGListenerHelper.configureCrossBrowserExecution(suites);
    }

    public void onStart(ISuite suite) {
        TestNGListenerHelper.setTotalNumberOfTests(suite);
        executionStartTime = System.currentTimeMillis();
    }

    public void transform(ITestAnnotation annotation, Class testClass, Constructor testConstructor, Method testMethod) {
        annotation.setRetryAnalyzer(RetryAnalyzer.class);
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult iTestResult, ITestContext iTestContext) {
        long elapsedTime = System.currentTimeMillis() - executionStartTime;
        if (SHAFT.Properties.reporting.debugMode()) {
            ReportManager.logDiscrete("elapsedTime: " + elapsedTime + "ms");
        }
        if (elapsedTime >= SHAFT.Properties.testNG.testSuiteTimeout() * 60000L) {
            throw new SkipException("Skipping method as the test suite has exceeded the defined timeout of " + SHAFT.Properties.testNG.testSuiteTimeout() + " minutes.");
        }
        xmlTest = method.getTestMethod().getXmlTest();
        JiraHelper.prepareTestResultAttributes(method, iTestResult);
        TestNGListenerHelper.setTestName(iTestContext);
        TestNGListenerHelper.logTestInformation(iTestResult);
        TestNGListenerHelper.failFast(iTestResult);
        TestNGListenerHelper.skipTestsWithLinkedIssues(iTestResult);
        TestNGListener.iTestResult = iTestResult;
    }

    public void afterInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult, ITestContext iTestContext) {
        IssueReporter.updateTestStatusInCaseOfVerificationFailure(iTestResult);
        IssueReporter.updateIssuesLog(iTestResult);
        TestNGListenerHelper.updateTestMethods(iTestResult);
        TestNGListenerHelper.logFinishedTestInformation(iTestResult);
        ReportManagerHelper.setDiscreteLogging(SHAFT.Properties.reporting.alwaysLogDiscreetly());
    }

    public void onExecutionFinish() {
        ReportManagerHelper.setDiscreteLogging(true);
        Thread.ofVirtual().start(() -> ExecutionSummaryReport.generateExecutionSummaryReport(passedTests.size(), failedTests.size(), skippedTests.size(), executionStartTime, System.currentTimeMillis()));
        Thread.ofVirtual().start(JiraHelper::reportExecutionStatusToJira);
        Thread.ofVirtual().start(GoogleTink::encrypt);
        ReportManagerHelper.logEngineClosure();
        AllureManager.openAllureReportAfterExecution();
        AllureManager.generateAllureReportArchive();
    }

    public void onTestSuccess(ITestResult result) {
        passedTests.add(result.getMethod());
        ExecutionSummaryReport.casesDetailsIncrement(TestNGListenerHelper.getTmsLinkAnnotationValue(result), result.getMethod().getQualifiedName().replace("." + result.getMethod().getMethodName(), ""), result.getMethod().getMethodName(), result.getMethod().getDescription(), "", ExecutionSummaryReport.StatusIcon.PASSED.getValue() + ExecutionSummaryReport.Status.PASSED.name(), TestNGListenerHelper.getIssueAnnotationValue(result));
    }

    public void onTestFailure(ITestResult result) {
        failedTests.add(result.getMethod());
        ExecutionSummaryReport.casesDetailsIncrement(TestNGListenerHelper.getTmsLinkAnnotationValue(result), result.getMethod().getQualifiedName().replace("." + result.getMethod().getMethodName(), ""), result.getMethod().getMethodName(), result.getMethod().getDescription(), result.getThrowable().getMessage(), ExecutionSummaryReport.StatusIcon.FAILED.getValue() + ExecutionSummaryReport.Status.FAILED.name(), TestNGListenerHelper.getIssueAnnotationValue(result));
    }

    public void onTestSkipped(ITestResult result) {
        skippedTests.add(result.getMethod());
        ExecutionSummaryReport.casesDetailsIncrement(TestNGListenerHelper.getTmsLinkAnnotationValue(result), result.getMethod().getQualifiedName().replace("." + result.getMethod().getMethodName(), ""), result.getMethod().getMethodName(), result.getMethod().getDescription(), result.getThrowable().getMessage(), ExecutionSummaryReport.StatusIcon.SKIPPED.getValue() + ExecutionSummaryReport.Status.SKIPPED.name(), TestNGListenerHelper.getIssueAnnotationValue(result));
    }

    public static ITestResult getITestResult() {
        return iTestResult;
    }

    public static XmlTest getXmlTest() {
        return xmlTest;
    }
}

