/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.listeners.internal;

import com.shaft.driver.SHAFT;
import com.shaft.tools.internal.tms.XrayIntegrationHelper;
import com.shaft.tools.io.internal.ReportManagerHelper;
import io.qameta.allure.Epic;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import io.qameta.allure.TmsLink;
import java.util.List;
import org.testng.IInvokedMethod;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

public class JiraHelper {
    public static void reportExecutionStatusToJira() {
        if (SHAFT.Properties.jira.isEnabled() && SHAFT.Properties.jira.reportTestCasesExecution()) {
            try {
                String reportPath = SHAFT.Properties.jira.reportPath();
                if (reportPath.contains("testng-results.xml")) {
                    XrayIntegrationHelper.importTestNGResults(reportPath);
                } else if (reportPath.contains("cucumber.json")) {
                    XrayIntegrationHelper.importCucumberResults(reportPath);
                }
                XrayIntegrationHelper.renameTestExecutionSuit(SHAFT.Properties.jira.executionName(), SHAFT.Properties.jira.executionDescription());
            }
            catch (Exception e) {
                ReportManagerHelper.logDiscrete(e);
            }
        }
    }

    public static void prepareTestResultAttributes(IInvokedMethod method, ITestResult testResult) {
        if (method.isTestMethod()) {
            if (JiraHelper.annotationPresent(method, Feature.class)) {
                testResult.setAttribute("requirement", (Object)method.getTestMethod().getConstructorOrMethod().getMethod().getAnnotation(Feature.class).value());
            }
            if (JiraHelper.annotationPresent(method, Epic.class)) {
                testResult.setAttribute("requirement", (Object)method.getTestMethod().getConstructorOrMethod().getMethod().getAnnotation(Epic.class).value());
            }
            if (JiraHelper.annotationPresent(method, Story.class)) {
                testResult.setAttribute("requirement", (Object)method.getTestMethod().getConstructorOrMethod().getMethod().getAnnotation(Story.class).value());
            }
            if (JiraHelper.annotationPresent(method, TmsLink.class)) {
                testResult.setAttribute("test", (Object)method.getTestMethod().getConstructorOrMethod().getMethod().getAnnotation(TmsLink.class).value());
            }
        }
    }

    private static boolean annotationPresent(IInvokedMethod method, Class<?> clazz) {
        return method.getTestMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(clazz);
    }

    public static void reportBugsToJIRA(List<String> attachments, String logText, ITestResult iTestResult, ITestNGMethod iTestNGMethod) {
        String bugID;
        if (!iTestResult.isSuccess() && SHAFT.Properties.jira.isEnabled() && SHAFT.Properties.jira.reportBugs() && (bugID = XrayIntegrationHelper.createIssue(attachments, ReportManagerHelper.getTestMethodName(), logText)) != null && iTestNGMethod.isTest() && iTestNGMethod.getConstructorOrMethod().getMethod().isAnnotationPresent(TmsLink.class)) {
            XrayIntegrationHelper.link2Tickets(bugID, iTestNGMethod.getConstructorOrMethod().getMethod().getAnnotation(TmsLink.class).value());
        }
    }
}

