/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.listeners.internal;

import com.shaft.driver.SHAFT;
import com.shaft.tools.io.ReportManager;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;

public class RetryAnalyzer
implements IRetryAnalyzer {
    private final int maxRetryCount = SHAFT.Properties.flags.retryMaximumNumberOfAttempts();
    private int counter = 0;

    public boolean retry(ITestResult iTestResult) {
        if (this.counter < this.maxRetryCount) {
            ++this.counter;
            ReportManager.logDiscrete("Retry #" + this.counter + " for test: " + iTestResult.getMethod().getMethodName() + ", on thread: " + Thread.currentThread().getName());
            return true;
        }
        return false;
    }
}

