/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.listeners.internal;

import com.shaft.driver.SHAFT;
import com.shaft.driver.internal.DriverFactory.DriverFactoryHelper;
import com.shaft.enums.internal.Screenshots;
import com.shaft.gui.internal.image.AnimatedGifManager;
import com.shaft.gui.internal.video.RecordManager;
import com.shaft.listeners.internal.ConfigurationHelper;
import com.shaft.listeners.internal.JiraHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import io.qameta.allure.Issue;
import io.qameta.allure.Issues;
import io.qameta.allure.TmsLink;
import io.qameta.allure.TmsLinks;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.Browser;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SkipException;
import org.testng.internal.ConfigurationMethod;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestNGListenerHelper {
    private static final ArrayList<ITestResult> beforeMethods = new ArrayList();
    private static final ArrayList<ITestResult> afterMethods = new ArrayList();
    private static final ThreadLocal<String> testName = new ThreadLocal();

    public static void setTotalNumberOfTests(ISuite testSuite) {
        if (testSuite.getAllMethods().size() != 1 || !((ITestNGMethod)testSuite.getAllMethods().getFirst()).getMethodName().equals("runScenario")) {
            ReportManagerHelper.setTotalNumberOfTests(testSuite.getAllMethods().size());
        }
    }

    public static void attachConfigurationMethods() {
        TestNGListenerHelper.attachBeforeConfigurationMethods();
        TestNGListenerHelper.attachAfterConfigurationMethods();
    }

    public static void updateConfigurationMethods(ITestResult iTestResult) {
        TestNGListenerHelper.updateBeforeConfigurationMethods(iTestResult);
        TestNGListenerHelper.updateAfterConfigurationMethods(iTestResult);
    }

    private static void attachBeforeConfigurationMethods() {
        if (!beforeMethods.isEmpty()) {
            if (beforeMethods.size() > 1) {
                TestNGListenerHelper.attachTestArtifacts(beforeMethods.getLast());
            } else {
                TestNGListenerHelper.attachTestArtifacts(beforeMethods.getFirst());
            }
            beforeMethods.clear();
        }
    }

    private static void updateBeforeConfigurationMethods(ITestResult iTestResult) {
        if (iTestResult != null && (iTestResult.getMethod().isBeforeMethodConfiguration() || iTestResult.getMethod().isBeforeTestConfiguration() || iTestResult.getMethod().isBeforeClassConfiguration() || iTestResult.getMethod().isBeforeSuiteConfiguration())) {
            beforeMethods.add(iTestResult);
        }
    }

    private static void attachAfterConfigurationMethods() {
        if (!afterMethods.isEmpty()) {
            if (afterMethods.size() > 1) {
                TestNGListenerHelper.attachTestArtifacts(afterMethods.getLast());
            } else {
                TestNGListenerHelper.attachTestArtifacts(afterMethods.getFirst());
            }
            afterMethods.clear();
        }
    }

    private static void updateAfterConfigurationMethods(ITestResult iTestResult) {
        if (iTestResult != null && (iTestResult.getMethod().isAfterMethodConfiguration() || iTestResult.getMethod().isAfterTestConfiguration() || iTestResult.getMethod().isAfterClassConfiguration() || iTestResult.getMethod().isAfterSuiteConfiguration())) {
            afterMethods.add(iTestResult);
        }
    }

    public static void updateTestMethods(ITestResult iTestResult) {
        if (iTestResult.getMethod().isTest()) {
            TestNGListenerHelper.attachTestArtifacts(iTestResult);
        }
    }

    public static String getTestName() {
        return testName.get();
    }

    public static void setTestName(ITestContext iTestContext) {
        testName.set(iTestContext.getCurrentXmlTest().getName());
    }

    public static void configureCrossBrowserExecution(List<XmlSuite> suites) {
        String crossBrowserMode = SHAFT.Properties.platform.crossBrowserMode();
        List<Browser> supportedBrowsers = Arrays.asList(Browser.CHROME, Browser.SAFARI, Browser.FIREFOX, Browser.EDGE);
        if (!"off".equals(crossBrowserMode)) {
            suites.forEach(suite -> {
                supportedBrowsers.forEach(supportedBrowser -> TestNGListenerHelper.createTestSuite((XmlTest)((XmlTest)suite.getTests().getFirst()).clone(), supportedBrowser));
                suite.getTests().removeFirst();
                if (crossBrowserMode.equals("parallelized")) {
                    suite.setParallel(XmlSuite.ParallelMode.TESTS);
                    suite.setThreadCount(supportedBrowsers.size());
                    SHAFT.Properties.visuals.set().videoParamsRecordVideo(true);
                    SHAFT.Properties.visuals.set().screenshotParamsScreenshotType(String.valueOf((Object)Screenshots.VIEWPORT));
                }
            });
        }
    }

    private static void createTestSuite(XmlTest xmlTest, Browser browser) {
        xmlTest.setParameters(Map.of("executionAddress", "dockerized", "targetOperatingSystem", Platform.LINUX.name(), "targetBrowserName", browser.browserName()));
        xmlTest.setThreadCount(SHAFT.Properties.testNG.threadCount());
        xmlTest.setParallel(XmlSuite.ParallelMode.valueOf((String)SHAFT.Properties.testNG.parallel()));
        xmlTest.setName(xmlTest.getName() + " - " + String.valueOf(browser));
    }

    public static void configureTestNGProperties(List<XmlSuite> suites) {
        suites.forEach(suite -> {
            suite.setPreserveOrder(Boolean.valueOf(SHAFT.Properties.testNG.preserveOrder()));
            suite.setGroupByInstances(SHAFT.Properties.testNG.groupByInstances());
            suite.setVerbose(SHAFT.Properties.testNG.verbose());
            suite.setParallel(XmlSuite.ParallelMode.valueOf((String)SHAFT.Properties.testNG.parallel()));
            suite.setThreadCount(SHAFT.Properties.testNG.threadCount());
            suite.setDataProviderThreadCount(SHAFT.Properties.testNG.dataProviderThreadCount());
            if (SHAFT.Properties.reporting.debugMode()) {
                ReportManager.log("getPreserveOrder: " + suite.getPreserveOrder());
                ReportManager.log("getDataProviderThreadCount: " + suite.getDataProviderThreadCount());
                ReportManager.log("getThreadCount: " + suite.getThreadCount());
                ReportManager.log("getVerbose: " + suite.getVerbose());
                ReportManager.log("getGroupByInstances: " + suite.getGroupByInstances());
                ReportManager.log("getParallel: " + String.valueOf(suite.getParallel()));
            }
        });
    }

    public static void attachConfigurationHelperClass(List<XmlSuite> suites) {
        suites.forEach(xmlSuite -> xmlSuite.getTests().forEach(xmlTest -> xmlTest.getClasses().add(new XmlClass(ConfigurationHelper.class.getName()))));
    }

    public static void configureJVMProxy() {
        String PROXY_SERVER_SETTINGS = SHAFT.Properties.platform.proxy();
        if (SHAFT.Properties.platform.jvmProxySettings() && !PROXY_SERVER_SETTINGS.isEmpty()) {
            String[] proxyHostPort = PROXY_SERVER_SETTINGS.split(":");
            System.setProperty("http.proxyHost", proxyHostPort[0]);
            System.setProperty("http.proxyPort", proxyHostPort[1]);
            System.setProperty("https.proxyHost", proxyHostPort[0]);
            System.setProperty("https.proxyPort", proxyHostPort[1]);
            System.setProperty("ftp.proxyHost", proxyHostPort[0]);
            System.setProperty("ftp.proxyPort", proxyHostPort[1]);
        }
    }

    public static void attachTestArtifacts(ITestResult iTestResult) {
        ITestNGMethod iTestNGMethod = iTestResult.getMethod();
        if (!Arrays.asList("suiteSetup", "suiteTeardown", "classTeardown").contains(iTestNGMethod.getMethodName())) {
            String attachment;
            ArrayList<String> attachments = new ArrayList<String>();
            if (SHAFT.Properties.visuals.videoParamsScope().equals("TestMethod")) {
                RecordManager.attachVideoRecording();
                attachment = RecordManager.getVideoRecordingFilePath();
                if (!attachment.isEmpty()) {
                    attachments.add(attachment);
                }
            }
            if (!(attachment = AnimatedGifManager.attachAnimatedGif()).isEmpty()) {
                attachments.add(attachment);
            }
            String logText = TestNGListenerHelper.createTestLog(Reporter.getOutput((ITestResult)iTestResult));
            ReportManagerHelper.attachTestLog(iTestNGMethod.getMethodName(), logText);
            JiraHelper.reportBugsToJIRA(attachments, logText, iTestResult, iTestNGMethod);
        }
    }

    public static String createTestLog(List<String> output) {
        StringBuilder builder = new StringBuilder();
        for (String each : output) {
            builder.append(each).append(System.lineSeparator());
        }
        String testLog = builder.toString();
        if (testLog.length() >= 2) {
            return testLog.substring(0, builder.length() - 2);
        }
        return testLog;
    }

    public static void skipTestsWithLinkedIssues(ITestResult iTestResult) {
        if (SHAFT.Properties.flags.skipTestsWithLinkedIssues()) {
            Method method = iTestResult.getMethod().getConstructorOrMethod().getMethod();
            Issue issue = method.getAnnotation(Issue.class);
            if (issue != null) {
                SkipException ex = new SkipException("Skipping Test as it's expected to fail due to open issue: [" + issue.value() + "]");
                ReportManagerHelper.logDiscrete((Throwable)ex);
                throw ex;
            }
            Issues issues = method.getAnnotation(Issues.class);
            if (issues != null) {
                StringBuilder issueNames = new StringBuilder();
                Arrays.stream(issues.value()).iterator().forEachRemaining(issueI -> issueNames.append(issueI.value()).append(" ,"));
                SkipException ex = new SkipException("Skipping Test as it's expected to fail due to open issues: [" + issueNames.substring(0, issueNames.length() - 2) + "]");
                ReportManagerHelper.logDiscrete((Throwable)ex);
                throw ex;
            }
        }
    }

    public static String getIssueAnnotationValue(ITestResult iTestResult) {
        Method method = iTestResult.getMethod().getConstructorOrMethod().getMethod();
        Issue issue = method.getAnnotation(Issue.class);
        Issues issues = method.getAnnotation(Issues.class);
        if (issues != null) {
            return Arrays.toString(issues.value()).replace("[@io.qameta.allure.Issue(\"", "").replace("@io.qameta.allure.Issue(\"", "").replace("\")]", "").replace("\"),", ",");
        }
        if (issue != null) {
            return issue.value();
        }
        return "";
    }

    public static String getTmsLinkAnnotationValue(ITestResult iTestResult) {
        Method method = iTestResult.getMethod().getConstructorOrMethod().getMethod();
        TmsLink tmsLink = method.getAnnotation(TmsLink.class);
        TmsLinks tmsLinks = method.getAnnotation(TmsLinks.class);
        if (tmsLinks != null) {
            return Arrays.toString(tmsLinks.value()).replace("[@io.qameta.allure.TmsLink(\"", "").replace("@io.qameta.allure.TmsLink(\"", "").replace("\")]", "").replace("\"),", ",");
        }
        if (tmsLink != null) {
            return tmsLink.value();
        }
        return "";
    }

    public static void failFast(ITestResult iTestResult) {
        if (DriverFactoryHelper.isKillSwitch()) {
            SkipException ex = new SkipException("Skipping Test: " + iTestResult.getName());
            ReportManagerHelper.logDiscrete((Throwable)ex);
            throw ex;
        }
    }

    public static void logTestInformation(ITestResult iTestResult) {
        ITestNGMethod iTestNGMethod = iTestResult.getMethod();
        String methodDescription = "";
        if (!iTestNGMethod.getQualifiedName().contains("AbstractTestNGCucumberTests")) {
            if (iTestNGMethod.isTest()) {
                String className = ReportManagerHelper.getTestClassName();
                String methodName = ReportManagerHelper.getTestMethodName();
                if (iTestNGMethod.getDescription() != null) {
                    methodDescription = iTestNGMethod.getDescription();
                }
                ReportManagerHelper.logTestInformation(className, methodName, methodDescription);
            } else if (iTestNGMethod instanceof ConfigurationMethod) {
                ConfigurationMethod configurationMethod = (ConfigurationMethod)iTestNGMethod;
                String className = configurationMethod.getTestClass().getName();
                String methodName = configurationMethod.getMethodName();
                String configurationMethodType = configurationMethod.getMethodName();
                ReportManagerHelper.logConfigurationMethodInformation(className, methodName, configurationMethodType);
            }
        }
    }

    public static void logFinishedTestInformation(ITestResult iTestResult) {
        ITestNGMethod iTestNGMethod = iTestResult.getMethod();
        String methodDescription = "";
        String methodStatus = "";
        if (!iTestNGMethod.getQualifiedName().contains("AbstractTestNGCucumberTests") && iTestNGMethod.isTest()) {
            String className = ReportManagerHelper.getTestClassName();
            String methodName = ReportManagerHelper.getTestMethodName();
            if (iTestNGMethod.getDescription() != null) {
                methodDescription = iTestNGMethod.getDescription();
            }
            if (iTestResult.getStatus() == 1) {
                methodStatus = "Passed";
            } else if (iTestResult.getStatus() == 2) {
                methodStatus = "Failed";
            } else if (iTestResult.getStatus() == 3) {
                methodStatus = "Skipped";
            }
            ReportManagerHelper.logFinishedTestInformation(className, methodName, methodDescription, methodStatus);
        }
    }
}

