/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.listeners.internal;

import com.shaft.cli.FileActions;
import com.shaft.driver.SHAFT;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Level;

public class UpdateChecker {
    public static void check() {
        block7: {
            ReportManager.logDiscrete("Checking for engine updates...");
            AtomicReference latestVersion = new AtomicReference();
            Thread thread1 = Thread.ofVirtual().start(() -> latestVersion.set(((Response)((Response)RestAssured.given().baseUri("https://api.github.com/").and().basePath("repos/ShaftHQ/SHAFT_ENGINE/releases/").when().get("latest", new Object[0])).thenReturn()).body().jsonPath().getString("name")));
            String todayDate = new SimpleDateFormat("dd-MM-yyyy").format(new Date());
            String lastCheckedFile = "engine_check";
            AtomicBoolean doesEngineCheckFileExists = new AtomicBoolean(false);
            AtomicBoolean doesFileContainTodayDate = new AtomicBoolean(false);
            Thread thread2 = Thread.ofVirtual().start(() -> {
                doesEngineCheckFileExists.set(FileActions.getInstance(true).doesFileExist("target/", lastCheckedFile, 1));
                if (doesEngineCheckFileExists.get()) {
                    doesFileContainTodayDate.set(FileActions.getInstance(true).readFile("target/", lastCheckedFile).equals(todayDate));
                }
            });
            thread1.join();
            thread2.join();
            if (!doesEngineCheckFileExists.get() || !doesFileContainTodayDate.get()) {
                Object logMessage;
                try {
                    String currentVersion = SHAFT.Properties.internal.shaftEngineVersion();
                    thread1.join();
                    logMessage = !currentVersion.equalsIgnoreCase((String)latestVersion.get()) ? "\u26a0\ufe0f You're using an outdated engine version \"" + currentVersion + "\" \u26a0\ufe0f\nKindly upgrade to the latest one \"" + String.valueOf(latestVersion) + "\" to ensure the best experience.\nFor more information click here: https://github.com/ShaftHQ/SHAFT_ENGINE/releases/latest ." : "You're using the latest engine version \"" + String.valueOf(latestVersion) + "\". \ud83d\udc4d";
                }
                catch (Throwable throwable) {
                    logMessage = "Failed to check for updates... proceeding with engine setup...";
                }
                Thread.ofVirtual().start(() -> FileActions.getInstance(true).writeToFile("target/", lastCheckedFile, todayDate));
                if (((String)logMessage).contains("\u26a0\ufe0f")) {
                    ReportManagerHelper.logDiscrete((String)logMessage, Level.WARN);
                } else {
                    ReportManagerHelper.logDiscrete((String)logMessage, Level.INFO);
                }
                break block7;
            }
            ReportManagerHelper.logDiscrete("Engine Update check done for the day. \ud83d\udc4d", Level.INFO);
        }
    }
}

