/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.listeners.internal;

import com.shaft.driver.SHAFT;
import com.shaft.gui.element.internal.ElementActionsHelper;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import io.appium.java_client.proxy.MethodCallListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.function.Function;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebDriverListener
implements org.openqa.selenium.support.events.WebDriverListener,
MethodCallListener {
    private static final double DEFAULT_ELEMENT_IDENTIFICATION_TIMEOUT = SHAFT.Properties.timeouts.defaultElementIdentificationTimeout();
    private static final int ELEMENT_IDENTIFICATION_POLLING_DELAY = 100;
    private static WebDriver currentWebDriver;

    public void afterAnyCall(Object target, Method method, Object[] args, Object result) {
    }

    public void onError(Object target, Method method, Object[] args, InvocationTargetException e) {
        ReportManager.log(JavaHelper.convertToSentenceCase(method.getName()) + " action failed.");
        ReportManagerHelper.logDiscrete(e);
    }

    public void afterGet(WebDriver driver, String url) {
        currentWebDriver = driver;
        ReportManager.log("Navigate to \"" + url + "\".");
    }

    public void afterGetCurrentUrl(String result, WebDriver driver) {
        currentWebDriver = driver;
        ReportManager.log("Current url is: \"" + result + "\".");
    }

    public void afterGetTitle(WebDriver driver, String result) {
        currentWebDriver = driver;
        ReportManager.log("Current Window Title is: \"" + result + "\".");
    }

    public void beforeFindElement(WebDriver driver, By locator) {
        currentWebDriver = driver;
        if (SHAFT.Properties.flags.respectBuiltInWaitsInNativeMode()) {
            try {
                new FluentWait((Object)driver).withTimeout(Duration.ofMillis((long)DEFAULT_ELEMENT_IDENTIFICATION_TIMEOUT)).pollingEvery(Duration.ofMillis(100L)).ignoreAll(ElementActionsHelper.getExpectedExceptions(false)).until(nestedDriver -> nestedDriver.findElement(locator));
            }
            catch (TimeoutException timeoutException) {
                ReportManager.logDiscrete(timeoutException.getMessage() + " || " + timeoutException.getCause().getMessage().substring(0, timeoutException.getCause().getMessage().indexOf("\n")));
                throw timeoutException;
            }
        }
    }

    public void afterClose(WebDriver driver) {
        currentWebDriver = driver;
        ReportManager.log("Successfully Closed Driver.");
    }

    public void afterQuit(WebDriver driver) {
        currentWebDriver = driver;
        ReportManager.log("Successfully Quit Driver.");
    }

    public void beforeClick(WebElement element) {
        if (SHAFT.Properties.flags.respectBuiltInWaitsInNativeMode()) {
            try {
                new WebDriverWait(currentWebDriver, Duration.ofMillis((long)DEFAULT_ELEMENT_IDENTIFICATION_TIMEOUT)).until((Function)ExpectedConditions.elementToBeClickable((WebElement)element));
            }
            catch (TimeoutException timeoutException) {
                ReportManagerHelper.logDiscrete(timeoutException);
                throw timeoutException;
            }
        }
        try {
            ReportManager.log("Click " + this.getElementName(element) + ".");
        }
        catch (Exception throwable) {
            ReportManager.log("Click.");
        }
    }

    public void beforeSubmit(WebElement element) {
        try {
            ReportManager.log("Submit " + this.getElementName(element) + ".");
        }
        catch (Exception throwable) {
            ReportManager.log("Submit.");
        }
    }

    public void beforeSendKeys(WebElement element, CharSequence ... keysToSend) {
        StringBuilder stringBuilder = new StringBuilder();
        Arrays.stream(keysToSend).toList().forEach(stringBuilder::append);
        try {
            ReportManager.log("Type \"" + String.valueOf(stringBuilder) + "\" into " + this.getElementName(element) + ".");
        }
        catch (Exception throwable) {
            ReportManager.log("Type \"" + String.valueOf(stringBuilder) + "\".");
        }
    }

    public void beforeClear(WebElement element) {
        try {
            ReportManager.log("Clear " + this.getElementName(element) + ".");
        }
        catch (Exception throwable) {
            ReportManager.log("Clear.");
        }
    }

    public void afterGetAttribute(WebElement element, String name, String result) {
        try {
            ReportManager.log("Get Attribute \"" + name + "\" from " + this.getElementName(element) + ", value is \"" + result + "\".");
        }
        catch (Exception throwable) {
            ReportManager.log("Get Attribute \"" + name + "\", value is \"" + result + "\".");
        }
    }

    public void afterGetText(WebElement element, String result) {
        try {
            ReportManager.log("Get Text from " + this.getElementName(element) + ", text is \"" + result + "\".");
        }
        catch (Exception throwable) {
            ReportManager.log("Get Text, text is :\"" + result + "\".");
        }
    }

    public void afterTo(WebDriver.Navigation navigation, String url) {
        ReportManager.log("Navigate to url \"" + url + "\".");
    }

    public void afterTo(WebDriver.Navigation navigation, URL url) {
        ReportManager.log("Navigate to url \"" + String.valueOf(url) + "\".");
    }

    public void afterBack(WebDriver.Navigation navigation) {
        ReportManager.log("Navigate back.");
    }

    public void afterForward(WebDriver.Navigation navigation) {
        ReportManager.log("Navigate forward.");
    }

    public void afterRefresh(WebDriver.Navigation navigation) {
        ReportManager.log("Refresh current page.");
    }

    public void beforeSendKeys(Alert alert, String text) {
        ReportManager.log("Type \"" + text + "\" into Alert.");
    }

    public void afterMaximize(WebDriver.Window window) {
        ReportManager.log("Maximize Current Window.");
    }

    private String getElementName(WebElement element) {
        String accessibleName = element.getAccessibleName();
        if ("".equals(accessibleName)) {
            return "element";
        }
        return "\"" + accessibleName + "\"";
    }
}

