/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.performance.internal;

import com.shaft.cli.FileActions;
import com.shaft.cli.TerminalActions;
import com.shaft.driver.SHAFT;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.WebDriver;

public class LightHouseGenerateReport {
    final WebDriver driver;
    int PortNum;
    String PageName;

    public LightHouseGenerateReport(WebDriver driver) {
        this.driver = driver;
    }

    public void generateLightHouseReport() {
        this.PortNum = SHAFT.Properties.performance.port();
        this.PageName = this.getPageName();
        if (SHAFT.Properties.performance.isEnabled()) {
            this.createLighthouseReportFolderInProjectDirectory();
            this.writeNodeScriptFileInProjectDirectory();
            Object commandToGenerateLightHouseReport = SystemUtils.IS_OS_WINDOWS ? "cmd.exe /c node GenerateLHScript.js --url=\"" + this.driver.getCurrentUrl() + "\" --port=" + this.PortNum + " --reportName=" + this.PageName + " " : "node GenerateLHScript.js --url=\"" + this.driver.getCurrentUrl() + "\" --port=" + this.PortNum + " --reportName=" + this.PageName + " ";
            commandToGenerateLightHouseReport = ((String)commandToGenerateLightHouseReport).replace("&", "N898");
            new TerminalActions().performTerminalCommand((String)commandToGenerateLightHouseReport);
            this.writeReportPathToFilesInProjectDirectory(this.PageName);
            this.openLighthouseReportWhileExecution();
            SHAFT.Report.report("Lighthouse Report Generated successfully");
            SHAFT.Report.attach("LightHouse HTML", "Report", FileActions.getInstance(true).readFile("lighthouse-reports/" + this.PageName + ".html"));
        }
    }

    public void createLighthouseReportFolderInProjectDirectory() {
        FileActions.getInstance(true).createFolder("lighthouse-reports");
    }

    public void openLighthouseReportWhileExecution() {
        if (SHAFT.Properties.reporting.openLighthouseReportWhileExecution()) {
            String commandToOpenLighthouseReport = SystemUtils.IS_OS_WINDOWS ? "cmd.exe /c node OpenLHReport.js" : "node OpenLHReport.js";
            new TerminalActions().performTerminalCommand(commandToOpenLighthouseReport);
            SHAFT.Report.report("Lighthouse Report Opened in new tab successfully");
        }
    }

    public void writeReportPathToFilesInProjectDirectory(String pageName) {
        List<CallSite> commandsToServeLHReport = List.of("import open from 'open';\nimport path from 'path';\nconst __dirname = path.resolve();\nawait open(__dirname +'/lighthouse-reports/" + pageName + ".html');\n");
        FileActions.getInstance(true).writeToFile("", "OpenLHReport.js", commandsToServeLHReport);
    }

    public void writeNodeScriptFileInProjectDirectory() {
        List<String> commandsToServeLHReport = SystemUtils.IS_OS_WINDOWS ? List.of("import puppeteer from 'puppeteer';\nimport fs from 'fs';\nimport lighthouse from 'lighthouse';\nimport optimist from 'optimist';\nvar argv =optimist.argv;\nimport open from 'open';\nimport path from 'path';\nconst __dirname = path.resolve();\n import desktopConfig from 'lighthouse/core/config/desktop-config.js';\n// -------- Configs ----------\n  var text = argv.url;\n  var Url = text.replaceAll(\"N898\", \"&\");\n  var Port = argv.port;\n  var LogLevel='info';\n  var OutputType='html'; // html , json\n  var ReportName=argv.reportName;\n//----------------------------\n(async() => {\n  // Use Puppeteer to connect to the opened session by port\n  const browserURL = 'http://127.0.0.1:'+Port;\n  const browser = await puppeteer.connect({browserURL});\n  // Lighthouse connect to the opened page and generate the report.\n  const options = {logLevel:LogLevel ,output: OutputType, port:Port};\n  const runnerResult = await lighthouse(Url,options,desktopConfig);\n  // `Genrate the report output as HTML or JSON\n  const reportHtml = runnerResult.report;\n  // save the report in node.js path\n  fs.writeFileSync(__dirname +'/lighthouse-reports/'+ReportName+'.'+OutputType, reportHtml);\n  // Disconnect from the session\n  await browser.disconnect();\n})();") : List.of("import puppeteer from 'puppeteer';\nimport fs from 'fs';\nimport lighthouse from 'lighthouse';\nimport optimist from 'optimist';\nvar argv =optimist.argv;\nimport open from 'open';\nimport path from 'path';\nconst __dirname = path.resolve();\nimport desktopConfig from 'lighthouse/lighthouse-core/config/desktop-config.js';\n// -------- Configs ----------\n   var text = argv.url;\n   var Url = text.replaceAll( \"N898 \",  \"& \");\n   //Url=Url.replace( \"'&' \",  \"& \");\n   var Port = argv.port;\n   var LogLevel='info';\n   var OutputType='html'; argv.outputType; // html , json\n   var ReportName=argv.reportName;\n//----------------------------\n(async() => {\n   // Use Puppeteer to connect to the opened session by port\n   const browserURL = 'http://127.0.0.1:'+Port;\n   const browser = await puppeteer.connect({browserURL});\n   // open new tab to Fix Lighthouse issue in MacOS as it run on same tab\n   const newTab = browser.newPage(browserURL);\n   //Lighthouse connect to the opened page and generate the report.\n   const options = {logLevel:LogLevel ,output: OutputType, port:Port};\n   const runnerResult = await lighthouse(Url,options,desktopConfig);\n   // `Genrate the report output as HTML or JSON\n   const reportHtml = runnerResult.report;\n   // save the report in node.js path\n   fs.writeFileSync(__dirname +'/lighthouse-reports/'+ReportName+'.'+OutputType, reportHtml);\n   // Disconnect from the session\n   await browser.disconnect();\n })();");
        FileActions.getInstance(true).writeToFile("", "GenerateLHScript.js", commandsToServeLHReport);
    }

    public String getPageName() {
        String CurrentUrl = this.driver.getCurrentUrl();
        try {
            URL url = URI.create(CurrentUrl).toURL();
            String Pagename = url.getPath();
            Pagename = Pagename.replace("/", "-");
            return new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss-SSSS-aaa").format(System.currentTimeMillis()) + "-" + Pagename;
        }
        catch (MalformedURLException e) {
            ReportManagerHelper.log(e);
            return "Error Occurred while creating the requested page name";
        }
    }
}

