/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.properties.internal;

import com.shaft.properties.internal.EngineProperties;
import com.shaft.properties.internal.Properties;
import com.shaft.tools.io.ReportManager;
import java.util.Map;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;

@Config.Sources(value={"system:properties", "file:src/main/resources/properties/PlatformFlags.properties", "file:src/main/resources/properties/default/PlatformFlags.properties", "classpath:PlatformFlags.properties"})
public interface Flags
extends EngineProperties {
    private static void setProperty(String key, String value) {
        java.util.Properties updatedProps = new java.util.Properties();
        updatedProps.setProperty(key, value);
        Properties.flags = (Flags)ConfigFactory.create(Flags.class, (Map[])new Map[]{updatedProps});
        System.setProperty(key, value);
        ReportManager.logDiscrete("Setting \"" + key + "\" property with \"" + value + "\".");
    }

    @Config.Key(value="retryMaximumNumberOfAttempts")
    @Config.DefaultValue(value="0")
    public int retryMaximumNumberOfAttempts();

    @Config.Key(value="autoMaximizeBrowserWindow")
    @Config.DefaultValue(value="true")
    public boolean autoMaximizeBrowserWindow();

    @Config.Key(value="forceCheckForElementVisibility")
    @Config.DefaultValue(value="true")
    public boolean forceCheckForElementVisibility();

    @Config.Key(value="forceCheckElementLocatorIsUnique")
    @Config.DefaultValue(value="true")
    public boolean forceCheckElementLocatorIsUnique();

    @Config.Key(value="forceCheckTextWasTypedCorrectly")
    @Config.DefaultValue(value="false")
    public boolean forceCheckTextWasTypedCorrectly();

    @Config.Key(value="attemptClearBeforeTypingUsingBackspace")
    @Config.DefaultValue(value="false")
    public boolean attemptClearBeforeTypingUsingBackspace();

    @Config.Key(value="attemptClearBeforeTyping")
    @Config.DefaultValue(value="true")
    public boolean attemptClearBeforeTyping();

    @Config.Key(value="forceCheckNavigationWasSuccessful")
    @Config.DefaultValue(value="false")
    public boolean forceCheckNavigationWasSuccessful();

    @Config.Key(value="respectBuiltInWaitsInNativeMode")
    @Config.DefaultValue(value="true")
    public boolean respectBuiltInWaitsInNativeMode();

    @Config.Key(value="forceCheckStatusOfRemoteServer")
    @Config.DefaultValue(value="false")
    public boolean forceCheckStatusOfRemoteServer();

    @Config.Key(value="clickUsingJavascriptWhenWebDriverClickFails")
    @Config.DefaultValue(value="false")
    public boolean clickUsingJavascriptWhenWebDriverClickFails();

    @Config.Key(value="autoCloseDriverInstance")
    @Config.DefaultValue(value="true")
    public boolean autoCloseDriverInstance();

    @Config.Key(value="automaticallyAssertResponseStatusCode")
    @Config.DefaultValue(value="true")
    public boolean automaticallyAssertResponseStatusCode();

    @Config.Key(value="maximumPerformanceMode")
    @Config.DefaultValue(value="0")
    public int maximumPerformanceMode();

    @Config.Key(value="skipTestsWithLinkedIssues")
    @Config.DefaultValue(value="false")
    public boolean skipTestsWithLinkedIssues();

    @Config.Key(value="attemptToClickBeforeTyping")
    @Config.DefaultValue(value="false")
    public boolean attemptToClickBeforeTyping();

    @Config.Key(value="disableCache")
    @Config.DefaultValue(value="false")
    public boolean disableCache();

    @Config.Key(value="enableTrueNativeMode")
    @Config.DefaultValue(value="false")
    public boolean enableTrueNativeMode();

    @Config.Key(value="handleNonSelectDropDown")
    @Config.DefaultValue(value="true")
    public boolean handleNonSelectDropDown();

    @Config.Key(value="validateSwipeToElement")
    @Config.DefaultValue(value="false")
    public boolean validateSwipeToElement();

    @Override
    default public SetProperty set() {
        return new SetProperty();
    }

    public static class SetProperty
    implements EngineProperties.SetProperty {
        public SetProperty retryMaximumNumberOfAttempts(int value) {
            Flags.setProperty("retryMaximumNumberOfAttempts", String.valueOf(value));
            return this;
        }

        public SetProperty autoMaximizeBrowserWindow(boolean value) {
            Flags.setProperty("autoMaximizeBrowserWindow", String.valueOf(value));
            return this;
        }

        public SetProperty forceCheckForElementVisibility(boolean value) {
            Flags.setProperty("forceCheckForElementVisibility", String.valueOf(value));
            return this;
        }

        public SetProperty forceCheckElementLocatorIsUnique(boolean value) {
            Flags.setProperty("forceCheckElementLocatorIsUnique", String.valueOf(value));
            return this;
        }

        public SetProperty forceCheckTextWasTypedCorrectly(boolean value) {
            Flags.setProperty("forceCheckTextWasTypedCorrectly", String.valueOf(value));
            return this;
        }

        public SetProperty attemptClearBeforeTyping(boolean value) {
            Flags.setProperty("attemptClearBeforeTyping", String.valueOf(value));
            return this;
        }

        public SetProperty attemptClearBeforeTypingUsingBackspace(boolean value) {
            Flags.setProperty("attemptClearBeforeTypingUsingBackspace", String.valueOf(value));
            return this;
        }

        public SetProperty forceCheckNavigationWasSuccessful(boolean value) {
            Flags.setProperty("forceCheckNavigationWasSuccessful", String.valueOf(value));
            return this;
        }

        public SetProperty forceCheckStatusOfRemoteServer(boolean value) {
            Flags.setProperty("forceCheckStatusOfRemoteServer", String.valueOf(value));
            return this;
        }

        public SetProperty respectBuiltInWaitsInNativeMode(boolean value) {
            Flags.setProperty("respectBuiltInWaitsInNativeMode", String.valueOf(value));
            return this;
        }

        public SetProperty clickUsingJavascriptWhenWebDriverClickFails(boolean value) {
            Flags.setProperty("clickUsingJavascriptWhenWebDriverClickFails", String.valueOf(value));
            return this;
        }

        public SetProperty attemptToClickBeforeTyping(boolean value) {
            Flags.setProperty("attemptToClickBeforeTyping", String.valueOf(value));
            return this;
        }

        public SetProperty autoCloseDriverInstance(boolean value) {
            Flags.setProperty("autoCloseDriverInstance", String.valueOf(value));
            return this;
        }

        public SetProperty automaticallyAssertResponseStatusCode(boolean value) {
            Flags.setProperty("automaticallyAssertResponseStatusCode", String.valueOf(value));
            return this;
        }

        public SetProperty maximumPerformanceMode(int value) {
            Flags.setProperty("maximumPerformanceMode", String.valueOf(value));
            return this;
        }

        public SetProperty skipTestsWithLinkedIssues(boolean value) {
            Flags.setProperty("skipTestsWithLinkedIssues", String.valueOf(value));
            return this;
        }

        public SetProperty disableCache(boolean value) {
            Flags.setProperty("disableCache", String.valueOf(value));
            return this;
        }

        public SetProperty enableTrueNativeMode(boolean value) {
            Flags.setProperty("enableTrueNativeMode", String.valueOf(value));
            return this;
        }

        public SetProperty handleNonSelectDropDown(boolean value) {
            Flags.setProperty("handleNonSelectDropDown", String.valueOf(value));
            return this;
        }

        public SetProperty validateSwipeToElement(boolean value) {
            Flags.setProperty("validateSwipeToElement", String.valueOf(value));
            return this;
        }
    }
}

