/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.properties.internal;

import com.shaft.properties.internal.EngineProperties;
import com.shaft.properties.internal.Properties;
import com.shaft.tools.io.ReportManager;
import java.util.Map;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;

@Config.Sources(value={"system:properties", "file:src/main/resources/properties/JiraXRay.properties", "file:src/main/resources/properties/default/JiraXRay.properties", "classpath:JiraXRay.properties"})
public interface Jira
extends EngineProperties {
    private static void setProperty(String key, String value) {
        java.util.Properties updatedProps = new java.util.Properties();
        updatedProps.setProperty(key, value);
        Properties.jira = (Jira)ConfigFactory.create(Jira.class, (Map[])new Map[]{updatedProps});
        System.setProperty(key, value);
        ReportManager.logDiscrete("Setting \"" + key + "\" property with \"" + value + "\".");
    }

    @Config.Key(value="jiraInteraction")
    @Config.DefaultValue(value="false")
    public boolean isEnabled();

    @Config.Key(value="jiraUrl")
    @Config.DefaultValue(value="https://")
    public String url();

    @Config.Key(value="projectKey")
    @Config.DefaultValue(value="")
    public String projectKey();

    @Config.Key(value="authorization")
    @Config.DefaultValue(value=":")
    public String authorization();

    @Config.Key(value="authType")
    @Config.DefaultValue(value="basic")
    public String authType();

    @Config.Key(value="reportTestCasesExecution")
    @Config.DefaultValue(value="false")
    public boolean reportTestCasesExecution();

    @Config.Key(value="reportPath")
    @Config.DefaultValue(value="target/surefire-reports/testng-results.xml")
    public String reportPath();

    @Config.Key(value="ExecutionName")
    @Config.DefaultValue(value="")
    public String executionName();

    @Config.Key(value="ExecutionDescription")
    @Config.DefaultValue(value="")
    public String executionDescription();

    @Config.Key(value="ReportBugs")
    @Config.DefaultValue(value="false")
    public boolean reportBugs();

    @Config.Key(value="assignee")
    @Config.DefaultValue(value="")
    public String assignee();

    @Config.Key(value="allure.link.tms.pattern")
    @Config.DefaultValue(value="https:///{}")
    public String allureLinkTmsPattern();

    @Config.Key(value="allure.link.custom.pattern")
    @Config.DefaultValue(value="{}")
    public String allureLinkCustomPattern();

    @Override
    default public SetProperty set() {
        return new SetProperty();
    }

    public static class SetProperty
    implements EngineProperties.SetProperty {
        public SetProperty jiraInteraction(boolean value) {
            Jira.setProperty("jiraInteraction", String.valueOf(value));
            return this;
        }

        public SetProperty jiraUrl(String value) {
            Jira.setProperty("jiraUrl", value);
            return this;
        }

        public SetProperty projectKey(String value) {
            Jira.setProperty("projectKey", value);
            return this;
        }

        public SetProperty authorization(String value) {
            Jira.setProperty("authorization", value);
            return this;
        }

        public SetProperty authType(String value) {
            Jira.setProperty("authType", value);
            return this;
        }

        public SetProperty reportTestCasesExecution(boolean value) {
            Jira.setProperty("reportTestCasesExecution", String.valueOf(value));
            return this;
        }

        public SetProperty reportPath(String value) {
            Jira.setProperty("reportPath", value);
            return this;
        }

        public SetProperty executionName(String value) {
            Jira.setProperty("ExecutionName", value);
            return this;
        }

        public SetProperty executionDescription(String value) {
            Jira.setProperty("ExecutionDescription", value);
            return this;
        }

        public SetProperty reportBugs(boolean value) {
            Jira.setProperty("ReportBugs", String.valueOf(value));
            return this;
        }

        public SetProperty assignee(String value) {
            Jira.setProperty("assignee", value);
            return this;
        }

        public SetProperty allureLinkTmsPattern(String value) {
            Jira.setProperty("allure.link.tms.pattern", value);
            return this;
        }

        public SetProperty allureLinkCustomPattern(String value) {
            Jira.setProperty("allure.link.custom.pattern", value);
            return this;
        }
    }
}

