/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.properties.internal;

import com.shaft.properties.internal.EngineProperties;
import com.shaft.properties.internal.Properties;
import com.shaft.tools.io.ReportManager;
import java.util.Map;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;

@Config.Sources(value={"system:properties", "file:src/main/resources/properties/path.properties", "file:src/main/resources/properties/default/path.properties", "classpath:path.properties"})
public interface Paths
extends EngineProperties {
    private static void setProperty(String key, String value) {
        java.util.Properties updatedProps = new java.util.Properties();
        updatedProps.setProperty(key, value);
        Properties.paths = (Paths)ConfigFactory.create(Paths.class, (Map[])new Map[]{updatedProps});
        System.setProperty(key, value);
        ReportManager.logDiscrete("Setting \"" + key + "\" property with \"" + value + "\".");
    }

    @Config.Key(value="propertiesFolderPath")
    @Config.DefaultValue(value="src/main/resources/properties/")
    public String properties();

    @Config.Key(value="defaultPropertiesFolderPath")
    @Config.DefaultValue(value="src/main/resources/properties/default")
    public String defaultProperties();

    @Config.Key(value="dynamicObjectRepositoryPath")
    @Config.DefaultValue(value="src/main/resources/dynamicObjectRepository/")
    public String dynamicObjectRepository();

    @Config.Key(value="testDataFolderPath")
    @Config.DefaultValue(value="src/test/resources/testDataFiles/")
    public String testData();

    @Config.Key(value="downloadsFolderPath")
    @Config.DefaultValue(value="target/downloadedFiles")
    public String downloads();

    @Config.Key(value="allureResultsFolderPath")
    @Config.DefaultValue(value="allure-results/")
    public String allureResults();

    @Config.Key(value="extentReportsFolderPath")
    @Config.DefaultValue(value="extent-reports/")
    public String extentReports();

    @Config.Key(value="executionSummaryReportFolderPath")
    @Config.DefaultValue(value="execution-summary/")
    public String executionSummaryReport();

    @Config.Key(value="video.folder")
    @Config.DefaultValue(value="allure-results/videos")
    public String video();

    @Config.Key(value="applitoolsApiKey")
    @Config.DefaultValue(value="")
    public String applitoolsApiKey();

    @Config.Key(value="servicesFolderPath")
    @Config.DefaultValue(value="src/test/resources/META-INF/services/")
    public String services();

    @Override
    default public SetProperty set() {
        return new SetProperty();
    }

    public static class SetProperty
    implements EngineProperties.SetProperty {
        public SetProperty properties(String value) {
            Paths.setProperty("propertiesFolderPath", value);
            return this;
        }

        public SetProperty dynamicObjectRepository(String value) {
            Paths.setProperty("dynamicObjectRepositoryPath", value);
            return this;
        }

        public SetProperty testData(String value) {
            Paths.setProperty("testDataFolderPath", value);
            return this;
        }

        public SetProperty downloads(String value) {
            Paths.setProperty("downloadsFolderPath", value);
            return this;
        }

        public SetProperty allureResults(String value) {
            Paths.setProperty("allureResultsFolderPath", value);
            return this;
        }

        public SetProperty extentReports(String value) {
            Paths.setProperty("extentReportsFolderPath", value);
            return this;
        }

        public SetProperty executionSummaryReport(String value) {
            Paths.setProperty("executionSummaryReportFolderPath", value);
            return this;
        }

        public SetProperty video(String value) {
            Paths.setProperty("video.folder", value);
            return this;
        }

        public SetProperty applitoolsApiKey(String value) {
            Paths.setProperty("applitoolsApiKey", value);
            return this;
        }

        public SetProperty services(String value) {
            Paths.setProperty("servicesFolderPath", value);
            return this;
        }
    }
}

