/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.properties.internal;

import com.shaft.properties.internal.EngineProperties;
import com.shaft.properties.internal.Properties;
import com.shaft.tools.io.ReportManager;
import java.util.Map;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;

@Config.Sources(value={"system:properties", "file:src/main/resources/properties/ExecutionPlatform.properties", "file:src/main/resources/properties/default/ExecutionPlatform.properties", "classpath:ExecutionPlatform.properties"})
public interface Platform
extends EngineProperties {
    private static void setProperty(String key, String value) {
        java.util.Properties updatedProps = new java.util.Properties();
        updatedProps.setProperty(key, value);
        Properties.platform = (Platform)ConfigFactory.create(Platform.class, (Map[])new Map[]{updatedProps});
        System.setProperty(key, value);
        ReportManager.logDiscrete("Setting \"" + key + "\" property with \"" + value + "\".");
    }

    @Config.Key(value="SHAFT.CrossBrowserMode")
    @Config.DefaultValue(value="off")
    public String crossBrowserMode();

    @Config.Key(value="executionAddress")
    @Config.DefaultValue(value="local")
    public String executionAddress();

    @Config.Key(value="targetOperatingSystem")
    @Config.DefaultValue(value="Linux")
    public String targetPlatform();

    @Config.Key(value="com.SHAFT.proxySettings")
    @Config.DefaultValue(value="")
    public String proxy();

    @Config.Key(value="driverProxySettings")
    @Config.DefaultValue(value="true")
    public boolean driverProxySettings();

    @Config.Key(value="jvmProxySettings")
    @Config.DefaultValue(value="true")
    public boolean jvmProxySettings();

    @Config.Key(value="enableBiDi")
    @Config.DefaultValue(value="true")
    public boolean enableBiDi();

    @Override
    default public SetProperty set() {
        return new SetProperty();
    }

    public static class SetProperty
    implements EngineProperties.SetProperty {
        public SetProperty crossBrowserMode(String value) {
            Platform.setProperty("SHAFT.CrossBrowserMode", value);
            return this;
        }

        public SetProperty executionAddress(String value) {
            Platform.setProperty("executionAddress", value);
            return this;
        }

        public SetProperty targetPlatform(String value) {
            Platform.setProperty("targetOperatingSystem", value);
            return this;
        }

        public SetProperty proxySettings(String value) {
            Platform.setProperty("com.SHAFT.proxySettings", value);
            return this;
        }

        public SetProperty driverProxySettings(boolean value) {
            Platform.setProperty("driverProxySettings", String.valueOf(value));
            return this;
        }

        public SetProperty jvmProxySettings(boolean value) {
            Platform.setProperty("jvmProxySettings", String.valueOf(value));
            return this;
        }

        public SetProperty enableBiDi(boolean value) {
            Platform.setProperty("enableBiDi", String.valueOf(value));
            return this;
        }
    }
}

